/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome;

import java.io.PrintWriter;
import java.io.StringWriter;

public class TraceUtils {
    public static final String getAsString(Throwable throwable) {
        if (throwable == null) {
            return "null exception";
        }
        if (throwable.getMessage() != null && throwable.getMessage().equalsIgnoreCase("No stack trace available")) {
            return throwable.getMessage();
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static final String getAsString(Throwable[] throwableArray) {
        if (throwableArray == null || throwableArray.length == 0) {
            return "There were no exception stack traces available";
        }
        StringBuffer stringBuffer = new StringBuffer("# of exceptions: ").append(throwableArray.length).append('\n');
        for (int i2 = 0; i2 < throwableArray.length; ++i2) {
            if (throwableArray[i2] == null) {
                stringBuffer.append("null exception at: ").append(i2).append('\n');
                continue;
            }
            stringBuffer.append("------").append(throwableArray[i2].getMessage()).append("------\n");
            stringBuffer.append(TraceUtils.getAsString(throwableArray[i2])).append('\n').append('\n');
        }
        return stringBuffer.toString();
    }

    public static final void showTrace() {
        try {
            throw new Exception("");
        }
        catch (Exception exception) {
            System.out.print("\n");
            exception.printStackTrace();
            return;
        }
    }

    public static final void showTrace(String string) {
        try {
            throw new Exception("\n\"" + string + "\"");
        }
        catch (Exception exception) {
            System.out.print("\n");
            exception.printStackTrace();
            return;
        }
    }
}

