/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.DatasetMetrics$ScoredStruc;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics$AbstractMetric;
import edu.mit.broad.genome.alg.Metrics$ClassMeansRatio;
import edu.mit.broad.genome.alg.Metrics$ClassMediansRatio;
import edu.mit.broad.genome.alg.Metrics$Signal2Noise;
import edu.mit.broad.genome.alg.SanityKit;
import edu.mit.broad.genome.alg.markers.PermutationTest;
import edu.mit.broad.genome.alg.markers.PermutationTestImpl;
import edu.mit.broad.genome.math.AddressedVector;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.LabelledVectorProcessors$None;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.RandomSeedGenerators$Timestamp;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.DT;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultRankedFeature;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedFeature;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.ScoredDatasetImpl;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactoryRandomizer;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DatasetMetrics {
    private final Logger log = XLogger.getLogger(this.getClass());

    public static final Map getDefaultMetricParams() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("USE_MEDIAN", XPreferencesFactory.kMedian.getBooleanO());
        hashMap.put("FIX_LOW", XPreferencesFactory.kFixLowVar.getBooleanO());
        hashMap.put("USE_BIASED", XPreferencesFactory.kBiasedVar.getBooleanO());
        return hashMap;
    }

    public final PermutationTest runCategoricalPermutationTest(int n, int n2, Dataset dataset, Template template) {
        return new PermutationTestImpl(n, n2, new LabelledVectorProcessors$None(), new Metrics$Signal2Noise(), SortMode.REAL, Order.DESCENDING, DatasetMetrics.getDefaultMetricParams(), dataset, template, null, new RandomSeedGenerators$Timestamp(), TemplateRandomizerType.NO_BALANCE, false, true);
    }

    public final Dataframe scoreDatasets(String string, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset[] datasetArray, Template[] templateArray) {
        int n = SanityKit.getAndEnforceEqualNumRows(datasetArray);
        SanityKit.enforceEqualNum(datasetArray, templateArray);
        Matrix matrix = new Matrix(n, datasetArray.length);
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            ScoredDataset scoredDataset = this.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, datasetArray[i2], templateArray[i2]);
            matrix.setColumn(n2++, scoredDataset.getScoresV(true));
            arrayList.add(SanityKit.getName(datasetArray[i2], templateArray[i2]));
        }
        return new Dataframe(string, matrix, arrayList, true);
    }

    public final StringDataframe scoreDatasetsS(String string, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset[] datasetArray, Template[] templateArray) {
        int n = SanityKit.getAndEnforceEqualNumRows(datasetArray);
        SanityKit.enforceEqualNum(datasetArray, templateArray);
        StringMatrix stringMatrix = new StringMatrix(n, datasetArray.length * 2);
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            ScoredDataset scoredDataset = this.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, datasetArray[i2], templateArray[i2]);
            stringMatrix.setColumn(n2++, scoredDataset.getRankedNamesArray());
            stringMatrix.setColumn(n2++, scoredDataset.getScoresV(true));
            arrayList.add("Name" + SanityKit.getName(datasetArray[i2], templateArray[i2]));
            arrayList.add("Score" + SanityKit.getName(datasetArray[i2], templateArray[i2]));
        }
        return new StringDataframe(string, stringMatrix, arrayList, true);
    }

    public final StringDataframe scoreDatasetsS(String string, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset[] datasetArray, Template[] templateArray, GeneSet geneSet) {
        SanityKit.getAndEnforceEqualNumRows(datasetArray);
        SanityKit.enforceEqualNum(datasetArray, templateArray);
        StringMatrix stringMatrix = new StringMatrix(geneSet.getNumMembers(), datasetArray.length * 2);
        DatasetGenerators datasetGenerators = new DatasetGenerators();
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            Dataset dataset = datasetGenerators.extractRows(datasetArray[i2], geneSet);
            LabelledVector labelledVector = this.scoreDatasetLv(metric, sortMode, order, map, labelledVectorProcessor, dataset, templateArray[i2]);
            stringMatrix.setColumn(n++, labelledVector.getLabelsArray());
            stringMatrix.setColumn(n++, labelledVector.getScoresV(false).toArray());
            arrayList.add("Name_" + datasetArray[i2].getName());
            arrayList.add("Score_" + datasetArray[i2].getName());
        }
        return new StringDataframe(string, stringMatrix, arrayList, true);
    }

    public final StringDataframe restrict(StringDataframe stringDataframe, GeneSet geneSet) {
        if (stringDataframe.getNumCol() % 2 != 0) {
            throw new IllegalArgumentException("sdfFull has to have even number of columns!: " + stringDataframe.getNumCol());
        }
        StringMatrix stringMatrix = new StringMatrix(geneSet.getNumMembers(), stringDataframe.getNumCol());
        for (int i2 = 0; i2 < stringDataframe.getNumCol(); i2 += 2) {
            int n = i2;
            int n2 = i2 + 1;
            List list = stringDataframe.getColumnAsList(n);
            String[] stringArray = stringDataframe.getColumn(n2);
            String[] stringArray2 = new String[geneSet.getNumMembers()];
            String[] stringArray3 = new String[geneSet.getNumMembers()];
            for (int i3 = 0; i3 < geneSet.getNumMembers(); ++i3) {
                stringArray2[i3] = geneSet.getMember(i3);
                int n3 = list.indexOf(stringArray2[i3]);
                stringArray3[i3] = stringArray[n3];
            }
            stringMatrix.setColumn(n, stringArray2);
            stringMatrix.setColumn(n2, stringArray3);
        }
        return new StringDataframe(stringDataframe.getName(), stringMatrix, stringDataframe.getColumnNames(), true);
    }

    public final ScoredDataset scoreDataset(Dataset dataset, Template template) {
        return this.scoreDataset((Metric)new Metrics$Signal2Noise(), SortMode.REAL, Order.DESCENDING, new HashMap(), (LabelledVectorProcessor)new LabelledVectorProcessors$None(), dataset, template);
    }

    public final ScoredDataset scoreDataset_fold(Dataset dataset, Template template, boolean bl) {
        Metrics$AbstractMetric metrics$AbstractMetric = bl ? new Metrics$ClassMeansRatio() : new Metrics$ClassMediansRatio();
        return this.scoreDataset((Metric)metrics$AbstractMetric, SortMode.REAL, Order.DESCENDING, new HashMap(), (LabelledVectorProcessor)new LabelledVectorProcessors$None(), dataset, template);
    }

    public final ScoredDataset scoreDataset(DT dT) {
        return this.scoreDataset(dT.ds, dT.t);
    }

    public final ScoredDataset scoreDataset(DatasetTemplate datasetTemplate) {
        return this.scoreDataset(datasetTemplate.getDataset(), datasetTemplate.getTemplate());
    }

    public final ScoredDataset scoreDataset(Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        AddressedVector addressedVector = this.calcSortedMetric(metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        return new ScoredDatasetImpl(addressedVector, dataset);
    }

    public final DatasetMetrics$ScoredStruc scoreDatasetStruc(Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        DatasetMetrics$ScoredStruc datasetMetrics$ScoredStruc = this.calcSortedMetricStruc(metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        datasetMetrics$ScoredStruc.sds = new ScoredDatasetImpl(datasetMetrics$ScoredStruc.av, dataset);
        return datasetMetrics$ScoredStruc;
    }

    public final ScoredDataset scoreDataset(Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, DT dT) {
        AddressedVector addressedVector = this.calcSortedMetric(metric, sortMode, order, map, labelledVectorProcessor, dT.ds, dT.t);
        return new ScoredDatasetImpl(addressedVector, dT.ds);
    }

    public final ScoredDataset scoreDataset(Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, DatasetTemplate datasetTemplate) {
        AddressedVector addressedVector = this.calcSortedMetric(metric, sortMode, order, map, labelledVectorProcessor, datasetTemplate.getDataset(), datasetTemplate.getTemplate());
        return new ScoredDatasetImpl(addressedVector, datasetTemplate.getDataset());
    }

    public final ScoredDataset[] scoreDataset(Metric metric, SortMode[] sortModeArray, Order[] orderArray, Map map, LabelledVectorProcessor labelledVectorProcessor, DT dT) {
        List list = this._calcUNSOMetric(metric, map, labelledVectorProcessor, dT.ds, dT.t);
        ScoredDataset[] scoredDatasetArray = new ScoredDataset[orderArray.length];
        for (int i2 = 0; i2 < orderArray.length; ++i2) {
            DoubleElement.sort(sortModeArray[i2], orderArray[i2], list);
            scoredDatasetArray[i2] = new ScoredDatasetImpl(new AddressedVector(list), dT.ds);
        }
        return scoredDatasetArray;
    }

    public final ScoredDataset[] scoreDataset(Metric metric, SortMode[] sortModeArray, Order[] orderArray, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        List list = this._calcUNSOMetric(metric, map, labelledVectorProcessor, dataset, template);
        ScoredDataset[] scoredDatasetArray = new ScoredDataset[orderArray.length];
        for (int i2 = 0; i2 < orderArray.length; ++i2) {
            DoubleElement.sort(sortModeArray[i2], orderArray[i2], list);
            scoredDatasetArray[i2] = new ScoredDatasetImpl(new AddressedVector(list), dataset);
        }
        return scoredDatasetArray;
    }

    public final ScoredDataset scoreDataset(String string, int n, int n2, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        AddressedVector addressedVector = this.calcSortedMetric(n, n2, metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        return new ScoredDatasetImpl(string, addressedVector, dataset);
    }

    public final ScoredDataset scoreDataset(int n, int n2, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        AddressedVector addressedVector = this.calcSortedMetric(n, n2, metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        return new ScoredDatasetImpl(addressedVector, dataset);
    }

    public final LabelledVector scoreDatasetLv(Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        AddressedVector addressedVector = this.calcSortedMetric(metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        return new LabelledVector(addressedVector, dataset);
    }

    public final AddressedVector calcSortedMetric(Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        return this.calcSortedMetricStruc((Metric)metric, (SortMode)sortMode, (Order)order, (Map)map, (LabelledVectorProcessor)labelledVectorProcessor, (Dataset)dataset, (Template)template).av;
    }

    public final DatasetMetrics$ScoredStruc calcSortedMetricStruc(Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        if (dataset == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        if (sortMode == null) {
            throw new IllegalArgumentException("Param sort cannot be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("Param order cannot be null");
        }
        ArrayList<DoubleElement> arrayList = new ArrayList<DoubleElement>(dataset.getNumRow());
        DoubleElement[] doubleElementArray = new DoubleElement[dataset.getNumRow()];
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            double d2 = metric.getScore(dataset.getRow(i2), template, map);
            DoubleElement doubleElement = new DoubleElement(i2, d2);
            arrayList.add(doubleElement);
            doubleElementArray[i2] = doubleElement;
        }
        DoubleElement.sort(sortMode, order, arrayList);
        labelledVectorProcessor.process(arrayList);
        return new DatasetMetrics$ScoredStruc(doubleElementArray, new AddressedVector(arrayList));
    }

    public final List _calcUNSOMetric(Metric metric, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        if (dataset == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Param template cannot be null");
        }
        if (metric == null) {
            throw new IllegalArgumentException("Param metric cannot be null");
        }
        ArrayList<DoubleElement> arrayList = new ArrayList<DoubleElement>(dataset.getNumRow());
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            double d2 = metric.getScore(dataset.getRow(i2), template, map);
            arrayList.add(new DoubleElement(i2, d2));
        }
        labelledVectorProcessor.process(arrayList);
        return arrayList;
    }

    public final AddressedVector calcSortedMetric(int n, int n2, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        int n3;
        if (dataset == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        if (n > dataset.getNumRow()) {
            throw new IllegalArgumentException("Too many top markers requested: " + n + " Dataset size is: " + dataset.getNumRow());
        }
        if (n2 > dataset.getNumRow()) {
            throw new IllegalArgumentException("Too many bottom markers requested: " + n + " Dataset size is: " + dataset.getNumRow());
        }
        AddressedVector addressedVector = this.calcSortedMetric(metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        int[] nArray = new int[n + n2];
        Vector vector = new Vector(n + n2);
        for (n3 = 0; n3 < n; ++n3) {
            nArray[n3] = addressedVector.getAddress(n3);
            vector.setElement(n3, addressedVector.getScore(n3));
        }
        for (int i2 = addressedVector.getSize() - n2; i2 < addressedVector.getSize(); ++i2) {
            nArray[n3] = addressedVector.getAddress(i2);
            vector.setElement(n3, addressedVector.getScore(i2));
            ++n3;
        }
        return new AddressedVector(vector, nArray, true);
    }

    public final Vector calcUNSOMetric(Metric metric, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        if (dataset == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        if (metric == null) {
            throw new IllegalArgumentException("Param metric cannot be null");
        }
        Vector vector = new Vector(dataset.getNumRow());
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            vector.setElement(i2, (float)metric.getScore(dataset.getRow(i2), template, map));
        }
        return labelledVectorProcessor.process(vector);
    }

    public final Dataframe calcUNSOMetrics(Metric[] metricArray, Map[] mapArray, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        if (metricArray.length != mapArray.length) {
            throw new MismatchedSizeException("metrics", metricArray, "metricParams", mapArray);
        }
        Matrix matrix = new Matrix(dataset.getNumRow(), metricArray.length);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < metricArray.length; ++i2) {
            Vector vector = this.calcUNSOMetric(metricArray[i2], mapArray[i2], labelledVectorProcessor, dataset, template);
            matrix.setColumn(i2, vector);
            arrayList.add(metricArray[i2].getName());
        }
        return new Dataframe("all_metrics_for_" + template.getName(), matrix, dataset.getRowNames(), arrayList, true);
    }

    public final Dataframe calcUNSOMetrics(Metric[] metricArray, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        Map[] mapArray = new Map[metricArray.length];
        for (int i2 = 0; i2 < metricArray.length; ++i2) {
            mapArray[i2] = map;
        }
        return this.calcUNSOMetrics(metricArray, mapArray, labelledVectorProcessor, dataset, template);
    }

    public final Matrix scoreAndPermuteDataset(int n, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, int n2, Dataset dataset, Template template, RandomSeedGenerator randomSeedGenerator) {
        Matrix matrix = new Matrix(n2, 1 + n);
        ScoredDataset scoredDataset = this.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        matrix.setColumn(0, scoredDataset.extractRanked(n2, true).getScoresV(false));
        Template[] templateArray = TemplateFactoryRandomizer.createRandomTemplates(n, template, randomSeedGenerator);
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            ScoredDataset scoredDataset2 = this.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, dataset, templateArray[i2]);
            matrix.setColumn(i2 + 1, scoredDataset2.extractRanked(n2, true).getScoresV(false));
        }
        return matrix;
    }

    public final RankedFeature[] getTopXMarkers(int n, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        if (n > dataset.getNumRow()) {
            throw new IllegalArgumentException("topX: " + n + " cannot be > than num of rows in dataset: " + dataset.getNumRow());
        }
        ScoredDataset scoredDataset = this.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        RankedFeature[] rankedFeatureArray = new DefaultRankedFeature[n];
        for (int i2 = 0; i2 < n; ++i2) {
            rankedFeatureArray[i2] = new DefaultRankedFeature(scoredDataset.getRowName(i2), i2, scoredDataset.getScore(i2));
        }
        return rankedFeatureArray;
    }

    public final GeneSet getTopXMarkersAsGeneSet(Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, int n, Dataset dataset, Template template) {
        if (n > dataset.getNumRow()) {
            throw new IllegalArgumentException("topX: " + n + " cannot be > than num of rows in dataset: " + dataset.getNumRow());
        }
        ScoredDataset scoredDataset = this.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < n; ++i2) {
            String string = scoredDataset.getRowName(i2);
            if (hashSet.contains(string)) {
                throw new IllegalStateException("Duplicate row: " + string);
            }
            hashSet.add(string);
        }
        return new FSet(dataset.getName() + "_" + template.getName() + "_" + n + "markers", hashSet);
    }

    public final GeneSet[] getTopXMarkers(int[] nArray, Metric metric, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        Order order = Order.DESCENDING;
        ScoredDataset scoredDataset = this.scoreDataset(metric, SortMode.REAL, order, map, labelledVectorProcessor, dataset, template);
        GeneSet[] geneSetArray = new GeneSet[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            geneSetArray[i2] = scoredDataset.getNamesOfUpOrDnXRanks_gs(nArray[i2], true);
        }
        return geneSetArray;
    }

    public final GeneSet getTopXMarker(int n, Metric metric, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template) {
        Order order = Order.DESCENDING;
        ScoredDataset scoredDataset = this.scoreDataset(metric, SortMode.REAL, order, map, labelledVectorProcessor, dataset, template);
        return scoredDataset.getNamesOfUpOrDnXRanks_gs(n, true);
    }
}

