/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.AlgMap;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.DatasetStatsCore$ColGeneSetsVector;
import edu.mit.broad.genome.alg.DatasetStatsCore$TwoClassMarkerStats;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics$ClassMeansRatio;
import edu.mit.broad.genome.alg.Metrics$Signal2Noise;
import edu.mit.broad.genome.alg.VectorSplitter;
import edu.mit.broad.genome.alg.gsea.GeneSetCohort;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.SimpleRange;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.VectorFunctor$Statistic;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import gnu.trove.TFloatArrayList;
import gnu.trove.THashMap;
import gnu.trove.TObjectFloatHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import xtools.api.param.BadParamException;

public class DatasetStatsCore {
    private Logger log = XLogger.getLogger(DatasetStatsCore.class);

    public final THashMap hashProbeRanges(Range[] rangeArray, Dataset dataset, boolean bl) {
        THashMap tHashMap = new THashMap();
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            Range[] rangeArray2 = SimpleRange.cloneShallow(rangeArray);
            Vector vector = dataset.getRow(i2);
            vector.bin(rangeArray2, true);
            if (bl) {
                tHashMap.put(dataset.getRowName(i2), SimpleRange.toString_counts_only(rangeArray2, '\t'));
                continue;
            }
            tHashMap.put(dataset.getRowName(i2), rangeArray2);
        }
        return tHashMap;
    }

    public final TObjectFloatHashMap hashProbeVariation(Dataset dataset) {
        TObjectFloatHashMap tObjectFloatHashMap = new TObjectFloatHashMap();
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            Vector vector = dataset.getRow(i2);
            tObjectFloatHashMap.put(dataset.getRowName(i2), (float)vector.stddev(false, false));
        }
        return tObjectFloatHashMap;
    }

    public final Map calc2MetricMarkerScores(Dataset dataset, Template template) {
        return this.calc2ClassCategoricalMetricMarkerScores(dataset, template, new Metrics$Signal2Noise(), DatasetMetrics.getDefaultMetricParams());
    }

    public final Map calc2MetricMarkerScores_class_means(Dataset dataset, Template template) {
        return this.calc2ClassCategoricalMetricMarkerScores(dataset, template, new Metrics$ClassMeansRatio(), DatasetMetrics.getDefaultMetricParams());
    }

    public final Map calc2ClassCategoricalMetricMarkerScores(Dataset dataset, Template template, Metric metric, Map map) {
        if (!metric.isCategorical()) {
            throw new IllegalArgumentException("Not a 2 class categorical metric: " + metric);
        }
        HashMap<String, DatasetStatsCore$TwoClassMarkerStats> hashMap = new HashMap<String, DatasetStatsCore$TwoClassMarkerStats>();
        boolean bl = AlgMap.isBiased(map);
        boolean bl2 = AlgMap.isFixLowVar(map);
        boolean bl3 = AlgMap.isMedian(map);
        VectorSplitter vectorSplitter = new VectorSplitter(metric.getMinNumSamplesNeededPerClassForCalculation());
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            String string = dataset.getRowName(i2);
            Vector vector = dataset.getRow(i2);
            Vector[] vectorArray = vectorSplitter.splitBiphasic_nansafe(vector, template);
            if (i2 == 0 && (metric.getName().equalsIgnoreCase("Signal2Noise") || metric.getName().equalsIgnoreCase("tTest"))) {
                if (dataset.getNumCol() < 6) {
                    throw new BadParamException("Too few samples in the dataset to use this metric", 1006);
                }
                if (vectorArray[0].getSize() < 3) {
                    throw new BadParamException("Too few samples in class A of the dataset to use this metric", 1006);
                }
                if (vectorArray[1].getSize() < 3) {
                    throw new BadParamException("Too few samples in class B of the dataset to use this metric", 1006);
                }
            }
            DatasetStatsCore$TwoClassMarkerStats datasetStatsCore$TwoClassMarkerStats = new DatasetStatsCore$TwoClassMarkerStats();
            if (vectorArray == null || vectorArray[0] == null || vectorArray[1] == null) {
                DatasetStatsCore$TwoClassMarkerStats.access$002(datasetStatsCore$TwoClassMarkerStats, Double.NaN);
                DatasetStatsCore$TwoClassMarkerStats.access$102(datasetStatsCore$TwoClassMarkerStats, Double.NaN);
                DatasetStatsCore$TwoClassMarkerStats.access$202(datasetStatsCore$TwoClassMarkerStats, Double.NaN);
                DatasetStatsCore$TwoClassMarkerStats.access$302(datasetStatsCore$TwoClassMarkerStats, Double.NaN);
                DatasetStatsCore$TwoClassMarkerStats.access$402(datasetStatsCore$TwoClassMarkerStats, Double.NaN);
                DatasetStatsCore$TwoClassMarkerStats.access$502(datasetStatsCore$TwoClassMarkerStats, Double.NaN);
                DatasetStatsCore$TwoClassMarkerStats.access$602(datasetStatsCore$TwoClassMarkerStats, Double.NaN);
                this.log.warn("Omitting as too few good data points: " + string);
            } else {
                DatasetStatsCore$TwoClassMarkerStats.access$002(datasetStatsCore$TwoClassMarkerStats, (float)metric.getScore(vector, template, map));
                Vector vector2 = new Vector(vectorArray);
                if (bl3) {
                    DatasetStatsCore$TwoClassMarkerStats.access$102(datasetStatsCore$TwoClassMarkerStats, vectorArray[0].median());
                    DatasetStatsCore$TwoClassMarkerStats.access$202(datasetStatsCore$TwoClassMarkerStats, vectorArray[1].median());
                    DatasetStatsCore$TwoClassMarkerStats.access$302(datasetStatsCore$TwoClassMarkerStats, vector2.median());
                } else {
                    DatasetStatsCore$TwoClassMarkerStats.access$102(datasetStatsCore$TwoClassMarkerStats, vectorArray[0].mean());
                    DatasetStatsCore$TwoClassMarkerStats.access$202(datasetStatsCore$TwoClassMarkerStats, vectorArray[1].mean());
                    DatasetStatsCore$TwoClassMarkerStats.access$302(datasetStatsCore$TwoClassMarkerStats, vector2.mean());
                }
                DatasetStatsCore$TwoClassMarkerStats.access$402(datasetStatsCore$TwoClassMarkerStats, (float)vectorArray[0].stddev(bl, bl2));
                DatasetStatsCore$TwoClassMarkerStats.access$502(datasetStatsCore$TwoClassMarkerStats, (float)vectorArray[1].stddev(bl, bl2));
                DatasetStatsCore$TwoClassMarkerStats.access$602(datasetStatsCore$TwoClassMarkerStats, (float)vector2.stddev(bl, bl2));
            }
            if (hashMap.containsKey(string)) {
                throw new RuntimeException("Duplicate row names in dataset: " + dataset.getName() + " rowname: " + string + " row: " + i2);
            }
            hashMap.put(string, datasetStatsCore$TwoClassMarkerStats);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public final DatasetStatsCore$TwoClassMarkerStats calc2ClassCategoricalMetricMarkerScores(Dataset dataset, Template template, String string) {
        return this.calc2ClassCategoricalMetricMarkerScores(dataset, template, new Metrics$Signal2Noise(), new HashMap(), string);
    }

    public final DatasetStatsCore$TwoClassMarkerStats calc2ClassCategoricalMetricMarkerScores(Dataset dataset, Template template, Metric metric, Map map, String string) {
        if (!metric.isCategorical()) {
            throw new IllegalArgumentException("Not a 2 class categorical metric: " + metric);
        }
        boolean bl = AlgMap.isBiased(map);
        boolean bl2 = AlgMap.isFixLowVar(map);
        boolean bl3 = AlgMap.isMedian(map);
        VectorSplitter vectorSplitter = new VectorSplitter(1);
        Vector vector = dataset.getRow(string);
        Vector[] vectorArray = vectorSplitter.splitBiphasic_nansafe(vector, template);
        DatasetStatsCore$TwoClassMarkerStats datasetStatsCore$TwoClassMarkerStats = new DatasetStatsCore$TwoClassMarkerStats();
        DatasetStatsCore$TwoClassMarkerStats.access$002(datasetStatsCore$TwoClassMarkerStats, (float)metric.getScore(vector, template, map));
        if (bl3) {
            DatasetStatsCore$TwoClassMarkerStats.access$102(datasetStatsCore$TwoClassMarkerStats, vectorArray[0].median());
            DatasetStatsCore$TwoClassMarkerStats.access$202(datasetStatsCore$TwoClassMarkerStats, vectorArray[1].median());
        } else {
            DatasetStatsCore$TwoClassMarkerStats.access$102(datasetStatsCore$TwoClassMarkerStats, vectorArray[0].mean());
            DatasetStatsCore$TwoClassMarkerStats.access$202(datasetStatsCore$TwoClassMarkerStats, vectorArray[1].mean());
        }
        DatasetStatsCore$TwoClassMarkerStats.access$402(datasetStatsCore$TwoClassMarkerStats, (float)vectorArray[0].stddev(bl, bl2));
        DatasetStatsCore$TwoClassMarkerStats.access$502(datasetStatsCore$TwoClassMarkerStats, (float)vectorArray[1].stddev(bl, bl2));
        return datasetStatsCore$TwoClassMarkerStats;
    }

    public final Dataframe calcRowStatsDf(VectorFunctor$Statistic[] vectorFunctor$StatisticArray, Dataset dataset) {
        Vector[] vectorArray = this.calcRowStats(vectorFunctor$StatisticArray, dataset);
        Matrix matrix = new Matrix(dataset.getNumRow(), vectorFunctor$StatisticArray.length);
        ArrayList<String> arrayList = new ArrayList<String>(vectorFunctor$StatisticArray.length);
        for (int i2 = 0; i2 < vectorFunctor$StatisticArray.length; ++i2) {
            matrix.setColumn(i2, vectorArray[i2]);
            arrayList.add(vectorFunctor$StatisticArray[i2].getName());
        }
        return new Dataframe("all_stats_for_" + dataset.getName(), matrix, dataset.getRowNames(), arrayList, true);
    }

    public final Vector calcRowStat(int n, VectorFunctor$Statistic vectorFunctor$Statistic, Dataset dataset, Template$Class template$Class) {
        return this.calcRowStats(n, new VectorFunctor$Statistic[]{vectorFunctor$Statistic}, dataset, template$Class)[0];
    }

    public final Vector[] calcRowStats(VectorFunctor$Statistic[] vectorFunctor$StatisticArray, Dataset dataset) {
        int n;
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter ds cannot be null");
        }
        Vector[] vectorArray = new Vector[vectorFunctor$StatisticArray.length];
        for (n = 0; n < vectorFunctor$StatisticArray.length; ++n) {
            vectorArray[n] = new Vector(dataset.getNumRow());
        }
        for (n = 0; n < dataset.getNumRow(); ++n) {
            Vector vector = dataset.getRow(n);
            for (int i2 = 0; i2 < vectorFunctor$StatisticArray.length; ++i2) {
                vectorArray[i2].setElement(n, (float)vectorFunctor$StatisticArray[i2].getValue(vector));
            }
        }
        return vectorArray;
    }

    public final Vector[] calcRowStats(VectorFunctor$Statistic[] vectorFunctor$StatisticArray, Dataset dataset, Template$Class template$Class) {
        int n;
        Vector[] vectorArray = new Vector[vectorFunctor$StatisticArray.length];
        for (n = 0; n < vectorFunctor$StatisticArray.length; ++n) {
            vectorArray[n] = new Vector(dataset.getNumRow());
        }
        for (n = 0; n < dataset.getNumRow(); ++n) {
            Vector vector = template$Class.extractByTemplateClass(dataset.getRow(n));
            for (int i2 = 0; i2 < vectorFunctor$StatisticArray.length; ++i2) {
                vectorArray[i2].setElement(n, (float)vectorFunctor$StatisticArray[i2].getValue(vector));
            }
        }
        return vectorArray;
    }

    public final Vector calcRowStat(VectorFunctor$Statistic vectorFunctor$Statistic, Dataset dataset, Template$Class template$Class) {
        Vector vector = new Vector(dataset.getNumRow());
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            Vector vector2 = template$Class.extractByTemplateClass(dataset.getRow(i2));
            vector.setElement(i2, (float)vectorFunctor$Statistic.getValue(vector2));
        }
        return vector;
    }

    public final Vector[] calcRowStats(int n, VectorFunctor$Statistic[] vectorFunctor$StatisticArray, Dataset dataset, Template$Class template$Class) {
        int n2;
        Vector[] vectorArray = new Vector[vectorFunctor$StatisticArray.length];
        for (n2 = 0; n2 < vectorFunctor$StatisticArray.length; ++n2) {
            vectorArray[n2] = new Vector(dataset.getNumRow());
        }
        for (n2 = 0; n2 < dataset.getNumRow(); ++n2) {
            Vector vector = template$Class.extractByTemplateClass(dataset.getRow(n2), n);
            for (int i2 = 0; i2 < vectorFunctor$StatisticArray.length; ++i2) {
                vectorArray[i2].setElement(n2, (float)vectorFunctor$StatisticArray[i2].getValue(vector));
            }
        }
        return vectorArray;
    }

    public final Vector calcRowStat(VectorFunctor$Statistic vectorFunctor$Statistic, Dataset dataset) {
        return this.calcRowStats(new VectorFunctor$Statistic[]{vectorFunctor$Statistic}, dataset)[0];
    }

    public final Vector getColumnDistances(int n, Dataset dataset, Metric metric, Map map) {
        Vector vector = new Vector(dataset.getNumCol() - 1);
        Vector vector2 = dataset.getColumn(n);
        boolean bl = false;
        int n2 = 0;
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            if (i2 == n) {
                bl = true;
            }
            double d2 = metric.getScore(vector2, dataset.getColumn(i2), map);
            vector.setElement(n2++, (float)d2);
        }
        if (!bl) {
            throw new IllegalArgumentException("Specified toCol: " + n + " was not encountered in the dataset");
        }
        return vector;
    }

    public final Vector extractGeneSetValuesFromDataset(int n, Dataset dataset, GeneSet geneSet) {
        int n2 = geneSet.getNumMembers(dataset);
        Vector vector = new Vector(n2);
        int n3 = 0;
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            String string = dataset.getRowName(i2);
            if (!geneSet.isMember(string)) continue;
            vector.setElement(n3++, dataset.getElement(i2, n));
        }
        if (n3 != n2) {
            throw new IllegalStateException("Failed sanity check cnt: " + n3 + " num: " + n2);
        }
        return vector;
    }

    public final Vector[] extractGeneSetValuesFromDataset(int n, Dataset dataset, GeneSetCohort geneSetCohort) {
        TFloatArrayList[] tFloatArrayListArray = new TFloatArrayList[geneSetCohort.getNumGeneSets()];
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            String string = dataset.getRowName(i2);
            float f2 = dataset.getElement(i2, n);
            for (int i3 = 0; i3 < geneSetCohort.getNumGeneSets(); ++i3) {
                if (i2 == 0) {
                    tFloatArrayListArray[i3] = new TFloatArrayList();
                }
                if (!geneSetCohort.isMember(i3, string)) continue;
                tFloatArrayListArray[i3].add(f2);
            }
        }
        Vector[] vectorArray = new Vector[tFloatArrayListArray.length];
        for (int i4 = 0; i4 < tFloatArrayListArray.length; ++i4) {
            vectorArray[i4] = new Vector(tFloatArrayListArray[i4]);
        }
        return vectorArray;
    }

    public final DatasetStatsCore$ColGeneSetsVector[] extractGeneSetValuesFromDataset(Dataset dataset, GeneSetCohort geneSetCohort) {
        int n;
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter ds cannot be null");
        }
        if (geneSetCohort == null) {
            throw new IllegalArgumentException("Parameter gcoh cannot be null");
        }
        DatasetStatsCore$ColGeneSetsVector[] datasetStatsCore$ColGeneSetsVectorArray = new DatasetStatsCore$ColGeneSetsVector[dataset.getNumCol()];
        for (n = 0; n < datasetStatsCore$ColGeneSetsVectorArray.length; ++n) {
            datasetStatsCore$ColGeneSetsVectorArray[n] = new DatasetStatsCore$ColGeneSetsVector(this, n, geneSetCohort.getNumGeneSets());
        }
        for (n = 0; n < dataset.getNumRow(); ++n) {
            String string = dataset.getRowName(n);
            for (int i2 = 0; i2 < geneSetCohort.getNumGeneSets(); ++i2) {
                if (!geneSetCohort.isMember(i2, string)) continue;
                for (int i3 = 0; i3 < dataset.getNumCol(); ++i3) {
                    datasetStatsCore$ColGeneSetsVectorArray[i3].values[i2].add(dataset.getElement(n, i3));
                }
            }
        }
        return datasetStatsCore$ColGeneSetsVectorArray;
    }

    public final Dataset[] dataset2EsDatasets(Dataset dataset, GeneSetCohort geneSetCohort, VectorFunctor$Statistic[] vectorFunctor$StatisticArray) {
        int n;
        Object[] objectArray;
        int n2;
        Matrix[] matrixArray = new Matrix[vectorFunctor$StatisticArray.length];
        for (n2 = 0; n2 < vectorFunctor$StatisticArray.length; ++n2) {
            matrixArray[n2] = new Matrix(dataset.getNumCol(), geneSetCohort.getNumGeneSets());
        }
        for (n2 = 0; n2 < dataset.getNumCol(); ++n2) {
            objectArray = this.extractGeneSetValuesFromDataset(n2, dataset, geneSetCohort);
            for (n = 0; n < objectArray.length; ++n) {
                for (int i2 = 0; i2 < vectorFunctor$StatisticArray.length; ++i2) {
                    matrixArray[i2].setElement(n, n2, (float)vectorFunctor$StatisticArray[i2].getValue((Vector)objectArray[n]));
                }
            }
        }
        List list = geneSetCohort.getGeneSetNames();
        objectArray = new Dataset[vectorFunctor$StatisticArray.length];
        for (n = 0; n < vectorFunctor$StatisticArray.length; ++n) {
            objectArray[n] = new DefaultDataset(dataset.getName() + "_" + vectorFunctor$StatisticArray[n].getName(), matrixArray[n], list, dataset.getColumnNames(), true, true, false, dataset.getAnnot());
        }
        return objectArray;
    }

    public final Dataset[] dataset2EsDatasets2(Dataset dataset, GeneSetCohort geneSetCohort, VectorFunctor$Statistic[] vectorFunctor$StatisticArray) {
        int n;
        Object[] objectArray;
        Matrix[] matrixArray = new Matrix[vectorFunctor$StatisticArray.length];
        for (int i2 = 0; i2 < vectorFunctor$StatisticArray.length; ++i2) {
            matrixArray[i2] = new Matrix(geneSetCohort.getNumGeneSets(), dataset.getNumCol());
        }
        DatasetStatsCore$ColGeneSetsVector[] datasetStatsCore$ColGeneSetsVectorArray = this.extractGeneSetValuesFromDataset(dataset, geneSetCohort);
        for (int i3 = 0; i3 < datasetStatsCore$ColGeneSetsVectorArray.length; ++i3) {
            objectArray = datasetStatsCore$ColGeneSetsVectorArray[i3].toVector();
            for (n = 0; n < objectArray.length; ++n) {
                for (int i4 = 0; i4 < vectorFunctor$StatisticArray.length; ++i4) {
                    matrixArray[i4].setElement(n, i3, (float)vectorFunctor$StatisticArray[i4].getValue((Vector)objectArray[n]));
                }
            }
        }
        List list = geneSetCohort.getGeneSetNames();
        objectArray = new Dataset[vectorFunctor$StatisticArray.length];
        for (n = 0; n < vectorFunctor$StatisticArray.length; ++n) {
            objectArray[n] = new DefaultDataset(dataset.getName() + "_" + vectorFunctor$StatisticArray[n].getName(), matrixArray[n], list, dataset.getColumnNames(), true, true, false, dataset.getAnnot());
        }
        return objectArray;
    }
}

