/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.AlgUtils;
import edu.mit.broad.genome.alg.FrequencyAnalysis;
import edu.mit.broad.genome.alg.GeneSetStats$HyperPValueComparator;
import edu.mit.broad.genome.alg.GeneSetStats$RedStruc;
import edu.mit.broad.genome.alg.TwoMer;
import edu.mit.broad.genome.math.HyperGeometricStruc;
import edu.mit.broad.genome.math.ObjectIndex;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.LabelledObject;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.meg.Gene;
import gnu.trove.TFloatIntHashMap;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class GeneSetStats {
    private final Logger log = XLogger.getLogger(GeneSetStats.class);

    public final GeneSetStats$RedStruc calcRedundancy(GeneSetMatrix geneSetMatrix, boolean bl) {
        return this.calcRedundancy(geneSetMatrix.getGeneSets(), bl);
    }

    public final float calcJacquardMean(GeneSetMatrix geneSetMatrix) {
        return this.calcRedundancy((GeneSet[])geneSetMatrix.getGeneSets(), (boolean)false).jacquardMean;
    }

    public final GeneSetStats$RedStruc calcRedundancy(GeneSet[] geneSetArray, boolean bl) {
        GeneSetStats$RedStruc geneSetStats$RedStruc = new GeneSetStats$RedStruc();
        if (bl) {
            geneSetStats$RedStruc.allFoundTwoMers = new HashSet();
            for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
                int n = geneSetArray[i2].getNumMembers();
                int n2 = n * (n - 1) / 2;
                Set set = this.hashTwoMers(geneSetArray[i2]);
                if (set.size() != n2) {
                    this.log.warn("Bad: " + set.size() + " " + n2);
                }
                geneSetStats$RedStruc.allFoundTwoMers.addAll(set);
                geneSetStats$RedStruc.totNumPairsPossible += n2;
            }
        }
        BitSetDataset bitSetDataset = new BitSetDataset(new DefaultGeneSetMatrix("foo", geneSetArray));
        Dataset dataset = bitSetDataset.and_by_or();
        LabelledVector labelledVector = this.getFeatureFrequency_lv(geneSetArray);
        geneSetStats$RedStruc.featureFreq = labelledVector.sort(SortMode.REAL, Order.DESCENDING);
        float f2 = 0.0f;
        geneSetStats$RedStruc.jacquardDistrib = new TFloatIntHashMap();
        for (int i3 = 0; i3 < dataset.getNumRow(); ++i3) {
            for (int i4 = 0; i4 < dataset.getNumCol(); ++i4) {
                f2 += dataset.getElement(i3, i4);
                if (i3 >= i4) continue;
                int n = geneSetStats$RedStruc.jacquardDistrib.get(dataset.getElement(i3, i4));
                geneSetStats$RedStruc.jacquardDistrib.put(dataset.getElement(i3, i4), ++n);
            }
        }
        geneSetStats$RedStruc.jacquardMean = f2 / (float)(dataset.getNumRow() * dataset.getNumRow());
        return geneSetStats$RedStruc;
    }

    public final Set hashTwoMers(GeneSet geneSet) {
        HashSet<TwoMer> hashSet = new HashSet<TwoMer>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            for (int i3 = 0; i3 < geneSet.getNumMembers(); ++i3) {
                if (i3 == i2) continue;
                hashSet.add(new TwoMer(string, geneSet.getMember(i3)));
            }
        }
        return hashSet;
    }

    public final LabelledObject[] calcHyperGeometric_genesets(GeneSet[] geneSetArray, GeneSetMatrix geneSetMatrix, double d2, int n, Collection collection) {
        int n2;
        if (geneSetArray == null) {
            throw new IllegalArgumentException("Parameter gsets cannot be null");
        }
        if (geneSetMatrix == null) {
            throw new IllegalArgumentException("Parameter gmdb cannot be null");
        }
        int[] nArray = new int[geneSetArray.length];
        ArrayList[] arrayListArray = new ArrayList[geneSetArray.length];
        ArrayList[] arrayListArray2 = new ArrayList[geneSetArray.length];
        for (n2 = 0; n2 < geneSetArray.length; ++n2) {
            nArray[n2] = geneSetArray[n2].getNumMembers(collection);
            arrayListArray[n2] = new ArrayList();
            arrayListArray2[n2] = new ArrayList();
            if (nArray[n2] == geneSetArray[n2].getNumMembers()) continue;
            throw new IllegalArgumentException("gsets not qualified!!: " + nArray[n2] + " " + geneSetArray[n2].getNumMembers() + " for: " + geneSetArray[n2].getName() + " " + geneSetArray[n2].getMembersS());
        }
        n2 = collection.size();
        this.log.info("symbol size for hypergeo: " + n2);
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            GeneSet geneSet = geneSetMatrix.getGeneSet(i2).cloneDeep(collection);
            int n3 = geneSet.getNumMembers();
            if (n3 == 0) {
                this.log.warn("No matches to the symbol set");
                continue;
            }
            if (n3 >= n) continue;
            for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
                GeneSet geneSet2 = AlgUtils.intersect("foo", geneSetArray[i3], geneSet);
                int n4 = geneSet2.getNumMembers();
                double d3 = XMath.hypergeometric(n4, n2, nArray[i3], n3);
                if (!(d3 <= d2) || n4 == 0) continue;
                arrayListArray2[i3].add(new HyperGeometricStruc(d3, n4, geneSetArray[i3].getNumMembers(), n3, geneSet2));
                arrayListArray[i3].add(geneSet.getName());
            }
        }
        LabelledObject[] labelledObjectArray = new LabelledObject[geneSetArray.length];
        for (int i4 = 0; i4 < geneSetArray.length; ++i4) {
            labelledObjectArray[i4] = new LabelledObject(AuxUtils.getAuxNameOnlyNoHash(geneSetArray[i4].getName()), arrayListArray[i4], arrayListArray2[i4]);
            labelledObjectArray[i4] = this.sort(labelledObjectArray[i4]);
        }
        return labelledObjectArray;
    }

    public final StringDataframe createHyperStatsReportInProbeSpace(String string, GeneSetMatrix geneSetMatrix, GeneSetMatrix geneSetMatrix2, Chip chip) {
        LabelledVector labelledVector = this.getFeatureFrequency_lv(geneSetMatrix);
        TObjectIntHashMap tObjectIntHashMap = this.getFeatureFrequency(geneSetMatrix2);
        LabelledVector labelledVector2 = this.getHyperGeometric(geneSetMatrix, geneSetMatrix2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("DEFAULT_TITLE");
        arrayList.add("FREQ_IN_SIGNALS");
        arrayList.add("FREQ_IN_GENSETSDB");
        arrayList.add("HYPER_PVALUE");
        StringMatrix stringMatrix = new StringMatrix(labelledVector.getSize(), arrayList.size());
        for (int i2 = 0; i2 < labelledVector.getSize(); ++i2) {
            int n = 0;
            String string2 = labelledVector.getLabel(i2);
            stringMatrix.setElement(i2, n++, chip.getHugo(string2).getTitle());
            stringMatrix.setElement(i2, n++, labelledVector.getScore(i2));
            stringMatrix.setElement(i2, n++, tObjectIntHashMap.get(string2));
            stringMatrix.setElement(i2, n, labelledVector2.getScore(i2));
            if (string2.equals(labelledVector2.getLabel(i2))) continue;
            throw new IllegalStateException("Mismatch: " + string2);
        }
        return new StringDataframe("hyper_stats_" + string, stringMatrix, labelledVector.getLabels(), arrayList, true);
    }

    public final StringDataframe createHyperStatsReportInGeneSymbolSpace(String string, GeneSetMatrix geneSetMatrix, GeneSetMatrix geneSetMatrix2, Chip chip) {
        if (chip == null) {
            throw new IllegalArgumentException("Parameter chip cannot be null");
        }
        TObjectIntHashMap tObjectIntHashMap = this.getGeneSymbolFrequency(geneSetMatrix, chip, true);
        TObjectIntHashMap tObjectIntHashMap2 = this.getGeneSymbolFrequency(geneSetMatrix2, chip, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("DEFAULT_TITLE");
        arrayList.add("FREQ_IN_SIGNALS");
        arrayList.add("FREQ_IN_GENSETSDB");
        arrayList.add("HYPER_PVALUE");
        StringMatrix stringMatrix = new StringMatrix(tObjectIntHashMap.size(), arrayList.size());
        TObjectIntIterator tObjectIntIterator = tObjectIntHashMap.iterator();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = AlgUtils.countTotal(tObjectIntHashMap2);
        int n2 = AlgUtils.countTotal(tObjectIntHashMap);
        int n3 = 0;
        int n4 = tObjectIntHashMap.size();
        while (n4-- > 0) {
            tObjectIntIterator.advance();
            String string2 = tObjectIntIterator.key().toString();
            arrayList2.add(string2);
            int n5 = tObjectIntIterator.value();
            int n6 = tObjectIntHashMap2.get(string2);
            if (n6 <= 0) {
                throw new IllegalArgumentException("The gmdb is invalid missing entry for: " + string2);
            }
            double d2 = XMath.hypergeometric(n5, n, n6, n2);
            int n7 = 0;
            Gene gene = chip.getHugo(string2);
            stringMatrix.setElement(n3, n7++, gene.getTitle());
            stringMatrix.setElement(n3, n7++, n5);
            stringMatrix.setElement(n3, n7++, n6);
            stringMatrix.setElement(n3, n7, d2);
            ++n3;
        }
        return new StringDataframe("hyper_stats_genes_" + string, stringMatrix, arrayList2, arrayList, true);
    }

    public final TObjectIntHashMap getFeatureFrequency(GeneSetMatrix geneSetMatrix) {
        String[] stringArray = geneSetMatrix.getAllMemberNames();
        return FrequencyAnalysis.featureFreq(stringArray);
    }

    public final TObjectIntHashMap getFeatureFrequency(GeneSet[] geneSetArray) {
        return this.getFeatureFrequency(new DefaultGeneSetMatrix("tmp", geneSetArray));
    }

    public final LabelledVector getFeatureFrequency_lv(GeneSet[] geneSetArray) {
        return this.getFeatureFrequency_lv(new DefaultGeneSetMatrix("tmp", geneSetArray));
    }

    public final LabelledVector getFeatureFrequency_lv(GeneSetMatrix geneSetMatrix) {
        TObjectIntHashMap tObjectIntHashMap = this.getFeatureFrequency(geneSetMatrix);
        String[] stringArray = geneSetMatrix.getAllMemberNamesOnlyOnce();
        Vector vector = new Vector(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n = tObjectIntHashMap.get(stringArray[i2]);
            vector.setElement(i2, n);
        }
        return new LabelledVector(stringArray, vector);
    }

    public final RankedList getFeatureFrequency_rl(GeneSetMatrix geneSetMatrix, Order order) {
        return this.getFeatureFrequency_lv(geneSetMatrix).sort(SortMode.REAL, order);
    }

    public final RankedList getFeatureFrequency_rl(GeneSet[] geneSetArray, Order order) {
        return this.getFeatureFrequency_lv(geneSetArray).sort(SortMode.REAL, order);
    }

    public final TObjectIntHashMap getGeneSymbolFrequency(GeneSetMatrix geneSetMatrix, Chip chip, boolean bl) {
        if (chip == null) {
            throw new IllegalArgumentException("Parameter chip cannot be null");
        }
        if (geneSetMatrix == null) {
            throw new IllegalArgumentException("Parameter gm cannot be null");
        }
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            Set set = chip.getSymbols(geneSetMatrix.getGeneSet(i2), Chip.REPLACE_WITH_PROBEID);
            if (bl) {
                arrayList.addAll(set);
                continue;
            }
            arrayList.addAll(new HashSet(set));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return FrequencyAnalysis.featureFreq(stringArray);
    }

    public final LabelledVector getHyperGeometric(GeneSetMatrix geneSetMatrix, GeneSetMatrix geneSetMatrix2) {
        int n = geneSetMatrix2.getAllMemberNamesOnlyOnceS().size();
        String[] stringArray = geneSetMatrix2.getAllMemberNames();
        TObjectIntHashMap tObjectIntHashMap = FrequencyAnalysis.featureFreq(stringArray);
        String[] stringArray2 = geneSetMatrix.getAllMemberNames();
        TObjectIntHashMap tObjectIntHashMap2 = FrequencyAnalysis.featureFreq(stringArray2);
        String[] stringArray3 = geneSetMatrix.getAllMemberNamesOnlyOnce();
        int n2 = stringArray3.length;
        Vector vector = new Vector(stringArray3.length);
        for (int i2 = 0; i2 < stringArray3.length; ++i2) {
            int n3 = tObjectIntHashMap2.get(stringArray3[i2]);
            int n4 = tObjectIntHashMap.get(stringArray3[i2]);
            double d2 = XMath.hypergeometric(n3, n, n4, n2);
            vector.setElement(i2, (float)d2);
        }
        return new LabelledVector(stringArray3, vector);
    }

    public final BitSetDataset getCoOccs(GeneSetMatrix geneSetMatrix, int n) {
        LabelledVector labelledVector = this.getFeatureFrequency_lv(geneSetMatrix);
        String[] stringArray = labelledVector.getLabelsForValuesArray(n, 2.1474836E9f);
        String string = geneSetMatrix.getName() + "_cutoff_" + n;
        return geneSetMatrix.getGeneSetMembershipBitSetDataset(string, stringArray);
    }

    private LabelledObject sort(LabelledObject labelledObject) {
        int n = labelledObject.getSize();
        ArrayList<ObjectIndex> arrayList = new ArrayList<ObjectIndex>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            arrayList.add(new ObjectIndex(labelledObject.getElement(i2), i2));
        }
        Collections.sort(arrayList, new GeneSetStats$HyperPValueComparator());
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        ArrayList<Object> arrayList3 = new ArrayList<Object>(arrayList.size());
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            ObjectIndex objectIndex = (ObjectIndex)arrayList.get(i3);
            arrayList2.add(labelledObject.getLabel(objectIndex.getIndex()));
            arrayList3.add(labelledObject.getElement(objectIndex.getIndex()));
        }
        return new LabelledObject(labelledObject.getName(), arrayList2, arrayList3);
    }
}

