/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.CorrMetric;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics$Bhattacharyya;
import edu.mit.broad.genome.alg.Metrics$ClassDiff;
import edu.mit.broad.genome.alg.Metrics$ClassLog2Ratio;
import edu.mit.broad.genome.alg.Metrics$ClassMeansDiff;
import edu.mit.broad.genome.alg.Metrics$ClassMeansLog2Ratio;
import edu.mit.broad.genome.alg.Metrics$ClassMeansRatio;
import edu.mit.broad.genome.alg.Metrics$ClassMediansDiff;
import edu.mit.broad.genome.alg.Metrics$ClassMediansLog2Ratio;
import edu.mit.broad.genome.alg.Metrics$ClassMediansRatio;
import edu.mit.broad.genome.alg.Metrics$ClassOfInterestMean;
import edu.mit.broad.genome.alg.Metrics$ClassOfInterestMedian;
import edu.mit.broad.genome.alg.Metrics$ClassRatio;
import edu.mit.broad.genome.alg.Metrics$Cosine;
import edu.mit.broad.genome.alg.Metrics$Euclidean;
import edu.mit.broad.genome.alg.Metrics$FeatureVar;
import edu.mit.broad.genome.alg.Metrics$FeatureVarD;
import edu.mit.broad.genome.alg.Metrics$KendallsTau;
import edu.mit.broad.genome.alg.Metrics$Manhatten;
import edu.mit.broad.genome.alg.Metrics$None;
import edu.mit.broad.genome.alg.Metrics$Pearson;
import edu.mit.broad.genome.alg.Metrics$PearsonD;
import edu.mit.broad.genome.alg.Metrics$RegressionSlope;
import edu.mit.broad.genome.alg.Metrics$Signal2Noise;
import edu.mit.broad.genome.alg.Metrics$Spearman;
import edu.mit.broad.genome.alg.Metrics$tTest;
import edu.mit.broad.genome.alg.RankMetric;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Metrics {
    protected static final transient Logger klog = XLogger.getLogger(Metrics.class);
    private static final int MIN_NUM_FOR_VAR = 3;

    public static final Metric[] createAllMetrics() {
        return new Metric[]{new Metrics$Pearson(), new Metrics$Cosine(), new Metrics$Euclidean(), new Metrics$Manhatten(), new Metrics$FeatureVar(), new Metrics$FeatureVarD(), new Metrics$tTest(), new Metrics$Signal2Noise(), new Metrics$None(), new Metrics$RegressionSlope(), new Metrics$Bhattacharyya(), new Metrics$PearsonD(), new Metrics$ClassMeansDiff(), new Metrics$ClassMediansDiff(), new Metrics$ClassOfInterestMean(), new Metrics$ClassOfInterestMedian(), new Metrics$ClassMeansRatio(), new Metrics$ClassMediansRatio(), new Metrics$ClassMeansLog2Ratio(), new Metrics$ClassMediansLog2Ratio(), new Metrics$ClassRatio(), new Metrics$ClassDiff(), new Metrics$ClassLog2Ratio(), new Metrics$FeatureVar(), new Metrics$FeatureVarD()};
    }

    public static final Metric[] createAllContinuousMetrics() {
        Metric[] metricArray = Metrics.createAllMetrics();
        ArrayList<Metric> arrayList = new ArrayList<Metric>();
        for (int i2 = 0; i2 < metricArray.length; ++i2) {
            if (!metricArray[i2].isContinuous()) continue;
            arrayList.add(metricArray[i2]);
        }
        return arrayList.toArray(new Metric[arrayList.size()]);
    }

    public static final Metric[] createAllCategoricalMetrics() {
        Metric[] metricArray = Metrics.createAllMetrics();
        ArrayList<Metric> arrayList = new ArrayList<Metric>();
        for (int i2 = 0; i2 < metricArray.length; ++i2) {
            if (!metricArray[i2].isCategorical()) continue;
            arrayList.add(metricArray[i2]);
        }
        return arrayList.toArray(new Metric[arrayList.size()]);
    }

    public static final CorrMetric[] createAllCorrMetrics() {
        return new CorrMetric[]{new Metrics$Pearson(), new Metrics$Cosine()};
    }

    public static final RankMetric[] createAllRankMetrics() {
        return new RankMetric[]{new Metrics$Spearman(), new Metrics$KendallsTau()};
    }

    public static final RankMetric lookupRankMetric(Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot lookup RankMetric for null object");
        }
        if (object instanceof RankMetric) {
            return (RankMetric)object;
        }
        RankMetric[] rankMetricArray = Metrics.createAllRankMetrics();
        for (int i2 = 0; i2 < rankMetricArray.length; ++i2) {
            if (!rankMetricArray[i2].getName().equalsIgnoreCase(object.toString())) continue;
            return rankMetricArray[i2];
        }
        throw new RuntimeException("Cannot lookup RankMetrics by: " + object);
    }

    private Metrics() {
    }

    public static final Metric lookupMetric(Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot lookup for null object");
        }
        if (object instanceof Metric) {
            return (Metric)object;
        }
        Metric[] metricArray = Metrics.createAllMetrics();
        for (int i2 = 0; i2 < metricArray.length; ++i2) {
            if (!metricArray[i2].getName().equalsIgnoreCase(object.toString())) continue;
            return metricArray[i2];
        }
        throw new RuntimeException("Cannot lookupMetric for: " + object);
    }

    public static final CorrMetric lookupCorrMetric(Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot lookup for null object");
        }
        if (object instanceof CorrMetric) {
            return (CorrMetric)object;
        }
        CorrMetric[] corrMetricArray = Metrics.createAllCorrMetrics();
        for (int i2 = 0; i2 < corrMetricArray.length; ++i2) {
            if (!corrMetricArray[i2].getName().equalsIgnoreCase(object.toString())) continue;
            return corrMetricArray[i2];
        }
        throw new RuntimeException("Cannot lookupCorrMetric for: " + object);
    }
}

