/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template;

public class SanityKit {
    public static final void enforceEqualNum(Dataset[] datasetArray, Template[] templateArray) {
        if (datasetArray.length != templateArray.length) {
            throw new IllegalArgumentException("# of datasets: " + datasetArray.length + " not equal to num of templates: " + templateArray.length);
        }
    }

    public static final void enforceEqualNumRows(Dataset[] datasetArray) {
        SanityKit.getAndEnforceEqualNumRows(datasetArray);
    }

    public static final int getAndEnforceEqualNumRows(Dataset[] datasetArray) {
        if (datasetArray.length == 0) {
            throw new IllegalArgumentException("No datasets provides in param -- length 0 array");
        }
        int n = datasetArray[0].getNumRow();
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            if (datasetArray[i2].getNumRow() == n) continue;
            throw new IllegalArgumentException("Dataset at: " + i2 + " has unequal num of rows: " + datasetArray[i2].getNumRow() + " expecting: " + n);
        }
        return n;
    }

    public static final int getAndEnforceEqualNumRows(Dataset dataset, Dataset dataset2) {
        return SanityKit.getAndEnforceEqualNumRows(new Dataset[]{dataset, dataset2});
    }

    public static final void enforceEqualNumRows(Dataset dataset, Dataset dataset2) {
        SanityKit.getAndEnforceEqualNumRows(new Dataset[]{dataset, dataset2});
    }

    public static final String getName(Dataset dataset, Template template) {
        return dataset.getName() + "_" + template.getName();
    }

    public static final Dataset[] combine(Dataset dataset, Dataset[] datasetArray) {
        Dataset[] datasetArray2 = new Dataset[1 + datasetArray.length];
        datasetArray2[0] = dataset;
        for (int i2 = 1; i2 < datasetArray2.length; ++i2) {
            datasetArray2[i2] = datasetArray[i2 - 1];
        }
        return datasetArray2;
    }

    public static final Template[] combine(Template template, Template[] templateArray) {
        Template[] templateArray2 = new Template[1 + templateArray.length];
        templateArray2[0] = template;
        for (int i2 = 1; i2 < templateArray2.length; ++i2) {
            templateArray2[i2] = templateArray[i2 - 1];
        }
        return templateArray2;
    }
}

