/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.TemplateStats$Portion;
import edu.mit.broad.genome.alg.TemplateStats$Usage;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TemplateStats$Composition {
    private Template[] tss;
    private TIntIntHashMap currPosCntMap;
    private StringBuffer fClassBreakup;

    TemplateStats$Composition(Template[] templateArray) {
        this.tss = templateArray;
        this.currPosCntMap = new TIntIntHashMap();
        this.fClassBreakup = new StringBuffer();
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            this.cntIt(templateArray[i2], this.currPosCntMap);
            this.fClassBreakup.append(templateArray[i2].getNumItems()).append('\t').append(templateArray[i2].getClass(0).getSize()).append('\t').append(templateArray[i2].getClass(1)).append('\n');
        }
    }

    public final TObjectIntHashMap getSampleUsage(Dataset dataset) {
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        for (int i2 = 0; i2 < this.tss.length; ++i2) {
            List list = this.tss[i2].extractColumnNames(dataset);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                String string = list.get(i3).toString();
                int n = tObjectIntHashMap.get(string);
                tObjectIntHashMap.put(string, ++n);
            }
        }
        return tObjectIntHashMap;
    }

    public final String getClassBreakup() {
        return this.fClassBreakup.toString();
    }

    private void cntIt(Template template, TIntIntHashMap tIntIntHashMap) {
        int[] nArray = template.getProfilePositionsOrdered();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n = tIntIntHashMap.get(nArray[i2]);
            tIntIntHashMap.put(nArray[i2], ++n);
        }
    }

    public final TIntIntHashMap getCurrPosCnts() {
        return this.currPosCntMap;
    }

    public final TemplateStats$Portion compare(Dataset dataset, Template template) {
        DatasetGenerators datasetGenerators = new DatasetGenerators();
        HashSet hashSet = new HashSet(datasetGenerators.extract(dataset, template.getClass(0)).getColumnNames());
        HashSet hashSet2 = new HashSet(datasetGenerators.extract(dataset, template.getClass(1)).getColumnNames());
        List list = dataset.getColumnNames();
        TemplateStats$Portion templateStats$Portion = new TemplateStats$Portion(list);
        for (int i2 = 0; i2 < this.tss.length; ++i2) {
            Set[] setArray = this.tss[i2].splitByTemplateClass(list);
            this.add2Portion(hashSet, hashSet2, setArray[0], setArray[1], templateStats$Portion);
        }
        return templateStats$Portion;
    }

    private void add2Portion(Set set, Set set2, Set set3, Set set4, TemplateStats$Portion templateStats$Portion) {
        TemplateStats$Usage templateStats$Usage = new TemplateStats$Usage();
        for (Object e2 : set3) {
            if (set.contains(e2)) {
                ++templateStats$Usage.real0in0;
                templateStats$Portion.addUsage(e2.toString(), true);
                continue;
            }
            if (set2.contains(e2)) {
                ++templateStats$Usage.real1in0;
                templateStats$Portion.addUsage(e2.toString(), false);
                continue;
            }
            throw new IllegalArgumentException("unknown sample name: " + e2);
        }
        for (Object e2 : set4) {
            if (set.contains(e2)) {
                ++templateStats$Usage.real0in1;
                templateStats$Portion.addUsage(e2.toString(), false);
                continue;
            }
            if (set2.contains(e2)) {
                ++templateStats$Usage.real1in1;
                templateStats$Portion.addUsage(e2.toString(), true);
                continue;
            }
            throw new IllegalArgumentException("unknown sample name: " + e2);
        }
        templateStats$Portion.addUsage(templateStats$Usage);
    }
}

