/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Template;

public class VectorSplitter {
    private int numtested;
    private int numtoofewA;
    private int numtoofewB;
    private int minNumNanlessPointsNeeded;

    public VectorSplitter(int n) {
        this.minNumNanlessPointsNeeded = n;
    }

    public final Vector[] splitBiphasic_nansafe(Vector vector, Template template) {
        Vector[] vectorArray = template.splitByTemplateClass(vector);
        if (vectorArray.length != 2) {
            VectorSplitter._barf_not_biphasic(template, vectorArray);
        }
        ++this.numtested;
        vectorArray[0] = vectorArray[0].toVectorNaNless();
        vectorArray[1] = vectorArray[1].toVectorNaNless();
        if (vectorArray[0].getSize() < this.minNumNanlessPointsNeeded) {
            ++this.numtoofewA;
            return null;
        }
        if (vectorArray[1].getSize() < this.minNumNanlessPointsNeeded) {
            ++this.numtoofewB;
            return null;
        }
        return vectorArray;
    }

    private static String _barf_not_biphasic(Template template, Vector[] vectorArray) {
        StringBuffer stringBuffer = new StringBuffer("Template is not biphasic. Name: " + template.getName() + " # splits= " + vectorArray.length);
        stringBuffer.append("\n<br>This metric can only be used with 2 class comparisons");
        throw new RuntimeException(stringBuffer.toString());
    }

    public final Vector[] splitBiphasic(Vector vector, Template template) {
        Vector[] vectorArray = template.splitByTemplateClass(vector);
        if (vectorArray.length != 2) {
            VectorSplitter._barf_not_biphasic(template, vectorArray);
        }
        if (vectorArray[0] == null) {
            throw new IllegalArgumentException("Split vector 0 is null");
        }
        if (vectorArray[1] == null) {
            throw new IllegalArgumentException("Split vector 1 is null");
        }
        return vectorArray;
    }

    public final String getMissingInfo() {
        return new StringBuffer("NumTested: ").append(this.numtested).append(" numTooFewA: ").append(this.numtoofewA).append(" numTooFewB: ").append(this.numtoofewB).toString();
    }
}

