/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.distrib;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.distrib.RangeUtils;
import edu.mit.broad.genome.math.FuzzyRange;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.SimpleRange;
import edu.mit.broad.genome.math.Vector;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class RangeFactory {
    private static Logger klog = XLogger.getLogger(RangeFactory.class);
    private static final float CORR_START = -1.0f;
    private static final float CORR_STOP = 1.0f;
    private static final float CORR_INCREMENT = 0.05f;

    public static final FuzzyRange[] createRanges_fuzzy(double d2, double d3, double d4, double d5) {
        ArrayList<FuzzyRange> arrayList = new ArrayList<FuzzyRange>();
        for (double d6 = d3; d6 <= d4; d6 += d2) {
            double d7 = d6 + d2;
            if (d7 > d4) {
                d7 = d4;
            }
            arrayList.add(new FuzzyRange(d6, d7, d5));
        }
        return arrayList.toArray(new FuzzyRange[arrayList.size()]);
    }

    public static final Range[] createRanges(double d2, double d3, double d4) {
        ArrayList<SimpleRange> arrayList = new ArrayList<SimpleRange>();
        for (double d5 = d3; d5 <= d4; d5 += d2) {
            double d6 = d5 + d2;
            if (d6 > d4) {
                d6 = d4;
            }
            arrayList.add(new SimpleRange(d5, d6));
        }
        return arrayList.toArray(new Range[arrayList.size()]);
    }

    public static final FuzzyRange[] createRanges_fuzzy(int n, double d2, double d3, double d4) {
        FuzzyRange[] fuzzyRangeArray = new FuzzyRange[n];
        double d5 = (d3 - d2) / (double)n;
        double d6 = d2;
        for (int i2 = 0; i2 < n; ++i2) {
            fuzzyRangeArray[i2] = new FuzzyRange(d6, d6 + d5, d4);
            d6 += d5;
        }
        return fuzzyRangeArray;
    }

    public static final Range[] createRanges(int n, double d2, double d3) {
        Range[] rangeArray = new Range[n];
        double d4 = (d3 - d2) / (double)n;
        double d5 = d2;
        for (int i2 = 0; i2 < n; ++i2) {
            rangeArray[i2] = new SimpleRange(d5, d5 + d4);
            d5 += d4;
        }
        return rangeArray;
    }

    public static final Range[] createRanges(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        ArrayList<SimpleRange> arrayList = new ArrayList<SimpleRange>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " -");
            String string3 = stringTokenizer2.nextToken().trim();
            String string4 = stringTokenizer2.nextToken().trim();
            float f2 = Float.parseFloat(string3);
            float f3 = Float.parseFloat(string4);
            arrayList.add(new SimpleRange(f2, f3));
        }
        return arrayList.toArray(new Range[arrayList.size()]);
    }

    public static final Range[] createRanges(int n, double[] dArray) {
        Range[] rangeArray = new Range[dArray.length / n];
        int n2 = 0;
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            float[] fArray = new float[n];
            System.arraycopy(dArray, n2, fArray, 0, n);
            Vector vector = new Vector(fArray);
            rangeArray[i2] = new SimpleRange(vector.min(), vector.max());
            n2 += n;
        }
        klog.debug("Expanding final range from: " + rangeArray[rangeArray.length - 1].getMax() + " to: " + dArray[dArray.length - 1]);
        rangeArray[rangeArray.length - 1] = new SimpleRange(rangeArray[rangeArray.length - 1].getMin(), dArray[dArray.length - 1]);
        return rangeArray;
    }

    public static final Range[] createRanges(int n, float[] fArray) {
        Range[] rangeArray = new Range[fArray.length / n];
        int n2 = 0;
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            float[] fArray2 = new float[n];
            System.arraycopy(fArray, n2, fArray2, 0, n);
            Vector vector = new Vector(fArray2);
            rangeArray[i2] = new SimpleRange(vector.min(), vector.max());
            n2 += n;
        }
        klog.debug("Expanding final range from: " + rangeArray[rangeArray.length - 1].getMax() + " to: " + fArray[fArray.length - 1]);
        rangeArray[rangeArray.length - 1] = new SimpleRange(rangeArray[rangeArray.length - 1].getMin(), fArray[fArray.length - 1]);
        return rangeArray;
    }

    public static final Range[] createRangesForCorrelationsAndFill(Vector vector) {
        Range[] rangeArray = RangeFactory.createRanges(-1.0, 1.0, (double)0.05f);
        vector.bin(rangeArray, true);
        RangeUtils.setImmutable(rangeArray);
        return rangeArray;
    }

    public static final Range[] createRangesForZeroToOneAndFill(Vector vector, float f2) {
        Range[] rangeArray = RangeFactory.createRanges(0, 1.0, (double)f2);
        vector.bin(rangeArray, true);
        RangeUtils.setImmutable(rangeArray);
        return rangeArray;
    }

    public static final SimpleRange[] createPans(int n, int n2, int n3, boolean bl) {
        int[] nArray = RangeUtils.createStopIndices(n, n2, n3, bl);
        ArrayList<SimpleRange> arrayList = new ArrayList<SimpleRange>(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(new SimpleRange(n, nArray[i2]));
        }
        return arrayList.toArray(new SimpleRange[arrayList.size()]);
    }

    public static final SimpleRange[] createWindows(int n, int n2, int n3, int n4) {
        RangeUtils.checkRangeIndices(n, n2);
        ArrayList<SimpleRange> arrayList = new ArrayList<SimpleRange>();
        int n5 = n;
        boolean bl = true;
        while (bl) {
            int n6 = n5 + n3;
            if (n6 > n2) {
                n6 = n2;
                bl = false;
            }
            arrayList.add(new SimpleRange(n5, n6));
            if ((n5 += n4) <= n2) continue;
            break;
        }
        return arrayList.toArray(new SimpleRange[arrayList.size()]);
    }

    private static final /* synthetic */ Logger access$000() {
        return klog;
    }
}

