/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.fdr;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.alg.fdr.FdrAlgs$FdrMap;
import edu.mit.broad.genome.math.DatasetModed;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.strucs.DefaultFdrStruc;
import edu.mit.broad.genome.objects.strucs.FdrStruc;
import edu.mit.broad.genome.objects.strucs.SkewCorrectedFdrStruc;
import org.apache.log4j.Logger;

public class FdrAlgs {
    private static final Logger klog = XLogger.getLogger(FdrAlgs.class);

    public static final FdrStruc[] calcFdrs(LabelledVector labelledVector, Dataset dataset, LabelledVector labelledVector2, Vector vector, SortMode sortMode, Order order) {
        if (labelledVector == null) {
            throw new IllegalArgumentException("Param real_scores cannot be null");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("Param rnd_scores_by_row cannot be null");
        }
        if (labelledVector.getSize() != dataset.getNumRow()) {
            throw new MismatchedSizeException("real_scores", labelledVector.getSize(), "rnd_scores_matrix", dataset.getNumRow());
        }
        if (labelledVector.getSize() != labelledVector2.getSize()) {
            throw new MismatchedSizeException("real_scores", labelledVector.getSize(), "real_scores_norm", labelledVector2.getSize());
        }
        int n = dataset.getNumRow() * dataset.getNumCol();
        if (vector.getSize() != n) {
            throw new MismatchedSizeException("all_rnd_scores_norm", vector.getSize(), "matrix size", n);
        }
        RankedList rankedList = labelledVector2.sort(sortMode, order);
        Vector vector2 = new Vector(vector, false);
        vector2.sort(sortMode, order);
        FdrStruc[] fdrStrucArray = new FdrStruc[labelledVector.getSize()];
        for (int i2 = 0; i2 < labelledVector.getSize(); ++i2) {
            String string = labelledVector.getLabel(i2);
            fdrStrucArray[i2] = DefaultFdrStruc.create(string, labelledVector, rankedList, dataset, vector2, order);
        }
        return fdrStrucArray;
    }

    public static final FdrAlgs$FdrMap calcFdrs_skewed(LabelledVector labelledVector, Dataset dataset, LabelledVector labelledVector2, DatasetModed datasetModed, DatasetModed datasetModed2, SortMode sortMode) {
        FdrAlgs$FdrMap fdrAlgs$FdrMap = new FdrAlgs$FdrMap();
        FdrAlgs._calcFdrs_skewed(labelledVector, dataset, labelledVector2, datasetModed, datasetModed2, sortMode, Order.DESCENDING, true, fdrAlgs$FdrMap);
        FdrAlgs._calcFdrs_skewed(labelledVector, dataset, labelledVector2, datasetModed, datasetModed2, sortMode, Order.ASCENDING, false, fdrAlgs$FdrMap);
        return fdrAlgs$FdrMap;
    }

    private static void _calcFdrs_skewed(LabelledVector labelledVector, Dataset dataset, LabelledVector labelledVector2, DatasetModed datasetModed, DatasetModed datasetModed2, SortMode sortMode, Order order, boolean bl, FdrAlgs$FdrMap fdrAlgs$FdrMap) {
        if (labelledVector == null) {
            throw new IllegalArgumentException("Param real_scores cannot be null");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("Param rnd_scores_by_row_FULL cannot be null");
        }
        if (labelledVector.getSize() != labelledVector2.getSize()) {
            throw new MismatchedSizeException("real_scores", labelledVector.getSize(), "real_scores_norm", labelledVector2.getSize());
        }
        RankedList rankedList = labelledVector2.sort(sortMode, order);
        for (int i2 = 0; i2 < labelledVector.getSize(); ++i2) {
            SkewCorrectedFdrStruc skewCorrectedFdrStruc;
            String string = labelledVector.getLabel(i2);
            float f2 = labelledVector.getScore(i2);
            if (bl && XMath.isPositive(f2)) {
                skewCorrectedFdrStruc = new SkewCorrectedFdrStruc(string, f2, rankedList, dataset.getRow(string), datasetModed, datasetModed2, bl);
                FdrAlgs$FdrMap.access$000(fdrAlgs$FdrMap, string, skewCorrectedFdrStruc);
                continue;
            }
            if (bl || !XMath.isNegative(f2)) continue;
            skewCorrectedFdrStruc = new SkewCorrectedFdrStruc(string, f2, rankedList, dataset.getRow(string), datasetModed, datasetModed2, bl);
            FdrAlgs$FdrMap.access$000(fdrAlgs$FdrMap, string, skewCorrectedFdrStruc);
        }
    }

    public static final FdrStruc[] calcFdrs(LabelledVector labelledVector, Dataset dataset, SortMode sortMode, Order order) {
        if (labelledVector == null) {
            throw new IllegalArgumentException("Param real_scores cannot be null");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("Param rnd_scores_by_row cannot be null");
        }
        if (labelledVector.getSize() != dataset.getNumRow()) {
            throw new MismatchedSizeException("real_scores", labelledVector.getSize(), "rnd_scores_matrix", dataset.getNumRow());
        }
        RankedList rankedList = RankedListGenerators.sort(labelledVector, sortMode, order);
        Vector vector = dataset.getMatrix().toVector();
        vector.sort(sortMode, order);
        FdrStruc[] fdrStrucArray = new FdrStruc[labelledVector.getSize()];
        for (int i2 = 0; i2 < labelledVector.getSize(); ++i2) {
            String string = labelledVector.getLabel(i2);
            Vector vector2 = dataset.getRow(string);
            fdrStrucArray[i2] = DefaultFdrStruc.create(string, rankedList, vector2, vector, order);
        }
        return fdrStrucArray;
    }
}

