/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.AbstractGeneSetCohort;
import edu.mit.broad.genome.alg.gsea.DefaultGeneSetCohort$1;
import edu.mit.broad.genome.alg.gsea.GeneSetCohort;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTable;
import edu.mit.broad.genome.alg.gsea.GeneToGeneSetMap;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;

public class DefaultGeneSetCohort
extends AbstractGeneSetCohort {
    private boolean fSilent;
    private GeneSetScoringTable[] fGeneSetScoringTables;
    private GeneSetScoringTable fOrigTable;

    public DefaultGeneSetCohort(GeneSetScoringTable geneSetScoringTable, RankedList rankedList, GeneSet[] geneSetArray, boolean bl) {
        this(geneSetScoringTable, rankedList, geneSetArray, GeneToGeneSetMap.generateGeneToGenesetMap(geneSetArray), bl, false);
    }

    public DefaultGeneSetCohort(GeneSetScoringTable geneSetScoringTable, RankedList rankedList, GeneSet[] geneSetArray, GeneToGeneSetMap geneToGeneSetMap, boolean bl) {
        this(geneSetScoringTable, rankedList, geneSetArray, geneToGeneSetMap, bl, false);
    }

    private DefaultGeneSetCohort(GeneSetScoringTable geneSetScoringTable, RankedList rankedList, GeneSet[] geneSetArray, GeneToGeneSetMap geneToGeneSetMap, boolean bl, boolean bl2) {
        super.init(rankedList, geneSetArray, geneToGeneSetMap, bl, bl2);
        this.fSilent = bl;
        this.fOrigTable = geneSetScoringTable;
        this.fGeneSetScoringTables = new GeneSetScoringTable[this.fGeneSets.length];
        for (int i2 = 0; i2 < this.fGeneSets.length; ++i2) {
            this.fGeneSetScoringTables[i2] = geneSetScoringTable.createTable(this.fGeneSets[i2], rankedList, this.fOrigTable.getRankedList());
            if (bl || i2 < 500 || i2 % 500 != 0) continue;
            System.out.println("GeneSetCohorted_scored: " + (i2 + 1) + " / " + this.fGeneSets.length);
        }
    }

    @Override
    public final GeneSetCohort clone(GeneSet[] geneSetArray, boolean bl) {
        return new DefaultGeneSetCohort(this.fOrigTable, this.getRankedList(), geneSetArray, GeneToGeneSetMap.generateGeneToGenesetMap(geneSetArray), this.fSilent, bl);
    }

    @Override
    public final double getHitPoints(int n, String string) {
        return this.fGeneSetScoringTables[n].getHitScore(string);
    }

    @Override
    public final double getMissPoints(int n, String string) {
        return this.fGeneSetScoringTables[n].getMissScore(string);
    }

    /* synthetic */ DefaultGeneSetCohort(GeneSetScoringTable geneSetScoringTable, RankedList rankedList, GeneSet[] geneSetArray, GeneToGeneSetMap geneToGeneSetMap, boolean bl, boolean bl2, DefaultGeneSetCohort$1 defaultGeneSetCohort$1) {
        this(geneSetScoringTable, rankedList, geneSetArray, geneToGeneSetMap, bl, bl2);
    }
}

