/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSetSignal;
import edu.mit.broad.genome.objects.SignalMatrix;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultGseaSignalMatrix
extends AbstractObject
implements SignalMatrix {
    private List fSignals;
    private THashMap fNameSignalMap;
    private GeneSetMatrix fGeneSetMatrixSignals;
    private GeneSetMatrix fGeneSetMatrixOrig;

    public DefaultGseaSignalMatrix(String string, GeneSetSignal[] geneSetSignalArray, GeneSetMatrix geneSetMatrix) {
        this.initHere(string, geneSetSignalArray, geneSetMatrix);
    }

    public DefaultGseaSignalMatrix(String string, SignalMatrix[] signalMatrixArray, boolean bl, GeneSet[] geneSetArray) {
        this(string, signalMatrixArray, bl, new DefaultGeneSetMatrix(string, geneSetArray));
    }

    public DefaultGseaSignalMatrix(String string, SignalMatrix[] signalMatrixArray, boolean bl, GeneSetMatrix geneSetMatrix) {
        Object object;
        Object object2;
        if (!bl) {
            throw new NotImplementedException();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i2 = 0; i2 < signalMatrixArray.length; ++i2) {
            object2 = signalMatrixArray[i2].getSignals();
            for (int i3 = 0; i3 < ((GeneSetSignal[])object2).length; ++i3) {
                object = hashMap.get(object2[i3].getName());
                if (object == null) {
                    object = new ArrayList();
                }
                ((List)object).add(object2[i3]);
                hashMap.put(object2[i3].getName(), object);
            }
        }
        ArrayList<GeneSetSignal> arrayList = new ArrayList<GeneSetSignal>();
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            String string2 = object2.next().toString();
            object = (List)hashMap.get(string2);
            GeneSetSignal geneSetSignal = (GeneSetSignal)object.get(0);
            for (int i4 = 0; i4 < object.size(); ++i4) {
                GeneSetSignal geneSetSignal2 = (GeneSetSignal)object.get(i4);
                if (geneSetSignal2.getSize() <= geneSetSignal.getSize()) continue;
                geneSetSignal = geneSetSignal2;
            }
            arrayList.add(geneSetSignal);
        }
        if (arrayList.size() != hashMap.size()) {
            throw new IllegalStateException("Some signals went missing/over-added: " + arrayList.size() + " " + hashMap.size());
        }
        object2 = new GeneSetSignal[arrayList.size()];
        for (int i5 = 0; i5 < arrayList.size(); ++i5) {
            object2[i5] = (GeneSetSignal)arrayList.get(i5);
        }
        this.initHere(string, (GeneSetSignal[])object2, geneSetMatrix);
    }

    @Override
    public final GeneSetMatrix cloneShallow(String string) {
        this.setName(string);
        return this;
    }

    private void initHere(String string, GeneSetSignal[] geneSetSignalArray, GeneSetMatrix geneSetMatrix) {
        super.initialize(string);
        if (geneSetSignalArray.length != geneSetMatrix.getNumGeneSets()) {
            throw new MismatchedSizeException("signals", geneSetSignalArray.length, "orig gene sets", geneSetMatrix.getNumGeneSets());
        }
        GeneSet[] geneSetArray = new GeneSet[geneSetSignalArray.length];
        this.fSignals = new ArrayList(geneSetSignalArray.length);
        this.fNameSignalMap = new THashMap();
        for (int i2 = 0; i2 < geneSetSignalArray.length; ++i2) {
            String string2 = geneSetSignalArray[i2].getName();
            GeneSet geneSet = geneSetMatrix.getGeneSet(string2);
            if (geneSet.getNumMembers() < geneSetSignalArray[i2].getSize()) {
                throw new IllegalStateException("Orig " + geneSet.getName() + " is smaller than signal! " + geneSetSignalArray[i2].getSize() + " " + geneSetSignalArray[i2].getName());
            }
            geneSetArray[i2] = geneSetSignalArray[i2].getAsGeneSet();
            this.fSignals.add(geneSetSignalArray[i2]);
            this.fNameSignalMap.put(geneSetSignalArray[i2].getName(), geneSetSignalArray[i2]);
        }
        this.fGeneSetMatrixSignals = new DefaultGeneSetMatrix(string, geneSetArray);
        this.fGeneSetMatrixOrig = geneSetMatrix;
    }

    @Override
    public final boolean containsSet(String string) {
        throw new NotImplementedException();
    }

    @Override
    public final String getQuickInfo() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getNumSignals()).append(" signs");
        return stringBuffer.toString();
    }

    @Override
    public final GeneSetMatrix getOriginalGeneSetMatrix() {
        return this.fGeneSetMatrixOrig;
    }

    @Override
    public final GeneSet getOriginalGeneSet(String string) {
        return this.fGeneSetMatrixOrig.getGeneSet(string);
    }

    @Override
    public final int getNumSignals() {
        return this.fSignals.size();
    }

    @Override
    public final GeneSetSignal getSignal(int n) {
        return (GeneSetSignal)this.fSignals.get(n);
    }

    @Override
    public final GeneSetSignal getSignal(String string) {
        Object object = this.fNameSignalMap.get(string);
        if (object == null) {
            throw new IllegalArgumentException("No Signal found for name: " + string);
        }
        return (GeneSetSignal)object;
    }

    @Override
    public final GeneSetSignal[] getSignals() {
        return this.fSignals.toArray(new GeneSetSignal[this.fSignals.size()]);
    }

    @Override
    public final List getSignalsL() {
        return Collections.unmodifiableList(this.fSignals);
    }

    @Override
    public final GeneSetSignal[] getSignals(Set set) {
        GeneSetSignal[] geneSetSignalArray = new GeneSetSignal[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            geneSetSignalArray[n++] = this.getSignal(string);
        }
        return geneSetSignalArray;
    }

    @Override
    public final int getNumGeneSets() {
        return this.getNumSignals();
    }

    @Override
    public final Dataset createTagMatrix(boolean bl, boolean bl2) {
        return this.fGeneSetMatrixSignals.createTagMatrix(bl, bl2);
    }

    @Override
    public final GeneSet getGeneSet(int n) {
        return this.fGeneSetMatrixSignals.getGeneSet(n);
    }

    @Override
    public final GeneSet getGeneSet(String string) {
        return this.fGeneSetMatrixSignals.getGeneSet(string);
    }

    @Override
    public final GeneSet[] getGeneSets() {
        return this.fGeneSetMatrixSignals.getGeneSets();
    }

    @Override
    public final List getGeneSetsL() {
        return this.fGeneSetMatrixSignals.getGeneSetsL();
    }

    @Override
    public final GeneSet[] getGeneSets(int n, int n2) {
        return this.fGeneSetMatrixSignals.getGeneSets(n, n2);
    }

    @Override
    public final List getGeneSetsL(int n, int n2) {
        return this.fGeneSetMatrixSignals.getGeneSetsL(n, n2);
    }

    @Override
    public final GeneSet[] getGeneSets(Set set) {
        return this.fGeneSetMatrixSignals.getGeneSets(set);
    }

    @Override
    public final GeneSetMatrix getGeneSetMatrix(GeneSet geneSet) {
        return this.fGeneSetMatrixSignals.getGeneSetMatrix(geneSet);
    }

    @Override
    public final GeneSet[] getGeneSets(String[] stringArray) {
        return this.fGeneSetMatrixSignals.getGeneSets(stringArray);
    }

    @Override
    public final String[] getGeneSetNames(boolean bl) {
        return this.fGeneSetMatrixSignals.getGeneSetNames(bl);
    }

    @Override
    public final List getGeneSetNamesL(boolean bl) {
        return this.fGeneSetMatrixSignals.getGeneSetNamesL(bl);
    }

    @Override
    public final Set getGeneSetNamesS(boolean bl) {
        return this.fGeneSetMatrixSignals.getGeneSetNamesS(bl);
    }

    @Override
    public final int getMaxGeneSetSize() {
        return this.fGeneSetMatrixSignals.getMaxGeneSetSize();
    }

    @Override
    public final String[] getAllMemberNames() {
        return this.fGeneSetMatrixSignals.getAllMemberNames();
    }

    @Override
    public final List getAllMemberNamesL() {
        return this.fGeneSetMatrixSignals.getAllMemberNamesL();
    }

    @Override
    public final String[] getAllMemberNamesOnlyOnce() {
        return this.fGeneSetMatrixSignals.getAllMemberNamesOnlyOnce();
    }

    @Override
    public final Set getAllMemberNamesOnlyOnceS() {
        return this.fGeneSetMatrixSignals.getAllMemberNamesOnlyOnceS();
    }

    public final String[] getAllGeneSetNames() {
        return this.fGeneSetMatrixSignals.getAllMemberNames();
    }

    @Override
    public final GeneSet getAllMemberNames_gset() {
        return new FSet(this.getName(), this.getAllMemberNamesOnlyOnceS());
    }

    @Override
    public final BitSet getGeneSetMembershipBitSet(String string) {
        return this.fGeneSetMatrixSignals.getGeneSetMembershipBitSet(string);
    }

    @Override
    public final BitSetDataset getGeneSetMembershipBitSetDataset(String string, String[] stringArray) {
        return this.fGeneSetMatrixSignals.getGeneSetMembershipBitSetDataset(string, stringArray);
    }

    @Override
    public final BitSetDataset getGeneSetMembershipBitSetDataset() {
        return this.fGeneSetMatrixSignals.getGeneSetMembershipBitSetDataset();
    }

    @Override
    public final String[] getGeneSetMembershipNames(String string) {
        return this.fGeneSetMatrixSignals.getGeneSetMembershipNames(string);
    }

    @Override
    public final GeneSet[] getGeneSetMembershipSets(String string) {
        return this.fGeneSetMatrixSignals.getGeneSetMembershipSets(string);
    }

    @Override
    public final String getGeneSetName(int n) {
        return this.fGeneSetMatrixSignals.getGeneSetName(n);
    }
}

