/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.AlgUtils;
import edu.mit.broad.genome.alg.gsea.EdbAlgs$ByGeneSet;
import edu.mit.broad.genome.alg.gsea.EdbAlgs$BySample;
import edu.mit.broad.genome.alg.gsea.EdbAlgs$DtgIndex;
import edu.mit.broad.genome.alg.gsea.EdbAlgs$EnrichmentResultMap;
import edu.mit.broad.genome.alg.gsea.EdbAlgs$SampleDtg;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EdbAlgs {
    private static final Logger klog = XLogger.getLogger(EdbAlgs.class);

    protected EdbAlgs() {
    }

    public static final Dataset createGeneSetMembershipDataset(String string, EnrichmentResult[] enrichmentResultArray, boolean bl) {
        EdbAlgs._nonNull(enrichmentResultArray);
        BitSetDataset bitSetDataset = new BitSetDataset(EdbAlgs.toGeneSetMatrix(string, enrichmentResultArray, bl));
        return bitSetDataset.toDataset(true, false);
    }

    public static final Dataset createGeneSetMembershipDataset(String string, EnrichmentResult[] enrichmentResultArray, RankedList rankedList, boolean bl, boolean bl2) {
        EdbAlgs._nonNull(enrichmentResultArray);
        BitSetDataset bitSetDataset = new BitSetDataset(EdbAlgs.toGeneSetMatrix(string, enrichmentResultArray, bl2));
        return bitSetDataset.toDataset(rankedList, bl, false);
    }

    public static final GeneSetMatrix toGeneSetMatrix(EnrichmentDb enrichmentDb, boolean bl) {
        return EdbAlgs.toGeneSetMatrix(enrichmentDb.getName(), enrichmentDb.getResults(), bl);
    }

    public static final GeneSetMatrix toGeneSetMatrix(String string, EnrichmentResult[] enrichmentResultArray, boolean bl) {
        EdbAlgs._nonNull(enrichmentResultArray);
        GeneSet[] geneSetArray = new GeneSet[enrichmentResultArray.length];
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            geneSetArray[i2] = bl ? enrichmentResultArray[i2].getSignal().getAsGeneSet() : enrichmentResultArray[i2].getGeneSet();
        }
        return new DefaultGeneSetMatrix(string, geneSetArray);
    }

    public static final LabelledVector createRealES(EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        Vector vector = new Vector(enrichmentResultArray.length);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            arrayList.add(enrichmentResultArray[i2].getGeneSetName());
            vector.setElement(i2, enrichmentResultArray[i2].getScore().getES());
        }
        return new LabelledVector(arrayList, vector, true);
    }

    public static final Dataset createRndESDataset(String string, EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        int n = EdbAlgs.enforceSameNumOfPerms(enrichmentResultArray);
        Matrix matrix = new Matrix(enrichmentResultArray.length, n);
        ArrayList<String> arrayList = new ArrayList<String>(enrichmentResultArray.length);
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            Vector vector = enrichmentResultArray[i2].getRndESS();
            matrix.setRow(i2, vector);
            arrayList.add(enrichmentResultArray[i2].getGeneSetName());
        }
        return new DefaultDataset(string + "_rnd_es", matrix, arrayList, EdbAlgs._permColNames(n), true, null);
    }

    public static final LabelledVector createNumHits(EnrichmentDb enrichmentDb) {
        return EdbAlgs.createNumHits(enrichmentDb.getResults());
    }

    public static final LabelledVector createNumHits(EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        Vector vector = new Vector(enrichmentResultArray.length);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            arrayList.add(enrichmentResultArray[i2].getGeneSetName());
            vector.setElement(i2, enrichmentResultArray[i2].getScore().getNumHits());
        }
        return new LabelledVector(arrayList, vector, true);
    }

    public static final GeneSet[] getGeneSets(EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        GeneSet[] geneSetArray = new GeneSet[enrichmentResultArray.length];
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            geneSetArray[i2] = enrichmentResultArray[i2].getGeneSet();
        }
        return geneSetArray;
    }

    public static final GeneSet[] getGeneSetSignals(EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        GeneSet[] geneSetArray = new GeneSet[enrichmentResultArray.length];
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            geneSetArray[i2] = enrichmentResultArray[i2].getSignal().getAsGeneSet();
        }
        return geneSetArray;
    }

    private static void _nonNull(EnrichmentResult[] enrichmentResultArray) {
        if (enrichmentResultArray == null || enrichmentResultArray.length == 0) {
            throw new IllegalArgumentException("Param results cannot be null nor zero length: " + enrichmentResultArray);
        }
    }

    public static final Map hashByGeneSetName(EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        HashMap<String, EnrichmentResult> hashMap = new HashMap<String, EnrichmentResult>();
        Errors errors = new Errors();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            String string = enrichmentResultArray[i2].getGeneSet().getName(true);
            if (hashMap.containsKey(string)) {
                errors.add("Duplicated gene set: " + string);
                continue;
            }
            hashMap.put(string, enrichmentResultArray[i2]);
        }
        errors.barfIfNotEmptyRuntime();
        return hashMap;
    }

    public static final Map hashByTemplateName(EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            String string = enrichmentResultArray[i2].getTemplate().getName();
            Object object = hashMap.get(string);
            if (object == null) {
                object = new ArrayList();
            }
            ((List)object).add(enrichmentResultArray[i2]);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    public static final Map hashByTemplate(EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            Template template = enrichmentResultArray[i2].getTemplate();
            Object object = hashMap.get(template);
            if (object == null) {
                object = new ArrayList();
            }
            ((List)object).add(enrichmentResultArray[i2]);
            hashMap.put(template, object);
        }
        return hashMap;
    }

    public static final EnrichmentResult[] filterByGeneSetName(EnrichmentResult[] enrichmentResultArray, GeneSet geneSet) {
        return EdbAlgs.filterByGeneSetName(enrichmentResultArray, geneSet.getName());
    }

    public static final EnrichmentResult[] filterByGeneSetName(EnrichmentResult[] enrichmentResultArray, String string) {
        ArrayList<EnrichmentResult> arrayList = new ArrayList<EnrichmentResult>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            if (!EdbAlgs._equalsG(enrichmentResultArray[i2], string)) continue;
            arrayList.add(enrichmentResultArray[i2]);
        }
        return arrayList.toArray(new EnrichmentResult[arrayList.size()]);
    }

    public static final EnrichmentResult[] filterByGeneSetName(EnrichmentResult[] enrichmentResultArray, GeneSet[] geneSetArray) {
        Set set = AlgUtils.getAllPobNamesS(geneSetArray);
        ArrayList<EnrichmentResult> arrayList = new ArrayList<EnrichmentResult>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            if (!set.contains(enrichmentResultArray[i2].getGeneSet().getName())) continue;
            arrayList.add(enrichmentResultArray[i2]);
        }
        return arrayList.toArray(new EnrichmentResult[arrayList.size()]);
    }

    public static final EnrichmentResult[] filterByTemplateName(EnrichmentResult[] enrichmentResultArray, Template template) {
        return EdbAlgs.filterByTemplateName(enrichmentResultArray, template.getName());
    }

    public static final EnrichmentResult[] filterByTemplateName(EnrichmentResult[] enrichmentResultArray, String string) {
        EdbAlgs._nonNull(enrichmentResultArray);
        ArrayList<EnrichmentResult> arrayList = new ArrayList<EnrichmentResult>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            if (!EdbAlgs._equalsT(enrichmentResultArray[i2], string)) continue;
            arrayList.add(enrichmentResultArray[i2]);
        }
        return arrayList.toArray(new EnrichmentResult[arrayList.size()]);
    }

    public static final EnrichmentResult[] filterByTemplateNames(EnrichmentResult[] enrichmentResultArray, Template[] templateArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        Set set = AlgUtils.getTemplateNamesS(templateArray);
        ArrayList<EnrichmentResult> arrayList = new ArrayList<EnrichmentResult>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            if (!set.contains(enrichmentResultArray[i2].getTemplate().getName())) continue;
            arrayList.add(enrichmentResultArray[i2]);
        }
        return arrayList.toArray(new EnrichmentResult[arrayList.size()]);
    }

    public static final EnrichmentResult[] filterByGeneSetSize(EnrichmentResult[] enrichmentResultArray, int n, int n2, Dataset dataset) {
        EdbAlgs._nonNull(enrichmentResultArray);
        ArrayList<EnrichmentResult> arrayList = new ArrayList<EnrichmentResult>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            int n3 = enrichmentResultArray[i2].getGeneSet().getNumMembers(dataset);
            if (n3 < n || n3 > n2) continue;
            arrayList.add(enrichmentResultArray[i2]);
        }
        return arrayList.toArray(new EnrichmentResult[arrayList.size()]);
    }

    public static final List getGeneSetNames(EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        ArrayList<String> arrayList = new ArrayList<String>(enrichmentResultArray.length);
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            arrayList.add(enrichmentResultArray[i2].getGeneSet().getName(true));
        }
        return arrayList;
    }

    public static final List getGeneSetNames_unique(EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        ArrayList<String> arrayList = new ArrayList<String>(enrichmentResultArray.length);
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            String string = enrichmentResultArray[i2].getGeneSet().getName(true);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static final EdbAlgs$DtgIndex getAndEnforceTheOnlyDtgByGeneSetName(String string, EnrichmentDb enrichmentDb) {
        return EdbAlgs.getAndEnforceTheOnlyDtgByGeneSetName(string, enrichmentDb.getResults());
    }

    public static final EdbAlgs$DtgIndex getAndEnforceTheOnlyDtgByGeneSetName(String string, EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        HashSet<EdbAlgs$DtgIndex> hashSet = new HashSet<EdbAlgs$DtgIndex>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            if (!enrichmentResultArray[i2].getGeneSet().getName().equals(string)) continue;
            hashSet.add(new EdbAlgs$DtgIndex(enrichmentResultArray[i2], i2));
        }
        if (hashSet.isEmpty()) {
            throw new IllegalArgumentException("No Dtg by gset name: " + string + " in this dtgs: " + enrichmentResultArray.length);
        }
        if (hashSet.size() > 1) {
            throw new IllegalArgumentException("More than 1 hit for specified gset .. expecting only 1, found" + hashSet.size() + " Dtg by gset name: " + string + " in this dtgs: " + enrichmentResultArray.length);
        }
        return (EdbAlgs$DtgIndex)hashSet.iterator().next();
    }

    public static final EdbAlgs$EnrichmentResultMap createResultMap(EnrichmentResult[] enrichmentResultArray) {
        EdbAlgs._nonNull(enrichmentResultArray);
        Errors errors = new Errors();
        EdbAlgs$EnrichmentResultMap edbAlgs$EnrichmentResultMap = new EdbAlgs$EnrichmentResultMap();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            EnrichmentResult enrichmentResult = enrichmentResultArray[i2];
            if (edbAlgs$EnrichmentResultMap.containsKey(enrichmentResult.getGeneSetName())) {
                errors.add("duplicate name: " + enrichmentResult.getGeneSetName());
            }
            edbAlgs$EnrichmentResultMap.put(enrichmentResult.getGeneSetName(), enrichmentResult);
        }
        return edbAlgs$EnrichmentResultMap;
    }

    public static final int enforceSameNumOfPerms(EnrichmentResult[] enrichmentResultArray) {
        if (enrichmentResultArray.length == 0) {
            return 0;
        }
        int n = enrichmentResultArray[0].getNumPerms();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            if (enrichmentResultArray[i2].getNumPerms() == n) continue;
            throw new MismatchedSizeException("enrichment result: " + enrichmentResultArray[0].getGeneSetName(), n, "enrichment result: " + enrichmentResultArray[i2].getGeneSetName(), enrichmentResultArray[i2].getNumPerms());
        }
        return n;
    }

    public static final float getRndVar(EnrichmentResult enrichmentResult) {
        Vector vector = enrichmentResult.getRndESS();
        return (float)Math.sqrt(vector.var(false, false));
    }

    public static final float getRndMean(EnrichmentResult enrichmentResult) {
        return (float)enrichmentResult.getRndESS().mean();
    }

    public static final float getNominalPValue(EnrichmentResult enrichmentResult) {
        return (float)XMath.getPValueTwoTailed(enrichmentResult.getScore().getES(), enrichmentResult.getRndESS());
    }

    protected static final boolean _equalsG(EnrichmentResult enrichmentResult, String string) {
        return enrichmentResult.getGeneSet().getName().equalsIgnoreCase(string);
    }

    protected static final boolean _equalsT(EnrichmentResult enrichmentResult, String string) {
        return enrichmentResult.getGeneSet().getName().equalsIgnoreCase(string);
    }

    protected static final List _toList(EnrichmentResult[] enrichmentResultArray) {
        ArrayList<EnrichmentResult> arrayList = new ArrayList<EnrichmentResult>(enrichmentResultArray.length);
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            arrayList.add(enrichmentResultArray[i2]);
        }
        return arrayList;
    }

    public static final StringDataframe createStringDataframe(String string, EdbAlgs$BySample[] edbAlgs$BySampleArray) {
        int n = 0;
        for (int i2 = 0; i2 < edbAlgs$BySampleArray.length; ++i2) {
            if (n >= edbAlgs$BySampleArray[i2].getDtgs().length) continue;
            n = edbAlgs$BySampleArray[i2].getDtgs().length;
        }
        StringMatrix stringMatrix = new StringMatrix(n, edbAlgs$BySampleArray.length);
        ArrayList<String> arrayList = new ArrayList<String>(edbAlgs$BySampleArray.length);
        for (int i3 = 0; i3 < edbAlgs$BySampleArray.length; ++i3) {
            arrayList.add(edbAlgs$BySampleArray[i3].getSample().getClass().getName() + "_" + edbAlgs$BySampleArray[i3].getSample().getName());
            EnrichmentResult[] enrichmentResultArray = edbAlgs$BySampleArray[i3].getDtgs();
            for (int i4 = 0; i4 < enrichmentResultArray.length; ++i4) {
                stringMatrix.setElement(i4, i3, enrichmentResultArray[i4].getGeneSet().getName());
                if (XMath.isPositive(enrichmentResultArray[i4].getScore().getES())) {
                    stringMatrix.setColor(i4, i3, Color.RED);
                    continue;
                }
                stringMatrix.setColor(i4, i3, Color.BLUE);
            }
        }
        return new StringDataframe(string, stringMatrix, arrayList, true);
    }

    public static final StringDataframe createStringDataframe(String string, EdbAlgs$ByGeneSet[] edbAlgs$ByGeneSetArray) {
        int n = 0;
        for (int i2 = 0; i2 < edbAlgs$ByGeneSetArray.length; ++i2) {
            if (n >= edbAlgs$ByGeneSetArray[i2].getSamplesDtgs().length) continue;
            n = edbAlgs$ByGeneSetArray[i2].getSamplesDtgs().length;
        }
        StringMatrix stringMatrix = new StringMatrix(n, edbAlgs$ByGeneSetArray.length);
        ArrayList<String> arrayList = new ArrayList<String>(edbAlgs$ByGeneSetArray.length);
        for (int i3 = 0; i3 < edbAlgs$ByGeneSetArray.length; ++i3) {
            arrayList.add(edbAlgs$ByGeneSetArray[i3].getGeneSet().getName());
            EdbAlgs$SampleDtg[] edbAlgs$SampleDtgArray = edbAlgs$ByGeneSetArray[i3].getSamplesDtgs();
            for (int i4 = 0; i4 < edbAlgs$SampleDtgArray.length; ++i4) {
                stringMatrix.setElement(i4, i3, edbAlgs$SampleDtgArray[i4].getSample().getClass().getName() + "_" + edbAlgs$SampleDtgArray[i4].getSample().getName());
                if (XMath.isPositive(edbAlgs$SampleDtgArray[i4].getDtg().getScore().getES())) {
                    stringMatrix.setColor(i4, i3, Color.RED);
                    continue;
                }
                stringMatrix.setColor(i4, i3, Color.BLUE);
            }
        }
        return new StringDataframe(string, stringMatrix, arrayList, true);
    }

    private static List _permColNames(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < n; ++i2) {
            arrayList.add("perm_" + (i2 + 1));
        }
        return arrayList;
    }
}

