/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.GeneSetScoringTable;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$AbstractScoringTable;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;

public class GeneSetScoringTables$WeightedLinear
extends GeneSetScoringTables$AbstractScoringTable {
    private static final String NAME = "weighted_linear";
    private float totalWeight;
    private float nhExpected;
    private float miss_score;
    private GeneSet gset;
    private RankedList rankedList_linearized;

    public GeneSetScoringTables$WeightedLinear() {
    }

    public GeneSetScoringTables$WeightedLinear(GeneSet geneSet, RankedList rankedList) {
        this.gset = geneSet;
        this.nhExpected = geneSet.getNumMembers();
        if (this.nhExpected == 0.0f) {
            throw new IllegalArgumentException("Number of members in gene set cannot be 0: " + geneSet.getName());
        }
        this.rankedList_linearized = GeneSetScoringTables.access$100(rankedList);
        for (int i2 = 0; i2 < this.gset.getNumMembers(); ++i2) {
            float f2 = this.rankedList_linearized.getScore(geneSet.getMember(i2));
            this.totalWeight += GeneSetScoringTables.access$000(f2);
        }
        float f3 = this.rankedList_linearized.getSize();
        this.miss_score = 1.0f / (f3 - this.nhExpected);
    }

    @Override
    public final String getName() {
        return NAME;
    }

    @Override
    public final RankedList getRankedList() {
        return this.rankedList_linearized;
    }

    @Override
    public final boolean isTwoSidedEs() {
        return false;
    }

    @Override
    public final GeneSetScoringTable createTable(GeneSet geneSet, RankedList rankedList, RankedList rankedList2) {
        return new GeneSetScoringTables$WeightedLinear(geneSet, rankedList);
    }

    @Override
    public final float getHitScore(String string) {
        float f2 = this.rankedList_linearized.getScore(string);
        if (XMath.isPositive(f2 = GeneSetScoringTables.access$000(f2))) {
            return f2 / this.totalWeight;
        }
        return f2 / this.totalWeight;
    }

    @Override
    public final float getMissScore(String string) {
        return this.miss_score;
    }
}

