/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.GeneSetGenerators;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics$None;
import edu.mit.broad.genome.alg.Metrics$Signal2Noise;
import edu.mit.broad.genome.alg.TemplateStats;
import edu.mit.broad.genome.alg.TemplateStats$RandomRankedListMode;
import edu.mit.broad.genome.alg.TemplateStats$TemplateHitStruc;
import edu.mit.broad.genome.alg.gsea.DefaultGeneSetCohort$Generator;
import edu.mit.broad.genome.alg.gsea.GeneSetCohort;
import edu.mit.broad.genome.alg.gsea.GeneSetCohortGenerator;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTable;
import edu.mit.broad.genome.alg.gsea.KSCore;
import edu.mit.broad.genome.alg.markers.PermutationTestBuilder;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.LabelledVectorProcessors$None;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.RandomSeedGenerators$Timestamp;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedListDb;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactoryRandomizer;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbImplWithPermTest;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbImpl_one_shared_rl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbMulti;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbMultiImpl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResultImpl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import edu.mit.broad.vdb.chip.Chip;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class KSTests {
    private final Logger log = XLogger.getLogger(this.getClass());
    private final KSCore core;
    private static final int LOG_FREQ = 5;
    private PrintStream sout;

    public KSTests(PrintStream printStream) {
        this.sout = printStream;
        this.core = new KSCore();
    }

    public KSTests() {
        this(System.out);
    }

    public final EnrichmentDb executeGsea(Dataset dataset, Template template, GeneSet[] geneSetArray, int n, GeneSetScoringTable geneSetScoringTable, boolean bl, int n2) {
        return this.executeGsea(dataset, template, KSTests.getGeneSets(dataset, geneSetArray, 15, 500), n, new Metrics$Signal2Noise(), SortMode.REAL, Order.DESCENDING, new LabelledVectorProcessors$None(), new RandomSeedGenerators$Timestamp(), TemplateRandomizerType.NO_BALANCE, DatasetMetrics.getDefaultMetricParams(), new DefaultGeneSetCohort$Generator(geneSetScoringTable, true), bl, n2, null);
    }

    public static final GeneSet[] getGeneSets(Dataset dataset, GeneSet[] geneSetArray, int n, int n2) {
        geneSetArray = GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, n, dataset, true);
        if ((geneSetArray = GeneSetGenerators.removeGeneSetsLargerThan(geneSetArray, n2, dataset, false)).length == 0) {
            throw new IllegalArgumentException("No gene sets passed seize threshold");
        }
        return geneSetArray;
    }

    public final EnrichmentDb executeGsea(DatasetTemplate datasetTemplate, GeneSet[] geneSetArray, int n, Metric metric, SortMode sortMode, Order order, LabelledVectorProcessor labelledVectorProcessor, RandomSeedGenerator randomSeedGenerator, TemplateRandomizerType templateRandomizerType, Map map, GeneSetCohortGenerator geneSetCohortGenerator, boolean bl, int n2, List list) {
        return this.executeGsea(datasetTemplate.getDataset(false), datasetTemplate.getTemplate(), geneSetArray, n, metric, sortMode, order, labelledVectorProcessor, randomSeedGenerator, templateRandomizerType, map, geneSetCohortGenerator, bl, n2, list);
    }

    public final EnrichmentDb executeGsea(Dataset dataset, Template template, GeneSet[] geneSetArray, int n, Metric metric, SortMode sortMode, Order order, LabelledVectorProcessor labelledVectorProcessor, RandomSeedGenerator randomSeedGenerator, TemplateRandomizerType templateRandomizerType, Map map, GeneSetCohortGenerator geneSetCohortGenerator, boolean bl, int n2, List list) {
        this.log.debug("!!!! Executing for: " + dataset.getName() + " # samples: " + dataset.getNumCol());
        EnrichmentDb enrichmentDb = bl ? this.shuffleTemplate(n, metric, sortMode, order, map, labelledVectorProcessor, dataset, template, geneSetArray, geneSetCohortGenerator, templateRandomizerType, randomSeedGenerator, n2, list) : this.shuffleGeneSet(n, metric, sortMode, order, map, labelledVectorProcessor, dataset, template, geneSetArray, geneSetCohortGenerator, randomSeedGenerator, true);
        this.sout.println("Finished permutations ... creating reports");
        return enrichmentDb;
    }

    public final EnrichmentDb executeGsea(RankedList rankedList, GeneSet[] geneSetArray, int n, RandomSeedGenerator randomSeedGenerator, Chip chip, GeneSetCohortGenerator geneSetCohortGenerator) {
        this.log.debug("!!!! Executing for: " + rankedList.getName() + " # features: " + rankedList.getSize());
        EnrichmentResult[] enrichmentResultArray = this.shuffleGeneSet_precannedRankedList(n, rankedList, null, geneSetArray, chip, geneSetCohortGenerator, randomSeedGenerator, false, true, true);
        return new EnrichmentDbImpl_one_shared_rl(rankedList.getName(), rankedList, null, null, enrichmentResultArray, new LabelledVectorProcessors$None(), new Metrics$None(), new HashMap(), SortMode.REAL, Order.DESCENDING, n, null);
    }

    public final EnrichmentDb shuffleTemplate(int n, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template, GeneSet[] geneSetArray, GeneSetCohortGenerator geneSetCohortGenerator, TemplateRandomizerType templateRandomizerType, RandomSeedGenerator randomSeedGenerator, int n2, List list) {
        Template[] templateArray = TemplateFactoryRandomizer.createRandomTemplates(n, template, templateRandomizerType, randomSeedGenerator);
        this.log.debug("Done generating rnd templates: " + templateArray.length);
        return this.shuffleTemplate_canned_templates(metric, sortMode, order, map, labelledVectorProcessor, dataset, template, geneSetArray, geneSetCohortGenerator, templateArray, null, null, n2, list);
    }

    public final EnrichmentDb shuffleTemplate(int n, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template, GeneSet[] geneSetArray, GeneSetCohortGenerator geneSetCohortGenerator, TemplateRandomizerType templateRandomizerType, RandomSeedGenerator randomSeedGenerator, float f2, float f3, int n2, TemplateStats$RandomRankedListMode templateStats$RandomRankedListMode, int n3, List list) {
        TemplateStats$TemplateHitStruc templateStats$TemplateHitStruc = TemplateStats.createRandomTemplates(f2, f3, n, n2, sortMode, order, metric, map, labelledVectorProcessor, dataset, template, templateRandomizerType, randomSeedGenerator, templateStats$RandomRankedListMode);
        Template[] templateArray = templateStats$TemplateHitStruc.getRandomTemplates(templateStats$RandomRankedListMode);
        RankedList[] rankedListArray = templateStats$TemplateHitStruc.getRandomRankedLists(templateStats$RandomRankedListMode);
        RankedList rankedList = templateStats$TemplateHitStruc.getRealRankedList();
        this.log.info("Done generating rnd templates: " + templateArray.length);
        return this.shuffleTemplate_canned_templates(metric, sortMode, order, map, labelledVectorProcessor, dataset, template, geneSetArray, geneSetCohortGenerator, templateArray, rankedList, rankedListArray, n3, list);
    }

    public final EnrichmentDb shuffleTemplate_canned_templates(Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template, GeneSet[] geneSetArray, GeneSetCohortGenerator geneSetCohortGenerator, Template[] templateArray, RankedList rankedList, RankedList[] rankedListArray, int n, List list) {
        int n2;
        this.log.debug("shuffleTemplate with -- nperm: " + templateArray.length + " Order: " + order + " Sort: " + sortMode + " gsets: " + geneSetArray.length);
        String string = NamingConventions.generateName(dataset, template, true);
        Chip chip = dataset.getAnnot().getChip();
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        PermutationTestBuilder permutationTestBuilder = new PermutationTestBuilder(string, n, templateArray.length, labelledVectorProcessor, metric, sortMode, order, map, dataset, template, null, template.isCategorical());
        RankedList rankedList2 = rankedList != null ? rankedList : datasetMetrics.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        if (rankedList2.getSize() != dataset.getNumRow()) {
            throw new MismatchedSizeException();
        }
        GeneSetCohort geneSetCohort = geneSetCohortGenerator.createGeneSetCohort(rankedList2, geneSetArray, false, true);
        EnrichmentScore[] enrichmentScoreArray = this.core.calculateKSScore(geneSetCohort, true);
        Vector[] vectorArray = new Vector[geneSetArray.length];
        for (n2 = 0; n2 < geneSetArray.length; ++n2) {
            vectorArray[n2] = new Vector(templateArray.length);
        }
        for (n2 = 0; n2 < templateArray.length; ++n2) {
            Object object;
            RankedList rankedList3 = rankedListArray != null ? rankedListArray[n2] : datasetMetrics.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, dataset, templateArray[n2]);
            if (list != null) {
                list.add(rankedList3);
            }
            if (n2 % 5 == 0) {
                object = new StringBuffer("Iteration: ").append(n2 + 1).append('/').append(templateArray.length);
                ((StringBuffer)object).append(" for ").append(string);
                System.out.println(((StringBuffer)object).toString());
            }
            object = geneSetCohortGenerator.createGeneSetCohort(rankedList3, geneSetArray, false, false);
            EnrichmentScore[] enrichmentScoreArray2 = this.core.calculateKSScore((GeneSetCohort)object, false);
            for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
                vectorArray[i2].setElement(n2, enrichmentScoreArray2[i2].getES());
            }
            permutationTestBuilder.addRnd(templateArray[n2], rankedList3);
        }
        EnrichmentResult[] enrichmentResultArray = new EnrichmentResult[geneSetArray.length];
        for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
            enrichmentResultArray[i3] = new EnrichmentResultImpl(rankedList2, template, geneSetArray[i3], chip, enrichmentScoreArray[i3], vectorArray[i3]);
        }
        permutationTestBuilder.doCalc();
        return new EnrichmentDbImplWithPermTest(string, rankedList2, dataset, template, enrichmentResultArray, labelledVectorProcessor, metric, map, sortMode, order, templateArray.length, null, permutationTestBuilder);
    }

    public final EnrichmentResult[] shuffleGeneSet_precannedRankedList(int n, RankedList rankedList, Template template, GeneSet[] geneSetArray, Chip chip, GeneSetCohortGenerator geneSetCohortGenerator, RandomSeedGenerator randomSeedGenerator, boolean bl, boolean bl2, boolean bl3) {
        EnrichmentResult[] enrichmentResultArray = new EnrichmentResult[geneSetArray.length];
        GeneSetCohort geneSetCohort = geneSetCohortGenerator.createGeneSetCohort(rankedList, geneSetArray, bl, true);
        EnrichmentScore[] enrichmentScoreArray = this.core.calculateKSScore(geneSetCohort, bl2, bl3);
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            Vector vector;
            if (i2 % 5 == 0) {
                this.sout.println("shuffleGeneSet for GeneSet " + (i2 + 1) + "/" + geneSetArray.length + " nperm: " + n);
            }
            if (n > 0) {
                GeneSet[] geneSetArray2 = GeneSetGenerators.createRandomGeneSetsFixedSize(n, rankedList, geneSetArray[i2], randomSeedGenerator);
                GeneSetCohort geneSetCohort2 = geneSetCohort.clone(geneSetArray2, false);
                vector = new Vector(geneSetArray2.length);
                EnrichmentScore[] enrichmentScoreArray2 = this.core.calculateKSScore(geneSetCohort2, false);
                for (int i3 = 0; i3 < geneSetArray2.length; ++i3) {
                    vector.setElement(i3, enrichmentScoreArray2[i3].getES());
                }
            } else {
                vector = new Vector(0);
            }
            enrichmentResultArray[i2] = new EnrichmentResultImpl(rankedList, template, geneSetArray[i2], chip, enrichmentScoreArray[i2], vector);
        }
        return enrichmentResultArray;
    }

    public final EnrichmentDbMulti createEdb_precannedRankedLists(String string, int n, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, RankedList[] rankedListArray, Template[] templateArray, GeneSet[] geneSetArray, Chip chip, GeneSetCohortGenerator geneSetCohortGenerator, RandomSeedGenerator randomSeedGenerator, boolean bl, boolean bl2) {
        EnrichmentDb[] enrichmentDbArray = new EnrichmentDb[rankedListArray.length];
        for (int i2 = 0; i2 < rankedListArray.length; ++i2) {
            Template template = null;
            if (templateArray != null) {
                template = templateArray[i2];
            }
            EnrichmentResult[] enrichmentResultArray = this.shuffleGeneSet_precannedRankedList(n, rankedListArray[i2], template, geneSetArray, chip, geneSetCohortGenerator, randomSeedGenerator, false, bl, bl2);
            enrichmentDbArray[i2] = new EnrichmentDbImpl_one_shared_rl(rankedListArray[i2].getName(), rankedListArray[i2], null, template, enrichmentResultArray, labelledVectorProcessor, metric, map, sortMode, order, n, null);
            System.out.println("Done edb for rls: " + rankedListArray[i2].getName() + " " + (i2 + 1) + " / " + rankedListArray.length);
        }
        return new EnrichmentDbMultiImpl(string, enrichmentDbArray);
    }

    public final EnrichmentDbMulti createEdb_precannedRankedLists(String string, int n, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, RankedListDb rankedListDb, GeneSet[] geneSetArray, Chip chip, GeneSetCohortGenerator geneSetCohortGenerator, RandomSeedGenerator randomSeedGenerator, boolean bl, boolean bl2) {
        EnrichmentDb[] enrichmentDbArray = new EnrichmentDb[rankedListDb.getNumRankedLists()];
        for (int i2 = 0; i2 < rankedListDb.getNumRankedLists(); ++i2) {
            RankedList rankedList = rankedListDb.getRankedList(i2);
            EnrichmentResult[] enrichmentResultArray = this.shuffleGeneSet_precannedRankedList(n, rankedList, null, geneSetArray, chip, geneSetCohortGenerator, randomSeedGenerator, false, bl, bl2);
            enrichmentDbArray[i2] = new EnrichmentDbImpl_one_shared_rl(rankedList.getName(), rankedList, null, null, enrichmentResultArray, labelledVectorProcessor, metric, map, sortMode, order, n, null);
            System.out.println("Done edb for rls: " + rankedList.getName() + " " + (i2 + 1) + " / " + rankedListDb.getNumRankedLists());
        }
        return new EnrichmentDbMultiImpl(string, enrichmentDbArray);
    }

    public final EnrichmentDbMulti createEdb_precannedRankedLists(String string, int n, RankedList[] rankedListArray, Template[] templateArray, GeneSet[] geneSetArray, Chip chip, GeneSetScoringTable geneSetScoringTable, boolean bl, boolean bl2) {
        return this.createEdb_precannedRankedLists(string, n, new Metrics$Signal2Noise(), SortMode.REAL, Order.DESCENDING, DatasetMetrics.getDefaultMetricParams(), new LabelledVectorProcessors$None(), rankedListArray, templateArray, geneSetArray, chip, new DefaultGeneSetCohort$Generator(geneSetScoringTable, true), new RandomSeedGenerators$Timestamp(), bl, bl2);
    }

    public final Dataset createEdb_precannedRankedLists(String string, int n, Dataset dataset, Template[] templateArray, GeneSet[] geneSetArray, Chip chip, GeneSetScoringTable geneSetScoringTable, boolean bl, boolean bl2) {
        Metrics$Signal2Noise metrics$Signal2Noise = new Metrics$Signal2Noise();
        Map map = DatasetMetrics.getDefaultMetricParams();
        DefaultGeneSetCohort$Generator defaultGeneSetCohort$Generator = new DefaultGeneSetCohort$Generator(geneSetScoringTable, true);
        RandomSeedGenerators$Timestamp randomSeedGenerators$Timestamp = new RandomSeedGenerators$Timestamp();
        LabelledVectorProcessors$None labelledVectorProcessors$None = new LabelledVectorProcessors$None();
        Matrix matrix = new Matrix(geneSetArray.length, n);
        String[] stringArray = null;
        String[] stringArray2 = new String[dataset.getNumCol()];
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            Template template = null;
            if (templateArray != null) {
                template = templateArray[i2];
            }
            RankedList rankedList = dataset.getColumnRL(i2, SortMode.REAL, Order.DESCENDING);
            stringArray2[i2] = rankedList.getName();
            EnrichmentResult[] enrichmentResultArray = this.shuffleGeneSet_precannedRankedList(n, rankedList, template, geneSetArray, chip, defaultGeneSetCohort$Generator, randomSeedGenerators$Timestamp, false, bl, bl2);
            EnrichmentDbImpl_one_shared_rl enrichmentDbImpl_one_shared_rl = new EnrichmentDbImpl_one_shared_rl(rankedList.getName(), rankedList, null, template, enrichmentResultArray, labelledVectorProcessors$None, metrics$Signal2Noise, map, SortMode.REAL, Order.DESCENDING, n, null);
            if (stringArray == null) {
                stringArray = enrichmentDbImpl_one_shared_rl.getGeneSetNamesArray();
            }
            System.out.println("Done edb for rls: " + dataset.getColumnName(i2) + " " + (i2 + 1) + " / " + dataset.getNumCol());
        }
        return new DefaultDataset(string + "_ess", matrix, stringArray, stringArray2, true);
    }

    public final EnrichmentDb shuffleGeneSet(int n, Metric metric, SortMode sortMode, Order order, Map map, LabelledVectorProcessor labelledVectorProcessor, Dataset dataset, Template template, GeneSet[] geneSetArray, GeneSetCohortGenerator geneSetCohortGenerator, RandomSeedGenerator randomSeedGenerator, boolean bl) {
        if (dataset == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        ScoredDataset scoredDataset = datasetMetrics.scoreDataset(metric, sortMode, order, map, labelledVectorProcessor, dataset, template);
        Chip chip = dataset.getAnnot().getChip();
        EnrichmentResult[] enrichmentResultArray = this.shuffleGeneSet_precannedRankedList(n, scoredDataset, template, geneSetArray, chip, geneSetCohortGenerator, randomSeedGenerator, false, true, bl);
        String string = NamingConventions.generateName(dataset, template, true);
        return new EnrichmentDbImpl_one_shared_rl(string, scoredDataset, dataset, template, enrichmentResultArray, labelledVectorProcessor, metric, map, sortMode, order, n, null);
    }
}

