/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.alg.gsea.MhtMode;
import edu.mit.broad.genome.alg.gsea.MhtModes;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import java.util.ArrayList;
import java.util.List;

abstract class MhtModes$Base
implements MhtMode {
    private String fName;
    protected EnrichmentResult[] fDtgs;
    private List fTGNames;
    private List fGeneSetNames;
    protected Matrix fRndMatrix;
    protected Matrix fRndMatrix_mw;

    protected MhtModes$Base(String string) {
        this.fName = string;
    }

    @Override
    public void setData(EnrichmentResult[] enrichmentResultArray) {
        this.fDtgs = enrichmentResultArray;
        this.fGeneSetNames = null;
        this.fTGNames = null;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public String toString() {
        return this.fName;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof MhtMode) {
            return this.getName().equalsIgnoreCase(((MhtMode)object).getName());
        }
        return false;
    }

    @Override
    public float getDiscoveryPValue(int n) {
        return (float)XMath.getPValueTwoTailed(this.getRealNES(n), this.getRndNESMatrix());
    }

    @Override
    public float getDiscoveryPValue(int n, float f2) {
        float f3 = (float)this.getRndNESMatrix().getAbsoluteSize() * f2;
        float f4 = this.getRealNES(n);
        return (float)XMath.getPValueTwoTailed(f4, MhtModes.access$000(f4, this.getRndNESMatrix(), (int)f3));
    }

    @Override
    public float getValidationPValue(int n, float f2) {
        float f3 = (float)this.fDtgs.length * f2;
        float f4 = this.getRealNES(n);
        return (float)XMath.getPValueTwoTailed(f4, MhtModes.access$100(f4, this.getRndNESMatrix(), (int)f3));
    }

    @Override
    public float getValidationPValue(int n) {
        float f2 = this.getRealNES(n);
        return (float)XMath.getPValueTwoTailed(f2, MhtModes.access$200(this.getRndNESMatrix()));
    }

    @Override
    public float getValidationType2PValue(int n) {
        float f2 = this.getRealNES(n);
        return (float)XMath.getPValueTwoTailed(f2, MhtModes.access$300(f2, this.getRndNESMatrix()));
    }

    @Override
    public Matrix getRndNESMatrix() {
        this.fRndMatrix.setImmutable();
        return this.fRndMatrix;
    }

    @Override
    public int getDiscoveryMatrixSize() {
        return this.getRndNESMatrix().getAbsoluteSize();
    }

    @Override
    public int getValidationMatrixSize() {
        return this.getRndNESMatrix().getNumCol();
    }

    @Override
    public float getRealNMW(int n) {
        return Float.NaN;
    }

    @Override
    public Vector getRndNMW(int n) {
        MhtModes.access$400().warn("Not implemented");
        return new Vector(this.fDtgs[n].getRndESS().getSize());
    }

    @Override
    public float getDiscoveryPValue_mw(int n) {
        return (float)XMath.getPValueTwoTailed(this.getRealNMW(n), this.getRndNMWMatrix());
    }

    @Override
    public float getValidationPValue_mw(int n) {
        float f2 = this.getRealNMW(n);
        return (float)XMath.getPValueTwoTailed(f2, MhtModes.access$200(this.getRndNMWMatrix()));
    }

    @Override
    public Matrix getRndNMWMatrix() {
        if (this.fRndMatrix_mw == null) {
            return new Matrix(this.fRndMatrix.getNumRow(), this.fRndMatrix.getNumCol());
        }
        this.fRndMatrix_mw.setImmutable();
        return this.fRndMatrix_mw;
    }

    @Override
    public Vector getRndNES(String string) {
        return this.getRndNES(this._indexOf(string));
    }

    @Override
    public float getRealNES(String string) {
        return this.getRealNES(this._indexOf(string));
    }

    @Override
    public float getDiscoveryPValue(String string) {
        return this.getDiscoveryPValue(this._indexOf(string));
    }

    @Override
    public float getDiscoveryPValue(String string, float f2) {
        return this.getDiscoveryPValue(this._indexOf(string), f2);
    }

    @Override
    public float getValidationPValue(String string) {
        return this.getValidationPValue(this._indexOf(string));
    }

    @Override
    public float getValidationPValue(String string, float f2) {
        return this.getValidationPValue(this._indexOf(string), f2);
    }

    @Override
    public float getValidationType2PValue(String string) {
        return this.getValidationType2PValue(this._indexOf(string));
    }

    @Override
    public Vector getRndNES_bygsetname(String string) {
        return this.getRndNES(this._indexOf_gsetname(string));
    }

    @Override
    public float getRealNES_bygsetname(String string) {
        return this.getRealNES(this._indexOf_gsetname(string));
    }

    @Override
    public float getDiscoveryPValue_bygsetname(String string) {
        return this.getDiscoveryPValue(this._indexOf_gsetname(string));
    }

    @Override
    public float getDiscoveryPValue_bygsetname(String string, float f2) {
        return this.getDiscoveryPValue(this._indexOf_gsetname(string), f2);
    }

    @Override
    public float getValidationPValue_bygsetname(String string) {
        return this.getValidationPValue(this._indexOf_gsetname(string));
    }

    @Override
    public float getValidationPValue_bygsetname(String string, float f2) {
        return this.getValidationPValue(this._indexOf_gsetname(string), f2);
    }

    @Override
    public float getValidationType2PValue_bygsetname(String string) {
        return this.getValidationPValue(this._indexOf_gsetname(string));
    }

    private int _indexOf(String string) {
        int n;
        if (this.fTGNames == null) {
            this.fTGNames = new ArrayList(this.fDtgs.length);
            for (n = 0; n < this.fDtgs.length; ++n) {
                if (this.fDtgs[n].getGeneSetName() == null || this.fTGNames.contains(this.fDtgs[n].getGeneSetName())) {
                    throw new IllegalStateException("Cannot use access by TGName as there are duplicate/null TG's: " + this.fDtgs[n].getGeneSetName());
                }
                this.fTGNames.add(this.fDtgs[n].getGeneSetName());
            }
        }
        if ((n = this.fTGNames.indexOf(string)) == -1) {
            throw new IllegalArgumentException("In this MhtMode no TG for: " + string + "\nThe TGs are: " + this.fTGNames);
        }
        return n;
    }

    private int _indexOf_gsetname(String string) {
        int n;
        if (this.fGeneSetNames == null) {
            this.fGeneSetNames = new ArrayList(this.fDtgs.length);
            for (n = 0; n < this.fDtgs.length; ++n) {
                if (this.fDtgs[n].getGeneSet() == null || this.fGeneSetNames.contains(this.fDtgs[n].getGeneSet().getName())) {
                    throw new IllegalStateException("Cannot use access by GeneSetName as there are duplicate/null GeneSet(s): " + this.fDtgs[n].getGeneSet());
                }
                this.fGeneSetNames.add(this.fDtgs[n].getGeneSet().getName());
            }
        }
        if ((n = this.fGeneSetNames.indexOf(string)) == -1) {
            throw new IllegalArgumentException("In this MhtMode no GeneSetName for: " + string + "\nThe GeneSetNames are: " + this.fGeneSetNames);
        }
        return n;
    }

    @Override
    public float calcNes(float f2, Vector vector, ScoreMode scoreMode) {
        throw new NotImplementedException();
    }

    @Override
    public Vector calcNes(Vector vector, ScoreMode scoreMode) {
        throw new NotImplementedException();
    }

    @Override
    public float calcVar(Vector vector, ScoreMode scoreMode) {
        throw new NotImplementedException();
    }

    @Override
    public float calcMean(Vector vector, ScoreMode scoreMode) {
        throw new NotImplementedException();
    }
}

