/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.gsea.MhtMode;
import edu.mit.broad.genome.alg.gsea.MhtModes$Area;
import edu.mit.broad.genome.alg.gsea.MhtModes$Linear;
import edu.mit.broad.genome.alg.gsea.MhtModes$Raw;
import edu.mit.broad.genome.alg.gsea.MhtModes$Var;
import edu.mit.broad.genome.alg.gsea.MhtModes$VarMean;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import org.apache.log4j.Logger;

public abstract class MhtModes {
    private static Logger klog = XLogger.getLogger(MhtModes.class);
    public static final String RAW_NORM = "no_norm";
    public static final String AREA_NORM = "area_norm";
    public static final String VAR_NORM = "var_norm";
    public static final String VARMEAN_NORM = "varmean_norm";
    public static final String VARMEAN_NORM_01 = "varmean_norm_01";
    public static final String LINEAR_NORM = "linear_norm";
    public static final String[] ALL = new String[]{"no_norm", "area_norm", "var_norm", "varmean_norm", "linear_norm", "varmean_norm_01"};

    public static final boolean isRaw(String string) {
        return string.equalsIgnoreCase(RAW_NORM);
    }

    public static final boolean isAreaNorm(String string) {
        return string.equalsIgnoreCase(AREA_NORM);
    }

    public static final boolean isVarNorm(String string) {
        return string.equalsIgnoreCase(VAR_NORM);
    }

    public static final boolean isVarMeanNorm(String string) {
        return string.equalsIgnoreCase(VARMEAN_NORM);
    }

    public static final boolean isVarMeanNorm01(String string) {
        return string.equalsIgnoreCase(VARMEAN_NORM_01);
    }

    public static final boolean isLinearNorm(String string) {
        return string.equalsIgnoreCase(LINEAR_NORM);
    }

    public static final MhtMode[] createAll() {
        return new MhtMode[]{new MhtModes$Raw(), new MhtModes$Area(), new MhtModes$Var(), new MhtModes$VarMean(), new MhtModes$Linear()};
    }

    public static final MhtMode[] createModes(String[] stringArray) {
        MhtMode[] mhtModeArray = new MhtMode[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (MhtModes.isRaw(stringArray[i2])) {
                mhtModeArray[i2] = new MhtModes$Raw();
                continue;
            }
            if (MhtModes.isAreaNorm(stringArray[i2])) {
                mhtModeArray[i2] = new MhtModes$Area();
                continue;
            }
            if (MhtModes.isVarNorm(stringArray[i2])) {
                mhtModeArray[i2] = new MhtModes$Var();
                continue;
            }
            if (MhtModes.isVarMeanNorm(stringArray[i2])) {
                mhtModeArray[i2] = new MhtModes$VarMean();
                continue;
            }
            if (MhtModes.isLinearNorm(stringArray[i2])) {
                mhtModeArray[i2] = new MhtModes$Linear();
                continue;
            }
            throw new IllegalArgumentException("Unknown MhtMode: " + stringArray[i2]);
        }
        return mhtModeArray;
    }

    public static final MhtMode lookup(Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot lookup for null object");
        }
        if (object instanceof MhtMode) {
            return (MhtMode)object;
        }
        MhtMode[] mhtModeArray = MhtModes.createAll();
        for (int i2 = 0; i2 < mhtModeArray.length; ++i2) {
            if (!mhtModeArray[i2].getName().equalsIgnoreCase(object.toString())) continue;
            return mhtModeArray[i2];
        }
        throw new RuntimeException("Cannot lookup MhtMode by: " + object);
    }

    public static final int checkAndGetNumPerms(EnrichmentResult[] enrichmentResultArray) {
        if (enrichmentResultArray.length == 0) {
            klog.warn("Zero length dtgs");
            return 0;
        }
        int n = enrichmentResultArray[0].getNumPerms();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            if (n == enrichmentResultArray[i2].getNumPerms()) continue;
            throw new IllegalArgumentException("Mismatched numperms: " + n + " but DTG at: " + i2 + " had: " + enrichmentResultArray[i2].getNumPerms());
        }
        return n;
    }

    private static Vector getValidationModeMaxScores(Matrix matrix) {
        Vector vector = new Vector(matrix.getNumCol());
        for (int i2 = 0; i2 < matrix.getNumCol(); ++i2) {
            Vector vector2 = matrix.getColumnV(i2);
            vector.setElement(i2, vector2.maxDevFrom0());
        }
        return vector;
    }

    private static Vector getDiscoveryModeMaxScores(float f2, Matrix matrix, int n) {
        Vector vector = new Vector(matrix.getAbsoluteSize());
        vector.sort(SortMode.REAL, MhtModes.getOrder(f2));
        Vector vector2 = new Vector(n);
        for (int i2 = 0; i2 < n; ++i2) {
            vector2.setElement(i2, vector.getElement(i2));
        }
        return vector2;
    }

    private static Vector getValidationModeMaxScores(float f2, Matrix matrix, int n) {
        Vector vector = new Vector(matrix.getNumCol() * n);
        int n2 = 0;
        for (int i2 = 0; i2 < matrix.getNumCol(); ++i2) {
            Vector vector2 = matrix.getColumnV(i2);
            vector2.sort(SortMode.REAL, MhtModes.getOrder(f2));
            for (int i3 = 0; i3 < n; ++i3) {
                vector.setElement(n2++, vector2.getElement(i3));
            }
        }
        return vector;
    }

    private static Vector getPabloModeScores(float f2, Matrix matrix) {
        Vector vector = new Vector(matrix.getNumRow());
        for (int i2 = 0; i2 < matrix.getNumRow(); ++i2) {
            if (f2 >= 0.0f) {
                vector.setElement(i2, matrix.getRowV(i2).max());
                continue;
            }
            vector.setElement(i2, matrix.getRowV(i2).min());
        }
        return vector;
    }

    private static Order getOrder(float f2) {
        if (f2 >= 0.0f) {
            return Order.DESCENDING;
        }
        return Order.ASCENDING;
    }

    static final /* synthetic */ Vector access$000(float f2, Matrix matrix, int n) {
        return MhtModes.getDiscoveryModeMaxScores(f2, matrix, n);
    }

    static final /* synthetic */ Vector access$100(float f2, Matrix matrix, int n) {
        return MhtModes.getValidationModeMaxScores(f2, matrix, n);
    }

    static final /* synthetic */ Vector access$200(Matrix matrix) {
        return MhtModes.getValidationModeMaxScores(matrix);
    }

    static final /* synthetic */ Vector access$300(float f2, Matrix matrix) {
        return MhtModes.getPabloModeScores(f2, matrix);
    }

    static final /* synthetic */ Logger access$400() {
        return klog;
    }
}

