/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.Norm;
import edu.mit.broad.genome.alg.gsea.Norms$AreaNorm;
import edu.mit.broad.genome.alg.gsea.Norms$MeanDivPosNegSeperate;
import edu.mit.broad.genome.alg.gsea.Norms$MeanPosNegCombined;
import edu.mit.broad.genome.alg.gsea.Norms$MeanPosNegSeperate;
import edu.mit.broad.genome.alg.gsea.Norms$None;
import edu.mit.broad.genome.alg.gsea.Norms$Struc;
import edu.mit.broad.genome.alg.gsea.Norms$VarMeanPosNegCombined;
import edu.mit.broad.genome.alg.gsea.Norms$VarMeanPosNegSeperate;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.LabelledVector;
import java.util.ArrayList;

public class Norms {
    public static final String NONE = Norms$None.access$000();
    public static final String VARMEAN_POS_NEG_SEPERATE = Norms$VarMeanPosNegSeperate.access$100();
    public static final String VARMEAN_POS_NEG_COMBINED = Norms$VarMeanPosNegCombined.access$200();
    public static final String MEANDIV_POS_NEG_SEPERATE = Norms$MeanDivPosNegSeperate.access$300();
    public static final String MEAN_POS_NEG_SEPERATE = Norms$MeanPosNegSeperate.access$400();
    public static final String MEAN_POS_NEG_COMBINED = Norms$MeanPosNegCombined.access$500();
    public static final String AREA_NORM = Norms$AreaNorm.access$600();

    public static final String[] createNormModeNames() {
        return new String[]{NONE, MEANDIV_POS_NEG_SEPERATE};
    }

    public static final String[] createNormModeNames_all() {
        return new String[]{NONE, VARMEAN_POS_NEG_SEPERATE, VARMEAN_POS_NEG_COMBINED, MEAN_POS_NEG_SEPERATE, MEAN_POS_NEG_COMBINED, MEANDIV_POS_NEG_SEPERATE, AREA_NORM};
    }

    public static final Norm createNorm(String string, float f2, Vector vector) {
        if (string == null) {
            throw new IllegalArgumentException("Param normModeName cannot be null");
        }
        if (string.equals(NONE)) {
            return new Norms$None(f2, vector);
        }
        if (string.equals(VARMEAN_POS_NEG_SEPERATE)) {
            return new Norms$VarMeanPosNegSeperate(f2, vector);
        }
        if (string.equals(VARMEAN_POS_NEG_COMBINED)) {
            return new Norms$VarMeanPosNegCombined(f2, vector);
        }
        if (string.equals(MEAN_POS_NEG_SEPERATE)) {
            return new Norms$MeanPosNegSeperate(f2, vector);
        }
        if (string.equals(MEAN_POS_NEG_COMBINED)) {
            return new Norms$MeanPosNegCombined(f2, vector);
        }
        if (string.equals(MEANDIV_POS_NEG_SEPERATE)) {
            return new Norms$MeanDivPosNegSeperate(f2, vector);
        }
        if (string.equals(AREA_NORM)) {
            return new Norms$MeanDivPosNegSeperate(f2, vector);
        }
        throw new IllegalArgumentException("Unknown norm mode: " + string);
    }

    public static final Norms$Struc normalize(String string, LabelledVector labelledVector, Dataset dataset) {
        Vector vector = new Vector(labelledVector.getSize());
        String[] stringArray = new String[labelledVector.getSize()];
        ArrayList<String> arrayList = new ArrayList<String>();
        Matrix matrix = new Matrix(labelledVector.getSize(), dataset.getNumCol());
        for (int i2 = 0; i2 < labelledVector.getSize(); ++i2) {
            String string2 = labelledVector.getLabel(i2);
            float f2 = labelledVector.getScore(string2);
            Norm norm = Norms.createNorm(string, f2, dataset.getRow(string2));
            matrix.setRow(i2, norm.getRandomNorm());
            vector.setElement(i2, norm.getRealNorm());
            stringArray[i2] = string2;
            arrayList.add(string2);
        }
        Norms$Struc norms$Struc = new Norms$Struc();
        norms$Struc.normReal = new LabelledVector(labelledVector.getName() + "_norm", stringArray, vector);
        norms$Struc.normRnd = new DefaultDataset("norm", matrix, arrayList, dataset.getColumnNames(), true, dataset.getAnnot());
        return norms$Struc;
    }

    public static final Dataset normalize(Dataset dataset, String string) {
        Matrix matrix = new Matrix(dataset.getNumRow(), dataset.getNumCol());
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            float f2 = 0.0f;
            Norm norm = Norms.createNorm(string, f2, dataset.getRow(i2));
            matrix.setRow(i2, norm.getRandomNorm());
        }
        return new DefaultDataset("norm", matrix, dataset.getRowNames(), dataset.getColumnNames(), true, null);
    }
}

