/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.charts;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XChartImpl;
import edu.mit.broad.genome.charts.XComboChart;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;

public class XComboDomainChart
implements XComboChart {
    private CombinedDomainXYPlot fCombinedXYPlot;
    private XChart fCombinedChart;
    private JFreeChart fCombinedFreeChart;
    private String fComboCaption;
    private String[] fSubplotTitles;
    private List fSubCharts;
    private static final Icon ICON = JarResources.getIcon("Chart.gif");
    private final Logger log = XLogger.getLogger(XComboDomainChart.class);

    public XComboDomainChart(String string, String string2, String string3, String string4, XYPlot[] xYPlotArray, int[] nArray, String[] stringArray) {
        this.init(string, string2, string3, string4, xYPlotArray, nArray, stringArray);
        for (int i2 = 0; i2 < this.getNumSubPlots(); ++i2) {
            this.fSubCharts.add(null);
        }
    }

    public XComboDomainChart(String string, String string2, String string3, String string4, XChart[] xChartArray) {
        int n;
        XYPlot[] xYPlotArray = new XYPlot[xChartArray.length];
        String[] stringArray = new String[xChartArray.length];
        for (int i2 = 0; i2 < xChartArray.length; ++i2) {
            Plot plot = xChartArray[i2].getFreeChart().getPlot();
            if (!(plot instanceof XYPlot)) {
                throw new IllegalArgumentException("Only XYPlots allowed. Found: " + plot.getClass() + " at: " + i2);
            }
            xYPlotArray[i2] = (XYPlot)plot;
            stringArray[i2] = xChartArray[i2].getName();
        }
        int[] nArray = new int[xYPlotArray.length];
        for (n = 0; n < xYPlotArray.length; ++n) {
            nArray[n] = 1;
        }
        this.init(string, string2, string3, string4, xYPlotArray, nArray, stringArray);
        for (n = 0; n < this.getNumSubPlots(); ++n) {
            this.fSubCharts.add(xChartArray[n]);
        }
    }

    public XComboDomainChart(String string, String string2, String string3, String string4, XChart[] xChartArray, int[] nArray) {
        int n;
        XYPlot[] xYPlotArray = new XYPlot[xChartArray.length];
        String[] stringArray = new String[xChartArray.length];
        for (n = 0; n < xChartArray.length; ++n) {
            Plot plot = xChartArray[n].getFreeChart().getPlot();
            if (!(plot instanceof XYPlot)) {
                throw new IllegalArgumentException("Only XYPlots allowed. Found: " + plot.getClass() + " at: " + n);
            }
            xYPlotArray[n] = (XYPlot)plot;
            stringArray[n] = xChartArray[n].getName();
        }
        this.init(string, string2, string3, string4, xYPlotArray, nArray, stringArray);
        for (n = 0; n < this.getNumSubPlots(); ++n) {
            this.fSubCharts.add(xChartArray[n]);
        }
    }

    private void init(String string, String string2, String string3, String string4, XYPlot[] xYPlotArray, int[] nArray, String[] stringArray) {
        if (xYPlotArray == null) {
            throw new IllegalArgumentException("Param xyplots cannot be null");
        }
        this.fCombinedXYPlot = new CombinedDomainXYPlot(new NumberAxis(string4));
        this.fCombinedXYPlot.setOrientation(PlotOrientation.VERTICAL);
        for (int i2 = 0; i2 < xYPlotArray.length; ++i2) {
            xYPlotArray[i2].setDomainAxis(null);
            this.fCombinedXYPlot.add(xYPlotArray[i2], nArray[i2]);
        }
        this.fComboCaption = string3;
        this.fSubplotTitles = stringArray;
        this.fCombinedFreeChart = new JFreeChart(string2, JFreeChart.DEFAULT_TITLE_FONT, this.fCombinedXYPlot, true);
        this.fCombinedChart = new XChartImpl(string, this.fComboCaption, this.fCombinedFreeChart);
        this.fSubCharts = new ArrayList();
    }

    public final CombinedDomainXYPlot getCombinedXYPlot() {
        return this.fCombinedXYPlot;
    }

    @Override
    public final XChart getCombinedChart() {
        return this.fCombinedChart;
    }

    @Override
    public final XChart getCombinedChart(String string) {
        return this.fCombinedChart.cloneShallow(string);
    }

    @Override
    public final void saveAsPNG(File file, int n, int n2) {
        this.getCombinedChart().saveAsPNG(file, n, n2);
    }

    @Override
    public final JFreeChart getCombinedFreeChart() {
        return this.fCombinedFreeChart;
    }

    @Override
    public final int getNumSubPlots() {
        return this.fCombinedXYPlot.getSubplots().size();
    }

    @Override
    public final XChart getSubChart(int n) {
        Object e2 = this.fSubCharts.get(n);
        if (e2 != null) {
            return (XChart)e2;
        }
        Plot plot = (Plot)this.fCombinedXYPlot.getSubplots().get(n);
        XChartImpl xChartImpl = new XChartImpl("index_" + n, this.fComboCaption + "_subplot" + n, this.fSubplotTitles[n], plot, true);
        this.fSubCharts.set(n, xChartImpl);
        return xChartImpl;
    }

    @Override
    public final XYPlot getSubXYPlot(int n) {
        return (XYPlot)this.fCombinedXYPlot.getSubplots().get(n);
    }

    @Override
    public final String getCaption() {
        return this.fComboCaption;
    }

    @Override
    public final Icon getIcon() {
        return ICON;
    }
}

