/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.charts.jfreechart.editor;

import edu.mit.broad.genome.charts.jfreechart.editor.AxisEditor;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.fields.GCheckBoxField;
import edu.mit.broad.genome.swing.fields.GColorFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GComboBoxField;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooserTable;
import edu.mit.broad.genome.swing.fields.GStringField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;

public class GenomeChartPropertyEditPanel
extends JPanel {
    private JTabbedPane fTabbedPane;
    private JFreeChart fChart;
    private GStringField fChartTitleChooser;
    private GColorFieldPlusChooser fChartBgColorChooser;
    private GColorFieldPlusChooser fPlotBgColorChooser;
    private GCheckBoxField fChartAntiAliasChooser;
    private GCheckBoxField fLegendOnOffChooser;
    private GComboBoxField fLegendOutlineStrokeChooser;
    private GColorFieldPlusChooser fLegendOutlineColorChooser;
    private GColorFieldPlusChooser fLegendBgColorChooser;
    private GColorFieldPlusChooser fLegendSeriesColorChooser;
    private AxisEditor fDomain;
    private AxisEditor fRange;

    public GenomeChartPropertyEditPanel(JFreeChart jFreeChart) {
        if (jFreeChart == null) {
            throw new IllegalArgumentException("Param chart cannot be null");
        }
        this.fChart = jFreeChart;
        this.init();
    }

    private void init() {
        this.jbInit();
    }

    private void jbInit() {
        JComponent jComponent;
        this.fTabbedPane = new JTabbedPane(1);
        this.fTabbedPane.addTab("Chart", new JScrollPane(this.createChartControls()));
        this.fTabbedPane.addTab("Legend", new JScrollPane(this.createLegendControls()));
        Axis axis = this.getDomainAxis();
        if (axis == null) {
            jComponent = GuiHelper.createNaPlaceholder();
        } else {
            this.fDomain = new AxisEditor(axis);
            jComponent = new JScrollPane(this.fDomain.fTable);
        }
        this.fTabbedPane.add("Domain Axis (X)", jComponent);
        axis = this.getRangeAxis();
        if (axis == null) {
            jComponent = GuiHelper.createNaPlaceholder();
        } else {
            this.fRange = new AxisEditor(axis);
            jComponent = new JScrollPane(this.fRange.fTable);
        }
        this.fTabbedPane.add("Range Axis (Y)", jComponent);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fTabbedPane, "Center");
    }

    private TextTitle getTextTitle() {
        TextTitle textTitle = this.fChart.getTitle();
        if (textTitle instanceof TextTitle) {
            return textTitle;
        }
        if (textTitle != null) {
            return new TextTitle(textTitle.getID());
        }
        return new TextTitle("na_title");
    }

    private GFieldPlusChooserTable createChartControls() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        TextTitle textTitle = this.getTextTitle();
        if (textTitle != null) {
            this.fChartTitleChooser = new GStringField(textTitle.getText());
            arrayList.add(this.fChartTitleChooser);
            arrayList2.add("Chart Title");
        }
        this.fChartBgColorChooser = new GColorFieldPlusChooser();
        arrayList.add(this.fChartBgColorChooser);
        arrayList2.add("Chart Background (External)");
        this.fPlotBgColorChooser = new GColorFieldPlusChooser();
        arrayList.add(this.fPlotBgColorChooser);
        arrayList2.add("Chart Background (Internal)");
        this.fChartAntiAliasChooser = new GCheckBoxField(new JCheckBox("", this.fChart.getAntiAlias()));
        arrayList.add(this.fChartAntiAliasChooser);
        arrayList2.add("Anti Alias");
        return new GFieldPlusChooserTable(arrayList2.toArray(new String[arrayList2.size()]), arrayList.toArray(new GFieldPlusChooser[arrayList.size()]));
    }

    private GFieldPlusChooserTable createLegendControls() {
        ArrayList<GFieldPlusChooser> arrayList = new ArrayList<GFieldPlusChooser>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.fLegendOutlineColorChooser = new GColorFieldPlusChooser();
        arrayList.add(this.fLegendOutlineColorChooser);
        arrayList2.add("Outline Color");
        this.fLegendBgColorChooser = new GColorFieldPlusChooser();
        arrayList.add(this.fLegendBgColorChooser);
        arrayList2.add("Legend Background");
        this.fLegendSeriesColorChooser = new GColorFieldPlusChooser();
        arrayList.add(this.fLegendSeriesColorChooser);
        arrayList2.add("Series Labels Color");
        this.fLegendOnOffChooser = new GCheckBoxField(new JCheckBox("", true));
        arrayList.add(this.fLegendOnOffChooser);
        arrayList2.add("Legend On");
        JComboBox jComboBox = new JComboBox();
        this.fLegendOutlineStrokeChooser = new GComboBoxField(jComboBox);
        arrayList.add(this.fLegendOutlineStrokeChooser);
        arrayList2.add("Stroke Outline");
        return new GFieldPlusChooserTable(arrayList2.toArray(new String[arrayList2.size()]), arrayList.toArray(new GFieldPlusChooser[arrayList.size()]));
    }

    public final void updateChartProperties() {
        Axis axis;
        TextTitle textTitle;
        if (this.fChartBgColorChooser.getColor() != null) {
            this.fChart.setBackgroundPaint(this.fChartBgColorChooser.getColor());
            this.fChart.getPlot().setBackgroundPaint(this.fPlotBgColorChooser.getColor());
        }
        if ((textTitle = this.getTextTitle()) != null) {
            textTitle.setText(this.fChartTitleChooser.getValue().toString());
        }
        this.fChart.setAntiAlias(this.fChartAntiAliasChooser.isSelected());
        Axis axis2 = this.getDomainAxis();
        if (axis2 != null) {
            this.fDomain.updateChoices();
        }
        if ((axis = this.getRangeAxis()) != null) {
            this.fRange.updateChoices();
        }
    }

    private Axis getDomainAxis() {
        Plot plot = this.fChart.getPlot();
        Axis axis = null;
        if (plot instanceof CategoryPlot) {
            axis = ((CategoryPlot)plot).getDomainAxis();
        } else if (plot instanceof XYPlot) {
            axis = ((XYPlot)plot).getDomainAxis();
        }
        return axis;
    }

    private Axis getRangeAxis() {
        Plot plot = this.fChart.getPlot();
        ValueAxis valueAxis = null;
        if (plot instanceof CategoryPlot) {
            valueAxis = ((CategoryPlot)plot).getRangeAxis();
        } else if (plot instanceof XYPlot) {
            valueAxis = ((XYPlot)plot).getRangeAxis();
        }
        return valueAxis;
    }
}

