/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.IMatrix;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.utils.ImmutedException;

public class BooleanMatrix
implements IMatrix {
    protected boolean[] elementData;
    private int fRowCnt;
    private int fColCnt;
    private boolean fImmuted;

    public BooleanMatrix() {
    }

    public BooleanMatrix(int n, int n2) {
        if (n < 0) {
            throw new NegativeArraySizeException(n + " < 0");
        }
        if (n2 < 0) {
            throw new NegativeArraySizeException(n2 + " < 0");
        }
        this.fRowCnt = n;
        this.fColCnt = n2;
        this.elementData = new boolean[this.fRowCnt * this.fColCnt];
    }

    public BooleanMatrix(BooleanMatrix booleanMatrix, boolean bl) {
        this.fRowCnt = booleanMatrix.fRowCnt;
        this.fColCnt = booleanMatrix.fColCnt;
        this.fImmuted = bl ? booleanMatrix.fImmuted : false;
        if (bl) {
            this.elementData = booleanMatrix.elementData;
        } else {
            int n = this.fRowCnt * this.fColCnt;
            this.elementData = new boolean[n];
            System.arraycopy(booleanMatrix.elementData, 0, this.elementData, 0, n);
        }
    }

    public final void setSize(int n, int n2) {
        this.checkImmutable();
        if (this.fRowCnt < 0 || this.fColCnt < 0) {
            throw new NegativeArraySizeException("nrows or ncols < 0");
        }
        int n3 = this.fRowCnt;
        int n4 = this.fColCnt;
        int n5 = this.fRowCnt * this.fColCnt;
        this.fRowCnt = n;
        this.fColCnt = n2;
        int n6 = this.fRowCnt * this.fColCnt;
        boolean[] blArray = this.elementData;
        if (n4 == this.fColCnt) {
            if (this.fRowCnt <= n3) {
                return;
            }
            this.elementData = new boolean[n6];
            System.arraycopy(blArray, 0, this.elementData, 0, n5);
        } else {
            this.elementData = new boolean[n6];
            for (int i2 = 0; i2 < n3; ++i2) {
                System.arraycopy(blArray, i2 * n4, this.elementData, i2 * this.fColCnt, n4);
            }
        }
    }

    @Override
    public final int getNumRow() {
        return this.fRowCnt;
    }

    @Override
    public final int getNumCol() {
        return this.fColCnt;
    }

    @Override
    public final int getDim() {
        return this.getNumRow() * this.getNumCol();
    }

    public final boolean getElement(int n, int n2) {
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (this.fColCnt <= n2) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " < 0");
        }
        return this.elementData[n * this.fColCnt + n2];
    }

    public final boolean isTrue(int n, int n2) {
        return this.getElement(n, n2);
    }

    public final void setElement(int n, int n2, boolean bl) {
        this.checkImmutable();
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (this.fColCnt <= n2) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " < 0");
        }
        this.elementData[n * this.fColCnt + n2] = bl;
    }

    public final boolean[] getRow(int n) {
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        boolean[] blArray = new boolean[this.fColCnt];
        System.arraycopy(this.elementData, n * this.fColCnt, blArray, 0, this.fColCnt);
        return blArray;
    }

    public final void setRow(int n, float[] fArray) {
        this.checkImmutable();
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (fArray.length < this.fColCnt) {
            throw new ArrayIndexOutOfBoundsException("array length:" + fArray.length + " < matrix's fColCnt=" + this.fColCnt);
        }
        System.arraycopy(fArray, 0, this.elementData, n * this.fColCnt, this.fColCnt);
    }

    public final void setColumn(int n, boolean[] blArray) {
        this.checkImmutable();
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt=" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (blArray.length < this.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("array length:" + blArray.length + " < matrix's fRowCnt:" + this.fRowCnt);
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            this.elementData[i2 * this.fColCnt + n] = blArray[i2];
        }
    }

    public final String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(string);
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            stringBuffer.append("  [");
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                if (0 < i3) {
                    stringBuffer.append("\t");
                }
                stringBuffer.append(this.elementData[i2 * this.fColCnt + i3]);
            }
            if (i2 + 1 < this.fRowCnt) {
                stringBuffer.append("]");
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("] ]");
        }
        return stringBuffer.toString();
    }

    public final boolean equals(BooleanMatrix booleanMatrix) {
        if (booleanMatrix == null) {
            return false;
        }
        if (booleanMatrix.fRowCnt != this.fRowCnt) {
            return false;
        }
        if (booleanMatrix.fColCnt != this.fColCnt) {
            return false;
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                if (this.elementData[i2 * this.fColCnt + i3] == booleanMatrix.elementData[i2 * this.fColCnt + i3]) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean equals(Object object) {
        return object != null && object instanceof Matrix;
    }

    public final void setImmutable() {
        this.fImmuted = true;
    }

    public final boolean isImmutable() {
        return this.fImmuted;
    }

    private void checkImmutable() {
        if (this.fImmuted) {
            throw new ImmutedException();
        }
    }
}

