/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.objects.GeneSet;

public class HyperGeometricStruc {
    private double fPValue;
    private int fOverlapSize;
    private int fQuerySetSize;
    private int fDbSize;
    private GeneSet fOverlapSet;

    public HyperGeometricStruc(double d2, int n, int n2, int n3, GeneSet geneSet) {
        if (geneSet == null) {
            throw new IllegalArgumentException("Parameter overlapSet cannot be null");
        }
        if (geneSet.getNumMembers() != n) {
            throw new MismatchedSizeException("OverlapSet size", geneSet.getNumMembers(), "OverlapNum", n);
        }
        if (geneSet.getNumMembers() == 0) {
            throw new IllegalArgumentException();
        }
        this.fPValue = d2;
        this.fOverlapSize = n;
        this.fQuerySetSize = n2;
        this.fDbSize = n3;
        this.fOverlapSet = geneSet;
    }

    public final double getPValue() {
        return this.fPValue;
    }

    public final int getOverlap() {
        return this.fOverlapSize;
    }

    public final int getQuerySize() {
        return this.fQuerySetSize;
    }

    public final int getDbSize() {
        return this.fDbSize;
    }

    public final GeneSet getOverlapSet() {
        return this.fOverlapSet;
    }
}

