/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.distrib.RangeFactory;
import edu.mit.broad.genome.math.BooleanMatrix;
import edu.mit.broad.genome.math.IMatrix;
import edu.mit.broad.genome.math.Matrix$Cell;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.utils.ArrayUtils;
import edu.mit.broad.genome.utils.ImmutedException;
import gnu.trove.TFloatArrayList;
import gnu.trove.TFloatHashSet;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class Matrix
extends AbstractObject
implements IMatrix {
    protected float[] elementData;
    private int fRowCnt;
    private int fColCnt;
    private boolean fImmuted;
    private static final transient Logger klog = XLogger.getLogger(Matrix.class);
    static int name_cnt;
    private Vector fColMaxes;
    private Vector fColMins;

    public Matrix() {
    }

    public Matrix(int n, int n2) {
        this.init(n, n2);
    }

    private void init(int n, int n2) {
        super.initialize("matrix_" + name_cnt++);
        if (n < 0) {
            throw new NegativeArraySizeException(n + " < 0");
        }
        if (n2 < 0) {
            throw new NegativeArraySizeException(n2 + " < 0");
        }
        this.fRowCnt = n;
        this.fColCnt = n2;
        this.elementData = new float[this.fRowCnt * this.fColCnt];
        this.setZero();
    }

    @Override
    public String getQuickInfo() {
        return this.getNumRow() + " x " + this.getNumCol();
    }

    public Matrix(int n, int n2, float[] fArray) {
        if (n < 0) {
            throw new NegativeArraySizeException(n + " < 0");
        }
        if (n2 < 0) {
            throw new NegativeArraySizeException(n2 + " < 0");
        }
        this.fRowCnt = n;
        this.fColCnt = n2;
        this.elementData = new float[this.fRowCnt * this.fColCnt];
        this.set(fArray);
    }

    public Matrix(int n, int n2, TFloatArrayList tFloatArrayList) {
        if (n < 0) {
            throw new NegativeArraySizeException(n + " < 0");
        }
        if (n2 < 0) {
            throw new NegativeArraySizeException(n2 + " < 0");
        }
        this.fRowCnt = n;
        this.fColCnt = n2;
        this.elementData = tFloatArrayList.toNativeArray();
    }

    public Matrix(BooleanMatrix booleanMatrix, boolean bl) {
        boolean bl2;
        boolean bl3;
        if (booleanMatrix == null) {
            throw new IllegalArgumentException("Parameter bm cannot be null");
        }
        this.fRowCnt = booleanMatrix.getNumRow();
        this.fColCnt = booleanMatrix.getNumCol();
        this.elementData = new float[booleanMatrix.elementData.length];
        if (bl) {
            bl3 = true;
            bl2 = false;
        } else {
            bl3 = false;
            bl2 = true;
        }
        for (int i2 = 0; i2 < booleanMatrix.elementData.length; ++i2) {
            this.elementData[i2] = booleanMatrix.elementData[i2] ? (float)bl3 : (float)bl2;
        }
    }

    public Matrix(Matrix matrix, Matrix matrix2, boolean bl) {
        this(new Matrix[]{matrix, matrix2}, bl);
    }

    public Matrix(Matrix[] matrixArray, boolean bl) {
        if (matrixArray.length == 0) {
            throw new IllegalArgumentException("Param matrices cannot be zero length");
        }
        if (bl) {
            int n = Matrix.enforceSameNumOfCols(matrixArray);
            this.fRowCnt = Matrix.getTotalNumRows(matrixArray);
            this.fColCnt = n;
            this.elementData = new float[this.fRowCnt * this.fColCnt];
            int n2 = 0;
            for (int i2 = 0; i2 < matrixArray.length; ++i2) {
                System.arraycopy(matrixArray[i2].elementData, 0, this.elementData, n2, matrixArray[i2].elementData.length);
                n2 += matrixArray[i2].elementData.length;
            }
        } else {
            int n = Matrix.enforceSameNumOfRows(matrixArray);
            int n3 = Matrix.getTotalNumCols(matrixArray);
            Matrix matrix = new Matrix(n, n3);
            int n4 = 0;
            for (int i3 = 0; i3 < matrixArray.length; ++i3) {
                for (int i4 = 0; i4 < matrixArray[i3].getNumCol(); ++i4) {
                    matrix.setColumn(n4++, matrixArray[i3].getColumn(i4));
                }
            }
            this.init(matrix, true);
        }
    }

    public Matrix(Matrix matrix, boolean bl) {
        this.init(matrix, bl);
    }

    private void init(Matrix matrix, boolean bl) {
        if (matrix == null) {
            throw new IllegalArgumentException("Param matrix cannot be null");
        }
        this.fRowCnt = matrix.fRowCnt;
        this.fColCnt = matrix.fColCnt;
        this.fImmuted = bl ? matrix.fImmuted : false;
        if (bl) {
            this.elementData = matrix.elementData;
        } else {
            int n = this.fRowCnt * this.fColCnt;
            this.elementData = new float[n];
            System.arraycopy(matrix.elementData, 0, this.elementData, 0, n);
        }
    }

    public Matrix(TFloatHashSet[] tFloatHashSetArray, boolean bl, boolean bl2) {
        Vector[] vectorArray = new Vector[tFloatHashSetArray.length];
        for (int i2 = 0; i2 < tFloatHashSetArray.length; ++i2) {
            vectorArray[i2] = new Vector(tFloatHashSetArray[i2].toArray());
        }
        this.initV(vectorArray, bl, bl2);
    }

    public Matrix(Vector[] vectorArray, boolean bl, boolean bl2) {
        this.initV(vectorArray, bl, bl2);
    }

    private void initV(Vector[] vectorArray, boolean bl, boolean bl2) {
        if (bl) {
            int n = XMath.max(vectorArray);
            this.init(vectorArray.length, n);
            for (int i2 = 0; i2 < vectorArray.length; ++i2) {
                if (!bl2 && vectorArray[i2].getSize() != n) {
                    throw new RuntimeException("Unequal col len: " + n + " and " + vectorArray[i2].getSize());
                }
                this.setRow(i2, vectorArray[i2]);
            }
        } else {
            int n = XMath.max(vectorArray);
            this.init(n, vectorArray.length);
            for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                if (!bl2 && vectorArray[i3].getSize() != n) {
                    throw new RuntimeException("Unequal row len: " + n + " and " + vectorArray[i3].getSize());
                }
                this.setColumn(i3, vectorArray[i3], !bl2);
            }
        }
    }

    public Matrix(List list, boolean bl, boolean bl2) {
        this(list.toArray(new Vector[list.size()]), bl, bl2);
    }

    public Matrix(LabelledVector[] labelledVectorArray, boolean bl, boolean bl2) {
        this(LabelledVector.toVectors(labelledVectorArray, false), bl, bl2);
    }

    public final Matrix cloneDeep() {
        klog.debug("Making cloneDeep of Matrix");
        TraceUtils.showTrace();
        return new Matrix(this, false);
    }

    public final void fill(int n) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            this.elementData[i2] = n;
        }
    }

    public final void fill(float f2) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            this.elementData[i2] = f2;
        }
    }

    public final void copySubMatrix(int n, int n2, int n3, int n4, int n5, int n6, Matrix matrix) {
        if (n < 0 || n2 < 0 || n5 < 0 || n6 < 0) {
            throw new ArrayIndexOutOfBoundsException("rowSource,colSource,rowDest,colDest < 0.");
        }
        if (this.fRowCnt < n3 + n || this.fColCnt < n4 + n2) {
            throw new ArrayIndexOutOfBoundsException("Source Matrix too small.");
        }
        if (matrix.fRowCnt < n3 + n5 || matrix.fColCnt < n4 + n6) {
            throw new ArrayIndexOutOfBoundsException("Target Matrix too small.");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                matrix.elementData[(i2 + n5) * this.fColCnt + (i3 + n6)] = this.elementData[(i2 + n) * this.fColCnt + (i3 + n2)];
            }
        }
    }

    public final void setSize(int n, int n2) {
        this.checkImmutable();
        if (this.fRowCnt < 0 || this.fColCnt < 0) {
            throw new NegativeArraySizeException("nrows or ncols < 0");
        }
        int n3 = this.fRowCnt;
        int n4 = this.fColCnt;
        int n5 = this.fRowCnt * this.fColCnt;
        this.fRowCnt = n;
        this.fColCnt = n2;
        int n6 = this.fRowCnt * this.fColCnt;
        float[] fArray = this.elementData;
        if (n4 == this.fColCnt) {
            if (this.fRowCnt <= n3) {
                return;
            }
            this.elementData = new float[n6];
            System.arraycopy(fArray, 0, this.elementData, 0, n5);
        } else {
            this.elementData = new float[n6];
            this.setZero();
            for (int i2 = 0; i2 < n3; ++i2) {
                System.arraycopy(fArray, i2 * n4, this.elementData, i2 * this.fColCnt, n4);
            }
        }
    }

    public final void set(float[] fArray) {
        this.checkImmutable();
        int n = this.fRowCnt * this.fColCnt;
        System.arraycopy(fArray, 0, this.elementData, 0, n);
    }

    public final void set(Matrix matrix, boolean bl) {
        this.checkImmutable();
        if (matrix.fRowCnt < this.fRowCnt || matrix.fColCnt < this.fColCnt) {
            throw new ArrayIndexOutOfBoundsException("m1 smaller than this matrix");
        }
        if (bl) {
            this.elementData = matrix.elementData;
            this.fRowCnt = matrix.fRowCnt;
            this.fColCnt = matrix.fColCnt;
            this.fImmuted = matrix.fImmuted;
        } else {
            System.arraycopy(matrix.elementData, 0, this.elementData, 0, this.fRowCnt * this.fColCnt);
        }
    }

    @Override
    public int getNumRow() {
        return this.fRowCnt;
    }

    @Override
    public int getNumCol() {
        return this.fColCnt;
    }

    @Override
    public int getDim() {
        return this.getNumRow() * this.getNumCol();
    }

    public final String getDimS() {
        return this.getNumRow() + "*" + this.getNumCol();
    }

    public final float getElement(int n, int n2) {
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (this.fColCnt <= n2) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " < 0");
        }
        return this.elementData[n * this.fColCnt + n2];
    }

    public final float getElement(int n) {
        return this.elementData[n];
    }

    public final void setElement(int n, float f2) {
        this.checkImmutable();
        this.elementData[n] = f2;
    }

    public final int getAbsoluteIndex(int n, int n2) {
        return n * this.fColCnt + n2;
    }

    public final float[] toArray() {
        float[] fArray = new float[this.elementData.length];
        System.arraycopy(this.elementData, 0, fArray, 0, this.elementData.length);
        return fArray;
    }

    public final double[] toArrayD() {
        double[] dArray = new double[this.elementData.length];
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            dArray[i2] = this.elementData[i2];
        }
        return dArray;
    }

    public final Vector toVector() {
        float[] fArray = new float[this.elementData.length];
        System.arraycopy(this.elementData, 0, fArray, 0, this.elementData.length);
        return new Vector(fArray);
    }

    public final int getAbsoluteSize() {
        return this.elementData.length;
    }

    public final void setElement(int n, int n2, float f2) {
        this.checkImmutable();
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (this.fColCnt <= n2) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " < 0");
        }
        this.elementData[n * this.fColCnt + n2] = f2;
    }

    public final void setElementByIndexPos(int n, float f2) {
        this.checkImmutable();
        if (this.elementData.length <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's length:" + this.elementData.length);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("indexPos:" + n + " < 0");
        }
        this.elementData[n] = f2;
    }

    public final Vector getRowV(int n) {
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        Vector vector = new Vector(this.fColCnt);
        System.arraycopy(this.elementData, n * this.fColCnt, vector.elementData, 0, this.fColCnt);
        return vector;
    }

    public final float[] getRow(int n) {
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        float[] fArray = new float[this.fColCnt];
        System.arraycopy(this.elementData, n * this.fColCnt, fArray, 0, this.fColCnt);
        return fArray;
    }

    private void _getColumnInPlace(int n, float[] fArray) {
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (fArray.length < this.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("array.length:" + fArray.length + " < matrix's fRowCnt=" + this.fRowCnt);
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            fArray[i2] = this.elementData[i2 * this.fColCnt + n];
        }
    }

    public final Vector getColumnV(int n) {
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        Vector vector = new Vector(this.fRowCnt);
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            vector.setElement(i2, this.elementData[i2 * this.fColCnt + n]);
        }
        return vector;
    }

    public final float[] getColumn(int n) {
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        float[] fArray = new float[this.fRowCnt];
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            fArray[i2] = this.elementData[i2 * this.fColCnt + n];
        }
        return fArray;
    }

    public final Vector getColumnMaxes() {
        if (this.fColMaxes == null) {
            this.fColMaxes = new Vector(this.getNumCol());
            for (int i2 = 0; i2 < this.getNumCol(); ++i2) {
                this.fColMaxes.setElement(i2, this.getColumnV(i2).max());
            }
        }
        return this.fColMaxes;
    }

    public final Vector getColumnMins() {
        if (this.fColMins == null) {
            this.fColMins = new Vector(this.getNumCol());
            for (int i2 = 0; i2 < this.getNumCol(); ++i2) {
                this.fColMins.setElement(i2, this.getColumnV(i2).min());
            }
        }
        return this.fColMins;
    }

    public final void setRow(int n, float[] fArray) {
        this.checkImmutable();
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (fArray.length < this.fColCnt) {
            throw new ArrayIndexOutOfBoundsException("array length:" + fArray.length + " < matrix's fColCnt=" + this.fColCnt);
        }
        System.arraycopy(fArray, 0, this.elementData, n * this.fColCnt, this.fColCnt);
    }

    public final void setRow(int n, float f2) {
        for (int i2 = 0; i2 < this.getNumCol(); ++i2) {
            this.setElement(n, i2, f2);
        }
    }

    public final void setRow(int n, Vector vector) {
        this.checkImmutable();
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        int n2 = vector.getSize();
        if (n2 < this.fColCnt) {
            throw new ArrayIndexOutOfBoundsException("vector's size:" + n2 + " < matrix's fColCnt=" + this.fColCnt);
        }
        for (int i2 = 0; i2 < this.fColCnt; ++i2) {
            this.elementData[n * this.fColCnt + i2] = vector.getElement(i2);
        }
    }

    public final void setRow_permit_smaller(int n, Vector vector) {
        this.checkImmutable();
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        int n2 = vector.getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.elementData[n * this.fColCnt + i2] = vector.getElement(i2);
        }
    }

    public final void setColumn(int n, float[] fArray) {
        this.checkImmutable();
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt=" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (fArray.length < this.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("array length:" + fArray.length + " < matrix's fRowCnt:" + this.fRowCnt);
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            this.elementData[i2 * this.fColCnt + n] = fArray[i2];
        }
    }

    public final void setColumn(int n, int[] nArray) {
        this.checkImmutable();
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt=" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (nArray.length < this.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("array length:" + nArray.length + " < matrix's fRowCnt:" + this.fRowCnt);
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            this.elementData[i2 * this.fColCnt + n] = nArray[i2];
        }
    }

    public final void setColumn(int n, Vector vector) {
        this.setColumn(n, vector, true);
    }

    private void setColumn(int n, Vector vector, boolean bl) {
        this.checkImmutable();
        if (bl && this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt=" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        int n2 = vector.getSize();
        if (bl && n2 < this.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("vector size:" + n2 + " < matrix's fRowCnt=" + this.fRowCnt);
        }
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            this.elementData[i2 * this.fColCnt + n] = vector.getElement(i2);
        }
    }

    public final void mulTransposeBoth(Matrix matrix, Matrix matrix2) {
        this.checkImmutable();
        this.multiply(matrix2, matrix);
        this.transpose();
    }

    public final void mulTransposeRight(Matrix matrix, Matrix matrix2) {
        this.checkImmutable();
        if (matrix.fColCnt != matrix2.fColCnt || this.fRowCnt != matrix.fRowCnt || this.fColCnt != matrix2.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("matrices mismatch");
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                float f2 = 0.0f;
                for (int i4 = 0; i4 < matrix.fColCnt; ++i4) {
                    f2 += matrix.elementData[i2 * matrix.fColCnt + i4] * matrix2.elementData[i3 * matrix2.fColCnt + i4];
                }
                this.elementData[i2 * this.fColCnt + i3] = f2;
            }
        }
    }

    public final void mulTransposeLeft(Matrix matrix, Matrix matrix2) {
        this.transpose(matrix);
        this.multiply(matrix2);
    }

    public final void transpose() {
        int n;
        this.checkImmutable();
        float[] fArray = new float[this.elementData.length];
        int n2 = 0;
        for (n = 0; n < this.getNumCol(); ++n) {
            float[] fArray2 = new float[this.getNumRow()];
            this._getColumnInPlace(n, fArray2);
            System.arraycopy(fArray2, 0, fArray, n2, fArray2.length);
            n2 += fArray2.length;
        }
        n = this.fRowCnt;
        int n3 = this.fColCnt;
        this.elementData = fArray;
        this.fColCnt = n;
        this.fRowCnt = n3;
    }

    public final void transpose(Matrix matrix) {
        this.checkImmutable();
        this.set(matrix, false);
        this.transpose();
    }

    public final String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(string);
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            stringBuffer.append("  [");
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                if (0 < i3) {
                    stringBuffer.append("\t");
                }
                stringBuffer.append(this.elementData[i2 * this.fColCnt + i3]);
            }
            if (i2 + 1 < this.fRowCnt) {
                stringBuffer.append("]");
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("] ]");
        }
        return stringBuffer.toString();
    }

    public final int hashCode() {
        int n = 0;
        for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            long l2 = Double.doubleToLongBits(this.elementData[i2]);
            n ^= (int)(l2 ^ l2 >> 32);
        }
        return n;
    }

    public final boolean equals(Matrix matrix) {
        if (matrix == null) {
            return false;
        }
        if (matrix.fRowCnt != this.fRowCnt) {
            return false;
        }
        if (matrix.fColCnt != this.fColCnt) {
            return false;
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                if (this.elementData[i2 * this.fColCnt + i3] == matrix.elementData[i2 * this.fColCnt + i3]) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean equals(Object object) {
        return object != null && object instanceof Matrix && this.equals((Matrix)object);
    }

    public final boolean epsilonEquals(Matrix matrix, float f2) {
        if (matrix.fRowCnt != this.fRowCnt) {
            return false;
        }
        if (matrix.fColCnt != this.fColCnt) {
            return false;
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                if (!(f2 < Math.abs(this.elementData[i2 * this.fColCnt + i3] - matrix.elementData[i2 * this.fColCnt + i3]))) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean epsilonEquals(Matrix matrix, double d2) {
        if (matrix.fRowCnt != this.fRowCnt) {
            return false;
        }
        if (matrix.fColCnt != this.fColCnt) {
            return false;
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                if (!(d2 < (double)Math.abs(this.elementData[i2 * this.fColCnt + i3] - matrix.elementData[i2 * this.fColCnt + i3]))) continue;
                return false;
            }
        }
        return true;
    }

    public final double trace() {
        int n = this.fRowCnt < this.fColCnt ? this.fRowCnt : this.fColCnt;
        double d2 = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            d2 += (double)this.elementData[i2 * this.fColCnt + i2];
        }
        return d2;
    }

    public final void setScale(float f2) {
        this.checkImmutable();
        this.setZero();
        int n = this.fRowCnt < this.fColCnt ? this.fRowCnt : this.fColCnt;
        for (int i2 = 0; i2 < n; ++i2) {
            this.elementData[i2 * this.fColCnt + i2] = f2;
        }
    }

    public final void sortColumns(SortMode sortMode, Order order) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.getNumCol(); ++i2) {
            Vector vector = this.getColumnV(i2);
            vector.sort(sortMode, order);
            this.setColumn(i2, vector);
        }
    }

    public final void multiply(Matrix matrix) {
        this.checkImmutable();
        this.multiply(this, matrix);
    }

    public final void multiply(Matrix matrix, Matrix matrix2) {
        this.checkImmutable();
        if (this.fRowCnt != matrix.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("fRowCnt:" + this.fRowCnt + " != m1.fRowCnt:" + matrix.fRowCnt);
        }
        if (this.fColCnt != matrix2.fColCnt) {
            throw new ArrayIndexOutOfBoundsException("fColCnt:" + this.fColCnt + " != m2.fColCnt:" + matrix2.fColCnt);
        }
        if (matrix.fColCnt != matrix2.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("m1.fColCnt:" + matrix.fColCnt + " != m2.fRowCnt:" + matrix2.fRowCnt);
        }
        float[] fArray = new float[this.fColCnt * this.fRowCnt];
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                float f2 = 0.0f;
                for (int i4 = 0; i4 < matrix.fColCnt; ++i4) {
                    f2 += matrix.elementData[i2 * matrix.fColCnt + i4] * matrix2.elementData[i4 * matrix2.fColCnt + i3];
                }
                fArray[i2 * this.fColCnt + i3] = f2;
            }
        }
        this.elementData = fArray;
    }

    public final void multiply(Vector vector, Vector vector2) {
        this.checkImmutable();
        if (this.fRowCnt < vector.getSize()) {
            throw new IllegalArgumentException("fRowCnt:" + this.fRowCnt + " < v1.getSize():" + vector.getSize());
        }
        if (this.fColCnt < vector2.getSize()) {
            throw new IllegalArgumentException("fColCnt:" + this.fColCnt + " < v2.getSize():" + vector2.getSize());
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                this.elementData[i2 * this.fColCnt + i3] = vector.getElement(i2) * vector2.getElement(i3);
            }
        }
    }

    public final void add(Matrix matrix) {
        this.checkImmutable();
        if (this.fRowCnt != matrix.fRowCnt || this.fColCnt != matrix.fColCnt) {
            throw new IllegalArgumentException("this:(" + this.fRowCnt + "x" + this.fColCnt + ") != m1:(" + matrix.fRowCnt + "x" + matrix.fColCnt + ").");
        }
        for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            int n = i2;
            this.elementData[n] = this.elementData[n] + matrix.elementData[i2];
        }
    }

    public final void add(Matrix matrix, Matrix matrix2) {
        this.checkImmutable();
        if (this.fRowCnt != matrix.fRowCnt || this.fColCnt != matrix.fColCnt) {
            throw new IllegalArgumentException("this:(" + this.fRowCnt + "x" + this.fColCnt + ") != m1:(" + matrix.fRowCnt + "x" + matrix.fColCnt + ").");
        }
        if (this.fRowCnt != matrix2.fRowCnt || this.fColCnt != matrix2.fColCnt) {
            throw new IllegalArgumentException("this:(" + this.fRowCnt + "x" + this.fColCnt + ") != m2:(" + matrix2.fRowCnt + "x" + matrix2.fColCnt + ").");
        }
        for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            this.elementData[i2] = matrix.elementData[i2] + matrix2.elementData[i2];
        }
    }

    public final void subtract(Matrix matrix) {
        this.checkImmutable();
        if (this.fRowCnt != matrix.fRowCnt || this.fColCnt != matrix.fColCnt) {
            throw new IllegalArgumentException("this:(" + this.fRowCnt + "x" + this.fColCnt + ") != m1:(" + matrix.fRowCnt + "x" + matrix.fColCnt + ").");
        }
        for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            int n = i2;
            this.elementData[n] = this.elementData[n] - matrix.elementData[i2];
        }
    }

    public final void subtract(Matrix matrix, Matrix matrix2) {
        this.checkImmutable();
        if (this.fRowCnt != matrix.fRowCnt || this.fColCnt != matrix.fColCnt) {
            throw new IllegalArgumentException("this:(" + this.fRowCnt + "x" + this.fColCnt + ") != m1:(" + matrix.fRowCnt + "x" + matrix.fColCnt + ").");
        }
        if (this.fRowCnt != matrix2.fRowCnt || this.fColCnt != matrix2.fColCnt) {
            throw new IllegalArgumentException("this:(" + this.fRowCnt + "x" + this.fColCnt + ") != m2:(" + matrix2.fRowCnt + "x" + matrix2.fColCnt + ").");
        }
        for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            this.elementData[i2] = matrix.elementData[i2] - matrix2.elementData[i2];
        }
    }

    public final void negate() {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            this.elementData[i2] = -1.0f * this.elementData[i2];
        }
    }

    public final void negate(Matrix matrix) {
        this.checkImmutable();
        this.set(matrix, false);
        this.negate();
    }

    public final void threshold(float f2, float f3) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            if (this.elementData[i2] < f2) {
                this.elementData[i2] = f2;
            }
            if (!(this.elementData[i2] > f3)) continue;
            this.elementData[i2] = f3;
        }
    }

    public final void thresholdToZeroInThisRange(float f2, float f3) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            if (!(this.elementData[i2] > f2) || !(this.elementData[i2] < f3)) continue;
            this.elementData[i2] = 0.0f;
        }
    }

    public final Matrix normalize(boolean bl) {
        Matrix matrix = new Matrix(this.getNumRow(), this.getNumCol());
        if (bl) {
            for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
                Vector vector = this.getRowV(i2);
                vector.divide(vector.max());
                matrix.setRow(i2, vector);
            }
        } else {
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                Vector vector = this.getColumnV(i3);
                vector.divide(vector.max());
                matrix.setColumn(i3, vector);
            }
        }
        return matrix;
    }

    public final Matrix normalizeToMinNegOneMaxOne(boolean bl) {
        Matrix matrix = new Matrix(this.getNumRow(), this.getNumCol());
        if (bl) {
            for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
                Vector vector = this.getRowV(i2);
                vector.normalizeToMinNegOneMaxOne();
                matrix.setRow(i2, vector);
            }
        } else {
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                Vector vector = this.getColumnV(i3);
                vector.normalizeToMinNegOneMaxOne();
                matrix.setColumn(i3, vector);
            }
        }
        return matrix;
    }

    public final Matrix normalizeByZScore(boolean bl, boolean bl2) {
        Matrix matrix = new Matrix(this.getNumRow(), this.getNumCol());
        if (bl) {
            for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
                Vector vector = this.getRowV(i2);
                vector.normalizeByZScore(bl2);
                matrix.setRow(i2, vector);
            }
        } else {
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                Vector vector = this.getColumnV(i3);
                vector.normalizeByZScore(bl2);
                matrix.setColumn(i3, vector);
            }
        }
        return matrix;
    }

    public final Matrix normalizeByZScore_mad(boolean bl, boolean bl2) {
        Matrix matrix = new Matrix(this.getNumRow(), this.getNumCol());
        if (bl) {
            for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
                Vector vector = this.getRowV(i2);
                vector.normalizeByZScore_mad(bl2);
                matrix.setRow(i2, vector);
            }
        } else {
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                Vector vector = this.getColumnV(i3);
                vector.normalizeByZScore_mad(bl2);
                matrix.setColumn(i3, vector);
            }
        }
        return matrix;
    }

    public final Matrix normalizeByGsea(boolean bl) {
        Matrix matrix = new Matrix(this.getNumRow(), this.getNumCol());
        if (bl) {
            for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
                Vector vector = this.getRowV(i2);
                vector.normalizeByGsea();
                matrix.setRow(i2, vector);
            }
        } else {
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                Vector vector = this.getColumnV(i3);
                vector.normalizeByGsea();
                matrix.setColumn(i3, vector);
            }
        }
        return matrix;
    }

    public final void divide(Matrix matrix, boolean bl) {
        this.checkImmutable();
        Matrix._enforceEqualDimensions(this, matrix);
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            this.elementData[i2] = bl && matrix.elementData[i2] == 0.0f ? 0.0f : this.elementData[i2] / matrix.elementData[i2];
        }
    }

    public final void log() {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            float f2 = this.elementData[i2];
            if (f2 == 0.0f) {
                f2 = 1.0E-8f;
            }
            this.elementData[i2] = (float)Math.log(f2);
        }
    }

    public final void log2() {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            float f2 = this.elementData[i2];
            if (f2 == 0.0f) {
                f2 = 1.0E-8f;
            }
            this.elementData[i2] = (float)XMath.log2(f2);
        }
    }

    public final void log10() {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            float f2 = this.elementData[i2];
            if (f2 == 0.0f) {
                f2 = 1.0E-8f;
            }
            this.elementData[i2] = (float)XMath.log10(f2);
        }
    }

    public final void exp(double d2) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            float f2 = this.elementData[i2];
            this.elementData[i2] = (float)Math.pow(d2, f2);
        }
    }

    public final void setZero() {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            this.elementData[i2] = 0.0f;
        }
    }

    public final void identityMinus() {
        this.checkImmutable();
        this.negate();
        int n = this.fRowCnt < this.fColCnt ? this.fRowCnt : this.fColCnt;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = i2 * this.fColCnt + i2;
            this.elementData[n2] = this.elementData[n2] + 1.0f;
        }
    }

    public final void setImmutable() {
        this.fImmuted = true;
    }

    public final boolean isImmutable() {
        return this.fImmuted;
    }

    private void checkImmutable() {
        if (this.fImmuted) {
            throw new ImmutedException();
        }
    }

    public final Vector sigByRow(double d2) {
        Vector vector = new Vector(this.fRowCnt);
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            vector.setElement(i2, this.getRowV(i2).sig(d2));
        }
        return vector;
    }

    public final Vector sigByCol(double d2) {
        Vector vector = new Vector(this.fColCnt);
        for (int i2 = 0; i2 < this.fColCnt; ++i2) {
            vector.setElement(i2, this.getColumnV(i2).sig(d2));
        }
        return vector;
    }

    public final Matrix$Cell max() {
        Matrix$Cell matrix$Cell = new Matrix$Cell();
        matrix$Cell.value = Float.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                if (!(this.elementData[i2 * this.fColCnt + i3] > matrix$Cell.value)) continue;
                matrix$Cell.row = i2;
                matrix$Cell.col = i3;
                matrix$Cell.value = this.elementData[i2 * this.fColCnt + i3];
            }
        }
        return matrix$Cell;
    }

    public final Matrix$Cell min() {
        Matrix$Cell matrix$Cell = new Matrix$Cell();
        matrix$Cell.value = Float.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                if (!(this.elementData[i2 * this.fColCnt + i3] < matrix$Cell.value)) continue;
                matrix$Cell.row = i2;
                matrix$Cell.col = i3;
                matrix$Cell.value = this.elementData[i2 * this.fColCnt + i3];
            }
        }
        return matrix$Cell;
    }

    public final Matrix$Cell[] maxByRow() {
        Matrix$Cell[] matrix$CellArray = new Matrix$Cell[this.fRowCnt];
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            matrix$CellArray[i2] = new Matrix$Cell();
            matrix$CellArray[i2].value = Float.NEGATIVE_INFINITY;
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                if (!(this.elementData[i2 * this.fColCnt + i3] > matrix$CellArray[i2].value)) continue;
                matrix$CellArray[i2].row = i2;
                matrix$CellArray[i2].col = i3;
                matrix$CellArray[i2].value = this.elementData[i2 * this.fColCnt + i3];
            }
        }
        return matrix$CellArray;
    }

    public final Vector removeValues(float f2) {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                float f3 = this.getElement(i2, i3);
                if (f3 == 0.0f) continue;
                tFloatArrayList.add(f3);
            }
        }
        return new Vector(tFloatArrayList);
    }

    public final double mean() {
        return new Vector(this.elementData, true).mean();
    }

    public final double median() {
        return new Vector(this.elementData, true).median();
    }

    public final double var(boolean bl, boolean bl2) {
        return new Vector(this.elementData, true).var(bl, bl2);
    }

    public final double stddev(boolean bl, boolean bl2) {
        return new Vector(this.elementData, true).stddev(bl, bl2);
    }

    public final void bin(Range[] rangeArray, boolean bl, boolean bl2) {
        int n;
        if (rangeArray == null) {
            throw new IllegalArgumentException("Param ranges cannot be null");
        }
        int n2 = 0;
        for (n = 0; n < this.elementData.length; ++n) {
            boolean bl3 = false;
            for (int i2 = 0; i2 < rangeArray.length; ++i2) {
                if (!rangeArray[i2].isInRange(this.elementData[n])) continue;
                rangeArray[i2].increment();
                bl3 = true;
                ++n2;
                if (bl2) break;
            }
            if (!bl || bl3) continue;
            throw new RuntimeException("Value was not binned as it didnt fall in any of the Ranges: " + this.elementData[n]);
        }
        n = n2;
        if (bl && n != this.elementData.length) {
            throw new IllegalStateException("Bad binning! Binned: " + n + " but elements in matrix: " + this.elementData.length);
        }
    }

    public final Matrix discretize(Range[] rangeArray) {
        Matrix matrix = new Matrix(this.getNumRow(), this.getNumCol());
        block0: for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            for (int i3 = 0; i3 < rangeArray.length; ++i3) {
                if (!rangeArray[i3].isInRange(this.elementData[i2])) continue;
                matrix.elementData[i2] = i3;
                continue block0;
            }
        }
        return matrix;
    }

    public final Matrix discretize(int n) {
        Matrix matrix = new Matrix(this, false);
        klog.debug("Starting uniq for discretize");
        float[] fArray = ArrayUtils.unique(matrix.elementData);
        klog.debug("Done uniq for discretize");
        Arrays.sort(fArray);
        klog.debug("Done sort for discretize");
        Range[] rangeArray = RangeFactory.createRanges(n, fArray);
        klog.debug("Number of ranges = " + rangeArray.length);
        block0: for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            for (int i3 = 0; i3 < rangeArray.length; ++i3) {
                if (!rangeArray[i3].isInRange(this.elementData[i2])) continue;
                matrix.elementData[i2] = i3;
                continue block0;
            }
        }
        return matrix;
    }

    public final void roundOff(int n) {
        this.checkImmutable();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            this.elementData[i2] = (float)XMath.roundOff(this.elementData[i2], n);
        }
    }

    private static void _enforceEqualDimensions(Matrix matrix, Matrix matrix2) {
        if (matrix.getNumRow() != matrix2.getNumRow()) {
            throw new IllegalArgumentException("Mismatched matrices: must be of equal row lengths a: " + matrix.getNumRow() + " b: " + matrix2.getNumRow());
        }
        if (matrix.getNumCol() != matrix2.getNumCol()) {
            throw new IllegalArgumentException("Mismatched matrices: must be of equal col lengths a: " + matrix.getNumCol() + " b: " + matrix2.getNumCol());
        }
    }

    private static int enforceSameNumOfCols(Matrix[] matrixArray) {
        int n = matrixArray[0].getNumCol();
        for (int i2 = 0; i2 < matrixArray.length; ++i2) {
            if (matrixArray[i2].getNumCol() == n) continue;
            throw new RuntimeException("Unequal ncols: " + n + " and " + matrixArray[i2].getNumCol() + "at index: " + i2);
        }
        return n;
    }

    private static int enforceSameNumOfRows(Matrix[] matrixArray) {
        int n = matrixArray[0].getNumRow();
        for (int i2 = 0; i2 < matrixArray.length; ++i2) {
            if (matrixArray[i2].getNumRow() == n) continue;
            throw new RuntimeException("Unequal nrows: " + n + " and " + matrixArray[i2].getNumRow() + "at index: " + i2);
        }
        return n;
    }

    public static final int getTotalNumRows(Matrix[] matrixArray) {
        int n = 0;
        for (int i2 = 0; i2 < matrixArray.length; ++i2) {
            n += matrixArray[i2].getNumRow();
        }
        return n;
    }

    public static final int getTotalNumCols(Matrix[] matrixArray) {
        int n = 0;
        for (int i2 = 0; i2 < matrixArray.length; ++i2) {
            n += matrixArray[i2].getNumCol();
        }
        return n;
    }
}

