/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

public class ScoreMode {
    public static final ScoreMode POS_ONLY = new ScoreMode("pos_only");
    public static final ScoreMode NEG_ONLY = new ScoreMode("neg_only");
    public static final ScoreMode POS_AND_NEG_TOGETHER = new ScoreMode("pos_and_neg_together");
    public static final ScoreMode POS_AND_NEG_SEPERATELY = new ScoreMode("pos_and_neg_seperately");
    public static final ScoreMode[] ALL = new ScoreMode[]{POS_ONLY, NEG_ONLY, POS_AND_NEG_TOGETHER, POS_AND_NEG_SEPERATELY};
    public static final ScoreMode[] POS_NEG = new ScoreMode[]{POS_ONLY, NEG_ONLY};
    private String fMode;

    ScoreMode(String string) {
        this.fMode = string;
    }

    public final String toString() {
        return this.fMode;
    }

    public final boolean equals(Object object) {
        return object instanceof ScoreMode && ((ScoreMode)object).fMode.equals(this.fMode);
    }

    public final int hashCode() {
        return this.fMode.hashCode();
    }

    public final String getName() {
        return this.fMode;
    }

    public final boolean isPostiveOnly() {
        return this.fMode.equals(ScoreMode.POS_ONLY.fMode);
    }

    public final boolean isPostiveAndNegTogether() {
        return this.fMode.equals(ScoreMode.POS_AND_NEG_TOGETHER.fMode);
    }

    public final boolean isPostiveAndNegSeperately() {
        return this.fMode.equals(ScoreMode.POS_AND_NEG_SEPERATELY.fMode);
    }

    public final boolean isNegativeOnly() {
        return this.fMode.equals(ScoreMode.NEG_ONLY.fMode);
    }

    public static final ScoreMode lookup(Object object) {
        if (object == null) {
            throw new NullPointerException("Null mode not allowed");
        }
        if (object instanceof ScoreMode) {
            return (ScoreMode)object;
        }
        String string = object.toString();
        if (string.equalsIgnoreCase(ScoreMode.POS_ONLY.fMode)) {
            return POS_ONLY;
        }
        if (string.equalsIgnoreCase(NEG_ONLY.toString())) {
            return NEG_ONLY;
        }
        if (string.equalsIgnoreCase(POS_AND_NEG_TOGETHER.toString())) {
            return POS_AND_NEG_TOGETHER;
        }
        if (string.equalsIgnoreCase(POS_AND_NEG_SEPERATELY.toString())) {
            return POS_AND_NEG_SEPERATELY;
        }
        throw new IllegalArgumentException("Unable to lookup ScoreMode String: " + object);
    }
}

