/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.utils.containers.ClassNamePair;

public class SortMode {
    public static final SortMode REAL = new SortMode("real");
    public static final SortMode ABSOLUTE = new SortMode("abs");
    public static final SortMode[] ALL = new SortMode[]{REAL, ABSOLUTE};
    public static final ClassNamePair[] ALL_CNP = new ClassNamePair[]{new ClassNamePair(REAL.getClass(), SortMode.REAL.fType), new ClassNamePair(ABSOLUTE.getClass(), SortMode.ABSOLUTE.fType)};
    private final String fType;

    private SortMode(String string) {
        this.fType = string;
    }

    public final String toString() {
        return this.fType;
    }

    public final boolean equals(Object object) {
        return object instanceof SortMode && ((SortMode)object).fType.equals(this.fType);
    }

    public final int hashCode() {
        return this.fType.hashCode();
    }

    public final boolean isAbsolute() {
        return this.fType.equals(SortMode.ABSOLUTE.fType);
    }

    public final boolean isReal() {
        return this.fType.equals(SortMode.REAL.fType);
    }

    public static final SortMode lookup(Object object) {
        if (object == null) {
            throw new NullPointerException("Null mode not allowed");
        }
        if (object instanceof SortMode) {
            return (SortMode)object;
        }
        String string = object.toString();
        if (string.equalsIgnoreCase(SortMode.REAL.fType)) {
            return REAL;
        }
        if (string.equalsIgnoreCase(ABSOLUTE.toString())) {
            return ABSOLUTE;
        }
        throw new IllegalArgumentException("Unable to lookup direction String: " + object);
    }
}

