/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.ObjectMatrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.reports.MultiElement;
import edu.mit.broad.genome.utils.ImmutedException;
import gnu.trove.TFloatArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class StringMatrix {
    private String[] elementData;
    private ObjectMatrix fColorMatrix;
    private int fRowCnt;
    private int fColCnt;
    private boolean fImmuted;
    private static final transient Logger klog = XLogger.getLogger(StringMatrix.class);

    public StringMatrix() {
    }

    public final void replace(String string, String string2) {
        if (!string.equals("NaN")) {
            this.checkImmuted();
        }
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            if (this.elementData[i2] == null || !this.elementData[i2].equals(string)) continue;
            this.elementData[i2] = string2;
        }
    }

    public final StringMatrix toUpperCase() {
        StringMatrix stringMatrix = new StringMatrix(this.getNumRow(), this.getNumCol());
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                String string = this.getElement(i2, i3);
                if (string == null) continue;
                stringMatrix.setElement(i2, i3, string.toUpperCase());
            }
        }
        return stringMatrix;
    }

    public StringMatrix(int n, int n2) {
        if (n < 0) {
            throw new NegativeArraySizeException(n + " < 0");
        }
        if (n2 < 0) {
            throw new NegativeArraySizeException(n2 + " < 0");
        }
        this.fRowCnt = n;
        this.fColCnt = n2;
        this.elementData = new String[this.fRowCnt * this.fColCnt];
        this.setZero();
    }

    public StringMatrix(StringMatrix stringMatrix, StringMatrix stringMatrix2) {
        this(new StringMatrix[]{stringMatrix, stringMatrix2});
    }

    public StringMatrix(Matrix matrix) {
        this(matrix.getNumRow(), matrix.getNumCol());
        for (int i2 = 0; i2 < matrix.elementData.length; ++i2) {
            this.elementData[i2] = matrix.elementData[i2] + "";
        }
    }

    public StringMatrix(StringMatrix[] stringMatrixArray) {
        int n;
        int n2;
        if (stringMatrixArray.length == 0) {
            throw new IllegalArgumentException("Cannot call this constructor with zero length StringMatrix[] array");
        }
        int n3 = stringMatrixArray[0].getNumCol();
        for (n2 = 0; n2 < stringMatrixArray.length; ++n2) {
            if (stringMatrixArray[n2].getNumCol() == n3) continue;
            throw new RuntimeException("Unequal ncols: " + n3 + " and " + stringMatrixArray[n2].getNumCol());
        }
        n2 = 0;
        for (n = 0; n < stringMatrixArray.length; ++n) {
            n2 += stringMatrixArray[n].getNumRow();
        }
        this.fRowCnt = n2;
        this.fColCnt = n3;
        this.elementData = new String[this.fRowCnt * this.fColCnt];
        n = 0;
        for (int i2 = 0; i2 < stringMatrixArray.length; ++i2) {
            System.arraycopy(stringMatrixArray[i2].elementData, 0, this.elementData, n, stringMatrixArray[i2].elementData.length);
            n += stringMatrixArray[i2].elementData.length;
        }
    }

    public StringMatrix(StringMatrix stringMatrix, boolean bl) {
        this.fRowCnt = stringMatrix.fRowCnt;
        this.fColCnt = stringMatrix.fColCnt;
        this.fImmuted = bl ? stringMatrix.fImmuted : false;
        if (bl) {
            this.elementData = stringMatrix.elementData;
        } else {
            int n = this.fRowCnt * this.fColCnt;
            this.elementData = new String[n];
            System.arraycopy(stringMatrix.elementData, 0, this.elementData, 0, n);
        }
    }

    public final void setZero() {
        this.checkImmuted();
        for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            this.elementData[i2] = "";
        }
    }

    public final StringMatrix cloneDeep() {
        klog.debug("Making cloneDeep of StringMatrix");
        return new StringMatrix(this, false);
    }

    public final void fill(String string) {
        this.checkImmuted();
        for (int i2 = 0; i2 < this.elementData.length; ++i2) {
            this.elementData[i2] = string;
        }
    }

    public final void copySubStringMatrix(int n, int n2, int n3, int n4, int n5, int n6, StringMatrix stringMatrix) {
        if (n < 0 || n2 < 0 || n5 < 0 || n6 < 0) {
            throw new ArrayIndexOutOfBoundsException("rowSource,colSource,rowDest,colDest < 0.");
        }
        if (this.fRowCnt < n3 + n || this.fColCnt < n4 + n2) {
            throw new ArrayIndexOutOfBoundsException("Source StringMatrix too small.");
        }
        if (stringMatrix.fRowCnt < n3 + n5 || stringMatrix.fColCnt < n4 + n6) {
            throw new ArrayIndexOutOfBoundsException("Target StringMatrix too small.");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                stringMatrix.elementData[(i2 + n5) * this.fColCnt + (i3 + n6)] = this.elementData[(i2 + n) * this.fColCnt + (i3 + n2)];
            }
        }
    }

    public final void setSize(int n, int n2) {
        this.checkImmuted();
        if (this.fRowCnt < 0 || this.fColCnt < 0) {
            throw new NegativeArraySizeException("nrows or ncols < 0");
        }
        int n3 = this.fRowCnt;
        int n4 = this.fColCnt;
        int n5 = this.fRowCnt * this.fColCnt;
        this.fRowCnt = n;
        this.fColCnt = n2;
        int n6 = this.fRowCnt * this.fColCnt;
        String[] stringArray = this.elementData;
        if (n4 == this.fColCnt) {
            if (this.fRowCnt <= n3) {
                return;
            }
            this.elementData = new String[n6];
            System.arraycopy(stringArray, 0, this.elementData, 0, n5);
        } else {
            this.elementData = new String[n6];
            this.setZero();
            for (int i2 = 0; i2 < n3; ++i2) {
                System.arraycopy(stringArray, i2 * n4, this.elementData, i2 * this.fColCnt, n4);
            }
        }
    }

    public final int getNumRow() {
        return this.fRowCnt;
    }

    public final int getNumCol() {
        return this.fColCnt;
    }

    public final String getElement(int n, int n2) {
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (this.fColCnt <= n2) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " < 0");
        }
        return this.elementData[n * this.fColCnt + n2];
    }

    public final int getElementPos(int n, int n2) {
        if (n >= this.getNumRow()) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.getNumRow());
        }
        if (n2 >= this.getNumCol()) {
            throw new ArrayIndexOutOfBoundsException("col:" + n2 + " > matrix's fColCnt:" + this.getNumCol());
        }
        return n * this.fColCnt + n2;
    }

    public final void setElement(int n, int n2, int n3) {
        this.setElement(n, n2, Integer.toString(n3));
    }

    public final void setElement(int n, int n2, float f2) {
        this.setElement(n, n2, Float.toString(f2));
    }

    public final void setElement(int n, int n2, float f2, int n3) {
        if (!Float.isNaN(f2)) {
            this.setElement(n, n2, Printf.format(f2, n3));
        } else {
            this.setElement(n, n2, f2);
        }
    }

    public final void setElement(int n, int n2, float[] fArray) {
        this.setElement(n, n2, StringMatrix.toString(fArray));
    }

    public final void setElement(int n, int n2, double[] dArray) {
        this.setElement(n, n2, StringMatrix.toString(dArray));
    }

    public final void setElement(int n, int n2, int[] nArray) {
        this.setElement(n, n2, StringMatrix.toString(nArray));
    }

    private static String toString(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            stringBuffer.append(fArray[i2]);
            if (i2 == fArray.length - 1) continue;
            stringBuffer.append('\u001c');
        }
        return stringBuffer.toString();
    }

    private static String toString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringBuffer.append(nArray[i2]);
            if (i2 == nArray.length - 1) continue;
            stringBuffer.append('\u001c');
        }
        return stringBuffer.toString();
    }

    private static String toString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            stringBuffer.append(dArray[i2]);
            if (i2 == dArray.length - 1) continue;
            stringBuffer.append('\u001c');
        }
        return stringBuffer.toString();
    }

    public final void setElement(int n, int n2, double d2) {
        this.setElement(n, n2, Double.toString(d2));
    }

    public final void setElement(int n, int n2, double d2, int n3) {
        if (!Double.isNaN(d2)) {
            this.setElement(n, n2, Printf.format(d2, n3));
        } else {
            this.setElement(n, n2, d2);
        }
    }

    public final void setElement(int n, int n2, Collection collection, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 != null) {
                stringBuffer.append(e2);
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(c2);
        }
        this.setElement(n, n2, stringBuffer.toString());
    }

    public final void setElement(int n, int n2, boolean bl) {
        this.setElement(n, n2, Boolean.toString(bl));
    }

    public final void setElement(int n, int n2, StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            this.setElement(n, n2, stringBuffer.toString());
        }
    }

    public final void setElement(int n, int n2, MultiElement multiElement) {
        if (multiElement != null) {
            this.setElement(n, n2, multiElement.toString());
        }
    }

    public final void setElement(int n, int n2, Object object) {
        if (object != null) {
            this.setElement(n, n2, object.toString());
        }
    }

    public final void setElement(int n, int n2, String string) {
        this.checkImmuted();
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        if (this.fColCnt <= n2) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + n2 + " < 0");
        }
        this.elementData[n * this.fColCnt + n2] = string;
    }

    public final void setElement(int n, int n2, Number number) {
        if (number != null) {
            this.setElement(n, n2, number.toString());
        }
    }

    public final void setElement(int n, int n2, Vector vector) {
        if (vector != null) {
            this.setElement(n, n2, vector.toString(','));
        }
    }

    public final void setElement(int n, int n2, Vector vector, int n3) {
        if (vector != null) {
            this.setElement(n, n2, vector.toString(',', n3));
        }
    }

    public final void setElement(int n, int n2, LabelledVector labelledVector) {
        if (labelledVector != null) {
            this.setElement(n, n2, labelledVector.toString(','));
        }
    }

    public final void setElement(int n, int n2, RankedList rankedList) {
        if (rankedList != null) {
            this.setElement(n, n2, rankedList.toString(','));
        }
    }

    public final void setElement(int n, int n2, Set set) {
        if (set != null && set.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                stringBuffer.append(e2.toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append('\u001c');
            }
            this.setElement(n, n2, stringBuffer.toString());
        }
    }

    public final void setElement(int n, int n2, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            if (i2 == stringArray.length - 1) continue;
            stringBuffer.append('\u001c');
        }
        this.setElement(n, n2, stringBuffer.toString());
    }

    public final String[] getRow(int n) {
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + n + " < 0");
        }
        String[] stringArray = new String[this.fColCnt];
        System.arraycopy(this.elementData, n * this.fColCnt, stringArray, 0, this.fColCnt);
        return stringArray;
    }

    public final void setRow(int n, String[] stringArray) {
        this.checkImmuted();
        if (this.fRowCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("row: " + n + " > matrix's fRowCnt: " + this.fRowCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("row: " + n + " < 0");
        }
        if (stringArray.length < this.fColCnt) {
            throw new ArrayIndexOutOfBoundsException("specified array length: " + stringArray.length + " < matrix's fColCnt: " + this.fColCnt);
        }
        System.arraycopy(stringArray, 0, this.elementData, n * this.fColCnt, this.fColCnt);
    }

    public final void setColumn(int n, String[] stringArray) {
        this.checkImmuted();
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt=" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (stringArray.length < this.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("array length:" + stringArray.length + " < matrix's fRowCnt:" + this.fRowCnt);
        }
        int n2 = this.fRowCnt;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.elementData[i2 * this.fColCnt + n] = stringArray[i2];
        }
    }

    public final void setColumn(int n, Collection collection, boolean bl) {
        if (!bl && collection.size() != this.getNumRow()) {
            throw new IllegalArgumentException("Number of objects in coll: " + collection.size() + " not equal to numRows: " + this.getNumRow() + " AND autobuffer was: " + bl);
        }
        String[] stringArray = new String[this.getNumRow()];
        int n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringArray[n2++] = iterator.next().toString();
        }
        this.setColumn(n, stringArray);
    }

    public final void setColumn(int n, Vector vector) {
        this.setColumn(n, vector.elementData);
    }

    public final void setColumn(int n, Vector vector, boolean bl) {
        this.setColumn(n, vector.elementData, bl);
    }

    public final void setColumn(int n, float[] fArray) {
        this.setColumn(n, fArray, false);
    }

    public final void setColumn(int n, float[] fArray, boolean bl) {
        this.checkImmuted();
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt=" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (bl) {
            String string = Float.toString(Float.NaN);
            for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
                this.elementData[i2 * this.fColCnt + n] = i2 >= fArray.length ? string : Float.toString(fArray[i2]);
            }
        } else {
            if (fArray.length < this.fRowCnt) {
                throw new ArrayIndexOutOfBoundsException("array length:" + fArray.length + " < matrix's fRowCnt:" + this.fRowCnt);
            }
            for (int i3 = 0; i3 < this.fRowCnt; ++i3) {
                this.elementData[i3 * this.fColCnt + n] = Float.toString(fArray[i3]);
            }
        }
    }

    public final void setColumn(int n, int[] nArray) {
        this.checkImmuted();
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt=" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (nArray.length < this.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("array length:" + nArray.length + " < matrix's fRowCnt:" + this.fRowCnt);
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            this.elementData[i2 * this.fColCnt + n] = Integer.toString(nArray[i2]);
        }
    }

    public final String[] getColumn(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        String[] stringArray = new String[this.fRowCnt];
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            stringArray[i2] = this.elementData[i2 * this.fColCnt + n];
        }
        return stringArray;
    }

    public final Vector getColumnAsVector(int n, boolean bl) {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            String string = this.getElement(i2, n);
            if (string == null && bl) continue;
            if (string == null && !bl) {
                tFloatArrayList.add(Float.NaN);
                continue;
            }
            tFloatArrayList.add(Float.parseFloat(string));
        }
        return new Vector(tFloatArrayList);
    }

    public final List getColumnL(int n) {
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.fRowCnt);
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            arrayList.add(this.elementData[i2 * this.fColCnt + n]);
        }
        return arrayList;
    }

    public final String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(string);
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            stringBuffer.append("  [");
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                if (0 < i3) {
                    stringBuffer.append("\t");
                }
                stringBuffer.append(this.elementData[i2 * this.fColCnt + i3]);
            }
            if (i2 + 1 < this.fRowCnt) {
                stringBuffer.append("]");
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("] ]");
        }
        return stringBuffer.toString();
    }

    public final int hashCode() {
        int n = 0;
        for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            long l2 = this.elementData[i2].hashCode();
            n ^= (int)(l2 ^ l2 >> 32);
        }
        return n;
    }

    public final boolean equals(StringMatrix stringMatrix) {
        if (stringMatrix == null) {
            return false;
        }
        if (stringMatrix.fRowCnt != this.fRowCnt) {
            return false;
        }
        if (stringMatrix.fColCnt != this.fColCnt) {
            return false;
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            for (int i3 = 0; i3 < this.fColCnt; ++i3) {
                if (this.elementData[i2 * this.fColCnt + i3] == stringMatrix.elementData[i2 * this.fColCnt + i3]) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean equals(Object object) {
        return object != null && object instanceof StringMatrix && this.equals((StringMatrix)object);
    }

    public final void add(StringMatrix stringMatrix) {
        this.checkImmuted();
        if (this.fRowCnt != stringMatrix.fRowCnt || this.fColCnt != stringMatrix.fColCnt) {
            throw new IllegalArgumentException("this:(" + this.fRowCnt + "x" + this.fColCnt + ") != m1:(" + stringMatrix.fRowCnt + "x" + stringMatrix.fColCnt + ").");
        }
        for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            int n = i2;
            this.elementData[n] = this.elementData[n] + stringMatrix.elementData[i2];
        }
    }

    public final void add(StringMatrix stringMatrix, StringMatrix stringMatrix2) {
        this.checkImmuted();
        if (this.fRowCnt != stringMatrix.fRowCnt || this.fColCnt != stringMatrix.fColCnt) {
            throw new IllegalArgumentException("this:(" + this.fRowCnt + "x" + this.fColCnt + ") != m1:(" + stringMatrix.fRowCnt + "x" + stringMatrix.fColCnt + ").");
        }
        if (this.fRowCnt != stringMatrix2.fRowCnt || this.fColCnt != stringMatrix2.fColCnt) {
            throw new IllegalArgumentException("this:(" + this.fRowCnt + "x" + this.fColCnt + ") != m2:(" + stringMatrix2.fRowCnt + "x" + stringMatrix2.fColCnt + ").");
        }
        for (int i2 = 0; i2 < this.fRowCnt * this.fColCnt; ++i2) {
            this.elementData[i2] = stringMatrix.elementData[i2] + stringMatrix2.elementData[i2];
        }
    }

    public final void setColor(int n, int n2, Color color) {
        this.checkImmuted();
        if (this.fColorMatrix == null) {
            this.fColorMatrix = new ObjectMatrix(this.getNumRow(), this.getNumCol());
        }
        this.fColorMatrix.setElement(n, n2, color);
    }

    public final Color getColor(int n, int n2) {
        if (this.fColorMatrix == null) {
            return null;
        }
        Object object = this.fColorMatrix.getElement(n, n2);
        if (object != null) {
            return (Color)object;
        }
        return null;
    }

    public final void transpose() {
        int n;
        this.checkImmuted();
        String[] stringArray = new String[this.elementData.length];
        int n2 = 0;
        for (n = 0; n < this.getNumCol(); ++n) {
            String[] stringArray2 = new String[this.getNumRow()];
            this._getColumnInPlace(n, stringArray2);
            System.arraycopy(stringArray2, 0, stringArray, n2, stringArray2.length);
            n2 += stringArray2.length;
        }
        n = this.fRowCnt;
        int n3 = this.fColCnt;
        this.elementData = stringArray;
        this.fColCnt = n;
        this.fRowCnt = n3;
    }

    private void _getColumnInPlace(int n, String[] stringArray) {
        if (this.fColCnt <= n) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + n + " < 0");
        }
        if (stringArray.length < this.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("array.length:" + stringArray.length + " < matrix's fRowCnt=" + this.fRowCnt);
        }
        for (int i2 = 0; i2 < this.fRowCnt; ++i2) {
            stringArray[i2] = this.elementData[i2 * this.fColCnt + n];
        }
    }

    public final void setImmutable() {
        this.fImmuted = true;
    }

    public final boolean isImmutable() {
        return this.fImmuted;
    }

    private void checkImmuted() {
        if (this.fImmuted) {
            throw new ImmutedException();
        }
    }
}

