/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.models;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.StringDataframe;
import gnu.trove.THashSet;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class StringDataframeModel
extends AbstractTableModel {
    private final Logger log = XLogger.getLogger(StringDataframeModel.class);
    private StringDataframe fStringDataframe;
    private String fFeatureName = "Feature";
    private THashSet floatColNames;

    public StringDataframeModel(StringDataframe stringDataframe, THashSet tHashSet) {
        if (stringDataframe == null) {
            throw new IllegalArgumentException("Param sdf cannot be null");
        }
        this.fStringDataframe = stringDataframe;
        this.floatColNames = tHashSet;
    }

    public StringDataframeModel(StringDataframe stringDataframe) {
        this(stringDataframe, null);
    }

    public final StringDataframe getStringDataframe() {
        return this.fStringDataframe;
    }

    @Override
    public final int getColumnCount() {
        return this.fStringDataframe.getNumCol() + 1;
    }

    @Override
    public final int getRowCount() {
        return this.fStringDataframe.getNumRow();
    }

    public final void setFeatureName(String string) {
        this.fFeatureName = string;
    }

    @Override
    public final String getColumnName(int n) {
        if (n == 0) {
            return this.fFeatureName;
        }
        return this.fStringDataframe.getColumnName(n - 1);
    }

    public final int getColumnIndex(String string) {
        if (string.equals(this.fFeatureName)) {
            return 0;
        }
        return this.fStringDataframe.getColumnIndex(string) - 1;
    }

    @Override
    public final Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.fStringDataframe.getRowName(n);
        }
        String string = this.getColumnName(n2);
        if (this.floatColNames != null && this.floatColNames.contains(string)) {
            return new Float(this.fStringDataframe.getElement(n, n2 - 1));
        }
        return this.fStringDataframe.getElement(n, n2 - 1);
    }

    public final Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public final boolean isEditable() {
        return false;
    }

    @Override
    public final boolean isCellEditable(int n, int n2) {
        return false;
    }
}

