/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.Matrix;

public class APMMatrix
extends Matrix {
    public static final String PRESENT_STR = "P";
    public static final String ABSENT_STR = "A";
    public static final String MISSING_STR = "M";
    public static final float PRESENT = 1.0f;
    public static final float ABSENT = 0.0f;
    public static final float MISSING = Float.NaN;

    public APMMatrix(int n, int n2) {
        super(n, n2);
    }

    public APMMatrix(APMMatrix aPMMatrix, boolean bl) {
        super(aPMMatrix, bl);
    }

    public final boolean isPresent(int n, int n2) {
        return this.getElement(n, n2) == 1.0f;
    }

    public final boolean isAbsent(int n, int n2) {
        return this.getElement(n, n2) == 0.0f;
    }

    public final void setElement(int n, int n2, String string) {
        super.setElement(n, n2, APMMatrix.valueOf(string));
    }

    public final boolean isMissing(int n, int n2) {
        return Float.isNaN(this.getElement(n, n2));
    }

    public final char getElement_char(int n, int n2) {
        float f2 = this.getElement(n, n2);
        if (f2 == 1.0f) {
            return PRESENT_STR.toCharArray()[0];
        }
        if (f2 == 0.0f) {
            return ABSENT_STR.toCharArray()[0];
        }
        if (Float.isNaN(f2)) {
            return MISSING_STR.toCharArray()[0];
        }
        throw new IllegalStateException("Unknown value: " + f2 + " at row: " + n + " col: " + n2);
    }

    public static final float valueOf(String string) {
        if (string == null) {
            throw new NullPointerException("Null value of param not allowed");
        }
        if (string.equalsIgnoreCase(PRESENT_STR)) {
            return 1.0f;
        }
        if (string.equalsIgnoreCase(ABSENT_STR)) {
            return 0.0f;
        }
        if (string.equalsIgnoreCase(MISSING_STR)) {
            return Float.NaN;
        }
        if (string.equals("0")) {
            return Float.NaN;
        }
        throw new IllegalArgumentException("Unknown AP call value >" + string + "<");
    }

    public final float[] getRowCallFrequencies(int n) {
        int n2;
        float[] fArray = new float[3];
        for (n2 = 0; n2 < this.getNumCol(); ++n2) {
            float f2 = this.getElement(n, n2);
            if (f2 == 1.0f) {
                fArray[0] = fArray[0] + 1.0f;
                continue;
            }
            if (f2 == 0.0f) {
                fArray[1] = fArray[1] + 1.0f;
                continue;
            }
            if (!Float.isNaN(f2)) continue;
            fArray[2] = fArray[2] + 1.0f;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            fArray[n2] = fArray[n2] / (float)this.getNumCol();
        }
        return fArray;
    }

    public final float[] getColCallFrequencies(int n) {
        int n2;
        float[] fArray = new float[3];
        for (n2 = 0; n2 < this.getNumRow(); ++n2) {
            float f2 = this.getElement(n2, n);
            if (f2 == 1.0f) {
                fArray[0] = fArray[0] + 1.0f;
                continue;
            }
            if (f2 == 0.0f) {
                fArray[1] = fArray[1] + 1.0f;
                continue;
            }
            if (!Float.isNaN(f2)) continue;
            fArray[2] = fArray[2] + 1.0f;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            fArray[n2] = fArray[n2] / (float)this.getNumRow();
        }
        return fArray;
    }

    public final float[] getCallFrequencies() {
        int n;
        float[] fArray = new float[3];
        for (n = 0; n < this.getNumRow(); ++n) {
            for (int i2 = 0; i2 < this.getNumCol(); ++i2) {
                float f2 = this.getElement(n, i2);
                if (f2 == 1.0f) {
                    fArray[0] = fArray[0] + 1.0f;
                    continue;
                }
                if (f2 == 0.0f) {
                    fArray[1] = fArray[1] + 1.0f;
                    continue;
                }
                if (!Float.isNaN(f2)) continue;
                fArray[2] = fArray[2] + 1.0f;
            }
        }
        for (n = 0; n < 3; ++n) {
            fArray[n] = fArray[n] / (float)(this.getNumCol() * this.getNumRow());
        }
        return fArray;
    }
}

