/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.objects.AbstractRankedListDb$ExtractedImpl_GeneSet;
import edu.mit.broad.genome.objects.AbstractRankedListDb_base;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedListDb;
import edu.mit.broad.genome.objects.RankedListDb$Extracted;
import edu.mit.broad.genome.objects.RankedListDb$OrderedSampleNames;
import edu.mit.broad.genome.objects.TemplateCohort;
import edu.mit.broad.genome.objects.TemplateCohort$Comp;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRankedListDb
extends AbstractRankedListDb_base
implements RankedListDb {
    private Dataset fFullDataset;
    private TemplateCohort fTch;
    private String fQuickInfo;

    protected AbstractRankedListDb() {
    }

    protected final void init(String string, List list, List list2, Chip chip, Annot annot, Dataset dataset, TemplateCohort templateCohort) {
        Errors errors = new Errors("Mismatched rdb and tch");
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            String string2 = list2.get(i2).toString();
            if (templateCohort == null || templateCohort.hasComp(string2)) continue;
            errors.add("tch doesnt have: " + string2);
        }
        errors.barfIfNotEmptyRuntime();
        if (chip == null) {
            throw new IllegalArgumentException("Param chip cannot be null");
        }
        if (annot == null) {
            throw new IllegalArgumentException("Param annot_for_rl cannot be null");
        }
        if (annot.getSampleAnnot_global() == null) {
            throw new IllegalArgumentException("Param annot_for_rl cannot have null sample annot");
        }
        super.init(string, list, list2, chip, annot);
        this.fFullDataset = dataset;
        this.fTch = templateCohort;
    }

    @Override
    public String getQuickInfo() {
        if (this.fQuickInfo == null) {
            this._setQuickInfo();
        }
        return this.fQuickInfo;
    }

    @Override
    public RankedListDb$OrderedSampleNames getSampleNames(int[] nArray, boolean bl) {
        SampleAnnot sampleAnnot = this.getDataset().getAnnot().getSampleAnnot_synched(this.getDataset().getColumnNamesArray());
        ArrayList arrayList = new ArrayList();
        GeneSet[] geneSetArray = new GeneSet[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string = this.getRankedListName(nArray[i2]);
            TemplateCohort$Comp templateCohort$Comp = this.getComp(string);
            List list = templateCohort$Comp.getSampleNames(sampleAnnot, bl);
            arrayList.addAll(list);
            geneSetArray[i2] = new FSet(string, list, true);
        }
        RankedListDb$OrderedSampleNames rankedListDb$OrderedSampleNames = new RankedListDb$OrderedSampleNames();
        rankedListDb$OrderedSampleNames.names = arrayList.toArray(new String[arrayList.size()]);
        rankedListDb$OrderedSampleNames.namesByRl = geneSetArray;
        return rankedListDb$OrderedSampleNames;
    }

    @Override
    public Dataset getDataset() {
        return this.fFullDataset;
    }

    @Override
    public TemplateCohort getTemplateCohort() {
        return this.fTch;
    }

    @Override
    public TemplateCohort$Comp getComp(String string) {
        return this.fTch.getComp(string);
    }

    @Override
    public TemplateCohort$Comp getComp(int n) {
        return this.fTch.getComp(this.getRankedListName(n));
    }

    @Override
    public RankedListDb$Extracted extract(String string) {
        return this._exr(this.getRankedList(string));
    }

    @Override
    public RankedListDb$Extracted extract(int n) {
        return this._exr(this.getRankedList(n));
    }

    @Override
    public RankedListDb$Extracted extract(String string, GeneSet geneSet) {
        return this._exr(this.getRankedList(string), geneSet);
    }

    @Override
    public RankedListDb$Extracted extract(int n, GeneSet geneSet) {
        return this._exr(this.getRankedList(n), geneSet);
    }

    @Override
    public RankedListDb$Extracted extract(String string, int n) {
        RankedList rankedList = this.getRankedList(string);
        return this._exr(rankedList, rankedList.getNamesOfUpAndDnXRanks(n).getBoth());
    }

    @Override
    public RankedListDb$Extracted extract(int n, int n2) {
        RankedList rankedList = this.getRankedList(n);
        return this._exr(rankedList, rankedList.getNamesOfUpAndDnXRanks(n2).getBoth());
    }

    private RankedListDb$Extracted _exr(RankedList rankedList, GeneSet geneSet) {
        TemplateCohort$Comp templateCohort$Comp = this.fTch.getComp(rankedList.getName());
        RankedList rankedList2 = rankedList.extractRanked(geneSet);
        return new AbstractRankedListDb$ExtractedImpl_GeneSet(this, rankedList.getName(), templateCohort$Comp, rankedList2, geneSet);
    }

    private RankedListDb$Extracted _exr(RankedList rankedList) {
        TemplateCohort$Comp templateCohort$Comp = this.fTch.getComp(rankedList.getName());
        return new AbstractRankedListDb$ExtractedImpl_GeneSet(this, rankedList.getName(), templateCohort$Comp, rankedList, null);
    }

    private void _setQuickInfo() {
        this.fQuickInfo = "todo";
    }

    static final /* synthetic */ Dataset access$000(AbstractRankedListDb abstractRankedListDb) {
        return abstractRankedListDb.fFullDataset;
    }
}

