/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath$Const;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrixPair;
import edu.mit.broad.genome.objects.GeneSetMatrixPairImpl;
import edu.mit.broad.genome.objects.GeneSetPair;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedListDb;
import edu.mit.broad.genome.objects.RankedListDbImpl;
import edu.mit.broad.vdb.chip.Chip;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractRankedListDb_base
extends AbstractObject
implements RankedListDb {
    private List fRowNames;
    private List fColNames;
    private int fNumRows;
    private GeneSet fColNamesGeneSet;
    private GeneSet fRowNamesGeneSet;
    private Chip fChip;
    private Annot fAnnot_for_rl;

    protected AbstractRankedListDb_base() {
    }

    protected final void init(String string, List list, List list2, Chip chip, Annot annot) {
        super.initialize(string);
        this.fRowNames = list;
        this.fColNames = list2;
        this.fNumRows = this.fRowNames.size();
        this.fChip = chip;
        this.fAnnot_for_rl = annot;
    }

    @Override
    public Chip getChip() {
        return this.fChip;
    }

    @Override
    public Annot getAnnot() {
        return this.fAnnot_for_rl;
    }

    @Override
    public RankedListDb cloneShallow(String[] stringArray, boolean bl) {
        if (bl) {
            RankedList[] rankedListArray = new RankedList[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                rankedListArray[i2] = this.getRankedList(stringArray[i2]);
            }
            return new RankedListDbImpl(this.getName() + "_" + stringArray.length, rankedListArray, this.getChip(), this.getAnnot(), this.getDataset(), this.getTemplateCohort());
        }
        ArrayList<RankedList> arrayList = new ArrayList<RankedList>();
        List<String> list = Arrays.asList(stringArray);
        for (int i3 = 0; i3 < this.getNumRankedLists(); ++i3) {
            RankedList rankedList = this.getRankedList(i3);
            if (list.contains(rankedList.getName())) continue;
            arrayList.add(rankedList);
        }
        return new RankedListDbImpl(this.getName() + "_" + stringArray.length, arrayList.toArray(new RankedList[arrayList.size()]), this.getChip(), this.getAnnot(), this.getDataset(), this.getTemplateCohort());
    }

    @Override
    public RankedList[] getRankedLists(String[] stringArray) {
        RankedList[] rankedListArray = new RankedList[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            rankedListArray[i2] = this.getRankedList(stringArray[i2]);
        }
        return rankedListArray;
    }

    @Override
    public RankedList[] getRankedLists(int[] nArray) {
        RankedList[] rankedListArray = new RankedList[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            rankedListArray[i2] = this.getRankedList(nArray[i2]);
        }
        return rankedListArray;
    }

    @Override
    public GeneSetMatrixPair createGeneSetMatrix(int n) {
        GeneSet[] geneSetArray = new GeneSet[this.getNumRankedLists()];
        GeneSet[] geneSetArray2 = new GeneSet[this.getNumRankedLists()];
        for (int i2 = 0; i2 < this.getNumRankedLists(); ++i2) {
            GeneSetPair geneSetPair = this.getRankedList(i2).getNamesOfUpAndDnXRanks(n);
            geneSetArray[i2] = geneSetPair.getUp();
            geneSetArray2[i2] = geneSetPair.getDown();
        }
        return new GeneSetMatrixPairImpl(this.getName() + "_" + n, geneSetArray, geneSetArray2);
    }

    @Override
    public Dataset createDataset(String string, int[] nArray) {
        RankedList[] rankedListArray = new RankedList[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            rankedListArray[i2] = this.getRankedList(nArray[i2]);
        }
        return this._createDataset(string, rankedListArray);
    }

    @Override
    public Dataset createDataset(String string, String[] stringArray) {
        RankedList[] rankedListArray = new RankedList[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            rankedListArray[i2] = this.getRankedList(stringArray[i2]);
        }
        return this._createDataset(string, rankedListArray);
    }

    private Dataset _createDataset(String string, RankedList[] rankedListArray) {
        if (rankedListArray == null || rankedListArray.length == 0) {
            throw new IllegalArgumentException("Param rls cannot be null nor zero size: " + rankedListArray);
        }
        String[] stringArray = this.getRowNamesArray();
        Matrix matrix = new Matrix(stringArray.length, rankedListArray.length);
        String[] stringArray2 = new String[rankedListArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            for (int i3 = 0; i3 < rankedListArray.length; ++i3) {
                if (i2 == 0) {
                    stringArray2[i3] = rankedListArray[i3].getName();
                }
                matrix.setElement(i2, i3, rankedListArray[i3].getScore(stringArray[i2]));
            }
            if (i2 % 500 != 0) continue;
            System.out.println("Done row: " + i2 + " / " + stringArray.length);
        }
        return new DefaultDataset(string, matrix, stringArray, stringArray2, true, this.getAnnot());
    }

    @Override
    public List getRowNames() {
        return Collections.unmodifiableList(this.fRowNames);
    }

    @Override
    public GeneSet getRowNamesGeneSet() {
        if (this.fRowNamesGeneSet == null) {
            this.fRowNamesGeneSet = new FSet(this.getName(), new HashSet(this.fRowNames));
        }
        return this.fRowNamesGeneSet;
    }

    @Override
    public String[] getRowNamesArray() {
        return this.fRowNames.toArray(new String[this.fRowNames.size()]);
    }

    @Override
    public int getNumRow() {
        return this.fNumRows;
    }

    @Override
    public int getNumRankedLists() {
        return this.fColNames.size();
    }

    @Override
    public List getRankedListNames() {
        return Collections.unmodifiableList(this.fColNames);
    }

    @Override
    public GeneSet getRankedListNamesGeneSet() {
        if (this.fColNamesGeneSet == null) {
            this.fColNamesGeneSet = new FSet(this.getName(), new ArrayList(this.fColNames), true);
        }
        return this.fColNamesGeneSet;
    }

    @Override
    public GeneSet getRankedListNamesGeneSet(int[] nArray) {
        List list = this.getRankedListNames(nArray);
        return new FSet(this.getName(), list, true);
    }

    @Override
    public String[] getRankedListNamesArray(int[] nArray) {
        List list = this.getRankedListNames(nArray);
        return list.toArray(new String[list.size()]);
    }

    @Override
    public List getRankedListNames(int[] nArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(this.getRankedListName(nArray[i2]));
        }
        return arrayList;
    }

    @Override
    public String[] getRankedListNamesArray() {
        return this.fColNames.toArray(new String[this.fColNames.size()]);
    }

    @Override
    public String getRankedListName(int n) {
        return (String)this.fColNames.get(n);
    }

    @Override
    public int getRankedListIndex(String string) {
        return this.fColNames.indexOf(string);
    }

    @Override
    public Vector getValues(String string, XMath$Const xMath$Const) {
        Vector vector = new Vector(this.getNumRankedLists());
        for (int i2 = 0; i2 < this.getNumRankedLists(); ++i2) {
            vector.setElement(i2, this.getRankedList(i2).getValue(string, xMath$Const));
        }
        return vector;
    }
}

