/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.objects.Template$Item;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractTemplate
extends AbstractObject
implements Template {
    private Vector fTemplateAsVector;
    private TIntObjectHashMap fProfilePosItemMap;

    AbstractTemplate(String string) {
        super(string);
    }

    protected AbstractTemplate() {
    }

    @Override
    public boolean equalsShallow(Template template) {
        return template != null && template.getName().equals(this.getName()) && template.getNumItems() == this.getNumItems();
    }

    @Override
    public String getQuickInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isContinuous()) {
            stringBuffer.append(this.getNumItems()).append("=>numeric");
        } else if (this.getNumClasses() == 2) {
            stringBuffer.append(this.getNumItems()).append(" samples").append('(').append(this.getClass(0).getSize()).append(',').append(this.getClass(1).getSize()).append(')').append("=>").append(this.getNumClasses()).append(" classes");
        } else if (this.getNumClasses() == 1) {
            stringBuffer.append(this.getNumItems()).append(" samples").append("=>").append(this.getNumClasses()).append(" class");
        } else {
            stringBuffer.append(this.getNumItems()).append(" samples").append("=>").append(this.getNumClasses()).append(" classes");
        }
        return stringBuffer.toString();
    }

    protected abstract Template$Item _getItemAsIs(int var1);

    protected abstract Template$Item[] _getItems();

    private String[] _getClassNamesOrderedByProfilePos_CAREFUL() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = this.getProfilePositionsOrdered();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string = this.getItemByProfilePos(nArray[i2]).getId();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        if (arrayList.size() != this.getNumClasses()) {
            throw new IllegalStateException("Odd: className.length: " + arrayList.size() + " getNumClasses: " + this.getNumClasses() + " " + arrayList);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public int getClassIndex(String string) {
        for (int i2 = 0; i2 < this.getNumClasses(); ++i2) {
            if (!this.getClass(i2).getName().equals(string)) continue;
            return i2;
        }
        throw new RuntimeException("No class for name: " + string);
    }

    @Override
    public Template$Class getClass(Template$Item template$Item) {
        for (int i2 = 0; i2 < this.getNumClasses(); ++i2) {
            Template$Class template$Class = this.getClass(i2);
            for (int i3 = 0; i3 < template$Class.getSize(); ++i3) {
                if (!template$Item.equals(template$Class.getItem(i3))) continue;
                return template$Class;
            }
        }
        throw new IllegalArgumentException("No membership for item in any of the classes: " + template$Item.getId() + " " + template$Item.getProfilePosition());
    }

    @Override
    public Template$Class getClass(String string) {
        for (int i2 = 0; i2 < this.getNumClasses(); ++i2) {
            if (!this.getClass(i2).getName().equals(string)) continue;
            return this.getClass(i2);
        }
        throw new RuntimeException("No class for name: " + string);
    }

    @Override
    public Template$Class getClassByProfilePos(int n) {
        return this.getClass(this.getItemByProfilePos(n));
    }

    @Override
    public boolean isClassesContiguous() {
        for (int i2 = 0; i2 < this.getNumClasses(); ++i2) {
            Template$Class template$Class = this.getClass(i2);
            int[] nArray = template$Class.getProfilePositions();
            if (!XMath.isAscending(nArray)) {
                return false;
            }
            if (XMath.isContiguous(nArray)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List extractColumnNames(Dataset dataset) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = this.getProfilePositionsOrdered();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(dataset.getColumnName(nArray[i2]));
        }
        return arrayList;
    }

    @Override
    public Vector extractProfile(String string, Dataset dataset) {
        int[] nArray = this.getProfilePositionsOrdered();
        Vector vector = new Vector(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            vector.setElement(i2, dataset.getElement(string, nArray[i2]));
        }
        return vector;
    }

    @Override
    public Vector extractProfile(int n, Dataset dataset) {
        int[] nArray = this.getProfilePositionsOrdered();
        Vector vector = new Vector(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            vector.setElement(i2, dataset.getElement(n, nArray[i2]));
        }
        return vector;
    }

    @Override
    public LabelledVector extractProfile_lv(String string, Dataset dataset) {
        return new LabelledVector(string, this.extractColumnNames(dataset), this.extractProfile(string, dataset), true);
    }

    @Override
    public LabelledVector extractProfile_lv(int n, Dataset dataset) {
        return new LabelledVector(dataset.getRowName(n), this.extractColumnNames(dataset), this.extractProfile(n, dataset), true);
    }

    @Override
    public Vector toVector() {
        if (this.fTemplateAsVector == null) {
            Vector vector = new Vector(this.getNumItems());
            if (this.isContinuous()) {
                for (int i2 = 0; i2 < this.getNumItems(); ++i2) {
                    vector.setElement(i2, this._getItemAsIs(i2).floatValue());
                }
            } else {
                for (int i3 = 0; i3 < this.getNumItems(); ++i3) {
                    vector.setElement(i3, this._getItemAsIs(i3).floatValue());
                }
            }
            this.fTemplateAsVector = vector;
            this.fTemplateAsVector.setImmutable();
        }
        return this.fTemplateAsVector;
    }

    @Override
    public Vector[] splitByTemplateClass(Vector vector) {
        Vector[] vectorArray = new Vector[this.getNumClasses()];
        for (int i2 = 0; i2 < this.getNumClasses(); ++i2) {
            Template$Class template$Class = this.getClass(i2);
            Vector vector2 = new Vector(template$Class.getSize());
            for (int i3 = 0; i3 < template$Class.getSize(); ++i3) {
                int n = template$Class.getItem(i3).getProfilePosition();
                vector2.setElement(i3, vector.getElement(n));
            }
            vectorArray[i2] = vector2;
        }
        return vectorArray;
    }

    @Override
    public Set[] splitByTemplateClass(List list) {
        Set[] setArray = new Set[this.getNumClasses()];
        for (int i2 = 0; i2 < this.getNumClasses(); ++i2) {
            Template$Class template$Class = this.getClass(i2);
            HashSet hashSet = new HashSet(template$Class.getSize());
            for (int i3 = 0; i3 < template$Class.getSize(); ++i3) {
                int n = template$Class.getItem(i3).getProfilePosition();
                hashSet.add(list.get(n));
            }
            setArray[i2] = hashSet;
        }
        return setArray;
    }

    @Override
    public String getAsString(boolean bl) {
        if (this.isContinuous()) {
            return this._getAsString_cont();
        }
        return this._getAsString_cat(bl);
    }

    private String _getAsString_cont() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#numeric").append('\n');
        stringBuffer.append('\n');
        stringBuffer.append('#').append(this.getName()).append('\n');
        Template$Item[] template$ItemArray = this.getItemsOrderedByProfilePos();
        for (int i2 = 0; i2 < template$ItemArray.length; ++i2) {
            stringBuffer.append(template$ItemArray[i2].floatValue());
            if (i2 == this.getNumItems() - 1) continue;
            stringBuffer.append(" ");
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private String _getAsString_cat(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNumItems());
        stringBuffer.append(" ");
        stringBuffer.append(this.getNumClasses());
        stringBuffer.append(" ");
        stringBuffer.append("1");
        stringBuffer.append("\n");
        stringBuffer.append("# ");
        String[] stringArray = this._getClassNamesOrderedByProfilePos_CAREFUL();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            if (i2 == stringArray.length - 1) continue;
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        Template$Item[] template$ItemArray = this.getItemsOrderedByProfilePos();
        if (bl) {
            int n;
            TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
            int n2 = 0;
            for (n = 0; n < template$ItemArray.length; ++n) {
                Template$Item template$Item = template$ItemArray[n];
                if (tObjectIntHashMap.containsKey(template$Item.getId())) continue;
                tObjectIntHashMap.put(template$Item.getId(), n2);
                ++n2;
            }
            for (n = 0; n < template$ItemArray.length; ++n) {
                int n3 = tObjectIntHashMap.get(template$ItemArray[n].getId());
                stringBuffer.append(n3);
                if (n == template$ItemArray.length - 1) continue;
                stringBuffer.append(" ");
            }
        } else {
            for (int i3 = 0; i3 < template$ItemArray.length; ++i3) {
                stringBuffer.append(template$ItemArray[i3].getId());
                if (i3 == template$ItemArray.length - 1) continue;
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public String getColumnName(Template$Item template$Item, Dataset dataset) {
        return dataset.getColumnName(template$Item.getProfilePosition());
    }

    @Override
    public boolean hasItemWithId(String string) {
        if (string == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.getNumItems(); ++i2) {
            Template$Item template$Item = this._getItemAsIs(i2);
            if (!template$Item.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAscendingProfilePositions() {
        int[] nArray = new int[this.getNumItems()];
        for (int i2 = 0; i2 < this.getNumItems(); ++i2) {
            Template$Item template$Item = this._getItemAsIs(i2);
            nArray[i2] = template$Item.getProfilePosition();
        }
        return XMath.isAscending(nArray);
    }

    @Override
    public Vector synchProfile(Vector vector) {
        Vector vector2 = new Vector(this.getNumItems());
        for (int i2 = 0; i2 < this.getNumItems(); ++i2) {
            int n = this._getItemAsIs(i2).getProfilePosition();
            vector2.setElement(i2, vector.getElement(n));
        }
        return vector2;
    }

    @Override
    public Template$Item[] getItemsOrderedByProfilePos() {
        int[] nArray = this.getProfilePositionsOrdered();
        ArrayList<Template$Item> arrayList = new ArrayList<Template$Item>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(this.getItemByProfilePos(nArray[i2]));
        }
        return arrayList.toArray(new Template$Item[arrayList.size()]);
    }

    @Override
    public Template$Item[] getItemsOrderedByClassFirstAndThenProfilePos() {
        ArrayList<Template$Item> arrayList = new ArrayList<Template$Item>();
        for (int i2 = 0; i2 < this.getNumClasses(); ++i2) {
            Template$Class template$Class = this.getClass(i2);
            Template$Item[] template$ItemArray = template$Class.getItemsOrderedByProfilePos();
            for (int i3 = 0; i3 < template$ItemArray.length; ++i3) {
                arrayList.add(template$ItemArray[i3]);
            }
        }
        return arrayList.toArray(new Template$Item[arrayList.size()]);
    }

    @Override
    public Template$Item getItemByProfilePos(int n) {
        this._initProfilePosItemMap();
        Object object = this.fProfilePosItemMap.get(n);
        if (object == null) {
            Printf.out(this.fProfilePosItemMap.keys());
            throw new IllegalArgumentException("No such profile pos: " + n + " # points: " + this.getNumItems());
        }
        return (Template$Item)object;
    }

    @Override
    public int[] getProfilePositionsOrdered() {
        this._initProfilePosItemMap();
        return AbstractTemplate.getProfilePositionsSorted(this.fProfilePosItemMap);
    }

    protected static final TIntObjectHashMap hashProfilePosItemMap(Template$Item[] template$ItemArray) {
        TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap();
        for (int i2 = 0; i2 < template$ItemArray.length; ++i2) {
            if (tIntObjectHashMap.containsKey(template$ItemArray[i2].getProfilePosition())) {
                throw new IllegalStateException("Duplicate profile positions: " + template$ItemArray[i2].getProfilePosition());
            }
            if (tIntObjectHashMap.get(template$ItemArray[i2].getProfilePosition()) != null) {
                throw new IllegalStateException("Multiple items at same profile position in template: " + template$ItemArray[i2].getProfilePosition());
            }
            tIntObjectHashMap.put(template$ItemArray[i2].getProfilePosition(), template$ItemArray[i2]);
        }
        return tIntObjectHashMap;
    }

    protected static final Template$Item[] getProfilePositionsSorted(Template$Item[] template$ItemArray) {
        TIntObjectHashMap tIntObjectHashMap = AbstractTemplate.hashProfilePosItemMap(template$ItemArray);
        Template$Item[] template$ItemArray2 = new Template$Item[template$ItemArray.length];
        int[] nArray = AbstractTemplate.getProfilePositionsSorted(tIntObjectHashMap);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            template$ItemArray2[i2] = (Template$Item)tIntObjectHashMap.get(nArray[i2]);
        }
        return template$ItemArray2;
    }

    protected static final int[] getProfilePositionsSorted(TIntObjectHashMap tIntObjectHashMap) {
        int[] nArray = tIntObjectHashMap.keys();
        Arrays.sort(nArray);
        return nArray;
    }

    private void _initProfilePosItemMap() {
        if (this.fProfilePosItemMap == null) {
            this.fProfilePosItemMap = AbstractTemplate.hashProfilePosItemMap(this._getItems());
        }
    }
}

