/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.ColorMap;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import org.apache.log4j.Logger;

public class AnnotImpl
implements Annot {
    private FeatureAnnot fFeatureAnnot;
    private SampleAnnot fSampleAnnot;
    private static final Logger klog = XLogger.getLogger(AnnotImpl.class);

    public AnnotImpl(FeatureAnnot featureAnnot, SampleAnnot sampleAnnot) {
        if (featureAnnot == null) {
            throw new IllegalArgumentException("Param featureAnnot cannot be null");
        }
        if (sampleAnnot == null) {
            throw new IllegalArgumentException("Param sampleAnnot cannot be null");
        }
        this.fFeatureAnnot = featureAnnot;
        this.fSampleAnnot = sampleAnnot;
    }

    @Override
    public final Annot cloneDeeep(String[] stringArray) {
        return new AnnotImpl(this.fFeatureAnnot, this.fSampleAnnot.cloneDeep(stringArray));
    }

    @Override
    public final FeatureAnnot getFeatureAnnot() {
        return this.fFeatureAnnot;
    }

    @Override
    public final SampleAnnot getSampleAnnot_global() {
        return this.fSampleAnnot;
    }

    @Override
    public final SampleAnnot getSampleAnnot_synched(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Param colNames cannot be null");
        }
        if (this.fSampleAnnot == null) {
            throw new IllegalStateException("No available sample annot: " + this.fSampleAnnot);
        }
        return this.fSampleAnnot.cloneDeep(stringArray);
    }

    @Override
    public final Chip getChip() {
        return this.fFeatureAnnot.getChip();
    }

    @Override
    public final void setChip(Chip chip, ColorMap.Rows rows) {
        this.fFeatureAnnot.setChip(chip, rows);
    }

    @Override
    public final void setSampleAnnot(SampleAnnot sampleAnnot) {
        if (sampleAnnot != null) {
            if (this.fSampleAnnot != null) {
                klog.debug("replacing curr sample annot: " + this.fSampleAnnot.getQuickInfo() + " with: " + sampleAnnot.getQuickInfo());
            }
            this.fSampleAnnot = sampleAnnot;
        } else {
            klog.debug("Ignoring setAnnot as ann is: " + sampleAnnot);
        }
    }
}

