/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.BooleanMatrix;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.parsers.AuxUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class BitSetDataset
extends AbstractObject {
    private BitSet[] fBitSets;
    private List fcBitNames;
    private List frBitSetNames;

    public BitSetDataset(String string, GeneSet[] geneSetArray) {
        this(new DefaultGeneSetMatrix(string, geneSetArray));
    }

    public BitSetDataset(GeneSetMatrix geneSetMatrix) {
        int n;
        ArrayList arrayList = new ArrayList(geneSetMatrix.getAllMemberNamesOnlyOnceS());
        BitSet[] bitSetArray = new BitSet[geneSetMatrix.getNumGeneSets()];
        ArrayList<String> arrayList2 = new ArrayList<String>(geneSetMatrix.getNumGeneSets());
        for (n = 0; n < geneSetMatrix.getNumGeneSets(); ++n) {
            bitSetArray[n] = new BitSet(arrayList.size());
            arrayList2.add(AuxUtils.getAuxNameOnlyNoHash(geneSetMatrix.getGeneSetName(n)));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            String string = arrayList.get(n).toString();
            for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
                GeneSet geneSet = geneSetMatrix.getGeneSet(i2);
                if (!geneSet.isMember(string)) continue;
                bitSetArray[i2].set(n);
            }
        }
        String string = NamingConventions.generateName(geneSetMatrix);
        string = NamingConventions.removeExtension(string);
        this.init(string, bitSetArray, arrayList2, arrayList, true);
    }

    public BitSetDataset(String string, BitSet[] bitSetArray, List list, List list2, boolean bl) {
        this.init(string, bitSetArray, list, list2, bl);
    }

    public BitSetDataset(String string, BitSet[] bitSetArray, String[] stringArray, String[] stringArray2, boolean bl) {
        this.init(string, bitSetArray, BitSetDataset.toList(stringArray), BitSetDataset.toList(stringArray2), bl);
    }

    private static List toList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList;
    }

    protected final void init(String string, BitSet[] bitSetArray, List list, List list2, boolean bl) {
        int n;
        super.initialize(string);
        if (bitSetArray == null) {
            throw new IllegalArgumentException("Param bss cannot be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("bitSetNames cannot be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Param bitNames cannot be null");
        }
        if (bitSetArray.length != list.size()) {
            throw new IllegalArgumentException("BitSet length: " + bitSetArray.length + " and bitSetNames (row names): " + list.size() + " do not match in size");
        }
        if (bitSetArray.length > 0) {
            n = bitSetArray[0].size();
            for (int i2 = 0; i2 < bitSetArray.length; ++i2) {
                if (bitSetArray[i2] == null) {
                    throw new IllegalArgumentException("BitSet cannot be null at: " + i2);
                }
                if (bitSetArray[i2].size() == n) continue;
                throw new IllegalArgumentException("BitSets are not of equal length, expected: " + n + " but at: " + i2 + " got size: " + bitSetArray[i2].size());
            }
        }
        if (bl) {
            this.fBitSets = bitSetArray;
        } else {
            this.log.debug("NON-sharing mode, so making deep copy of bitsets: " + bitSetArray.length);
            this.fBitSets = new BitSet[bitSetArray.length];
            for (n = 0; n < bitSetArray.length; ++n) {
                this.fBitSets[n] = (BitSet)bitSetArray[n].clone();
            }
        }
        this.fcBitNames = Collections.unmodifiableList(list2);
        this.frBitSetNames = Collections.unmodifiableList(list);
        BitSetDataset.ensureAllUniqueValues(this.frBitSetNames);
    }

    protected static final void ensureAllUniqueValues(List list) {
        if (list == null) {
            throw new IllegalArgumentException("Parameter list cannot be null");
        }
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (hashSet.contains(e2)) {
                throw new IllegalArgumentException("Duplicate COL names are NOT allowed in Datasets. The offending entry was: " + e2 + " at pos: " + i2 + "\n" + hashSet);
            }
            hashSet.add(e2);
        }
        hashSet.clear();
    }

    public final Dataframe toDataframe(boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>(this.fcBitNames);
        if (bl2) {
            arrayList.add("Total");
        }
        return new Dataframe(this.getName(), this.toMatrix(bl, bl2), this.frBitSetNames, arrayList, true, false, false);
    }

    public final Dataset toDataset(boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>(this.fcBitNames);
        if (bl2) {
            arrayList.add("Total");
        }
        return new DefaultDataset(this.getName(), this.toMatrix(bl, bl2), this.frBitSetNames, arrayList, true, false, false, null);
    }

    public final Dataset toDataset(int n, int n2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(this.fcBitNames);
        if (bl) {
            arrayList.add("Total");
        }
        return new DefaultDataset(this.getName(), this.toMatrix(n, n2, bl), this.frBitSetNames, arrayList, true, false, false, null);
    }

    public final Dataset toDataset(RankedList rankedList, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>(this.fcBitNames);
        if (bl2) {
            arrayList.add("Total");
        }
        return new DefaultDataset(this.getName(), this.toMatrix(rankedList, bl, bl2), this.frBitSetNames, arrayList, true, false, false, null);
    }

    public final BitSet getBitSet(int n) {
        return (BitSet)this.fBitSets[n].clone();
    }

    public final String getBitName(int n) {
        return (String)this.fcBitNames.get(n);
    }

    public final List getBitNames() {
        return Collections.unmodifiableList(this.fcBitNames);
    }

    public final int getRowIndex(String string) {
        return this.frBitSetNames.indexOf(string);
    }

    public final int getColIndex(String string) {
        return this.fcBitNames.indexOf(string);
    }

    public final String[] getRowNamesArray() {
        return this.frBitSetNames.toArray(new String[this.frBitSetNames.size()]);
    }

    public final String getRowName(int n) {
        return this.frBitSetNames.get(n).toString();
    }

    public final String getColName(int n) {
        return this.fcBitNames.get(n).toString();
    }

    public final String[] getColNamesArray() {
        return this.fcBitNames.toArray(new String[this.fcBitNames.size()]);
    }

    public final int getNumBitSets() {
        return this.fBitSets.length;
    }

    public final int getNumBits() {
        return this.fcBitNames.size();
    }

    @Override
    public final String getQuickInfo() {
        return this.fBitSets.length + "x" + this.fcBitNames.size();
    }

    public final Dataset or() {
        return new DefaultDataset(this.getName() + "_OR", this.orMatrix(), this.frBitSetNames, this.frBitSetNames, true, false, false, null);
    }

    public final Matrix orMatrix() {
        Matrix matrix = new Matrix(this.getNumBitSets(), this.getNumBitSets());
        for (int i2 = 0; i2 < this.getNumBitSets(); ++i2) {
            for (int i3 = 0; i3 < this.getNumBitSets(); ++i3) {
                BitSet bitSet = this.getBitSet(i2);
                bitSet.or(this.fBitSets[i3]);
                matrix.setElement(i2, i3, bitSet.cardinality());
            }
        }
        return matrix;
    }

    public final Dataset and(boolean bl) {
        return new DefaultDataset(this.getName() + "_AND", this.andMatrix(bl), this.frBitSetNames, this.frBitSetNames, true, false, false, null);
    }

    public final Matrix andMatrix(boolean bl) {
        Matrix matrix = new Matrix(this.getNumBitSets(), this.getNumBitSets());
        for (int i2 = 0; i2 < this.getNumBitSets(); ++i2) {
            for (int i3 = 0; i3 < this.getNumBitSets(); ++i3) {
                BitSet bitSet = this.getBitSet(i2);
                float f2 = bitSet.cardinality();
                bitSet.and(this.fBitSets[i3]);
                float f3 = bitSet.cardinality();
                if (bl) {
                    f3 /= f2;
                }
                matrix.setElement(i2, i3, f3);
            }
        }
        return matrix;
    }

    public final int[] andMatched(BitSetDataset bitSetDataset) {
        if (bitSetDataset.getNumBitSets() != this.getNumBitSets()) {
            throw new MismatchedSizeException("BitSetDataset " + this.getName(), this.getNumBitSets(), "BitSetDataset " + bitSetDataset.getName(), bitSetDataset.getNumBitSets());
        }
        int[] nArray = new int[bitSetDataset.getNumBitSets()];
        for (int i2 = 0; i2 < bitSetDataset.getNumBitSets(); ++i2) {
            BitSet bitSet = bitSetDataset.getBitSet(i2);
            BitSet bitSet2 = this.getBitSet(i2);
            bitSet.and(bitSet2);
            nArray[i2] = bitSet.cardinality();
        }
        return nArray;
    }

    public final Dataset and_by_or() {
        this.log.debug("Doing and_by_or");
        return this.and_by_or(this.getName() + "AND_BY_OR");
    }

    public final Dataset and_by_or(String string) {
        return new DefaultDataset(string, this.and_by_orMatrix(), this.frBitSetNames, this.frBitSetNames, true, false, false, null);
    }

    public final Matrix and_by_orMatrix() {
        Matrix matrix = this.orMatrix();
        Matrix matrix2 = new Matrix(this.andMatrix(false), false);
        matrix2.divide(matrix, true);
        return matrix2;
    }

    public final Dataset xor() {
        return new DefaultDataset(this.getName() + "_XOR", this.xorMatrix(), this.frBitSetNames, this.frBitSetNames, true, false, false, null);
    }

    public final Matrix xorMatrix() {
        Matrix matrix = new Matrix(this.getNumBitSets(), this.getNumBitSets());
        for (int i2 = 0; i2 < this.getNumBitSets(); ++i2) {
            for (int i3 = 0; i3 < this.getNumBitSets(); ++i3) {
                BitSet bitSet = this.getBitSet(i2);
                bitSet.xor(this.fBitSets[i3]);
                matrix.setElement(i2, i3, bitSet.cardinality());
            }
        }
        return matrix;
    }

    public final BooleanMatrix toBooleanMatrix() {
        BooleanMatrix booleanMatrix = new BooleanMatrix(this.getNumBits(), this.getNumBitSets());
        for (int i2 = 0; i2 < booleanMatrix.getNumRow(); ++i2) {
            for (int i3 = 0; i3 < booleanMatrix.getNumCol(); ++i3) {
                booleanMatrix.setElement(i2, i3, this.fBitSets[i3].get(i2));
            }
        }
        return booleanMatrix;
    }

    public final Matrix toMatrix(boolean bl, boolean bl2) {
        int n;
        int n2;
        if (bl) {
            n2 = 1;
            n = 0;
        } else {
            n2 = 0;
            n = 1;
        }
        return this.toMatrix(n2, n, bl2);
    }

    public final Matrix toMatrix(int n, int n2, boolean bl) {
        int n3 = this.getNumBits();
        if (bl) {
            ++n3;
        }
        Matrix matrix = new Matrix(this.getNumBitSets(), n3);
        for (int i2 = 0; i2 < this.getNumBitSets(); ++i2) {
            int n4;
            int n5 = 0;
            for (n4 = 0; n4 < this.getNumBits(); ++n4) {
                if (this.fBitSets[i2].get(n4)) {
                    matrix.setElement(i2, n4, n);
                    ++n5;
                    continue;
                }
                matrix.setElement(i2, n4, n2);
            }
            if (!bl) continue;
            matrix.setElement(i2, n4, n5);
        }
        return matrix;
    }

    public final Matrix toMatrix(RankedList rankedList, boolean bl, boolean bl2) {
        int n = this.getNumBits();
        if (bl2) {
            ++n;
        }
        Matrix matrix = new Matrix(this.getNumBitSets(), n);
        boolean bl3 = false;
        for (int i2 = 0; i2 < this.getNumBitSets(); ++i2) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this.getNumBits(); ++n2) {
                String string = this.getColName(n2);
                if (this.fBitSets[i2].get(n2)) {
                    if (bl) {
                        matrix.setElement(i2, n2, rankedList.getRank(string));
                    } else {
                        matrix.setElement(i2, n2, rankedList.getScore(string));
                    }
                    ++n3;
                    continue;
                }
                matrix.setElement(i2, n2, (float)bl3);
            }
            if (!bl2) continue;
            matrix.setElement(i2, n2, n3);
        }
        return matrix;
    }
}

