/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.ColorScheme;
import edu.mit.broad.genome.math.GraphMode;
import java.awt.Color;
import org.apache.log4j.Logger;

public class ColorDataset$Helper {
    private static final Logger klog = XLogger.getLogger(ColorDataset$Helper.class);

    public static final Color computeRelativeMeanColor(double d2, double d3, double d4, double d5, GraphMode graphMode, ColorScheme colorScheme, boolean bl) {
        if (bl && d2 == 0.0) {
            return Color.WHITE;
        }
        if (graphMode.isLinear()) {
            double d6 = 0.5;
            Color color = null;
            int n = -1;
            try {
                if (d2 < d3) {
                    d2 = d3;
                }
                if (d2 >= d4) {
                    d2 = d4;
                }
                d6 = (d2 - d3) / (d4 - d3);
                if (d5 != Double.NEGATIVE_INFINITY) {
                    d6 = d2 <= d5 ? 0.5 * (d2 - d3) / (d5 - d3) : 0.5 + 0.5 * (d2 - d5) / (d4 - d5);
                }
                if ((n = (int)(d6 * (double)colorScheme.getNumColors())) == colorScheme.getNumColors()) {
                    n = colorScheme.getNumColors() - 1;
                }
                color = colorScheme.getColor(n);
            }
            catch (Exception exception) {
                klog.error("ColorMatrix: Cval: " + d6 + " Xval: " + d2 + " Index: " + n + " Min: " + d3 + " Max: " + d4 + " Mean: " + d5, exception);
            }
            return color;
        }
        if (graphMode.IsLog()) {
            return colorScheme.getMinColor();
        }
        throw new IllegalStateException("Unknown GraphMode: " + graphMode);
    }

    public static final Color computeRelativeMedianColor(double d2, double d3, double d4, double d5, GraphMode graphMode, ColorScheme colorScheme) {
        if (graphMode.isLinear()) {
            double d6 = 0.5;
            Color color = null;
            int n = -1;
            try {
                if (d2 < d3) {
                    d2 = d3;
                }
                if (d2 >= d4) {
                    d2 = d4;
                }
                d6 = (d2 - d3) / (d4 - d3);
                if (d5 != Double.NEGATIVE_INFINITY) {
                    d6 = d2 <= d5 ? 0.5 * (d2 - d3) / (d5 - d3) : 0.5 + 0.5 * (d2 - d5) / (d4 - d5);
                }
                if ((n = (int)(d6 * (double)colorScheme.getNumColors())) == colorScheme.getNumColors()) {
                    n = colorScheme.getNumColors() - 1;
                }
                color = colorScheme.getColor(n);
            }
            catch (Exception exception) {
                klog.error("ColorMatrix: Cval: " + d6 + " Xval: " + d2 + " Index: " + n + " Min: " + d3 + " Max: " + d4 + " Median: " + d5, exception);
            }
            return color;
        }
        if (graphMode.IsLog()) {
            return colorScheme.getMinColor();
        }
        throw new IllegalStateException("Unknown graphmode: " + graphMode);
    }

    public static final Color computeAbsoluteColor(float f2, GraphMode graphMode, ColorScheme colorScheme) {
        if (graphMode.isLinear()) {
            float f3 = 0.0f;
            float f4 = 8000.0f;
            float f5 = Float.NEGATIVE_INFINITY;
            float f6 = 0.5f;
            Color color = null;
            int n = -1;
            try {
                if (f2 < f3) {
                    f2 = f3;
                }
                if (f2 >= f4) {
                    f2 = f4;
                }
                f6 = (f2 - f3) / (f4 - f3);
                if (f5 != Float.NEGATIVE_INFINITY) {
                    f6 = f2 <= f5 ? 0.5f * (f2 - f3) / (f5 - f3) : 0.5f + 0.5f * (f2 - f5) / (f4 - f5);
                }
                if ((n = (int)(f6 * (float)colorScheme.getNumColors())) == colorScheme.getNumColors()) {
                    n = colorScheme.getNumColors() - 1;
                }
                color = colorScheme.getColor(n);
            }
            catch (Exception exception) {
                klog.error("ColorMatrix: Cval: " + f6 + " Xval: " + f2 + " Index: " + n + " Min: " + f3 + " Max: " + f4 + " Mean: " + f5, exception);
            }
            return color;
        }
        if (graphMode.IsLog()) {
            return colorScheme.getMinColor();
        }
        throw new IllegalStateException("Unknown GraphMode:" + graphMode);
    }
}

