/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.ColorScheme;
import edu.mit.broad.genome.math.ColorSchemes$BroadCancer;
import edu.mit.broad.genome.math.GraphMode;
import edu.mit.broad.genome.math.Orientation;
import edu.mit.broad.genome.math.ScaleMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.ColorDataset;
import edu.mit.broad.genome.objects.ColorDataset$Helper;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DatasetProxy;
import java.awt.Color;

public class ColorDatasetImpl
extends DatasetProxy
implements ColorDataset {
    protected ScaleMode fScaleMode;
    protected Orientation fOrientType;
    protected ColorScheme fColorScheme;
    protected GraphMode fGraphMode;
    private Color[][] fColors;

    public ColorDatasetImpl(Dataset dataset, ScaleMode scaleMode, ColorScheme colorScheme, Orientation orientation, GraphMode graphMode) {
        super("colored." + dataset.getName(), dataset);
        this.fScaleMode = scaleMode;
        this.fColorScheme = colorScheme;
        this.fOrientType = orientation;
        this.fGraphMode = graphMode;
        this.cacheColors();
    }

    public ColorDatasetImpl(Dataset dataset) {
        this(dataset, DEFAULT_SCALE_MODE, DEFAULT_COLOR_SCHEME, DEFAULT_ORIENTATION, DEFAULT_GRAPH_MODE);
    }

    public ColorDatasetImpl(ColorDataset colorDataset, ScaleMode scaleMode) {
        this(colorDataset, scaleMode, colorDataset.getColorScheme(), colorDataset.getOrientation(), colorDataset.getGraphMode());
    }

    public ColorDatasetImpl(ColorDataset colorDataset, Orientation orientation) {
        this(colorDataset, colorDataset.getScaleMode(), colorDataset.getColorScheme(), orientation, colorDataset.getGraphMode());
    }

    public ColorDatasetImpl(ColorDataset colorDataset, GraphMode graphMode) {
        this(colorDataset, colorDataset.getScaleMode(), colorDataset.getColorScheme(), colorDataset.getOrientation(), graphMode);
    }

    public ColorDatasetImpl(ColorDataset colorDataset, ColorScheme colorScheme) {
        this(colorDataset, colorDataset.getScaleMode(), colorScheme, colorDataset.getOrientation(), colorDataset.getGraphMode());
    }

    public ColorDatasetImpl(Dataset dataset, ScaleMode scaleMode) {
        this(dataset, scaleMode, DEFAULT_COLOR_SCHEME, DEFAULT_ORIENTATION, DEFAULT_GRAPH_MODE);
    }

    public ColorDatasetImpl(Dataset dataset, ColorScheme colorScheme) {
        this(dataset, DEFAULT_SCALE_MODE, colorScheme, DEFAULT_ORIENTATION, DEFAULT_GRAPH_MODE);
    }

    public ColorDatasetImpl(Dataset dataset, ScaleMode scaleMode, ColorScheme colorScheme) {
        this(dataset, scaleMode, colorScheme, DEFAULT_ORIENTATION, DEFAULT_GRAPH_MODE);
    }

    public ColorDatasetImpl(Dataset dataset, Orientation orientation) {
        this(dataset, DEFAULT_SCALE_MODE, DEFAULT_COLOR_SCHEME, orientation, DEFAULT_GRAPH_MODE);
    }

    public ColorDatasetImpl(Dataset dataset, GraphMode graphMode) {
        this(dataset, DEFAULT_SCALE_MODE, DEFAULT_COLOR_SCHEME, DEFAULT_ORIENTATION, graphMode);
    }

    @Override
    public final ColorDataset cloneState(Dataset dataset) {
        ColorDatasetImpl colorDatasetImpl = new ColorDatasetImpl(dataset);
        colorDatasetImpl.setColorScheme(this.fColorScheme);
        colorDatasetImpl.setGraphMode(this.fGraphMode);
        colorDatasetImpl.setOrientType(this.fOrientType);
        colorDatasetImpl.setScaleMode(this.fScaleMode);
        return colorDatasetImpl;
    }

    @Override
    public final Orientation getOrientation() {
        return this.fOrientType;
    }

    @Override
    public final GraphMode getGraphMode() {
        return this.fGraphMode;
    }

    @Override
    public final ScaleMode getScaleMode() {
        return this.fScaleMode;
    }

    protected final void cacheColors() {
        if (this.fOrientType.isByRow()) {
            this.cacheColorsByRow();
        } else if (this.fOrientType.isByCol()) {
            this.cacheColorsByColumn();
        } else {
            throw new IllegalStateException("Unknown orientType option: " + this.fOrientType);
        }
    }

    protected final void cacheColorsByRow() {
        this.fColors = new Color[this.getNumRow()][this.getNumCol()];
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            Vector vector = this.getRow(i2);
            Vector vector2 = vector.toVectorNaNless();
            if (this.fScaleMode.isRelative()) {
                double d2 = vector2.meanOrMedian(this.fScaleMode.isMean());
                double d3 = vector2.max();
                double d4 = vector2.min();
                for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                    if (this.fScaleMode.isMean()) {
                        boolean bl = false;
                        if (this.fScaleMode == ScaleMode.REL_MEAN_ZERO_OMITTED) {
                            bl = true;
                        }
                        this.fColors[i2][i3] = ColorDataset$Helper.computeRelativeMeanColor(this.getElement(i2, i3), d4, d3, d2, this.fGraphMode, this.fColorScheme, bl);
                        continue;
                    }
                    this.fColors[i2][i3] = ColorDataset$Helper.computeRelativeMedianColor(this.getElement(i2, i3), d4, d3, d2, this.fGraphMode, this.fColorScheme);
                }
                continue;
            }
            for (int i4 = 0; i4 < this.getNumCol(); ++i4) {
                this.fColors[i2][i4] = ColorDataset$Helper.computeAbsoluteColor(this.getElement(i2, i4), this.fGraphMode, this.fColorScheme);
            }
        }
    }

    protected final void cacheColorsByColumn() {
        this.log.info("Beginning to cache fColors by COL from: " + this.getClass());
        this.fColors = new Color[this.getNumRow()][this.getNumCol()];
        for (int i2 = 0; i2 < this.getNumCol(); ++i2) {
            Vector vector = this.getColumn(i2);
            if (this.fScaleMode.isRelative()) {
                double d2 = vector.mean();
                double d3 = vector.median();
                double d4 = vector.max();
                double d5 = vector.min();
                for (int i3 = 0; i3 < this.getNumRow(); ++i3) {
                    this.fColors[i3][i2] = this.fScaleMode.isMean() ? ColorDataset$Helper.computeRelativeMeanColor(this.getElement(i3, i2), d5, d4, d2, this.fGraphMode, this.fColorScheme, false) : ColorDataset$Helper.computeRelativeMedianColor(this.getElement(i3, i2), d5, d4, d3, this.fGraphMode, this.fColorScheme);
                }
                continue;
            }
            for (int i4 = 0; i4 < this.getNumRow(); ++i4) {
                this.fColors[i4][i2] = ColorDataset$Helper.computeAbsoluteColor(this.getElement(i4, i2), this.fGraphMode, this.fColorScheme);
            }
        }
        this.log.info("Finished caching Colors: " + this.getClass());
    }

    @Override
    public final Color getColor(int n, int n2) {
        return this.fColors[n][n2];
    }

    public final void setColorScheme(ColorScheme colorScheme) {
        this.fColorScheme = colorScheme;
        this.cacheColors();
    }

    @Override
    public final ColorScheme getColorScheme() {
        return this.fColorScheme;
    }

    public final void setDefaultColorScheme() {
        this.fColorScheme = new ColorSchemes$BroadCancer();
        this.cacheColors();
    }

    public final void setScaleMode(ScaleMode scaleMode) {
        this.fScaleMode = scaleMode;
        this.cacheColors();
    }

    public final void setOrientType(Orientation orientation) {
        this.fOrientType = orientation;
        this.cacheColors();
    }

    public final void setGraphMode(GraphMode graphMode) {
        this.fGraphMode = graphMode;
        this.cacheColors();
    }

    public static final Color[] createColors(Vector vector, ColorScheme colorScheme) {
        double d2 = vector.min();
        double d3 = vector.max();
        double d4 = vector.mean();
        Color[] colorArray = new Color[vector.getSize()];
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            float f2 = vector.getElement(i2);
            double d5 = ((double)f2 - d2) / (d3 - d2);
            d5 = (double)f2 <= d4 ? 0.5 * ((double)f2 - d2) / (d4 - d2) : 0.5 + 0.5 * ((double)f2 - d4) / (d3 - d4);
            int n = (int)(d5 * (double)colorScheme.getNumColors());
            if (n == colorScheme.getNumColors()) {
                n = colorScheme.getNumColors() - 1;
            }
            colorArray[i2] = colorScheme.getColor(n);
        }
        return colorArray;
    }
}

