/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.IDataframe$Helper;
import edu.mit.broad.genome.utils.ArrayUtils;
import edu.mit.broad.genome.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Dataframe
extends AbstractObject
implements IDataframe {
    private Matrix fMatrix;
    private List fRowNames;
    private List fColNames;

    protected Dataframe() {
    }

    public final Dataframe cloneShallow(String string) {
        super.setName(string);
        return this;
    }

    public Dataframe(String string, Matrix matrix, List list, List list2, boolean bl) {
        this(string, matrix, list, list2, bl, bl, bl);
    }

    public Dataframe(String string, Matrix matrix, List list, boolean bl) {
        this(string, matrix, CollectionUtils.createSeriesStrings(0, matrix.getNumRow()), list, bl, true, bl);
    }

    public Dataframe(String string, Matrix matrix, boolean bl, List list) {
        this(string, matrix, list, CollectionUtils.createSeriesStrings(0, matrix.getNumCol()), bl, bl, true);
    }

    public Dataframe(String string, Matrix matrix, String[] stringArray, boolean bl) {
        this(string, matrix, CollectionUtils.createSeriesStrings(0, matrix.getNumRow()), ArrayUtils.toList(stringArray), bl, true, true);
    }

    public Dataframe(String string, Matrix matrix, boolean bl) {
        this(string, matrix, CollectionUtils.createSeriesStrings(0, matrix.getNumRow()), CollectionUtils.createSeriesStrings(0, matrix.getNumCol(), "col_"), true, true, bl);
    }

    public Dataframe(String string, Matrix matrix, String[] stringArray, List arrayList, boolean bl, boolean bl2) {
        if (matrix == null) {
            throw new NullPointerException("Dataset matrix cant be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Param rowNames cannot be null");
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("Param colNames cannot be null");
        }
        Matrix matrix2 = bl ? matrix : matrix.cloneDeep();
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList2.add(stringArray[i2]);
        }
        ArrayList arrayList3 = bl2 ? arrayList : new ArrayList(arrayList);
        this.init(string, matrix2, arrayList2, arrayList3);
    }

    public Dataframe(String string, Dataframe[] dataframeArray) {
        if (dataframeArray == null) {
            throw new NullPointerException("Paramters dfs cant be null");
        }
        Matrix[] matrixArray = new Matrix[dataframeArray.length];
        for (int i2 = 0; i2 < dataframeArray.length; ++i2) {
            if (dataframeArray[i2] == null) {
                throw new IllegalArgumentException("Dataframe cannot be null at: " + i2);
            }
            matrixArray[i2] = dataframeArray[i2].getMatrix();
        }
        Matrix matrix = new Matrix(matrixArray, false);
        ArrayList arrayList = new ArrayList(dataframeArray[0].getRowNames());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i3 = 0; i3 < dataframeArray.length; ++i3) {
            String[] stringArray = dataframeArray[i3].getColumnNamesArray();
            for (int i4 = 0; i4 < stringArray.length; ++i4) {
                arrayList2.add(stringArray[i3] + "_" + dataframeArray[i3].getName());
            }
        }
        this.init(string, matrix, arrayList, arrayList2);
    }

    public Dataframe(String string, Matrix matrix, List arrayList, String[] stringArray, boolean bl, boolean bl2) {
        if (matrix == null) {
            throw new NullPointerException("Dataset matrix cant be null");
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("Param rowNames cannot be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Param colNames cannot be null");
        }
        Matrix matrix2 = bl ? matrix : matrix.cloneDeep();
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList2.add(stringArray[i2]);
        }
        ArrayList arrayList3 = bl2 ? arrayList : new ArrayList(arrayList);
        this.init(string, matrix2, arrayList3, arrayList2);
    }

    public Dataframe(String string, Matrix matrix, String[] stringArray, String[] stringArray2, boolean bl) {
        int n;
        if (matrix == null) {
            throw new NullPointerException("Dataset matrix cant be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Param rowNames cannot be null");
        }
        if (stringArray2 == null) {
            throw new IllegalArgumentException("Param colNames cannot be null");
        }
        Matrix matrix2 = bl ? matrix : matrix.cloneDeep();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray2.length);
        for (n = 0; n < stringArray2.length; ++n) {
            arrayList.add(stringArray2[n]);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            arrayList2.add(stringArray[n]);
        }
        this.init(string, matrix2, arrayList2, arrayList);
    }

    public Dataframe(String string, Matrix matrix, List arrayList, List arrayList2, boolean bl, boolean bl2, boolean bl3) {
        if (matrix == null) {
            throw new IllegalArgumentException("Param matrix cant be null");
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("Param rownames cant be null");
        }
        if (arrayList2 == null) {
            throw new IllegalArgumentException("Param rownames cant be null");
        }
        Matrix matrix2 = bl ? matrix : matrix.cloneDeep();
        ArrayList arrayList3 = bl2 ? arrayList : new ArrayList(arrayList);
        ArrayList arrayList4 = bl3 ? arrayList2 : new ArrayList(arrayList2);
        this.init(string, matrix2, arrayList3, arrayList4);
    }

    private void init(String string, Matrix matrix, List list, List list2) {
        super.initialize(string);
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix cannot be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("rowNames cannot be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("colNames cannot be null");
        }
        if (matrix.getNumRow() != list.size()) {
            throw new IllegalArgumentException("Matrix numrow: " + matrix.getNumRow() + " and rowNames: " + list.size() + " do not match in size");
        }
        if (matrix.getNumCol() != list2.size()) {
            throw new IllegalArgumentException("Matrix numcol: " + matrix.getNumCol() + " and colNames: " + list2.size() + " do not match in size");
        }
        this.fMatrix = matrix;
        this.fMatrix.setImmutable();
        this.fRowNames = Collections.unmodifiableList(list);
        this.fColNames = Collections.unmodifiableList(list2);
    }

    public final Vector getRow(int n) {
        return this.fMatrix.getRowV(n);
    }

    public final Vector getRow(String string) {
        int n = this.getRowIndex(string);
        if (n == -1) {
            throw new IllegalArgumentException("No such rowName: " + string + " \n" + this.getRowNames());
        }
        return this.fMatrix.getRowV(n);
    }

    public final Vector getColumn(int n) {
        return this.fMatrix.getColumnV(n);
    }

    @Override
    public final String[] getColumnAsStrings(int n) {
        return IDataframe$Helper.getColumnAsStrings((IDataframe)this, n);
    }

    @Override
    public final String[] getColumnAsStrings(String string) {
        return IDataframe$Helper.getColumnAsStrings((IDataframe)this, string);
    }

    public final float getElement(int n, int n2) {
        return this.fMatrix.getElement(n, n2);
    }

    @Override
    public final Object getElementObj(int n, int n2) {
        return new Float(this.fMatrix.getElement(n, n2));
    }

    @Override
    public final String getRowName(int n) {
        return (String)this.fRowNames.get(n);
    }

    @Override
    public final List getRowNames() {
        return Collections.unmodifiableList(this.fRowNames);
    }

    @Override
    public final int getRowIndex(String string) {
        return this.fRowNames.indexOf(string);
    }

    @Override
    public final String[] getRowNamesArray() {
        return this.fRowNames.toArray(new String[this.fRowNames.size()]);
    }

    @Override
    public final List getColumnNames() {
        return Collections.unmodifiableList(this.fColNames);
    }

    @Override
    public final int getColumnIndex(String string) {
        return this.fColNames.indexOf(string);
    }

    @Override
    public final String[] getColumnNamesArray() {
        return this.fColNames.toArray(new String[this.fColNames.size()]);
    }

    @Override
    public final String getColumnName(int n) {
        return (String)this.fColNames.get(n);
    }

    @Override
    public final int getNumRow() {
        return this.fMatrix.getNumRow();
    }

    @Override
    public final int getNumCol() {
        return this.fMatrix.getNumCol();
    }

    public final Matrix getMatrix() {
        this.fMatrix.setImmutable();
        return this.fMatrix;
    }

    public final Dataset toDataset(String string) {
        return new DefaultDataset(string, this.fMatrix, this.fRowNames, this.fColNames, false, null);
    }

    public final Dataset toDataset(boolean bl) {
        return new DefaultDataset(this.getName(), this.fMatrix, this.fRowNames, this.fColNames, bl, null);
    }

    public final Dataframe addColumn(String string, String string2, Vector vector) {
        int n;
        Matrix matrix = new Matrix(this.getNumRow(), this.getNumCol() + 1);
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            for (n = 0; n < this.getNumCol(); ++n) {
                matrix.setElement(i2, n, this.getElement(i2, n));
            }
            matrix.setElement(i2, n, vector.getElement(i2));
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.getNumCol() + 1);
        for (n = 0; n < this.getNumCol(); ++n) {
            arrayList.add(this.getColumnName(n));
        }
        arrayList.add(string2);
        return new Dataframe(string, matrix, this.getRowNames(), arrayList, true, false, true);
    }

    @Override
    public final String getQuickInfo() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getNumRow()).append('x').append(this.getNumCol());
        return stringBuffer.toString();
    }
}

