/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.APMMatrix;
import edu.mit.broad.genome.objects.AbstractDataset;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.AnnotImpl;
import edu.mit.broad.genome.objects.ColorMap$Rows;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.FeatureAnnotImpl;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.parsers.GctParser;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.utils.ArrayUtils;
import edu.mit.broad.genome.utils.CollectionUtils;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DefaultDataset
extends AbstractDataset {
    private Matrix fMatrix;
    private List fRowNames;
    private List fColNames;
    private GeneSet fColNamesGeneSet;
    private GeneSet rowNamesGeneSet;
    private Annot fAnn;
    private File dsFile;
    private String fQuickInfo;
    private APMMatrix fAPMMatrix;
    private TObjectIntHashMap fRowIndexNameHashMap;

    public final APMMatrix getAPMMatrix() {
        return this.fAPMMatrix;
    }

    public final boolean hasAPMCalls() {
        return this.fAPMMatrix != null;
    }

    @Override
    public final Dataset cloneShallow(String string) {
        super.setName(string);
        return this;
    }

    public final Dataset cloneShallow(APMMatrix aPMMatrix) {
        if (this.fAPMMatrix != null) {
            this.log.warn("Overwriting extant APM with: " + aPMMatrix);
        }
        this.fAPMMatrix = aPMMatrix;
        return this;
    }

    public final Dataset cloneShallow(String[] stringArray) {
        return this.cloneShallow(this.getName(), stringArray);
    }

    public final Dataset cloneShallow(Map map) {
        Errors errors = new Errors("Missing col names");
        String[] stringArray = new String[this.getNumCol()];
        for (int i2 = 0; i2 < this.getNumCol(); ++i2) {
            Object v = map.get(this.getColumnName(i2));
            if (v == null) {
                errors.add(">" + this.getColumnName(i2) + "<");
                continue;
            }
            stringArray[i2] = v.toString();
        }
        errors.barfIfNotEmptyRuntime();
        return this.cloneShallow(this.getName(), stringArray);
    }

    public final Dataset cloneShallow(String string, String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Param newColNames cannot be null");
        }
        this.fColNames = DefaultDataset.toList(stringArray);
        super.setName(string);
        return this;
    }

    public final Dataset cloneShallow(Annot annot) {
        this.fAnn = annot;
        this._setQuickInfo();
        return this;
    }

    protected DefaultDataset() {
    }

    public DefaultDataset(String string, Dataset dataset) {
        APMMatrix aPMMatrix;
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset param cant be null");
        }
        Matrix matrix = dataset.getMatrix().cloneDeep();
        APMMatrix aPMMatrix2 = null;
        if (dataset instanceof DefaultDataset && (aPMMatrix = ((DefaultDataset)dataset).getAPMMatrix()) != null) {
            aPMMatrix2 = new APMMatrix(aPMMatrix, false);
        }
        this.init(string, matrix, dataset.getRowNames(), dataset.getColumnNames(), dataset.getAnnot(), aPMMatrix2);
    }

    public DefaultDataset(String string, RankedList[] rankedListArray) {
        ArrayList arrayList = new ArrayList(rankedListArray[0].getRankedNames());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = rankedListArray[0].getSize();
        Matrix matrix = new Matrix(n, rankedListArray.length);
        for (int i2 = 0; i2 < rankedListArray.length; ++i2) {
            arrayList2.add(rankedListArray[i2].getName());
            for (int i3 = 0; i3 < n; ++i3) {
                matrix.setElement(i3, i2, rankedListArray[i2].getScore(arrayList.get(i3).toString()));
            }
        }
        this.init(string, matrix, arrayList, arrayList2, null);
    }

    public DefaultDataset(String string, LabelledVector[] labelledVectorArray) {
        ArrayList arrayList = new ArrayList(labelledVectorArray[0].getLabels());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = labelledVectorArray[0].getSize();
        Matrix matrix = new Matrix(n, labelledVectorArray.length);
        for (int i2 = 0; i2 < labelledVectorArray.length; ++i2) {
            arrayList2.add(labelledVectorArray[i2].getName());
            for (int i3 = 0; i3 < n; ++i3) {
                matrix.setElement(i3, i2, labelledVectorArray[i2].getScore(arrayList.get(i3).toString()));
            }
        }
        this.init(string, matrix, arrayList, arrayList2, null);
    }

    public DefaultDataset(String string, Dataset[] datasetArray, boolean bl) {
        if (datasetArray == null) {
            throw new IllegalArgumentException("Param dss cant be null");
        }
        if (bl) {
            throw new NotImplementedException();
        }
        Matrix[] matrixArray = new Matrix[datasetArray.length];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            matrixArray[i2] = datasetArray[i2].getMatrix();
            for (int i3 = 0; i3 < datasetArray[i2].getNumCol(); ++i3) {
                arrayList.add(datasetArray[i2].getColumnName(i3) + "_ds" + i2);
            }
        }
        Matrix matrix = new Matrix(matrixArray, bl);
        this.init(string, matrix, datasetArray[0].getRowNames(), arrayList, null);
    }

    public DefaultDataset(String string, ScoredDataset scoredDataset) {
        if (scoredDataset == null) {
            throw new IllegalArgumentException("Dataset param cant be null");
        }
        Matrix matrix = scoredDataset.getMatrix().cloneDeep();
        ArrayList arrayList = new ArrayList(scoredDataset.getRankedNames());
        ArrayList arrayList2 = new ArrayList(scoredDataset.getColumnNames());
        this.init(string, matrix, arrayList, arrayList2, scoredDataset.getAnnot());
    }

    public DefaultDataset(String string, Matrix matrix, List list, List list2, boolean bl, Annot annot) {
        this(string, matrix, list, list2, bl, bl, bl, annot);
    }

    public DefaultDataset(String string, Matrix matrix, List list, List list2, boolean bl, Annot annot, APMMatrix aPMMatrix) {
        this(string, matrix, list, list2, bl, bl, bl, annot, aPMMatrix);
    }

    public DefaultDataset(String string, Matrix matrix, List list, boolean bl, boolean bl2, Annot annot) {
        this(string, matrix, list, CollectionUtils.createSeriesStrings(0, matrix.getNumCol()), bl, bl2, true, annot);
    }

    public DefaultDataset(String string, Matrix matrix, String[] stringArray, String[] stringArray2, boolean bl) {
        this(string, matrix, stringArray, stringArray2, bl, null);
    }

    public DefaultDataset(String string, Matrix matrix, String[] stringArray, String[] stringArray2, boolean bl, Annot annot) {
        this(string, matrix, DefaultDataset.toList(stringArray), DefaultDataset.toList(stringArray2), bl, true, true, annot);
    }

    public DefaultDataset(String string, Matrix matrix, String[] stringArray, String[] stringArray2, boolean bl, Annot annot, APMMatrix aPMMatrix) {
        this(string, matrix, DefaultDataset.toList(stringArray), DefaultDataset.toList(stringArray2), bl, true, true, annot, aPMMatrix);
    }

    public DefaultDataset(String string, Matrix matrix, Annot annot) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(matrix.getNumRow());
        ArrayList<String> arrayList2 = new ArrayList<String>(matrix.getNumCol());
        for (n = 0; n < matrix.getNumRow(); ++n) {
            arrayList.add("row_" + n);
        }
        for (n = 0; n < matrix.getNumCol(); ++n) {
            arrayList2.add("col_" + n);
        }
        this.init(string, matrix, arrayList, arrayList2, annot);
    }

    public DefaultDataset(File file, Annot annot, APMMatrix aPMMatrix) {
        List[] listArray = new GctParser().parseRowAndColNamesOnly(file);
        this.init_rows_and_cols(NamingConventions.removeExtension(file.getName()), listArray[0], listArray[1], annot, aPMMatrix);
        this.dsFile = file;
    }

    public DefaultDataset(String string, Matrix matrix, List list, List list2, boolean bl, boolean bl2, boolean bl3, Annot annot) {
        this(string, matrix, list, list2, bl, bl2, bl3, annot, null);
    }

    public DefaultDataset(String string, Matrix matrix, List arrayList, List arrayList2, boolean bl, boolean bl2, boolean bl3, Annot annot, APMMatrix aPMMatrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("Param matrix cant be null");
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("Param rowNames cant be null");
        }
        if (arrayList2 == null) {
            throw new IllegalArgumentException("Param colNames cant be null");
        }
        Matrix matrix2 = bl ? matrix : matrix.cloneDeep();
        ArrayList arrayList3 = bl2 ? arrayList : new ArrayList(arrayList);
        ArrayList arrayList4 = bl3 ? arrayList2 : new ArrayList(arrayList2);
        this.init(string, matrix2, arrayList3, arrayList4, annot, aPMMatrix);
    }

    public DefaultDataset(String string, int[] nArray, int[] nArray2, Dataset dataset) {
        this._row_col_array_based_constructor(string, nArray, nArray2, dataset);
    }

    private void _row_col_array_based_constructor(String string, int[] nArray, int[] nArray2, Dataset dataset) {
        int n;
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset param cant be null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("rowIndices param cant be null");
        }
        if (nArray2 == null) {
            throw new IllegalArgumentException("colIndices param cant be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>(nArray.length);
        ArrayList<String> arrayList2 = new ArrayList<String>(nArray2.length);
        Matrix matrix = new Matrix(nArray.length, nArray2.length);
        for (n = 0; n < nArray.length; ++n) {
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                matrix.setElement(n, i2, dataset.getElement(nArray[n], nArray2[i2]));
            }
            arrayList.add(dataset.getRowName(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            arrayList2.add(dataset.getColumnName(nArray2[n]));
        }
        this.init(string, matrix, arrayList, arrayList2, dataset.getAnnot());
    }

    public DefaultDataset(String string, int[] nArray, Dataset dataset) {
        this._row_array_based_constructor(string, nArray, dataset);
    }

    private void _row_array_based_constructor(String string, int[] nArray, Dataset dataset) {
        this._row_col_array_based_constructor(string, nArray, ArrayUtils.fill(0, dataset.getNumCol() - 1, 1), dataset);
    }

    public DefaultDataset(String string, int n, int n2, Dataset dataset) {
        this(string, ArrayUtils.fill(n, n2, 1), ArrayUtils.fill(0, dataset.getNumCol() - 1, 1), dataset);
    }

    public DefaultDataset(String string, int n, Dataset dataset) {
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i2 = 0; i2 < dataset.getNumRow(); i2 += n) {
            tIntArrayList.add(i2);
        }
        this._row_array_based_constructor(string, tIntArrayList.toNativeArray(), dataset);
    }

    protected final void init(String string, Matrix matrix, List list, List list2, Annot annot) {
        this.init(string, matrix, list, list2, annot, null);
    }

    protected final void init(String string, Matrix matrix, List list, List list2, Annot annot, APMMatrix aPMMatrix) {
        this.init_rows_and_cols(string, list, list2, annot, aPMMatrix);
        this.initMatrix(matrix, list, list2);
    }

    private void initMatrix(Matrix matrix, List list, List list2) {
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix cannot be null");
        }
        if (matrix.getNumRow() != list.size()) {
            throw new IllegalArgumentException("Matrix nrows: " + matrix.getNumRow() + " and rownames: " + list.size() + " do not match in size");
        }
        if (matrix.getNumCol() != list2.size()) {
            throw new IllegalArgumentException("Matrix ncols: " + matrix.getNumCol() + " and colnames: " + list2.size() + " do not match in size");
        }
        this.fMatrix = matrix;
        this.fMatrix.setImmutable();
    }

    protected final void init_rows_and_cols(String string, List list, List list2, Annot annot, APMMatrix aPMMatrix) {
        super.initialize(string);
        if (list == null) {
            throw new IllegalArgumentException("rowNames cannot be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("colNames cannot be null");
        }
        this.fRowNames = list;
        this.fRowNames = Collections.unmodifiableList(this.fRowNames);
        this.fColNames = list2;
        this.fColNames = Collections.unmodifiableList(this.fColNames);
        if (annot != null) {
            FeatureAnnot featureAnnot = annot.getFeatureAnnot();
            if (featureAnnot.getNumFeatures() < this.fRowNames.size()) {
                throw new IllegalArgumentException("Annot features is less than dataset rowNames: " + featureAnnot.getNumFeatures() + " " + this.fRowNames.size());
            }
            if (featureAnnot.hasNativeDescriptions() && this.fRowNames.size() > 1) {
                featureAnnot.getNativeDesc(this.fRowNames.get(0).toString());
            }
        }
        this.fAnn = annot;
        DefaultDataset.ensureAllUniqueValues(this.fColNames);
        this.fAPMMatrix = aPMMatrix;
    }

    protected static final void ensureAllUniqueValues(List list) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (hashSet.contains(e2)) {
                throw new IllegalArgumentException("Duplicate COL names are NOT allowed in Datasets. The offending entry was: " + e2 + " at pos: " + i2);
            }
            hashSet.add(e2);
        }
        hashSet.clear();
    }

    @Override
    public final Annot getAnnot() {
        if (this.fAnn == null) {
            ColorMap$Rows colorMap$Rows = null;
            FeatureAnnotImpl featureAnnotImpl = new FeatureAnnotImpl(this.getName(), this.fRowNames, null, colorMap$Rows);
            SampleAnnotImpl sampleAnnotImpl = new SampleAnnotImpl(this.getName(), this.getColumnNames(), null);
            this.fAnn = new AnnotImpl(featureAnnotImpl, sampleAnnotImpl);
        }
        return this.fAnn;
    }

    @Override
    public final String getRowName(int n) {
        return (String)this.fRowNames.get(n);
    }

    @Override
    public final List getRowNames() {
        return Collections.unmodifiableList(this.fRowNames);
    }

    @Override
    public final int getRowIndex(String string) {
        int n;
        if (string == null) {
            throw new IllegalArgumentException("rowName cannot be null: " + string);
        }
        if (this.fRowIndexNameHashMap == null) {
            this.fRowIndexNameHashMap = new TObjectIntHashMap();
            for (n = 0; n < this.fRowNames.size(); ++n) {
                this.fRowIndexNameHashMap.put(this.fRowNames.get(n), n);
            }
        }
        if ((n = this.fRowIndexNameHashMap.get(string)) == 0 && !this.fRowIndexNameHashMap.containsKey(string)) {
            n = -1;
            return -1;
        }
        return n;
    }

    @Override
    public final String[] getRowNamesArray() {
        return this.fRowNames.toArray(new String[this.fRowNames.size()]);
    }

    @Override
    public final List getColumnNames() {
        return Collections.unmodifiableList(this.fColNames);
    }

    @Override
    public final List getColumnNames(Template template) {
        ArrayList<String> arrayList = new ArrayList<String>(this.fColNames);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            arrayList.set(i2, template.getClassByProfilePos(i2).getName() + "_" + arrayList.get(i2));
        }
        return arrayList;
    }

    @Override
    public final GeneSet getColumnNamesGeneSet() {
        if (this.fColNamesGeneSet == null) {
            this.fColNamesGeneSet = new FSet(this.getName(), new HashSet(this.fColNames));
        }
        return this.fColNamesGeneSet;
    }

    @Override
    public final GeneSet getRowNamesGeneSet() {
        if (this.rowNamesGeneSet == null) {
            this.rowNamesGeneSet = new FSet(this.getName(), new HashSet(this.fRowNames));
        }
        return this.rowNamesGeneSet;
    }

    @Override
    public final int getColumnIndex(String string) {
        return this.fColNames.indexOf(string);
    }

    @Override
    public final String[] getColumnNamesArray() {
        return this.fColNames.toArray(new String[this.fColNames.size()]);
    }

    @Override
    public final String getColumnName(int n) {
        return (String)this.fColNames.get(n);
    }

    @Override
    public final int getNumRow() {
        return this.fRowNames.size();
    }

    @Override
    public final int getNumCol() {
        return this.fColNames.size();
    }

    @Override
    public final Vector getRow(String string) {
        return this.getRow(this.getRowIndex(string));
    }

    @Override
    public final Vector[] getRows(GeneSet geneSet) {
        Vector[] vectorArray = new Vector[geneSet.getNumMembers()];
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            vectorArray[i2] = this.getRow(geneSet.getMember(i2));
        }
        return vectorArray;
    }

    @Override
    public final Vector getColumn(String string) {
        return this.getColumn(this.getColumnIndex(string));
    }

    @Override
    public final Vector[] getColumns(String[] stringArray) {
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            vectorArray[i2] = this.getColumn(stringArray[i2]);
        }
        return vectorArray;
    }

    @Override
    public final Vector getColumn(int n, GeneSet geneSet) {
        Vector vector = new Vector(geneSet.getNumMembers());
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            vector.setElement(i2, this.getElement(geneSet.getMember(i2), n));
        }
        return vector;
    }

    @Override
    public final Vector getColumn(String string, GeneSet geneSet) {
        return this.getColumn(this.getColumnIndex(string), geneSet);
    }

    @Override
    public final LabelledVector getColumnLV(String string) {
        return this.getColumnLV(this.getColumnIndex(string));
    }

    @Override
    public final LabelledVector getColumnLV(int n) {
        return new LabelledVector(this.getColumnName(n), this.getRowNamesArray(), this._matrix().getColumnV(n));
    }

    @Override
    public final float getElement(int n, int n2) {
        return this._matrix().getElement(n, n2);
    }

    @Override
    public final Vector getRow(int n) {
        return this._matrix().getRowV(n);
    }

    @Override
    public final Vector getColumn(int n) {
        return this._matrix().getColumnV(n);
    }

    @Override
    public final RankedList getColumnRL(String string, SortMode sortMode, Order order) {
        return this.getColumnLV(string).sort(sortMode, order);
    }

    @Override
    public final RankedList getColumnRL(int n, SortMode sortMode, Order order) {
        return this.getColumnLV(n).sort(sortMode, order);
    }

    @Override
    public final float getElement(int n, String string) {
        try {
            return this.getElement(n, this.getColumnIndex(string));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Could not find colName: " + string);
            throw arrayIndexOutOfBoundsException;
        }
    }

    @Override
    public final float getElement(String string, int n) {
        int n2 = this.getRowIndex(string);
        if (n2 == -1) {
            throw new IllegalArgumentException("Could not find rowName: " + string);
        }
        return this.getElement(n2, n);
    }

    @Override
    public final float getElement(String string, String string2) {
        int n = this.getRowIndex(string);
        int n2 = this.getColumnIndex(string2);
        if (n == -1) {
            throw new IllegalArgumentException("No such row: >" + string + "<");
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("No such col: >" + string2 + "<");
        }
        return this.getElement(n, n2);
    }

    @Override
    public final int getDim() {
        return this._matrix().getDim();
    }

    @Override
    public final Matrix getMatrix() {
        this._matrix().setImmutable();
        return this._matrix();
    }

    private Matrix _matrix() {
        if (this.fMatrix == null) {
            if (this.dsFile == null || !this.dsFile.exists()) {
                throw new IllegalStateException("ds file for lazy matrix loading is null or missing: " + this.dsFile);
            }
            try {
                this.log.debug("LAZY loading dataset from: " + this.dsFile.getPath());
                Dataset dataset = ParserFactory.readDataset(this.dsFile, true, true, false);
                this.initMatrix(((DefaultDataset)dataset).fMatrix, this.fRowNames, this.fColNames);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.fMatrix;
    }

    @Override
    public final String getQuickInfo() {
        if (this.fQuickInfo == null) {
            this._setQuickInfo();
        }
        return this.fQuickInfo;
    }

    private void _setQuickInfo() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getNumRow()).append('x').append(this.getNumCol());
        if (this.getAnnot() != null && this.getAnnot().getFeatureAnnot() != null && this.getAnnot().getSampleAnnot_global() != null) {
            FeatureAnnot featureAnnot = this.getAnnot().getFeatureAnnot();
            SampleAnnot sampleAnnot = this.getAnnot().getSampleAnnot_global();
            stringBuffer.append(" (ann: ");
            if (featureAnnot != null) {
                stringBuffer.append(featureAnnot.getNumFeatures());
            } else {
                stringBuffer.append("na");
            }
            stringBuffer.append(",");
            if (sampleAnnot != null) {
                stringBuffer.append(sampleAnnot.getNumSamples());
            } else {
                stringBuffer.append("na");
            }
            stringBuffer.append(",");
            if (this.getAnnot().getChip() != null) {
                stringBuffer.append(this.getAnnot().getChip().getName());
            } else {
                stringBuffer.append("chip na");
            }
            stringBuffer.append(")");
        }
        this.fQuickInfo = stringBuffer.toString();
    }

    private static List toList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList;
    }
}

