/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.math.AddressedVector;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath$Const;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetPair;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedList$Helper;
import edu.mit.broad.genome.objects.strucs.DefaultMetricWeightStruc;
import gnu.trove.TFloatArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultRankedList
extends AbstractObject
implements RankedList {
    private List fRankedNames;
    private Vector fRankedScores;
    private TObjectIntHashMap fRowNameSdsRowIndexMap;
    private MetricWeightStruc mws;

    public DefaultRankedList(String string, String[] stringArray, float[] fArray) {
        this.init(string, stringArray, new Vector(fArray));
    }

    public DefaultRankedList(String string, String[] stringArray, TFloatArrayList tFloatArrayList) {
        this.init(string, stringArray, new Vector(tFloatArrayList));
    }

    public DefaultRankedList(String string, List list, TFloatArrayList tFloatArrayList) {
        this.init(string, list, new Vector(tFloatArrayList));
    }

    public DefaultRankedList(List list, Vector vector, boolean bl, boolean bl2) {
        this(null, list, vector, bl, bl2);
    }

    public DefaultRankedList(String string, List arrayList, Vector vector, boolean bl, boolean bl2) {
        Vector vector2 = new Vector(vector, bl2);
        ArrayList arrayList2 = bl ? arrayList : new ArrayList(arrayList);
        this.init(string, arrayList2, vector2);
    }

    public DefaultRankedList(String string, String[] stringArray, Vector vector, boolean bl) {
        Vector vector2 = new Vector(vector, bl);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        this.init(string, arrayList, vector2);
    }

    public DefaultRankedList(AddressedVector addressedVector, Dataset dataset) {
        this(addressedVector, dataset, true);
    }

    public DefaultRankedList(AddressedVector addressedVector, Dataset dataset, boolean bl) {
        if (addressedVector == null) {
            throw new NullPointerException("Param iv cannot be null");
        }
        if (dataset == null) {
            throw new NullPointerException("Param Dataset cannot be null");
        }
        if (addressedVector.getSize() != dataset.getNumRow()) {
            throw new MismatchedSizeException("AddressedVector", addressedVector.getSize(), "Dataset NumRows", dataset.getNumRow());
        }
        Vector vector = new Vector(addressedVector.getScoresArray(), bl);
        ArrayList<String> arrayList = new ArrayList<String>(vector.getSize());
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            int n = addressedVector.getAddress(i2);
            arrayList.add(dataset.getRowName(n));
        }
        this.init(null, arrayList, vector);
    }

    @Override
    public final RankedList cloneShallowRL(String string) {
        super.setName(string);
        return this;
    }

    private void init(String string, String[] stringArray, Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Parameter v cannot be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Param alabels cannot be null");
        }
        if (vector.getSize() != stringArray.length) {
            throw new MismatchedSizeException("Vector", vector.getSize(), "Labels", stringArray.length);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        this.init(string, arrayList, vector);
    }

    private void init(String string, List list, Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Param v cannot be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Param labels cannot be null");
        }
        if (vector.getSize() != list.size()) {
            throw new MismatchedSizeException("Vector", vector.getSize(), "Labels", list.size());
        }
        if (string == null) {
            super.initialize(" " + this.getClass().hashCode() + System.currentTimeMillis());
        } else {
            super.initialize(string);
        }
        this.fRankedScores = vector;
        this.fRankedNames = Collections.unmodifiableList(list);
        this.fRankedScores.setImmutable();
    }

    @Override
    public final String getQuickInfo() {
        return this.getSize() + " names";
    }

    @Override
    public final boolean isMember(String string) {
        return this.fRankedNames.contains(string);
    }

    @Override
    public final String getRankName(int n) {
        return this.fRankedNames.get(n).toString();
    }

    @Override
    public final List getRankedNames() {
        return Collections.unmodifiableList(this.fRankedNames);
    }

    @Override
    public final String[] getRankedNamesArray() {
        return this.fRankedNames.toArray(new String[this.fRankedNames.size()]);
    }

    @Override
    public final String toString(char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            stringBuffer.append(this.getRankName(i2)).append('=').append(this.getScore(i2)).append(c2);
        }
        return stringBuffer.toString();
    }

    @Override
    public final Vector getScoresV(boolean bl) {
        return new Vector(this.fRankedScores, bl);
    }

    @Override
    public final float getValue(String string, XMath$Const xMath$Const) {
        if (xMath$Const.isScore()) {
            return this.getScore(string);
        }
        return this.getRank(string);
    }

    @Override
    public final float getScore(int n) {
        return this.fRankedScores.getElement(n);
    }

    @Override
    public final int getRank(String string) {
        int n = this._index(string);
        return n;
    }

    @Override
    public final float getScore(String string) {
        int n = this._index(string);
        if (n == -1) {
            throw new IllegalArgumentException("No such name: " + string + " \navailable: " + this.fRankedNames + "\n but no: " + string);
        }
        return this.fRankedScores.getElement(n);
    }

    private int _index(String string) {
        int n;
        if (this.fRowNameSdsRowIndexMap == null) {
            this.cacheRowNameIndex();
        }
        if ((n = this.fRowNameSdsRowIndexMap.get(string)) == 0) {
            if (!this.fRowNameSdsRowIndexMap.containsKey(string)) {
                return -1;
            }
            return 0;
        }
        return n;
    }

    private void cacheRowNameIndex() {
        if (this.fRowNameSdsRowIndexMap == null) {
            this.fRowNameSdsRowIndexMap = new TObjectIntHashMap();
            for (int i2 = 0; i2 < this.getSize(); ++i2) {
                this.fRowNameSdsRowIndexMap.put(this.fRankedNames.get(i2), i2);
            }
        }
    }

    @Override
    public final float[] getScores(GeneSet geneSet) {
        float[] fArray = new float[geneSet.getNumMembers()];
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            fArray[i2] = this.getScore(geneSet.getMember(i2));
        }
        return fArray;
    }

    @Override
    public final int[] getRanks(GeneSet geneSet) {
        return RankedList$Helper.getRanks(geneSet, this);
    }

    @Override
    public final Vector getRanksV(GeneSet geneSet) {
        return RankedList$Helper.getRanksV(geneSet, this);
    }

    @Override
    public final RankedList extractRanked(GeneSet geneSet) {
        return RankedList$Helper.extract(geneSet, (RankedList)this);
    }

    @Override
    public final RankedList extractRanked(String[] stringArray) {
        return RankedList$Helper.extract(stringArray, (RankedList)this);
    }

    @Override
    public final RankedList extractRanked(List list) {
        return RankedList$Helper.extract(list, (RankedList)this);
    }

    @Override
    public final GeneSet toGeneSet() {
        return new FSet(this.getName(), this.fRankedNames, false);
    }

    @Override
    public final String toString(char c2, boolean bl) {
        return RankedList$Helper.toString(c2, bl, this);
    }

    @Override
    public final int getSize() {
        return this.fRankedScores.getSize();
    }

    @Override
    public final int getSize(ScoreMode scoreMode) {
        return this.fRankedScores.getSize(scoreMode);
    }

    @Override
    public final List getNamesOfUpOrDnXRanks(int n, boolean bl) {
        return RankedList$Helper.getLabelsOfUpOrDnXRanks(n, bl, this);
    }

    @Override
    public final String[] getNamesOfUpOrDnXRanks_array(int n, boolean bl) {
        return RankedList$Helper.getLabelsOfUpOrDnXRanks_array(n, bl, this);
    }

    @Override
    public final GeneSet getNamesOfUpOrDnXRanks_gs(int n, boolean bl) {
        return RankedList$Helper.getLabelsOfUpOrDnXRanks_gs(n, bl, this);
    }

    @Override
    public final GeneSetPair getNamesOfUpAndDnXRanks(int n) {
        return RankedList$Helper.getLabelsOfUpAndDnXRanks(n, this);
    }

    @Override
    public final RankedList extractRanked(int n) {
        return RankedList$Helper.extractRanked(n, (RankedList)this);
    }

    @Override
    public final RankedList extractRanked(int n, boolean bl) {
        return RankedList$Helper.extractRanked(n, bl, this);
    }

    @Override
    public final RankedList extractRanked(ScoreMode scoreMode) {
        return RankedList$Helper.extractRanked(scoreMode, (RankedList)this);
    }

    @Override
    public final RankedList extractRanked(float f2, float f3) {
        return RankedList$Helper.extract(f2, f3, this);
    }

    @Override
    public final int getNumScores(float f2, float f3) {
        return RankedList$Helper.getNumScores(f2, f3, this);
    }

    @Override
    public final GeneSet getScores_gs(float f2, float f3) {
        return RankedList$Helper.getScores_gs(f2, f3, this);
    }

    @Override
    public final MetricWeightStruc getMetricWeightStruc() {
        if (this.mws == null) {
            this.mws = new DefaultMetricWeightStruc(null, this);
        }
        return this.mws;
    }
}

