/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.alg.ComparatorFactory$ScoredDatasetScoreComparator;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.ISet;
import edu.mit.broad.genome.objects.LabelledList;
import edu.mit.broad.genome.objects.Neighbor;
import edu.mit.broad.genome.objects.RankedFeature;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.SetHelper;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.meg.Gene;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FSet
extends AbstractObject
implements GeneSet {
    protected List fMembers;

    protected FSet() {
    }

    public FSet(String string, String string2, String[] stringArray) {
        this.init(string, string2, stringArray, true);
    }

    public FSet(String string, String string2, List list, boolean bl) {
        this.init(string, string2, list, bl);
    }

    public FSet(String string, List list, boolean bl) {
        this.init(string, null, list, bl);
    }

    public FSet(String string, String[] stringArray) {
        this.init(string, null, stringArray, true);
    }

    public FSet(String string, Set set) {
        this.init(string, null, set, false);
    }

    public FSet(String string, Set[] setArray) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < setArray.length; ++i2) {
            hashSet.addAll(setArray[i2]);
        }
        this.init(string, null, hashSet, false);
    }

    public FSet(String string, RankedFeature[] rankedFeatureArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < rankedFeatureArray.length; ++i2) {
            hashSet.add(rankedFeatureArray[i2].getName());
        }
        this.init(string, null, hashSet, false);
    }

    public FSet(String string, GeneSet[] geneSetArray) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            hashSet.addAll(geneSetArray[i2].getMembers());
        }
        this.init(string, null, hashSet, false);
    }

    public FSet(GeneSet geneSet, ScoredDataset scoredDataset) {
        ArrayList<String> arrayList = new ArrayList<String>(geneSet.getMembers().size());
        for (int i2 = 0; i2 < geneSet.getMembers().size(); ++i2) {
            arrayList.add(geneSet.getMember(i2));
        }
        Collections.sort(arrayList, new ComparatorFactory$ScoredDatasetScoreComparator(scoredDataset));
        this.init(geneSet.getName() + ".orderedby." + scoredDataset.getName(), geneSet.getNameEnglish(), arrayList, false);
    }

    public FSet(GeneSet geneSet) {
        this.init(geneSet);
    }

    protected final void init(GeneSet geneSet) {
        if (geneSet instanceof FSet) {
            this.init(geneSet.getName(), geneSet.getNameEnglish(), ((FSet)geneSet).fMembers, false);
        } else {
            this.init(geneSet.getName(), geneSet.getNameEnglish(), geneSet.getMembers(), false);
        }
    }

    protected final void init(String string, String string2, Collection collection, boolean bl) {
        super.initialize(string, string2);
        if (collection == null) {
            throw new NullPointerException("Param members cant be null");
        }
        this.fMembers = new ArrayList();
        int n = 0;
        for (Object e2 : collection) {
            String string3;
            ++n;
            if (e2 == null) {
                throw new NullPointerException("Member is null at: " + n);
            }
            if (e2 instanceof Gene) {
                Gene gene = (Gene)e2;
                string3 = gene.getSymbol();
            } else {
                string3 = e2 instanceof Probe ? ((Probe)e2).getName() : (e2 instanceof Neighbor ? ((Neighbor)e2).getName() : e2.toString());
            }
            if (bl) {
                if (this.fMembers.contains(string3)) {
                    this.log.warn("Duplicate GeneSet member: " + string3);
                    continue;
                }
                this.fMembers.add(string3);
                continue;
            }
            this.fMembers.add(string3);
        }
    }

    private void init(String string, String string2, String[] stringArray, boolean bl) {
        super.initialize(string, string2);
        if (stringArray == null) {
            throw new NullPointerException("Members param cant be null");
        }
        this.fMembers = new ArrayList();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null) {
                throw new NullPointerException("Member is null at: " + i2);
            }
            if (bl) {
                if (this.fMembers.contains(stringArray[i2])) {
                    this.log.warn("Duplicate GeneSet member: " + stringArray[i2]);
                    continue;
                }
                this.fMembers.add(stringArray[i2]);
                continue;
            }
            this.fMembers.add(stringArray[i2]);
        }
    }

    @Override
    public final GeneSet cloneDeep() {
        return new FSet(this.getName(), this.getNameEnglish(), this.getMembers(), false);
    }

    @Override
    public final GeneSet cloneDeep(String string, String string2) {
        return new FSet(string, string2, this.getMembers(), false);
    }

    @Override
    public final GeneSet cloneDeep(String string, Comparator comparator) {
        ArrayList arrayList = new ArrayList(this.fMembers);
        Collections.sort(arrayList, comparator);
        return new FSet(string, this.getNameEnglish(), arrayList, false);
    }

    @Override
    public final GeneSet cloneDeep(Dataset dataset) {
        int n;
        ArrayList arrayList = new ArrayList(this.fMembers);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < this.getNumMembers(); ++n) {
            String string = this.getMember(n);
            if (dataset.getRowIndex(string) != -1) continue;
            arrayList2.add(string);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.remove(arrayList2.get(n));
        }
        return new FSet(this.getName(), this.getNameEnglish(), arrayList, false);
    }

    @Override
    public final GeneSet cloneDeep(RankedList rankedList) {
        int n;
        ArrayList arrayList = new ArrayList(this.fMembers);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < this.getNumMembers(); ++n) {
            String string = this.getMember(n);
            if (rankedList.getRank(string) != -1) continue;
            arrayList2.add(string);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.remove(arrayList2.get(n));
        }
        return new FSet(this.getName(), this.getNameEnglish(), arrayList, false);
    }

    @Override
    public final GeneSet cloneDeep(Collection collection) {
        int n;
        ArrayList arrayList = new ArrayList(this.fMembers);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < this.getNumMembers(); ++n) {
            String string = this.getMember(n);
            if (collection.contains(string)) continue;
            arrayList2.add(string);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.remove(arrayList2.get(n));
        }
        return new FSet(this.getName(), this.getNameEnglish(), arrayList, false);
    }

    @Override
    public final GeneSet cloneShallow() {
        return this.cloneShallow(this.getName());
    }

    @Override
    public final GeneSet cloneShallow(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param newName cannot be null");
        }
        FSet fSet = new FSet();
        fSet.initialize(string, this.getNameEnglish());
        fSet.fMembers = this.fMembers;
        return fSet;
    }

    @Override
    public final GeneSet cloneShallow(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Param newName cannot be null");
        }
        FSet fSet = new FSet();
        fSet.initialize(string, string2);
        fSet.fMembers = this.fMembers;
        return fSet;
    }

    public final FSet cloneShallow(int n, String string) {
        if (this.fMembers.contains(string)) {
            this.log.warn("Duplicate GeneSet member: " + string);
        }
        this.fMembers.set(n, string);
        return this;
    }

    @Override
    public final String getQuickInfo() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getNumMembers()).append(" members");
        return stringBuffer.toString();
    }

    @Override
    public final String getName(boolean bl) {
        if (bl) {
            return AuxUtils.getAuxNameOnlyNoHash(this.getName());
        }
        return this.getName();
    }

    @Override
    public final String getMember(int n) {
        return (String)this.fMembers.get(n);
    }

    @Override
    public final int getPosition(String string) {
        return this.fMembers.indexOf(string);
    }

    @Override
    public final boolean isMember(String string) {
        return this.fMembers.contains(string);
    }

    @Override
    public final int getNumMembers() {
        return this.fMembers.size();
    }

    @Override
    public final List getMembers() {
        return Collections.unmodifiableList(this.fMembers);
    }

    public final List getMembers_quick() {
        return this.fMembers;
    }

    @Override
    public final Set getMembersS() {
        return Collections.unmodifiableSet(new HashSet(this.fMembers));
    }

    @Override
    public final String[] getMembersArray() {
        return this.fMembers.toArray(new String[this.fMembers.size()]);
    }

    @Override
    public final boolean equalsShallow(GeneSet geneSet) {
        return geneSet != null && geneSet.getName().equals(this.getName()) && geneSet.getNumMembers() == this.getNumMembers();
    }

    @Override
    public final int getNumMembers(Dataset dataset) {
        return SetHelper.getNumMembers((GeneSet)this, dataset);
    }

    @Override
    public final int getNumMembers(Collection collection) {
        return SetHelper.getNumMembers((ISet)this, collection);
    }

    @Override
    public final int getNumMembers(GeneSet geneSet) {
        return SetHelper.getNumMembers((GeneSet)this, geneSet);
    }

    @Override
    public final int getNumMembers(RankedList rankedList) {
        return SetHelper.getNumMembers((ISet)this, rankedList);
    }

    @Override
    public final int getNumMembers(LabelledList labelledList) {
        return SetHelper.getNumMembers((ISet)this, labelledList);
    }

    @Override
    public final String toString(char c2) {
        return SetHelper.toString(c2, this);
    }

    public final String toString(char c2, Chip chip) {
        return SetHelper.toString(c2, this, chip);
    }
}

