/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.ColorMap$Rows;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.FeatureAnnot$Helper;
import edu.mit.broad.genome.objects.strucs.Linked;
import edu.mit.broad.genome.reports.web.LinkedFactory;
import edu.mit.broad.vdb.chip.Chip;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class FeatureAnnotImpl
extends AbstractObject
implements FeatureAnnot {
    private Logger log = XLogger.getLogger(this.getClass());
    private Object fDataset_or_FeatureNamesList;
    private List fRowDescs;
    private Chip fChip;
    private FeatureAnnot$Helper fHelper;
    private ColorMap$Rows fColorMap;

    public FeatureAnnotImpl(Dataset dataset, List list, ColorMap$Rows colorMap$Rows) {
        this.initHere(dataset.getName(), dataset, list, null, colorMap$Rows);
    }

    public FeatureAnnotImpl(Dataset dataset, List list) {
        this.initHere(dataset.getName(), dataset, list, null, null);
    }

    public FeatureAnnotImpl(Chip chip) {
        this.initHere(chip.getName(), Arrays.asList(chip.getProbeNamesArr()), null, chip, null);
    }

    public FeatureAnnotImpl(String string, List list, List list2, ColorMap$Rows colorMap$Rows) {
        this.initHere(string, list, list2, null, colorMap$Rows);
    }

    public FeatureAnnotImpl(String string, List list, List list2) {
        this.initHere(string, list, list2, null, null);
    }

    public FeatureAnnotImpl(String string, List list, List list2, Chip chip, ColorMap$Rows colorMap$Rows) {
        this.initHere(string, list, list2, chip, colorMap$Rows);
    }

    public FeatureAnnotImpl(String string, List list, List list2, Chip chip) {
        this.initHere(string, list, list2, chip, null);
    }

    public FeatureAnnotImpl(Dataset dataset, List list, Chip chip, ColorMap$Rows colorMap$Rows) {
        this.initHere(dataset.getName(), dataset, list, chip, colorMap$Rows);
    }

    private void initHere(String string, Object object, List list, Chip chip, ColorMap$Rows colorMap$Rows) {
        if (object == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        if (object instanceof Dataset) {
            Dataset dataset = (Dataset)object;
            if (list != null && dataset.getNumRow() != list.size()) {
                throw new MismatchedSizeException("dataset num rows", dataset.getNumRow(), " row descs", list.size());
            }
        } else {
            List list2 = (List)object;
            if (list != null && list2.size() != list.size()) {
                throw new MismatchedSizeException("num rows", list2.size(), " row descs", list.size());
            }
        }
        super.initialize(string);
        this.fDataset_or_FeatureNamesList = object;
        this.fRowDescs = list;
        this.fChip = chip;
        this.fColorMap = colorMap$Rows;
        this.fHelper = new FeatureAnnot$Helper();
    }

    @Override
    public final Chip getChip() {
        return this.fChip;
    }

    @Override
    public final ColorMap$Rows getColorMap() {
        return this.fColorMap;
    }

    @Override
    public final void setChip(Chip chip, ColorMap$Rows colorMap$Rows) {
        if (chip != null) {
            FeatureAnnot$Helper.checkChip(this.fChip, chip);
            this.fChip = chip;
            this.fColorMap = colorMap$Rows;
        }
    }

    @Override
    public final String getQuickInfo() {
        if (this.fDataset_or_FeatureNamesList instanceof Dataset) {
            return ((Dataset)this.fDataset_or_FeatureNamesList).getQuickInfo();
        }
        return null;
    }

    @Override
    public final String[] getNames() {
        if (this.fDataset_or_FeatureNamesList instanceof Dataset) {
            return ((Dataset)this.fDataset_or_FeatureNamesList).getRowNamesArray();
        }
        List list = (List)this.fDataset_or_FeatureNamesList;
        return list.toArray(new String[list.size()]);
    }

    @Override
    public final int getNumFeatures() {
        if (this.fDataset_or_FeatureNamesList instanceof Dataset) {
            return ((Dataset)this.fDataset_or_FeatureNamesList).getNumRow();
        }
        List list = (List)this.fDataset_or_FeatureNamesList;
        return list.size();
    }

    @Override
    public final boolean hasNativeDescriptions() {
        return this.fRowDescs != null && !this.fRowDescs.isEmpty();
    }

    @Override
    public final String getNativeDesc(String string) {
        int n;
        if (this.fRowDescs == null) {
            return null;
        }
        if (this.fDataset_or_FeatureNamesList instanceof Dataset) {
            n = ((Dataset)this.fDataset_or_FeatureNamesList).getRowIndex(string);
        } else {
            List list = (List)this.fDataset_or_FeatureNamesList;
            n = list.indexOf(string);
        }
        if (n == -1) {
            this.log.warn("No such such feature: >" + string + "< " + this.getName());
            return null;
        }
        return this.fRowDescs.get(n).toString();
    }

    @Override
    public final String getGeneSymbol(String string) {
        return this.fHelper.getGeneSymbol(string, this.fChip);
    }

    @Override
    public final String getGeneTitle(String string) {
        return this.fHelper.getGeneTitle(string, this.fChip);
    }

    @Override
    public final Linked getLink(String string) {
        return LinkedFactory.createLinkedProbeSet(string);
    }
}

