/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.HClustTree$Node;
import edu.mit.broad.genome.objects.HClustTree$Root;
import edu.mit.broad.genome.objects.PersistentObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class HClustTree
extends AbstractObject
implements PersistentObject {
    private final HClustTree$Node[] fNodes;
    private List fRoots;

    public HClustTree(String string, List list, boolean bl) {
        super(string);
        Object object;
        int n;
        this.fNodes = new HClustTree$Node[list.size()];
        for (n = 0; n < list.size(); ++n) {
            object = list.get(n);
            if (object instanceof HClustTree$Node) {
                if (bl) {
                    this.fNodes[n] = (HClustTree$Node)object;
                    continue;
                }
                this.fNodes[n] = (HClustTree$Node)object;
                continue;
            }
            throw new IllegalArgumentException("Only Node objects allowed. Found: " + object + " at: " + n);
        }
        this.fRoots = new ArrayList();
        for (n = 0; n < this.getNumNodes(); ++n) {
            Object object2;
            object = this.getNode(n);
            Object object3 = ((HClustTree$Node)object).getParentA();
            if (object3 instanceof HClustTree$Root) {
                this.fRoots.add(object3);
            }
            if (!((object2 = ((HClustTree$Node)object).getParentB()) instanceof HClustTree$Root)) continue;
            this.fRoots.add(object2);
        }
        if (this.fNodes.length + 1 != this.fRoots.size()) {
            throw new IllegalArgumentException("Bad # of nodes: " + this.fNodes.length + " must be 1 less that # of roots: " + this.fRoots.size());
        }
        this.doNameNodeCheck();
    }

    private void doNameNodeCheck() {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 0; n < this.fNodes.length; ++n) {
            if (hashSet.contains(this.fNodes[n].getName())) {
                throw new IllegalArgumentException("Node names must be unique. Found duplicate Node: " + this.fNodes[n].getName() + " at: " + n);
            }
            hashSet.add(this.fNodes[n].getName());
        }
        hashSet = new HashSet();
        for (n = 0; n < this.fRoots.size(); ++n) {
            String string = ((HClustTree$Root)this.fRoots.get(n)).getName();
            if (hashSet.contains(string)) {
                throw new IllegalArgumentException("Root names must be unique. Found duplicate Root: " + string + " at: " + n);
            }
            hashSet.add(string);
        }
    }

    public final int getNumNodes() {
        return this.fNodes.length;
    }

    public final int getNumRoots() {
        return this.fRoots.size();
    }

    public final HClustTree$Node getNode(int n) {
        return this.fNodes[n];
    }

    public final HClustTree$Root[] getRoots() {
        List list = this.getRootsL();
        return list.toArray(new HClustTree$Root[list.size()]);
    }

    public final List getRootsL() {
        return this.fRoots;
    }

    @Override
    public final String getQuickInfo() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getNumNodes()).append(" nodes");
        return stringBuffer.toString();
    }
}

