/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.LabelledList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LabelledObject
extends AbstractObject
implements LabelledList {
    private List fLabels;
    private List fObjects;

    public LabelledObject(String string, List list, List list2) {
        this.init(string, list, list2);
    }

    public LabelledObject(String string, String[] stringArray, String[] stringArray2) {
        this.init(string, stringArray, stringArray2);
    }

    private void init(String string, String[] stringArray, Object[] objectArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Param alabels cannot be null");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("Parameter objs cannot be null");
        }
        if (objectArray.length != stringArray.length) {
            throw new MismatchedSizeException("Objects", objectArray.length, "Labels", stringArray.length);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(objectArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
            arrayList2.add(objectArray[i2]);
        }
        this.init(string, arrayList, arrayList);
    }

    private void init(String string, List list, List list2) {
        super.initialize(string);
        if (list == null) {
            throw new IllegalArgumentException("Param labels cannot be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Parameter objects cannot be null");
        }
        if (list.size() != list2.size()) {
            throw new MismatchedSizeException("Objects", list2.size(), "Labels", list.size());
        }
        this.fLabels = Collections.unmodifiableList(list);
        this.fObjects = Collections.unmodifiableList(list2);
    }

    @Override
    public final String getQuickInfo() {
        return Integer.toString(this.fLabels.size()) + " labels";
    }

    public final List getRowNames() {
        return this.getLabels();
    }

    public final String[] getRowNamesArray() {
        return this.getLabelsArray();
    }

    @Override
    public final String getLabel(int n) {
        return this.fLabels.get(n).toString();
    }

    public final Object getElement(String string) {
        int n = this.getLabelIndex(string);
        if (n == -1) {
            throw new IllegalArgumentException("No match to label: " + string);
        }
        return this.fObjects.get(n);
    }

    public final List getLabels() {
        return Collections.unmodifiableList(this.fLabels);
    }

    public final String[] getLabelsArray() {
        return this.fLabels.toArray(new String[this.fLabels.size()]);
    }

    public final boolean isMember(String string) {
        return this.fLabels.contains(string);
    }

    public final int getLabelIndex(String string) {
        return this.fLabels.indexOf(string);
    }

    public final Object getElement(int n) {
        return this.fObjects.get(n);
    }

    public final String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            stringBuffer.append(this.getLabel(i2)).append(string).append(this.getElement(i2)).append('\n');
        }
        return stringBuffer.toString();
    }

    @Override
    public final int getSize() {
        return this.fLabels.size();
    }
}

