/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.math.AddressedVector;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultRankedList;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.LabelledList;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.strucs.DefaultMetricWeightStruc;
import edu.mit.broad.genome.parsers.AuxUtils;
import gnu.trove.TFloatArrayList;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectFloatHashMap;
import gnu.trove.TObjectFloatIterator;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LabelledVector
extends AbstractObject
implements LabelledList {
    private List fLabels;
    private Vector fVector;
    private TObjectIntHashMap fLabelNameLabelIndexMap;
    private MetricWeightStruc ws;

    public final LabelledVector cloneShallow(String string) {
        super.setName(string);
        return this;
    }

    public LabelledVector(String string, String[] stringArray, TFloatArrayList tFloatArrayList) {
        this.init(string, stringArray, new Vector(tFloatArrayList));
    }

    public LabelledVector(String string, List list, TFloatArrayList tFloatArrayList) {
        this.init(string, list, new Vector(tFloatArrayList));
    }

    public LabelledVector(TObjectFloatHashMap tObjectFloatHashMap) {
        String[] stringArray = new String[tObjectFloatHashMap.size()];
        Vector vector = new Vector(tObjectFloatHashMap.size());
        TObjectFloatIterator tObjectFloatIterator = tObjectFloatHashMap.iterator();
        int n = tObjectFloatHashMap.size();
        while (n-- > 0) {
            tObjectFloatIterator.advance();
            stringArray[n] = tObjectFloatIterator.key().toString();
            vector.setElement(n, tObjectFloatIterator.value());
        }
        this.init(stringArray, vector);
    }

    public LabelledVector(String string, TObjectFloatHashMap tObjectFloatHashMap) {
        String[] stringArray = new String[tObjectFloatHashMap.size()];
        Vector vector = new Vector(tObjectFloatHashMap.size());
        TObjectFloatIterator tObjectFloatIterator = tObjectFloatHashMap.iterator();
        int n = tObjectFloatHashMap.size();
        while (n-- > 0) {
            tObjectFloatIterator.advance();
            stringArray[n] = tObjectFloatIterator.key().toString();
            vector.setElement(n, tObjectFloatIterator.value());
        }
        this.init(string, stringArray, vector);
    }

    public LabelledVector(TObjectIntHashMap tObjectIntHashMap) {
        this("", tObjectIntHashMap);
    }

    public LabelledVector(String string, TObjectIntHashMap tObjectIntHashMap) {
        String[] stringArray = new String[tObjectIntHashMap.size()];
        Vector vector = new Vector(tObjectIntHashMap.size());
        TObjectIntIterator tObjectIntIterator = tObjectIntHashMap.iterator();
        int n = tObjectIntHashMap.size();
        while (n-- > 0) {
            tObjectIntIterator.advance();
            stringArray[n] = tObjectIntIterator.key().toString();
            vector.setElement(n, tObjectIntIterator.value());
        }
        this.init(string, stringArray, vector);
    }

    public LabelledVector(RankedList rankedList, boolean bl) {
        ArrayList<String> arrayList = bl ? rankedList.getRankedNames() : new ArrayList<String>(rankedList.getSize());
        Vector vector = new Vector(rankedList.getSize());
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            if (!bl) {
                arrayList.add(rankedList.getRankName(i2));
            }
            vector.setElement(i2, rankedList.getScore(i2));
        }
        this.init(rankedList.getName(), arrayList, vector);
    }

    public LabelledVector(String string, String[] stringArray, float[] fArray) {
        this.init(string, stringArray, new Vector(fArray));
    }

    public LabelledVector(String string, String[] stringArray, Vector vector) {
        this.init(string, stringArray, vector);
    }

    public LabelledVector(GeneSet geneSet, Vector vector, boolean bl) {
        if (bl) {
            this.init(geneSet.getMembers(), vector);
        } else {
            this.init(geneSet.getMembersArray(), vector);
        }
    }

    public LabelledVector(Vector vector) {
        ArrayList<String> arrayList = new ArrayList<String>(vector.getSize());
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            arrayList.add("row_" + i2);
        }
        this.init(arrayList, vector);
    }

    public LabelledVector(List list, Vector vector, boolean bl) {
        if (bl) {
            this.init(list, vector);
        } else {
            this.init(new ArrayList(list), vector);
        }
    }

    public LabelledVector(String string, List list, Vector vector, boolean bl) {
        if (bl) {
            this.init(string, list, vector);
        } else {
            this.init(string, new ArrayList(list), vector);
        }
    }

    public LabelledVector(DoubleElement[] doubleElementArray, LabelledList labelledList) {
        if (labelledList == null) {
            throw new NullPointerException("Param ll cannot be null");
        }
        if (doubleElementArray == null) {
            throw new NullPointerException("Param dels cannot be null");
        }
        if (labelledList.getSize() != doubleElementArray.length) {
            throw new MismatchedSizeException("LabelledList", labelledList.getSize(), "DoubleElement Array", doubleElementArray.length);
        }
        Vector vector = new Vector(doubleElementArray.length);
        ArrayList<String> arrayList = new ArrayList<String>(doubleElementArray.length);
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            int n = doubleElementArray[i2].fIndex;
            vector.setElement(i2, (float)doubleElementArray[i2].fValue);
            arrayList.add(labelledList.getLabel(n));
        }
        this.init(arrayList, vector);
    }

    public LabelledVector(TIntArrayList tIntArrayList, int n, Dataset dataset) {
        if (tIntArrayList == null) {
            throw new NullPointerException("Param indices cannot be null");
        }
        if (dataset == null) {
            throw new NullPointerException("Param Dataset cannot be null");
        }
        if (tIntArrayList.size() > dataset.getNumRow()) {
            throw new MismatchedSizeException("Indices", tIntArrayList.size(), "Dataset", dataset.getNumRow());
        }
        Vector vector = new Vector(tIntArrayList.size());
        ArrayList<String> arrayList = new ArrayList<String>(vector.getSize());
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            int n2 = tIntArrayList.get(i2);
            vector.setElement(i2, dataset.getElement(n2, n));
            arrayList.add(dataset.getRowName(n2));
        }
        this.init(arrayList, vector);
    }

    public LabelledVector(String[] stringArray, Vector vector) {
        this.init(stringArray, vector);
    }

    public LabelledVector(String string, Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Parameter v cannot be null");
        }
        if (string == null) {
            string = "";
        }
        String[] stringArray = new String[vector.getSize()];
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            stringArray[i2] = string + i2;
        }
        this.init(stringArray, vector);
    }

    public LabelledVector(AddressedVector addressedVector, Dataset dataset) {
        this(addressedVector, dataset, true);
    }

    public LabelledVector(AddressedVector addressedVector, Dataset dataset, boolean bl) {
        if (addressedVector == null) {
            throw new NullPointerException("Param iv cannot be null");
        }
        if (dataset == null) {
            throw new NullPointerException("Param Dataset cannot be null");
        }
        if (addressedVector.getSize() != dataset.getNumRow()) {
            throw new MismatchedSizeException("AddressedVector", addressedVector.getSize(), "Dataset NumRows", dataset.getNumRow());
        }
        Vector vector = new Vector(addressedVector.getScoresArray(), bl);
        ArrayList<String> arrayList = new ArrayList<String>(vector.getSize());
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            int n = addressedVector.getAddress(i2);
            arrayList.add(dataset.getRowName(n));
        }
        this.init(arrayList, vector);
    }

    public LabelledVector(LabelledVector[] labelledVectorArray) {
        if (labelledVectorArray == null) {
            throw new IllegalArgumentException("Param lvs cannot be null");
        }
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < labelledVectorArray.length; ++i2) {
            tFloatArrayList.add(labelledVectorArray[i2].getScoresV(false).toArray());
            arrayList.addAll(labelledVectorArray[i2].getLabels());
        }
        this.init(arrayList, new Vector(tFloatArrayList));
    }

    public LabelledVector(PersistentObject[] persistentObjectArray, Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Param v cannot be null");
        }
        if (persistentObjectArray == null) {
            throw new IllegalArgumentException("Param labels cannot be null");
        }
        if (vector.getSize() != persistentObjectArray.length) {
            throw new MismatchedSizeException("Vector", vector.getSize(), "Labels from Pobs", persistentObjectArray.length);
        }
        this.fVector = vector;
        this.fLabels = new ArrayList(vector.getSize());
        for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
            this.fLabels.add(persistentObjectArray[i2].getName());
        }
    }

    private void init(String[] stringArray, Vector vector) {
        this.init(null, stringArray, vector);
    }

    private void init(String string, String[] stringArray, Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Parameter v cannot be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Param alabels cannot be null");
        }
        if (vector.getSize() != stringArray.length) {
            throw new MismatchedSizeException("Vector", vector.getSize(), "Labels", stringArray.length);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        this.init(string, arrayList, vector);
    }

    private void init(List list, Vector vector) {
        this.init(null, list, vector);
    }

    private void init(String string, List list, Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Param v cannot be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Param labels cannot be null");
        }
        if (vector.getSize() != list.size()) {
            throw new MismatchedSizeException("Vector", vector.getSize(), "Labels", list.size());
        }
        if (string == null) {
            super.initialize(" " + this.getClass().hashCode() + System.currentTimeMillis());
        } else {
            super.initialize(string);
        }
        this.fVector = vector;
        this.fLabels = list;
        this.fVector.setImmutable();
    }

    @Override
    public final String getQuickInfo() {
        return Integer.toString(this.fLabels.size()) + " labels";
    }

    public final boolean isMember(String string) {
        return this.fLabels.contains(string);
    }

    public final float getScore(String string) {
        int n = this._labelIndex(string);
        if (n == -1) {
            System.err.println("Labels are: \n" + this.getLabels() + "\n");
            throw new IllegalArgumentException("No match to label: " + string);
        }
        return this.fVector.getElement(n);
    }

    public final float getScore(int n) {
        return this.fVector.getElement(n);
    }

    @Override
    public final String getLabel(int n) {
        return this.fLabels.get(n).toString();
    }

    public final List getLabels() {
        return Collections.unmodifiableList(this.fLabels);
    }

    public final String[] getLabelsForValuesArray(float f2, float f3) {
        Set set = this.getLabelsForValues(f2, f3);
        return set.toArray(new String[set.size()]);
    }

    public final String[] getLabelsArray() {
        return this.fLabels.toArray(new String[this.fLabels.size()]);
    }

    public final List getLabelsSubset(int n, int n2) {
        return this.fLabels.subList(n, n2);
    }

    public final Set getLabelsForValues(float f2, float f3) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            if (!(this.getScore(i2) >= f2) || !(this.getScore(i2) <= f3)) continue;
            hashSet.add(this.getLabel(i2));
        }
        return hashSet;
    }

    public final String[] getLabels_asis(int n) {
        String[] stringArray = new String[n];
        for (int i2 = 0; i2 < n; ++i2) {
            stringArray[i2] = this.getLabel(i2);
        }
        return stringArray;
    }

    public final LabelledVector synchLabels(LabelledVector labelledVector, boolean bl) {
        if (labelledVector == null) {
            throw new IllegalArgumentException("Param lv cannot be null");
        }
        if (bl && labelledVector.getSize() != this.getSize()) {
            throw new MismatchedSizeException(labelledVector.getName(), labelledVector.getSize(), this.getName(), this.getSize());
        }
        Vector vector = new Vector(labelledVector.getSize());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < labelledVector.getSize(); ++i2) {
            String string = labelledVector.getLabel(i2);
            arrayList.add(string);
            vector.setElement(i2, this.getScore(string));
        }
        return new LabelledVector(this.getName(), arrayList, vector, false);
    }

    public final RankedList sort(SortMode sortMode, Order order) {
        DoubleElement[] doubleElementArray = this.toDoubleElements();
        doubleElementArray = DoubleElement.sort(sortMode, order, doubleElementArray);
        ArrayList<String> arrayList = new ArrayList<String>(doubleElementArray.length);
        Vector vector = new Vector(doubleElementArray.length);
        for (int i2 = 0; i2 < doubleElementArray.length; ++i2) {
            arrayList.add(this.getLabel(doubleElementArray[i2].fIndex));
            vector.setElement(i2, (float)doubleElementArray[i2].fValue);
        }
        return new DefaultRankedList(this.getName(), arrayList, vector, true, true);
    }

    private int _labelIndex(String string) {
        if (this.fLabelNameLabelIndexMap == null) {
            this.cacheRowNameIndex();
        }
        if (this.fLabelNameLabelIndexMap.containsKey(string)) {
            return this.fLabelNameLabelIndexMap.get(string);
        }
        String string2 = AuxUtils.getAuxNameOnlyNoHash(string);
        if (this.fLabelNameLabelIndexMap.containsKey(string2)) {
            return this.fLabelNameLabelIndexMap.get(string2);
        }
        return -1;
    }

    private void cacheRowNameIndex() {
        if (this.fLabelNameLabelIndexMap == null) {
            this.fLabelNameLabelIndexMap = new TObjectIntHashMap();
            for (int i2 = 0; i2 < this.getSize(); ++i2) {
                this.fLabelNameLabelIndexMap.put(this.getLabel(i2), i2);
            }
        }
    }

    public final float[] getScoresArray() {
        return this.fVector.toArray();
    }

    public final Vector getScoresV(boolean bl) {
        if (bl) {
            return new Vector(this.fVector, false);
        }
        this.fVector.setImmutable();
        return this.fVector;
    }

    public final String toString(char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            stringBuffer.append(this.getLabel(i2)).append('=').append(this.getScore(i2)).append(c2);
        }
        return stringBuffer.toString();
    }

    public final String toString_newline(char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            stringBuffer.append(this.getLabel(i2)).append(c2).append(this.getScore(i2)).append('\n');
        }
        return stringBuffer.toString();
    }

    public static final Vector[] toVectors(LabelledVector[] labelledVectorArray, boolean bl) {
        Vector[] vectorArray = new Vector[labelledVectorArray.length];
        for (int i2 = 0; i2 < labelledVectorArray.length; ++i2) {
            vectorArray[i2] = labelledVectorArray[i2].getScoresV(bl);
        }
        return vectorArray;
    }

    @Override
    public final int getSize() {
        return this.fVector.getSize();
    }

    public final int getSize(ScoreMode scoreMode) {
        return this.fVector.getSize(scoreMode);
    }

    public final DoubleElement[] toDoubleElements() {
        DoubleElement[] doubleElementArray = new DoubleElement[this.getSize()];
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            doubleElementArray[i2] = new DoubleElement(i2, this.getScore(i2));
        }
        return doubleElementArray;
    }

    public static final int getMaxSize(LabelledVector[] labelledVectorArray) {
        int n = 0;
        for (int i2 = 0; i2 < labelledVectorArray.length; ++i2) {
            if (labelledVectorArray[i2].getSize() <= n) continue;
            n = labelledVectorArray[i2].getSize();
        }
        return n;
    }

    public static final LabelledVector getMaxSize_lv(LabelledVector[] labelledVectorArray) {
        if (labelledVectorArray == null) {
            throw new IllegalArgumentException("Param lvs cannot be null");
        }
        if (labelledVectorArray.length == 0) {
            throw new IllegalArgumentException("Param lvs cannot be 0 length");
        }
        LabelledVector labelledVector = null;
        int n = -1;
        for (int i2 = 0; i2 < labelledVectorArray.length; ++i2) {
            if (labelledVectorArray[i2].getSize() <= n) continue;
            n = labelledVectorArray[i2].getSize();
            labelledVector = labelledVectorArray[i2];
        }
        return labelledVector;
    }

    public static final int getMinSize(LabelledVector[] labelledVectorArray) {
        int n = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < labelledVectorArray.length; ++i2) {
            if (labelledVectorArray[i2].getSize() >= n) continue;
            n = labelledVectorArray[i2].getSize();
        }
        return n;
    }

    public final MetricWeightStruc getMetricWeightStruc() {
        if (this.ws == null) {
            this.ws = new DefaultMetricWeightStruc(null, this);
        }
        return this.ws;
    }

    public final LabelledVector multiply(LabelledVector labelledVector) {
        if (this.getSize() != labelledVector.getSize()) {
            throw new MismatchedSizeException(this, labelledVector);
        }
        Vector vector = new Vector(this.getSize());
        String[] stringArray = new String[vector.getSize()];
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            stringArray[i2] = this.getLabel(i2);
            vector.setElement(i2, this.getScore(i2) * labelledVector.getScore(stringArray[i2]));
        }
        return new LabelledVector(stringArray, vector);
    }

    public final LabelledVector multiply(LabelledVector labelledVector, LabelledVector labelledVector2) {
        if (this.getSize() != labelledVector.getSize()) {
            throw new MismatchedSizeException(this, labelledVector);
        }
        if (this.getSize() != labelledVector2.getSize()) {
            throw new MismatchedSizeException(this, labelledVector2);
        }
        Vector vector = new Vector(this.getSize());
        String[] stringArray = new String[vector.getSize()];
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            stringArray[i2] = this.getLabel(i2);
            vector.setElement(i2, this.getScore(i2) * labelledVector.getScore(stringArray[i2]) * labelledVector2.getScore(stringArray[i2]));
        }
        return new LabelledVector(stringArray, vector);
    }

    public final LabelledVector extractLV(GeneSet geneSet) {
        return this.extractLV(geneSet.getName(true), geneSet.getMembersArray());
    }

    public final LabelledVector extractLV(String string, String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Param labels cannot be null");
        }
        float[] fArray = new float[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            fArray[i2] = this.getScore(stringArray[i2]);
        }
        return new LabelledVector(string, stringArray, fArray);
    }
}

