/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.strucs.ProbeNeighborhoodEsStruc;
import java.util.ArrayList;
import java.util.List;

public class Nedb
extends AbstractObject {
    private ProbeNeighborhoodEsStruc[] fPnes;
    private GeneSet[] fGeneSets;
    private List fNeighNames;
    private Dataset fDataset;

    public Nedb(String string, Dataset dataset, GeneSet[] geneSetArray, ProbeNeighborhoodEsStruc[] probeNeighborhoodEsStrucArray) {
        super(string);
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter ds cannot be null");
        }
        if (geneSetArray == null) {
            throw new IllegalArgumentException("Parameter gcoh cannot be null");
        }
        this.fDataset = dataset;
        this.fNeighNames = new ArrayList(probeNeighborhoodEsStrucArray.length);
        for (int i2 = 0; i2 < probeNeighborhoodEsStrucArray.length; ++i2) {
            if (geneSetArray.length != probeNeighborhoodEsStrucArray[i2].getSize()) {
                throw new MismatchedSizeException();
            }
            String string2 = probeNeighborhoodEsStrucArray[i2].getProbeName();
            if (this.fNeighNames.indexOf(string2) != -1) {
                throw new IllegalArgumentException("Duplicated probe neighborhood: " + string2);
            }
            this.fNeighNames.add(string2);
        }
        this.fPnes = probeNeighborhoodEsStrucArray;
        this.fGeneSets = geneSetArray;
    }

    public final Dataset getFullDataset() {
        return this.fDataset;
    }

    public final String[] getGeneSetNames() {
        String[] stringArray = new String[this.getNumGeneSets()];
        for (int i2 = 0; i2 < this.getNumGeneSets(); ++i2) {
            stringArray[i2] = this.getGeneSet(i2).getName();
        }
        return stringArray;
    }

    public final String getNeighName(int n) {
        return this.fNeighNames.get(n).toString();
    }

    @Override
    public final String getQuickInfo() {
        return null;
    }

    public final int getNumNeighs() {
        return this.fPnes.length;
    }

    public final int getNumGeneSets() {
        return this.fGeneSets.length;
    }

    public final String getGeneSetName(int n) {
        return this.fGeneSets[n].getName();
    }

    public final GeneSet getGeneSet(int n) {
        return this.fGeneSets[n];
    }

    public final ProbeNeighborhoodEsStruc getPnes(String string) {
        return this.fPnes[this.fNeighNames.indexOf(string)];
    }

    public final ProbeNeighborhoodEsStruc getPnes(int n) {
        return this.fPnes[n];
    }

    public final String[] getNeighNames() {
        return this.fNeighNames.toArray(new String[this.fNeighNames.size()]);
    }
}

