/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Item;
import edu.mit.broad.genome.objects.TemplateCohort;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateImpl$ItemImpl;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.utils.CollectionUtils;
import edu.mit.broad.vdb.sampledb.Sample;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TemplateCohort$Comp {
    private String fName;
    private Color fColor;
    private String fClassAShortName;
    private String fClassBShortName;
    private Color fClassAColor_opt;
    private Color fClassBColor_opt;
    private String fClassASpec;
    private String fClassBSpec;
    private String fCategoryName;

    public TemplateCohort$Comp(String string, Color color, String string2, String string3, Color color2, String string4, String string5, Color color3, String string6) {
        this.fName = string;
        TemplateCohort$Comp.sanityCheck(string4, string6);
        TemplateCohort$Comp.sanityCheck(string3, string5);
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Param categoryName cannot be null");
        }
        this.fCategoryName = string2;
        this.fColor = color;
        this.fClassAShortName = string3;
        this.fClassBShortName = string5;
        this.fClassASpec = string4;
        this.fClassBSpec = string6;
        this.fClassAColor_opt = color2;
        this.fClassBColor_opt = color3;
    }

    private static void sanityCheck(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Class names cannot be null: >" + string + "< >" + string2 + "<");
        }
        if (string.length() == 0 || string2.length() == 0) {
            throw new IllegalArgumentException("Class names cannot be zero: >" + string + "< >" + string2 + "<");
        }
        if (string.equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException("Class names cannot be identical: >" + string + "< >" + string2 + "<");
        }
    }

    public final Color getColor() {
        if (this.fColor == null) {
            return Color.WHITE;
        }
        return this.fColor;
    }

    public final String getCategoryName() {
        return this.fCategoryName;
    }

    public final String getClassASpec() {
        return this.fClassASpec;
    }

    public final String getClassBSpec() {
        return this.fClassBSpec;
    }

    public final String getClassAShortName() {
        return this.fClassAShortName;
    }

    public final String getClassBShortName() {
        return this.fClassBShortName;
    }

    public final Color getClassAColor() {
        return this.fClassAColor_opt;
    }

    public final Color getClassBColor() {
        return this.fClassBColor_opt;
    }

    public final String getClassShortName(boolean bl) {
        if (bl) {
            return this.getClassAShortName();
        }
        return this.getClassBShortName();
    }

    public final String getClassSpec(boolean bl) {
        if (bl) {
            return this.getClassASpec();
        }
        return this.getClassBSpec();
    }

    public final String getName() {
        return this.fName;
    }

    public final String toString() {
        return this.fName;
    }

    public final List getSampleNames(SampleAnnot sampleAnnot, boolean bl) {
        if (sampleAnnot == null) {
            throw new IllegalArgumentException("Param annot cannot be null");
        }
        String string = this.getClassSpec(bl);
        Set set = ParseUtils.string2stringsSet(string, "+", false);
        set = CollectionUtils.toUpperCase(set);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < sampleAnnot.getNumSamples(); ++i2) {
            Sample sample = sampleAnnot.getSample(i2);
            String string2 = sample.getCategoryValue(this.getCategoryName()).toUpperCase();
            boolean bl2 = set.contains(string2);
            if (!bl2) continue;
            arrayList.add(sample.getName());
        }
        return arrayList;
    }

    public final SampleAnnot createSampleAnnot(SampleAnnot sampleAnnot, boolean bl) {
        List list = this.getSampleNames(sampleAnnot, bl);
        return sampleAnnot.cloneDeep(list.toArray(new String[list.size()]));
    }

    public final DatasetTemplate createDatasetTemplate(Dataset dataset) {
        String string;
        Template template = this.createTemplate(dataset.getAnnot().getSampleAnnot_synched(dataset.getColumnNamesArray()));
        DatasetTemplate datasetTemplate = new DatasetGenerators().extract(dataset, template);
        String string2 = this.getClassAShortName();
        if (string2.equals(string = datasetTemplate.getTemplate().getClass(0).getName())) {
            TemplateCohort.access$000().debug("Already ordered: " + string2 + " " + datasetTemplate.getTemplate().getName());
            return datasetTemplate;
        }
        Template template2 = TemplateFactory.createReversedBiphasicTemplate2(datasetTemplate.getTemplate());
        TemplateCohort.access$000().debug("Reversed template from: >" + datasetTemplate.getTemplate().getName() + " " + datasetTemplate.getTemplate().getClass(0).getName() + " " + datasetTemplate.getTemplate().getClass(1).getName() + "< to rev >" + template2.getName() + " " + template2.getClass(0).getName() + " " + template2.getClass(1).getName() + "<" + " comp: >" + string2 + " " + this.getClassBShortName() + "<");
        return new DatasetTemplate(datasetTemplate.getDataset(false), template2);
    }

    private static void sanityCheck(Template template, Template template2) {
        Errors errors = new Errors();
        for (int i2 = 0; i2 < template.getNumClasses(); ++i2) {
            if (template.getClass(i2).getName().equals(template2.getClass(i2).getName())) continue;
            errors.add(template.getClass(i2).getName() + " and " + template2.getClass(i2).getName() + " at loc: " + i2);
        }
        errors.barfIfNotEmptyRuntime();
    }

    public final Template createTemplate(SampleAnnot sampleAnnot) {
        if (sampleAnnot == null) {
            throw new IllegalArgumentException("Param annot cannot be null");
        }
        List list = this.getSampleNames(sampleAnnot, true);
        List list2 = this.getSampleNames(sampleAnnot, false);
        if (list.isEmpty() || list2.isEmpty()) {
            throw new IllegalArgumentException("No matches to some class specs\nfClassASpec: " + this.fClassASpec + " matches: " + list.size() + "\nfClassBSpec: " + this.fClassBSpec + " matches: " + list2.size());
        }
        ArrayList<TemplateImpl$ItemImpl> arrayList = new ArrayList<TemplateImpl$ItemImpl>();
        for (int i2 = 0; i2 < sampleAnnot.getNumSamples(); ++i2) {
            String string = sampleAnnot.getSample(i2).getName();
            if (list.contains(string)) {
                arrayList.add(TemplateImpl$ItemImpl.createItem(this.fClassAShortName, i2));
                continue;
            }
            if (!list2.contains(string)) continue;
            arrayList.add(TemplateImpl$ItemImpl.createItem(this.fClassBShortName, i2));
        }
        return TemplateFactory.createTemplate(this.getName(), arrayList.toArray(new Template$Item[arrayList.size()]), false);
    }
}

