/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PreTemplate;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.objects.Template$Item;
import edu.mit.broad.genome.objects.TemplateFactory$Struc2;
import edu.mit.broad.genome.objects.TemplateFromAnnot;
import edu.mit.broad.genome.objects.TemplateImpl;
import edu.mit.broad.genome.objects.TemplateImpl$ClassImpl;
import edu.mit.broad.genome.objects.TemplateImpl$ItemImpl;
import edu.mit.broad.genome.objects.TemplateImplFromSampleNames;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.vdb.sampledb.Sample;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import edu.mit.broad.vdb.sampledb.State;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class TemplateFactory
extends TemplateImpl {
    private static final Logger klog = XLogger.getLogger(TemplateFactory.class);
    private static final String VS = "_versus_";

    private TemplateFactory() {
    }

    public static final TemplateFactory$Struc2 createTemplate_struc(String string, State[] stateArray, SampleAnnot sampleAnnot) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < stateArray.length; ++i2) {
            object2 = stateArray[i2].getSamples();
            for (int i3 = 0; i3 < ((Sample[])object2).length; ++i3) {
                object = TemplateImpl$ItemImpl.createItem(stateArray[i2].getName(), sampleAnnot.getSampleIndex(object2[i3]));
                arrayList.add(object);
            }
        }
        Template$Item[] template$ItemArray = arrayList.toArray(new Template$Item[arrayList.size()]);
        object2 = TemplateFactory.hashProfilePosItemMap(template$ItemArray);
        int[] nArray = TemplateFactory.getProfilePositionsSorted((TIntObjectHashMap)object2);
        object = new ArrayList();
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            Template$Item template$Item = (Template$Item)((TIntObjectHashMap)object2).get(nArray[i4]);
            if (object.contains(template$Item.getId())) continue;
            object.add(template$Item.getId());
        }
        Template$Class[] template$ClassArray = new Template$Class[object.size()];
        for (int i5 = 0; i5 < object.size(); ++i5) {
            template$ClassArray[i5] = new TemplateImpl$ClassImpl(object.get(i5).toString());
        }
        TemplateFactory$Struc2 templateFactory$Struc2 = new TemplateFactory$Struc2();
        templateFactory$Struc2.template = TemplateFactory.createTemplate_ordered_assign(string, template$ItemArray, template$ClassArray, false);
        templateFactory$Struc2.samples_in_order = sampleAnnot.getSamples(nArray);
        return templateFactory$Struc2;
    }

    public static final TemplateFromAnnot createTemplate_from_annot(String string, State[] stateArray, SampleAnnot sampleAnnot) {
        TemplateFactory$Struc2 templateFactory$Struc2 = TemplateFactory.createTemplate_struc(string, stateArray, sampleAnnot);
        return new TemplateFromAnnot(templateFactory$Struc2.template, templateFactory$Struc2.samples_in_order, null, null);
    }

    public static final Template createTemplate(String string, State[] stateArray, SampleAnnot sampleAnnot) {
        return TemplateFactory.createTemplate_struc((String)string, (State[])stateArray, (SampleAnnot)sampleAnnot).template;
    }

    public static final synchronized DatasetTemplate extract(Dataset dataset, Template template, boolean bl) {
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Parameter template cannot be null");
        }
        for (int i2 = 0; i2 < template.getNumClasses(); ++i2) {
            if (template.getClass(i2).getSize() != 0) continue;
            throw new IllegalArgumentException("In template: " + template.getName() + " 0 members in class: " + template.getClass(i2).getName());
        }
        if (dataset.getNumCol() == template.getNumItems() && template.isAscendingProfilePositions()) {
            if (bl) {
                klog.info("Already a synched dataset-template -- NO extracting done");
            }
            return new DatasetTemplate(dataset, template);
        }
        if (bl) {
            klog.info("Extracting ds: " + dataset.getName() + " by template: " + template.getName());
        }
        Matrix matrix = new Matrix(dataset.getNumRow(), template.getNumItems());
        ArrayList<String> arrayList = new ArrayList<String>(template.getNumItems());
        Template$Item[] template$ItemArray = new Template$Item[template.getNumItems()];
        Template$Item[] template$ItemArray2 = template.getItemsOrderedByClassFirstAndThenProfilePos();
        for (int i3 = 0; i3 < template$ItemArray2.length; ++i3) {
            int n = template$ItemArray2[i3].getProfilePosition();
            matrix.setColumn(i3, dataset.getColumn(n));
            arrayList.add(dataset.getColumnName(n));
            template$ItemArray[i3] = TemplateImpl$ItemImpl.createItem(template$ItemArray2[i3].getId(), i3);
        }
        String string = NamingConventions.generateName(dataset, template, true);
        DefaultDataset defaultDataset = new DefaultDataset(string, matrix, dataset.getRowNames(), arrayList, true, false, true, dataset.getAnnot());
        defaultDataset.setProperty("extracted", "true");
        Template template2 = TemplateFactory.createTemplate(template.getName() + "_repos", template$ItemArray, template.isContinuous());
        return new DatasetTemplate(defaultDataset, template2);
    }

    public static final synchronized Template createTemplate(String string, List list, List list2, boolean bl) {
        return TemplateFactory.createTemplate_ordered_assign(string, list.toArray(new Template$Item[list.size()]), list2.toArray(new Template$Class[list2.size()]), bl);
    }

    public static final synchronized Template createTemplate(String string, Template$Item[] template$ItemArray, Template$Class[] template$ClassArray, boolean bl) {
        return TemplateFactory.createTemplate_ordered_assign(string, template$ItemArray, template$ClassArray, bl);
    }

    private static int _getColumnIndex(List list, String string) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string2 = list.get(i2).toString();
            if (!string.equalsIgnoreCase(string2)) continue;
            return i2;
        }
        return -1;
    }

    public static final synchronized Template createCategoricalTemplate(String string, Dataset dataset, String string2, String[] stringArray, String string3, String[] stringArray2) {
        return TemplateFactory.createCategoricalTemplate(string, dataset.getColumnNames(), string2, stringArray, string3, stringArray2);
    }

    public static final synchronized Template createCategoricalTemplate(String string, List list, String string2, String[] stringArray, String string3, String[] stringArray2) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Empty classASampleNames");
        }
        if (stringArray2.length == 0) {
            throw new IllegalArgumentException("Empty classBSampleNames");
        }
        FSet fSet = new FSet(string2, stringArray);
        FSet fSet2 = new FSet(string3, stringArray2);
        return TemplateFactory.createCategoricalTemplate(string, list, new GeneSet[]{fSet, fSet2});
    }

    public static final synchronized Template createCategoricalTemplate(String string, Dataset dataset, GeneSet[] geneSetArray) {
        return TemplateFactory.createCategoricalTemplate(string, dataset.getColumnNames(), geneSetArray);
    }

    public static final synchronized Template createCategoricalTemplate(String string, List list, GeneSet[] geneSetArray) {
        TemplateImpl templateImpl = new TemplateImpl(string);
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(geneSetArray[i2].getName(true));
            templateImpl.add(templateImpl$ClassImpl);
            for (int i3 = 0; i3 < geneSetArray[i2].getNumMembers(); ++i3) {
                String string2 = geneSetArray[i2].getMember(i3).toUpperCase();
                int n = TemplateFactory._getColumnIndex(list, string2);
                if (n == -1) {
                    throw new IllegalArgumentException("No such sample in ds: " + string2 + " \n" + Printf.outs(list));
                }
                TemplateImpl$ItemImpl templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem(geneSetArray[i2].getName(true), n);
                templateImpl.add(templateImpl$ItemImpl);
                templateImpl$ClassImpl.add(templateImpl$ItemImpl);
            }
        }
        templateImpl.setContinuous(false);
        templateImpl.setAux(false);
        templateImpl.makeImmutable();
        templateImpl.setSampleNamesFromDataset(true);
        return templateImpl;
    }

    private static synchronized Template createTemplate_ordered_assign(String string, Template$Item[] template$ItemArray, Template$Class[] template$ClassArray, boolean bl) {
        int n;
        if (template$ItemArray == null) {
            throw new IllegalArgumentException("Null items not allowed parameter");
        }
        if (template$ClassArray == null) {
            throw new IllegalArgumentException("Null classes not allowed parameter");
        }
        TemplateImpl templateImpl = new TemplateImpl(string);
        for (n = 0; n < template$ItemArray.length; ++n) {
            templateImpl.add(template$ItemArray[n]);
        }
        for (n = 0; n < template$ClassArray.length; ++n) {
            templateImpl.add(template$ClassArray[n]);
        }
        templateImpl.assignItems2ClassInOrder();
        templateImpl.setContinuous(bl);
        templateImpl.makeImmutable();
        return templateImpl;
    }

    public static final synchronized Template createTemplate(String string, Template$Item[] template$ItemArray, boolean bl) {
        if (template$ItemArray == null) {
            throw new IllegalArgumentException("Null items not allowed parameter");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Template$Item[] template$ItemArray2 = TemplateFactory.getProfilePositionsSorted(template$ItemArray);
        for (int i2 = 0; i2 < template$ItemArray2.length; ++i2) {
            String string2 = template$ItemArray2[i2].getId();
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        Template$Class[] template$ClassArray = new Template$Class[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            template$ClassArray[i3] = new TemplateImpl$ClassImpl(arrayList.get(i3).toString());
        }
        return TemplateFactory.createTemplate_ordered_assign(string, template$ItemArray, template$ClassArray, bl);
    }

    public static final synchronized Template createContinuousTemplate(String string, Vector vector) {
        TemplateImpl templateImpl = new TemplateImpl(string);
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl("class." + i2);
            templateImpl.add(templateImpl$ClassImpl);
            TemplateImpl$ItemImpl templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem(Float.toString(vector.getElement(i2)), i2);
            templateImpl.add(templateImpl$ItemImpl);
            templateImpl$ClassImpl.add(templateImpl$ItemImpl);
        }
        templateImpl.setContinuous(true);
        templateImpl.makeImmutable();
        return templateImpl;
    }

    public static final synchronized Template createContinuousTemplate(String string, Dataset dataset) {
        int n = dataset.getRowIndex(string);
        if (n == -1) {
            throw new IllegalArgumentException("No data in Dataset: " + dataset.getName() + " for probe: " + string);
        }
        Vector vector = dataset.getRow(n);
        return TemplateFactory.createContinuousTemplate(string, vector);
    }

    public static final synchronized Template[] createContinuousTemplates(GeneSet geneSet, Dataset dataset) {
        Template[] templateArray = new Template[geneSet.getNumMembers()];
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            templateArray[i2] = TemplateFactory.createContinuousTemplate(geneSet.getMember(i2), dataset);
        }
        return templateArray;
    }

    public static final synchronized Template[] createContinuousTemplates(String[] stringArray, Dataset dataset) {
        Template[] templateArray = new Template[stringArray.length];
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            templateArray[i2] = TemplateFactory.createContinuousTemplate(stringArray[i2], dataset);
        }
        return templateArray;
    }

    public static final synchronized Template createCategoricalTemplate(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<TemplateImpl$ItemImpl> arrayList2 = new ArrayList<TemplateImpl$ItemImpl>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Object object;
            if (!arrayList.contains(stringArray[i2])) {
                arrayList.add(stringArray[i2]);
                object = new TemplateImpl$ClassImpl("class." + stringArray[i2]);
                arrayList3.add(object);
            }
            object = TemplateImpl$ItemImpl.createItem(stringArray[i2], i2);
            arrayList2.add((TemplateImpl$ItemImpl)object);
        }
        return TemplateFactory.createTemplate(string, arrayList2, arrayList3, false);
    }

    public static final synchronized Template createCategoricalTemplate(String string, int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = "class_" + i2;
        }
        return TemplateFactory.createCategoricalTemplate(string, nArray, stringArray);
    }

    public static final synchronized Template createCategoricalTemplate(String string, int[] nArray, String[] stringArray) {
        if (nArray.length != stringArray.length) {
            throw new IllegalArgumentException("Number of classes: " + nArray.length + " not equal to number of classnames: " + stringArray.length);
        }
        ArrayList<TemplateImpl$ItemImpl> arrayList = new ArrayList<TemplateImpl$ItemImpl>();
        ArrayList<TemplateImpl$ClassImpl> arrayList2 = new ArrayList<TemplateImpl$ClassImpl>();
        int n = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(stringArray[i2]);
            arrayList2.add(templateImpl$ClassImpl);
            for (int i3 = 0; i3 < n2; ++i3) {
                TemplateImpl$ItemImpl templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem(Integer.toString(i2), n++);
                arrayList.add(templateImpl$ItemImpl);
            }
        }
        return TemplateFactory.createTemplate(string, arrayList, arrayList2, false);
    }

    public static final synchronized Template createBiphasicTemplate(String string, int n, int n2) {
        TemplateImpl templateImpl = new TemplateImpl(string);
        TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl("class_0");
        templateImpl.add(templateImpl$ClassImpl);
        int n3 = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            TemplateImpl$ItemImpl templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem("0", n3++);
            templateImpl.add(templateImpl$ItemImpl);
            templateImpl$ClassImpl.add(templateImpl$ItemImpl);
        }
        TemplateImpl$ClassImpl templateImpl$ClassImpl2 = new TemplateImpl$ClassImpl("class_1");
        templateImpl.add(templateImpl$ClassImpl2);
        for (int i3 = 0; i3 < n2; ++i3) {
            TemplateImpl$ItemImpl templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem("1", n3++);
            templateImpl.add(templateImpl$ItemImpl);
            templateImpl$ClassImpl2.add(templateImpl$ItemImpl);
        }
        templateImpl.setContinuous(false);
        templateImpl.makeImmutable();
        return templateImpl;
    }

    public static final Template createTemplate(String string, Matrix[] matrixArray) {
        int[] nArray = new int[matrixArray.length];
        for (int i2 = 0; i2 < matrixArray.length; ++i2) {
            nArray[i2] = matrixArray[i2].getNumCol();
        }
        return TemplateFactory.createCategoricalTemplate(string, nArray);
    }

    public static final Template createCategoricalTemplateFromClassCountByParsing(String string, String string2) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (stringTokenizer.hasMoreElements()) {
            object = stringTokenizer.nextToken();
            if (((String)(object = ((String)object).trim())).length() <= 0) continue;
            arrayList.add(object);
        }
        object = new String[arrayList.size()];
        int[] nArray = new int[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            stringTokenizer = new StringTokenizer(arrayList.get(i2).toString(), " \t");
            object[i2] = stringTokenizer.nextToken();
            nArray[i2] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return TemplateFactory.createCategoricalTemplate(string, nArray, (String[])object);
    }

    public static final Template creatCategoricalTemplate_by_splitting_pos_neg(RankedList rankedList) {
        Template$Item[] template$ItemArray = new Template$Item[rankedList.getSize()];
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            float f2 = rankedList.getScore(i2);
            String string = XMath.isPositive(f2) ? "pos" : "neg";
            template$ItemArray[i2] = TemplateImpl$ItemImpl.createItem(string, i2);
        }
        return TemplateFactory.createTemplate(rankedList.getName(), template$ItemArray, false);
    }

    public static final Template createCategoricalTemplate(String string, int n, int n2) {
        int n3;
        Template$Item[] template$ItemArray = new Template$Item[n + n2];
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            template$ItemArray[n4] = TemplateImpl$ItemImpl.createItem("A", n4);
            ++n4;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            template$ItemArray[n4] = TemplateImpl$ItemImpl.createItem("B", n4);
            ++n4;
        }
        return TemplateFactory.createTemplate(string, template$ItemArray, false);
    }

    public static final Template createCombinedTemplateUsingClass0(String string, Template[] templateArray) {
        return TemplateFactory.createCombinedTemplateUsingClassFoo(string, templateArray, true);
    }

    public static final Template createCombinedTemplateUsingClass1(String string, Template[] templateArray) {
        return TemplateFactory.createCombinedTemplateUsingClassFoo(string, templateArray, false);
    }

    public static final Template createCombinedTemplateUsingClassFoo(String string, Template[] templateArray, boolean bl) {
        ArrayList<TemplateImpl$ItemImpl> arrayList = new ArrayList<TemplateImpl$ItemImpl>();
        ArrayList<TemplateImpl$ClassImpl> arrayList2 = new ArrayList<TemplateImpl$ClassImpl>();
        int n = bl ? 0 : 1;
        int n2 = 0;
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            Template$Class template$Class = templateArray[i2].getClass(n);
            String string2 = template$Class.getName() + "_" + i2;
            for (int i3 = 0; i3 < template$Class.getSize(); ++i3) {
                TemplateImpl$ItemImpl templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem(string2, n2++);
                arrayList.add(templateImpl$ItemImpl);
            }
            TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(string2);
            arrayList2.add(templateImpl$ClassImpl);
        }
        return TemplateFactory.createTemplate(string, arrayList, arrayList2, false);
    }

    public static final synchronized Template extractTemplate(String string, Template template, int[] nArray) {
        if (template == null) {
            throw new IllegalArgumentException("Param origT cannot be null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("Param colIndices cannot be null");
        }
        Template$Item[] template$ItemArray = new Template$Item[nArray.length];
        HashSet<Template$Class> hashSet = new HashSet<Template$Class>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Template$Item template$Item = template.getItemByProfilePos(nArray[i2]);
            template$ItemArray[i2] = TemplateImpl$ItemImpl.createItem(template$Item.getId(), i2);
            hashSet.add(template.getClass(template$Item));
        }
        Template$Class[] template$ClassArray = hashSet.toArray(new Template$Class[hashSet.size()]);
        return TemplateFactory.createTemplate_ordered_assign(string, template$ItemArray, template$ClassArray, template.isContinuous());
    }

    public static final synchronized Template extractTemplate(String string, Template template, int[] nArray, boolean bl) {
        if (template == null) {
            throw new IllegalArgumentException("Param origT cannot be null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("Param colIndices_in_orig cannot be null");
        }
        if (bl) {
            return TemplateFactory.extractTemplate(string, template, nArray);
        }
        TIntHashSet tIntHashSet = new TIntHashSet(nArray);
        TIntArrayList tIntArrayList = new TIntArrayList();
        int[] nArray2 = template.getProfilePositionsOrdered();
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            if (tIntHashSet.contains(nArray2[i2])) continue;
            tIntArrayList.add(nArray2[i2]);
        }
        return TemplateFactory.extractTemplate(string, template, tIntArrayList.toNativeArray());
    }

    public static final Template[] extractAllPossibleTemplates(Template template, boolean bl) {
        if (template == null) {
            throw new IllegalArgumentException("Parameter origT cannot be null");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            arrayList.add(template);
        }
        if (!(template instanceof PreTemplate)) {
            if (template instanceof TemplateImplFromSampleNames) {
                Template template2 = TemplateFactory.extractForwardBiphasicTemplate(template);
                arrayList.add(template2);
                Template template3 = TemplateFactory.createReversedBiphasicTemplate(template);
                arrayList.add(template3);
            } else if (!template.isContinuous()) {
                Object object;
                if (template.getNumClasses() > 2) {
                    object = TemplateFactory.extractAll2ClassTemplates(template, false);
                    for (int i2 = 0; i2 < ((Template[])object).length; ++i2) {
                        arrayList.add(object[i2]);
                    }
                }
                if (template.getNumClasses() == 2) {
                    object = TemplateFactory.extractForwardBiphasicTemplate(template);
                    arrayList.add(object);
                    Template template4 = TemplateFactory.createReversedBiphasicTemplate(template);
                    arrayList.add(template4);
                }
                if (!template.isAux() && template.getNumClasses() > 1) {
                    object = TemplateFactory.extractAllUniphasicTemplates(template);
                    for (int i3 = 0; i3 < ((Template[])object).length; ++i3) {
                        arrayList.add(object[i3]);
                    }
                }
            }
        }
        return arrayList.toArray(new Template[arrayList.size()]);
    }

    public static final Template[] extractAll2ClassTemplates(Template template, boolean bl) {
        ArrayList<Template> arrayList = new ArrayList<Template>();
        if (template.getNumClasses() == 2) {
            arrayList.add(template);
            arrayList.add(TemplateFactory.createReversedBiphasicTemplate(template));
            return arrayList.toArray(new Template[arrayList.size()]);
        }
        Template[] templateArray = TemplateFactory.extractAllOvaTemplates(template, bl);
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            arrayList.add(templateArray[i2]);
        }
        Template[] templateArray2 = TemplateFactory.extractAllPairsTemplates(template);
        for (int i3 = 0; i3 < templateArray2.length; ++i3) {
            arrayList.add(templateArray2[i3]);
        }
        return arrayList.toArray(new Template[arrayList.size()]);
    }

    public static final synchronized Template[] extractAllPairsTemplates(Template template) {
        Object object;
        if (template.getNumClasses() < 2) {
            throw new IllegalArgumentException("At least 3 Template classes needed to do ALL_PAIRS");
        }
        if (template.isContinuous()) {
            throw new IllegalArgumentException("Cannot work on continuous Template: " + template.getName());
        }
        ArrayList<Template$Class[]> arrayList = new ArrayList<Template$Class[]>();
        for (int i2 = 0; i2 < template.getNumClasses(); ++i2) {
            Template$Class template$Class = template.getClass(i2);
            for (int i3 = 0; i3 < template.getNumClasses(); ++i3) {
                if (i2 == i3) continue;
                object = template.getClass(i3);
                arrayList.add(new Template$Class[]{template$Class, object});
            }
        }
        ArrayList<TemplateImpl> arrayList2 = new ArrayList<TemplateImpl>(arrayList.size());
        for (int i4 = 0; i4 < arrayList.size(); ++i4) {
            Template$Item template$Item;
            Template$Item template$Item2;
            int n;
            Template$Class[] template$ClassArray = (Template$Class[])arrayList.get(i4);
            object = template.getName() + "#" + template$ClassArray[0].getName() + VS + template$ClassArray[1].getName();
            TemplateImpl templateImpl = new TemplateImpl((String)object);
            TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(template$ClassArray[0].getName());
            TemplateImpl$ClassImpl templateImpl$ClassImpl2 = new TemplateImpl$ClassImpl(template$ClassArray[1].getName());
            templateImpl.add(templateImpl$ClassImpl);
            templateImpl.add(templateImpl$ClassImpl2);
            for (n = 0; n < template$ClassArray[0].getSize(); ++n) {
                template$Item2 = template$ClassArray[0].getItem(n);
                template$Item = template$Item2.cloneDeep();
                templateImpl$ClassImpl.add(template$Item);
                templateImpl.add(template$Item);
            }
            for (n = 0; n < template$ClassArray[1].getSize(); ++n) {
                template$Item2 = template$ClassArray[1].getItem(n);
                template$Item = template$Item2.cloneDeep();
                templateImpl$ClassImpl2.add(template$Item);
                templateImpl.add(template$Item);
            }
            templateImpl.setContinuous(false);
            templateImpl.makeImmutable();
            arrayList2.add(templateImpl);
        }
        return arrayList2.toArray(new Template[arrayList2.size()]);
    }

    public static final synchronized Template[] extractAllOvaTemplates(Template template, boolean bl) {
        if (template.getNumClasses() <= 2) {
            throw new IllegalArgumentException("At least 3 Template classes needed to make a set of ova templates but found: " + template.getNumClasses() + "\n" + template.getAsString(false));
        }
        ArrayList<Template> arrayList = new ArrayList<Template>();
        for (int i2 = 0; i2 < template.getNumClasses(); ++i2) {
            Template$Class template$Class = template.getClass(i2);
            Template template2 = TemplateFactory.extractOvaTemplate(template, template$Class);
            arrayList.add(template2);
            if (bl) continue;
            String string = template.getName() + "#REST" + VS + template$Class.getName();
            Template template3 = TemplateFactory._createReversedBiphasicTemplate(string, template2);
            arrayList.add(template3);
        }
        return arrayList.toArray(new Template[arrayList.size()]);
    }

    public static final synchronized Template extractOvaTemplate(Template template, Template$Class template$Class) {
        Object object;
        int n;
        if (!template.isMemberClass(template$Class)) {
            throw new IllegalArgumentException("Specified theOneClass: " + template$Class.getName() + " is not a member of parentMultiClassTemplate: " + template.getName());
        }
        if (template.getNumClasses() <= 2) {
            throw new IllegalArgumentException("Need 3 or more classes to do a ova. Found: " + template.getNumClasses());
        }
        if (template.isContinuous()) {
            throw new IllegalArgumentException("Cannot work on continuous Template: " + template.getName());
        }
        String string = template.getName() + "#" + template$Class.getName() + VS + "REST";
        TemplateImpl templateImpl = new TemplateImpl(string);
        TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(template$Class.getName());
        templateImpl.add(templateImpl$ClassImpl);
        int n2 = template.getClassIndex(template$Class);
        TemplateImpl$ClassImpl templateImpl$ClassImpl2 = new TemplateImpl$ClassImpl("REST");
        templateImpl.add(templateImpl$ClassImpl2);
        for (n = 0; n < template$Class.getSize(); ++n) {
            object = TemplateImpl$ItemImpl.createItem(template$Class.getName(), template$Class.getItem(n).getProfilePosition());
            templateImpl.add((Template$Item)object);
            templateImpl$ClassImpl.add((Template$Item)object);
        }
        for (n = 0; n < template.getNumClasses(); ++n) {
            object = template.getClass(n);
            if (n == n2) continue;
            for (int i2 = 0; i2 < object.getSize(); ++i2) {
                TemplateImpl$ItemImpl templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem("REST", object.getItem(i2).getProfilePosition());
                templateImpl.add(templateImpl$ItemImpl);
                templateImpl$ClassImpl2.add(templateImpl$ItemImpl);
            }
        }
        templateImpl.setContinuous(false);
        templateImpl.makeImmutable();
        return templateImpl;
    }

    public static final synchronized Template extractForwardBiphasicTemplate(Template template) {
        if (template.getNumClasses() != 2) {
            throw new IllegalArgumentException("Cannot straight template as its not biphasic. # classes: " + template.getNumClasses() + " " + template.getName());
        }
        String string = template.getName() + "#" + template.getClassName(0) + VS + template.getClassName(1);
        Template template2 = template.cloneDeep(string);
        template2.makeImmutable();
        return template2;
    }

    public static final synchronized Template createReversedBiphasicTemplate(Template template) {
        return TemplateFactory._createReversedBiphasicTemplate(template.getName() + "#" + template.getClassName(1) + VS + template.getClassName(0), template);
    }

    public static final synchronized Template createReversedBiphasicTemplate2(Template template) {
        return TemplateFactory._createReversedBiphasicTemplate(template.getClassName(1) + VS + template.getClassName(0), template);
    }

    private static synchronized Template _createReversedBiphasicTemplate(String string, Template template) {
        if (template.getNumClasses() != 2) {
            throw new IllegalArgumentException("Cannot reverse template as its not biphasic. # classes: " + template.getNumClasses() + " " + template.getName());
        }
        if (template instanceof TemplateImplFromSampleNames) {
            return ((TemplateImplFromSampleNames)template).cloneDeepReversed(string);
        }
        TemplateImpl templateImpl = new TemplateImpl(string);
        TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(template.getClass(1).getName());
        for (int i2 = 0; i2 < template.getClass(1).getSize(); ++i2) {
            Template$Item template$Item = template.getClass(1).getItem(i2);
            templateImpl$ClassImpl.add(template$Item.cloneDeep());
            templateImpl.add(template$Item);
        }
        TemplateImpl$ClassImpl templateImpl$ClassImpl2 = new TemplateImpl$ClassImpl(template.getClassName(0));
        for (int i3 = 0; i3 < template.getClass(0).getSize(); ++i3) {
            Template$Item template$Item = template.getClass(0).getItem(i3);
            templateImpl$ClassImpl2.add(template$Item.cloneDeep());
            templateImpl.add(template$Item);
        }
        templateImpl.add(templateImpl$ClassImpl);
        templateImpl.add(templateImpl$ClassImpl2);
        templateImpl.setContinuous(false);
        templateImpl.makeImmutable();
        return templateImpl;
    }

    public static final synchronized Template extractUniphasicTemplate(Template template, Template$Class template$Class) {
        if (template.isAux()) {
            throw new IllegalArgumentException("Cannot make uniphasic from aux templates: " + template.getName());
        }
        TemplateImpl templateImpl = new TemplateImpl(template.getName() + "#" + template$Class.getName());
        TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(template$Class.getName());
        templateImpl.add(templateImpl$ClassImpl);
        for (int i2 = 0; i2 < template$Class.getSize(); ++i2) {
            Template$Item template$Item = template$Class.getItem(i2);
            Template$Item template$Item2 = template$Item.cloneDeep();
            templateImpl.add(template$Item2);
            templateImpl$ClassImpl.add(template$Item2);
        }
        templateImpl.setContinuous(false);
        templateImpl.setAux(true);
        templateImpl.makeImmutable();
        return templateImpl;
    }

    public static final synchronized Template extractUniphasicTemplateUntested(Template template, Template$Class template$Class) {
        TemplateImpl templateImpl = new TemplateImpl(template.getName() + "#" + template$Class.getName());
        TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(template$Class.getName());
        templateImpl.add(templateImpl$ClassImpl);
        for (int i2 = 0; i2 < template$Class.getSize(); ++i2) {
            Template$Item template$Item = template$Class.getItem(i2);
            TemplateImpl$ItemImpl templateImpl$ItemImpl = TemplateImpl$ItemImpl.createItem(templateImpl$ClassImpl.getName(), template$Item.getProfilePosition());
            templateImpl.add(templateImpl$ItemImpl);
            templateImpl$ClassImpl.add(templateImpl$ItemImpl);
        }
        templateImpl.setContinuous(false);
        templateImpl.setAux(true);
        templateImpl.makeImmutable();
        return templateImpl;
    }

    public static final synchronized Template[] extractAllUniphasicTemplates(Template template) {
        Template[] templateArray = new Template[template.getNumClasses()];
        for (int i2 = 0; i2 < template.getNumClasses(); ++i2) {
            templateArray[i2] = TemplateFactory.extractUniphasicTemplate(template, template.getClass(i2));
        }
        return templateArray;
    }

    public static final Template createAuxEqualizedRealTemplate(Template template, RandomSeedGenerator randomSeedGenerator) {
        if (template.getNumClasses() != 2) {
            throw new IllegalArgumentException("Only 2 class templates possible");
        }
        int n = XMath.min(new int[]{template.getClass(0).getSize(), template.getClass(1).getSize()});
        return TemplateFactory.createAuxConstrainedRealTemplate(template, n, n, randomSeedGenerator);
    }

    public static final Template createAuxConstrainedRealTemplate(Template template, int n, int n2, RandomSeedGenerator randomSeedGenerator) {
        Template$Item template$Item;
        Template$Class template$Class = template.getClass(0);
        Template$Class template$Class2 = template.getClass(1);
        if (n > template$Class.getSize()) {
            throw new IllegalArgumentException("numFromC0inC0:   cannot be larger than size of templateclass 0: " + template$Class.getSize());
        }
        if (n2 > template$Class2.getSize()) {
            throw new IllegalArgumentException("numFromC1inC1: " + n2 + " cannot be larger than size of templateclass 1: " + template$Class2.getSize());
        }
        TemplateImpl templateImpl = new TemplateImpl(template.getName() + "#" + n + "_" + n2);
        TemplateImpl$ClassImpl templateImpl$ClassImpl = new TemplateImpl$ClassImpl(template$Class.getName());
        TemplateImpl$ClassImpl templateImpl$ClassImpl2 = new TemplateImpl$ClassImpl(template$Class2.getName());
        int[] nArray = XMath.randomlyPickIndicesWithoutReplacement(n, template$Class.getSize(), randomSeedGenerator);
        for (int i2 = 0; i2 < n; ++i2) {
            Template$Item template$Item2 = template$Class.getItem(nArray[i2]);
            template$Item = template$Item2.cloneDeep();
            templateImpl$ClassImpl.add(template$Item);
            templateImpl.add(template$Item);
        }
        int[] nArray2 = XMath.randomlyPickIndicesWithoutReplacement(n2, template$Class2.getSize(), randomSeedGenerator);
        for (int i3 = 0; i3 < nArray2.length; ++i3) {
            template$Item = template$Class2.getItem(nArray2[i3]);
            Template$Item template$Item3 = template$Item.cloneDeep();
            templateImpl$ClassImpl2.add(template$Item3);
            templateImpl.add(template$Item3);
        }
        templateImpl.add(templateImpl$ClassImpl);
        templateImpl.add(templateImpl$ClassImpl2);
        templateImpl.setClassOfInterestIndex(template.getClassOfInterestIndex());
        templateImpl.setAux(true);
        templateImpl.setContinuous(false);
        templateImpl.makeImmutable();
        return templateImpl;
    }
}

