/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.AbstractTemplate;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.objects.Template$Item;
import gnu.trove.TFloatArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;

public class TemplateImpl$ClassImpl
implements Template$Class {
    protected String fName;
    protected ArrayList fItems;

    public TemplateImpl$ClassImpl(String string) {
        this.fName = string;
        this.fItems = new ArrayList();
    }

    @Override
    public final String getName() {
        return this.fName;
    }

    @Override
    public final Template$Item getItem(int n) {
        return (Template$Item)this.fItems.get(n);
    }

    @Override
    public final int[] getOrderedProfilePositions() {
        Template$Item[] template$ItemArray = this.getItemsOrderedByProfilePos();
        int[] nArray = new int[template$ItemArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = template$ItemArray[i2].getProfilePosition();
        }
        if (!XMath.isAscending(nArray)) {
            throw new IllegalStateException();
        }
        return nArray;
    }

    @Override
    public final Template$Item[] getItemsOrderedByProfilePos() {
        Template$Item[] template$ItemArray = this.fItems.toArray(new Template$Item[this.fItems.size()]);
        TIntObjectHashMap tIntObjectHashMap = AbstractTemplate.hashProfilePosItemMap(template$ItemArray);
        int[] nArray = AbstractTemplate.getProfilePositionsSorted(tIntObjectHashMap);
        Template$Item[] template$ItemArray2 = new Template$Item[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            template$ItemArray2[i2] = (Template$Item)tIntObjectHashMap.get(nArray[i2]);
        }
        return template$ItemArray2;
    }

    @Override
    public final List extractColumnNames(Dataset dataset) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = this.getOrderedProfilePositions();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(dataset.getColumnName(nArray[i2]));
        }
        return arrayList;
    }

    @Override
    public final int getSize() {
        return this.fItems.size();
    }

    public final int hashCode() {
        return this.fName.hashCode();
    }

    @Override
    public final int getMinItemPosition() {
        return XMath.min(this.getProfilePositions());
    }

    @Override
    public final int getMaxItemPosition() {
        return XMath.max(this.getProfilePositions());
    }

    @Override
    public final int[] getProfilePositions() {
        int[] nArray = new int[this.getSize()];
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            nArray[i2] = this.getItem(i2).getProfilePosition();
        }
        return nArray;
    }

    @Override
    public final String getMembershipInfo() {
        StringBuffer stringBuffer = new StringBuffer("Class: ").append(this.getName()).append('\n');
        stringBuffer.append("Members: \t");
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            int n = this.getItem(i2).getProfilePosition();
            if (n != -1) {
                stringBuffer.append(this.getItem(i2).getId()).append('[').append(i2).append(',').append(n).append(']');
            } else {
                stringBuffer.append(this.getItem(i2).getId()).append('[').append(this.getItem(i2).getProfilePosition()).append(']');
            }
            if (i2 == this.getSize() - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    @Override
    public final Vector extractByTemplateClass(Vector vector) {
        Vector vector2 = new Vector(this.getSize());
        int[] nArray = this.getProfilePositions();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            vector2.setElement(i2, vector.getElement(nArray[i2]));
        }
        return vector2;
    }

    @Override
    public final Vector extractByTemplateClass(Vector vector, int n) {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            int n2 = this.getItem(i2).getProfilePosition();
            if (n2 == n) continue;
            tFloatArrayList.add(vector.getElement(n2));
        }
        return new Vector(tFloatArrayList);
    }

    protected final void setName(String string) {
        this.fName = string;
    }

    protected final void add(Template$Item template$Item) {
        if (template$Item == null) {
            throw new IllegalArgumentException("item cannot be null");
        }
        this.fItems.add(template$Item);
    }
}

