/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.AnnotImpl;
import edu.mit.broad.genome.objects.ColorMap$Columns;
import edu.mit.broad.genome.objects.ColumnsImpl;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.FeatureAnnotImpl;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbMulti;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.strucs.NamedColor;
import edu.mit.broad.genome.utils.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractEnrichmentDbMulti
extends AbstractObject
implements EnrichmentDbMulti {
    private List fRowNames;
    private GeneSet fRowNamesGeneSet;
    private List fColNames;
    private GeneSet fColNamesGeneSet;
    private int fNumRows;
    protected Dataset essDataset;
    protected Dataset nessDataset;
    protected Dataset npDataset;
    protected Dataset fdrDataset;

    protected final void init(String string, String[] stringArray, String[] stringArray2) {
        int n;
        super.initialize(string);
        if (stringArray2 == null) {
            throw new IllegalArgumentException("Param edbNames cannot be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Param rowNames cannot be null");
        }
        this.fColNames = new ArrayList();
        for (n = 0; n < stringArray2.length; ++n) {
            this.fColNames.add(stringArray2[n]);
        }
        this.fRowNames = new ArrayList();
        for (n = 0; n < stringArray.length; ++n) {
            this.fRowNames.add(stringArray[n]);
        }
        this.fNumRows = stringArray.length;
    }

    @Override
    public Dataset getESSDataset() {
        if (this.essDataset == null) {
            this.log.debug("Starting essDataset gen");
            Timer timer = new Timer();
            Matrix matrix = new Matrix(this.getNumRow(), this.getNumEdbs());
            for (int i2 = 0; i2 < this.getNumEdbs(); ++i2) {
                matrix.setColumn(i2, this.getEdb(i2).getESS());
                if (i2 % 5 != 0) continue;
                System.out.println("Done ess: " + (i2 + 1) + " / " + this.getNumEdbs());
            }
            timer.stop();
            timer.printTimeTakenS("Retrieved essDataset from edb");
            this.essDataset = new DefaultDataset(this.getName() + "_ess", matrix, this.getRowNamesArray(), this.getEdbNamesArray(), true);
            ((DefaultDataset)this.essDataset).cloneShallow(this._ann());
        }
        return this.essDataset;
    }

    @Override
    public Dataset getNESSDataset() {
        if (this.nessDataset == null) {
            this.log.debug("Starting nessDataset gen");
            Timer timer = new Timer();
            Matrix matrix = new Matrix(this.getNumRow(), this.getNumEdbs());
            for (int i2 = 0; i2 < this.getNumEdbs(); ++i2) {
                matrix.setColumn(i2, this.getEdb(i2).getNESS());
            }
            timer.stop();
            timer.printTimeTaken("Retrieved nessDataset from edb");
            this.nessDataset = new DefaultDataset(this.getName() + "_ness", matrix, this.getRowNamesArray(), this.getEdbNamesArray(), true);
            ((DefaultDataset)this.nessDataset).cloneShallow(this._ann());
        }
        return this.nessDataset;
    }

    @Override
    public Dataset getNPDataset() {
        if (this.npDataset == null) {
            this.log.debug("Starting npDataset gen");
            Timer timer = new Timer();
            Matrix matrix = new Matrix(this.getNumRow(), this.getNumEdbs());
            for (int i2 = 0; i2 < this.getNumEdbs(); ++i2) {
                matrix.setColumn(i2, this.getEdb(i2).getNPs());
            }
            timer.stop();
            timer.printTimeTaken("Retrieved npDataset from edb");
            this.npDataset = new DefaultDataset(this.getName() + "_np", matrix, this.getRowNamesArray(), this.getEdbNamesArray(), true);
            ((DefaultDataset)this.npDataset).cloneShallow(this._ann());
        }
        return this.npDataset;
    }

    @Override
    public Dataset getFDRDataset() {
        if (this.fdrDataset == null) {
            this.log.debug("Starting fdrDataset gen");
            Timer timer = new Timer();
            Matrix matrix = new Matrix(this.getNumRow(), this.getNumEdbs());
            for (int i2 = 0; i2 < this.getNumEdbs(); ++i2) {
                matrix.setColumn(i2, this.getEdb(i2).getFDRs());
            }
            timer.stop();
            timer.printTimeTaken("Retrieved fdrDataset from edb");
            this.fdrDataset = new DefaultDataset(this.getName() + "_fdr", matrix, this.getRowNamesArray(), this.getEdbNamesArray(), true);
            ((DefaultDataset)this.fdrDataset).cloneShallow(this._ann());
        }
        return this.fdrDataset;
    }

    private Annot _ann() {
        FeatureAnnotImpl featureAnnotImpl = new FeatureAnnotImpl("foo", this.getRowNames(), null);
        SampleAnnotImpl sampleAnnotImpl = new SampleAnnotImpl("bar", this.getEdbNamesArray(), (ColorMap$Columns)new ColumnsImpl(new NamedColor[0]));
        return new AnnotImpl(featureAnnotImpl, sampleAnnotImpl);
    }

    @Override
    public int getNumEdbs() {
        return this.fColNames.size();
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    @Override
    public EnrichmentResult[] getResults(String string) {
        EnrichmentResult[] enrichmentResultArray = new EnrichmentResult[this.getNumEdbs()];
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            enrichmentResultArray[i2] = this.getEdb(i2).getResultForGeneSet(string);
        }
        return enrichmentResultArray;
    }

    @Override
    public List getRowNames() {
        return Collections.unmodifiableList(this.fRowNames);
    }

    @Override
    public GeneSet getRowNamesGeneSet() {
        if (this.fRowNamesGeneSet == null) {
            this.fRowNamesGeneSet = new FSet(this.getName(), new HashSet(this.fRowNames));
        }
        return this.fRowNamesGeneSet;
    }

    @Override
    public String[] getRowNamesArray() {
        return this.fRowNames.toArray(new String[this.fRowNames.size()]);
    }

    @Override
    public int getNumRow() {
        return this.fNumRows;
    }

    @Override
    public List getEdbNames() {
        return Collections.unmodifiableList(this.fColNames);
    }

    @Override
    public GeneSet getEdbNamesGeneSet() {
        if (this.fColNamesGeneSet == null) {
            this.fColNamesGeneSet = new FSet(this.getName(), new HashSet(this.fColNames));
        }
        return this.fColNamesGeneSet;
    }

    @Override
    public String[] getEdbNamesArray() {
        return this.fColNames.toArray(new String[this.fColNames.size()]);
    }

    @Override
    public String getEdbName(int n) {
        return (String)this.fColNames.get(n);
    }

    @Override
    public int getEdbIndex(String string) {
        return this.fColNames.indexOf(string);
    }

    @Override
    public EnrichmentDb[] getEdbs(String[] stringArray) {
        EnrichmentDb[] enrichmentDbArray = new EnrichmentDb[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            enrichmentDbArray[i2] = this.getEdb(stringArray[i2]);
        }
        return enrichmentDbArray;
    }

    @Override
    public EnrichmentDb[] getEdbs(int[] nArray) {
        EnrichmentDb[] enrichmentDbArray = new EnrichmentDb[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            enrichmentDbArray[i2] = this.getEdb(nArray[i2]);
        }
        return enrichmentDbArray;
    }
}

