/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.alg.gsea.EdbAlgs;
import edu.mit.broad.genome.alg.gsea.MhtMode;
import edu.mit.broad.genome.alg.gsea.MhtModes$VarMean;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.ObjectMatrix;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DtgDataset
extends AbstractObject {
    private List fRowNames;
    private List fColNames;
    private ObjectMatrix fMatrix;
    private MhtMode[] fMhtModes;

    public DtgDataset(String string, ObjectMatrix objectMatrix, List list, List list2) {
        super(string);
        if (objectMatrix == null) {
            throw new IllegalArgumentException("Parameter dtgMatrix cannot be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Parameter rowNames cannot be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Parameter colNames cannot be null");
        }
        if (objectMatrix.getNumRow() != list.size()) {
            throw new IllegalArgumentException("Mismatched nrows");
        }
        if (objectMatrix.getNumCol() != list2.size()) {
            throw new IllegalArgumentException("Mismatched ncols");
        }
        this.fMatrix = objectMatrix;
        this.fRowNames = list;
        this.fColNames = list2;
        this.fMhtModes = new MhtMode[this.fMatrix.getNumCol()];
        for (int i2 = 0; i2 < this.fMatrix.getNumCol(); ++i2) {
            Object[] objectArray = this.fMatrix.getColumn(i2);
            EnrichmentResult[] enrichmentResultArray = new EnrichmentResult[objectArray.length];
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                enrichmentResultArray[i3] = (EnrichmentResult)objectArray[i3];
            }
            this.fMhtModes[i2] = new MhtModes$VarMean(enrichmentResultArray);
        }
    }

    public final Dataset createRealESDataset() {
        Matrix matrix = new Matrix(this.getNumRow(), this.getNumCol());
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                matrix.setElement(i2, i3, this.getRealEs(i2, i3));
            }
        }
        return new DefaultDataset(this.getName() + ".ES", matrix, this.getRowNames(), this.getColNames(), true, null);
    }

    public final Dataset createRealNESDataset() {
        Matrix matrix = new Matrix(this.getNumRow(), this.getNumCol());
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                matrix.setElement(i2, i3, this.getNes(i2, i3));
            }
        }
        return new DefaultDataset(this.getName() + ".NES", matrix, this.getRowNames(), this.getColNames(), true, null);
    }

    public final int getNumRow() {
        return this.fRowNames.size();
    }

    public final int getNumCol() {
        return this.fColNames.size();
    }

    @Override
    public final String getQuickInfo() {
        return this.getNumRow() + "x" + this.getNumCol();
    }

    public final String getRowName(int n) {
        return this.fRowNames.get(n).toString();
    }

    public final List getRowNames() {
        return Collections.unmodifiableList(this.fRowNames);
    }

    public final List getColNames() {
        return Collections.unmodifiableList(this.fColNames);
    }

    public final String getColName(int n) {
        return this.fColNames.get(n).toString();
    }

    public final float getRealEs(int n, int n2) {
        return this.getDtg(n, n2).getScore().getES();
    }

    public final float getNes(int n, int n2) {
        return this.fMhtModes[n2].getRealNES(n);
    }

    public final float getNominalPValue(int n, int n2) {
        return EdbAlgs.getNominalPValue(this.getDtg(n, n2));
    }

    public final float getDiscoveryPValue(int n, int n2) {
        return this.fMhtModes[n2].getDiscoveryPValue(n);
    }

    public final float getValidationPValue(int n, int n2) {
        return this.fMhtModes[n2].getValidationPValue(n);
    }

    public final EnrichmentResult getDtg(int n, int n2) {
        return (EnrichmentResult)this.fMatrix.getElement(n, n2);
    }

    public final EnrichmentResult[] getDtgRow(int n) {
        EnrichmentResult[] enrichmentResultArray = new EnrichmentResult[this.getNumRow()];
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            enrichmentResultArray[i2] = this.getDtg(n, i2);
        }
        return enrichmentResultArray;
    }

    public final EnrichmentResult[] getDtgCol(int n) {
        EnrichmentResult[] enrichmentResultArray = new EnrichmentResult[this.getNumCol()];
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            enrichmentResultArray[i2] = this.getDtg(i2, n);
        }
        return enrichmentResultArray;
    }

    public final void ensureSameGeneSetsForEveryRow() {
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            this.ensureSameGeneSetsInRow(i2);
        }
    }

    public final void ensureSameGeneSetsInRow(int n) {
        GeneSet geneSet = null;
        for (int i2 = 0; i2 < this.fMatrix.getNumCol(); ++i2) {
            EnrichmentResult enrichmentResult = this.getDtg(n, i2);
            if (geneSet == null) {
                geneSet = enrichmentResult.getGeneSet();
            }
            if (enrichmentResult.getGeneSet().equalsShallow(geneSet)) continue;
            throw new IllegalStateException("Mismatched gensets: " + geneSet + " and " + enrichmentResult.getGeneSet());
        }
    }

    public final void ensureSameTemplate() {
        Template template = null;
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                EnrichmentResult enrichmentResult = this.getDtg(i2, i3);
                if (template == null) {
                    template = enrichmentResult.getTemplate();
                }
                if (enrichmentResult.getTemplate().equalsShallow(template)) continue;
                throw new IllegalStateException("Mismatched templates: " + template + " and " + enrichmentResult.getTemplate());
            }
        }
    }

    public final List getGeneSetNamesForCol(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            arrayList.add(this.getDtg(i2, n).getGeneSet().getName());
        }
        return arrayList;
    }

    public final List getGeneSetsForCol(int n) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            arrayList.add(this.getDtg(i2, n).getGeneSet());
        }
        return arrayList;
    }
}

