/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.strucs.FdrStruc;
import edu.mit.broad.vdb.chip.Chip;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public interface EnrichmentDb
extends PersistentObject {
    public EnrichmentDb cloneDeep(EnrichmentResult[] var1);

    public EnrichmentDb cloneShallow(String var1);

    public EnrichmentDb cloneShallow(Dataset var1);

    public File getEdbDir();

    public Template getTemplate();

    public Dataset getDataset();

    public Chip getChip();

    public RankedList getRankedList();

    public GeneSet[] getGeneSetSignals();

    public GeneSet[] getGeneSets();

    public List getGeneSetNames();

    public String[] getGeneSetNamesArray();

    public GeneSet[] getGeneSetSignals(float var1, float var2, Comparator var3);

    public GeneSet[] getGeneSets(float var1, float var2, Comparator var3);

    public boolean containsGeneSet(String var1);

    public int getNumScores(boolean var1);

    public int getNumNominallySig(float var1, boolean var2);

    public int getNumFDRSig(float var1, boolean var2);

    public FdrStruc[] getFDRSig(float var1, boolean var2);

    public FdrStruc[] getFDR_all();

    public FdrStruc[] getFDR(boolean var1);

    public EnrichmentResult getResult(int var1);

    public EnrichmentResult[] getResults(float var1, float var2, Comparator var3);

    public EnrichmentResult[] getResults();

    public EnrichmentResult[] getResults(Comparator var1);

    public EnrichmentResult[] getResults(Comparator var1, boolean var2);

    public List getResultsList(Comparator var1);

    public List getResultsList();

    public int getNumResults();

    public EnrichmentResult getResultForGeneSet(String var1);

    public Vector getESS();

    public LabelledVector getESS_lv();

    public Vector getNESS();

    public LabelledVector getNESS_lv();

    public RankedList getNESS_rl();

    public Vector getNPs();

    public LabelledVector getNPs_lv();

    public Vector getFDRs();

    public LabelledVector getFDRs_lv();

    public Vector getFWERs();

    public LabelledVector getFWERs_lv();

    public boolean isCompatible(EnrichmentDb var1);

    public void checkCompatibility(EnrichmentDb var1);

    public LabelledVectorProcessor getRankedListProcessor();

    public Metric getMetric();

    public Map getMetricParams();

    public SortMode getSortMode();

    public Order getOrder();

    public int getNumPerm();
}

